/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.NaturalKey;
import org.eclipse.ui.keys.ParseException;
import org.eclipse.ui.keys.SWTKeySupport;
import org.eclipse.ui.keys.SpecialKey;

public final class KeySequenceText {
    private static final String EMPTY_STRING = "";
    public static final int INFINITE = -1;
    public static final List TRAPPED_KEYS;
    private final KeyTrapListener keyFilter = new KeyTrapListener();
    private KeySequence keySequence = KeySequence.getInstance();
    private int maxStrokes = -1;
    private final Text text;
    private final UpdateSequenceListener updateSequenceListener = new UpdateSequenceListener();

    static {
        TreeSet<KeyStroke> trappedKeys = new TreeSet<KeyStroke>();
        trappedKeys.add(SWTKeySupport.convertAcceleratorToKeyStroke(9));
        trappedKeys.add(SWTKeySupport.convertAcceleratorToKeyStroke(131081));
        trappedKeys.add(SWTKeySupport.convertAcceleratorToKeyStroke(8));
        ArrayList trappedKeyList = new ArrayList(trappedKeys);
        TRAPPED_KEYS = Collections.unmodifiableList(trappedKeyList);
    }

    public KeySequenceText(Text wrappedText) {
        this.text = wrappedText;
        if ("carbon".equals(SWT.getPlatform())) {
            final Font font = new Font((Device)this.text.getDisplay(), "Lucida Grande", 13, 0);
            this.text.setFont(font);
            this.text.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    font.dispose();
                }
            });
        }
        this.text.addListener(2, (Listener)this.keyFilter);
        this.text.addListener(1, (Listener)this.keyFilter);
        this.text.addFocusListener((FocusListener)new TraversalFilterManager());
        this.text.addModifyListener((ModifyListener)this.updateSequenceListener);
    }

    public void clear() {
        this.keySequence = KeySequence.getInstance();
        this.text.setText(EMPTY_STRING);
    }

    /*
     * Unable to fully structure code
     */
    private int deleteSelection(List keyStrokes, boolean allowIncomplete) {
        selection = this.text.getSelection();
        start = selection.x;
        end = selection.y;
        string = new String();
        currentStrokes = new ArrayList<E>();
        keyStrokeItr = keyStrokes.iterator();
        startTextIndex = 0;
        while (string.length() < start && keyStrokeItr.hasNext()) {
            startTextIndex = string.length();
            currentStrokes.add(keyStrokeItr.next());
            string = KeySequence.getInstance(currentStrokes).format();
        }
        startStrokeIndex = string.length() == start ? currentStrokes.size() : currentStrokes.size() - 1;
        if (start != end) ** GOTO lbl20
        return startStrokeIndex;
lbl-1000:
        // 1 sources

        {
            currentStrokes.add(keyStrokeItr.next());
            string = KeySequence.getInstance(currentStrokes).format();
lbl20:
            // 2 sources

            ** while (string.length() < end && keyStrokeItr.hasNext())
        }
lbl21:
        // 1 sources

        endStrokeIndex = currentStrokes.size() - 1;
        if (endStrokeIndex < 0) {
            endStrokeIndex = 0;
        }
        startStroke = (KeyStroke)keyStrokes.get(startStrokeIndex);
        while (startStrokeIndex <= endStrokeIndex) {
            keyStrokes.remove(startStrokeIndex);
            --endStrokeIndex;
        }
        if (allowIncomplete && startTextIndex + (incompleteStrokeLength = (incompleteStroke = KeyStroke.getInstance(modifierKeys = new TreeSet<E>(startStroke.getModifierKeys()), null)).format().length()) <= start) {
            keyStrokes.add(startStrokeIndex, incompleteStroke);
        }
        return startStrokeIndex;
    }

    public KeySequence getKeySequence() {
        return this.keySequence;
    }

    private String getText() {
        return this.text.getText();
    }

    private boolean hasIncompleteStroke() {
        return !this.keySequence.isComplete();
    }

    private boolean hasSelection() {
        return this.text.getSelectionCount() > 0;
    }

    public void insert(KeyStroke stroke) {
        if (!stroke.isComplete()) {
            return;
        }
        ArrayList keyStrokes = new ArrayList(this.getKeySequence().getKeyStrokes());
        if (this.hasIncompleteStroke() && !keyStrokes.isEmpty()) {
            keyStrokes.remove(keyStrokes.size() - 1);
        }
        int index = this.deleteSelection(keyStrokes, false);
        this.insertStrokeAt(keyStrokes, stroke, index);
        this.keyFilter.clearInsertionIndex();
        this.setKeySequence(KeySequence.getInstance(keyStrokes));
    }

    private void insertStrokeAt(List keyStrokes, KeyStroke stroke, int index) {
        KeyStroke currentStroke;
        KeyStroke keyStroke = currentStroke = index >= keyStrokes.size() ? null : (KeyStroke)keyStrokes.get(index);
        if (currentStroke != null && !currentStroke.isComplete()) {
            TreeSet modifierKeys = new TreeSet(currentStroke.getModifierKeys());
            NaturalKey naturalKey = stroke.getNaturalKey();
            modifierKeys.addAll(stroke.getModifierKeys());
            keyStrokes.remove(index);
            keyStrokes.add(index, KeyStroke.getInstance(modifierKeys, naturalKey));
        } else {
            keyStrokes.add(index, stroke);
        }
    }

    private boolean isCursorInLastPosition() {
        return this.text.getSelection().y >= this.getText().length();
    }

    private void selectAll() {
        this.text.setSelection(0, this.getText().length());
    }

    public void setKeySequence(KeySequence newKeySequence) {
        String newString;
        String currentString;
        this.keySequence = newKeySequence;
        if (this.maxStrokes != -1) {
            ArrayList keyStrokes = new ArrayList(this.keySequence.getKeyStrokes());
            int keyStrokesSize = keyStrokes.size();
            int i = keyStrokesSize - 1;
            while (i >= this.maxStrokes) {
                keyStrokes.remove(i);
                --i;
            }
            this.keySequence = KeySequence.getInstance(keyStrokes);
        }
        if (!(currentString = this.getText()).equals(newString = this.keySequence.format())) {
            this.text.removeModifyListener((ModifyListener)this.updateSequenceListener);
            this.text.setText(this.keySequence.format());
            this.text.addModifyListener((ModifyListener)this.updateSequenceListener);
            this.text.setSelection(this.getText().length());
        }
    }

    public int getKeyStrokeLimit() {
        return this.maxStrokes;
    }

    public void setKeyStrokeLimit(int keyStrokeLimit) {
        if (keyStrokeLimit <= 0 && keyStrokeLimit != -1) {
            throw new IllegalArgumentException();
        }
        this.maxStrokes = keyStrokeLimit;
        this.setKeySequence(this.getKeySequence());
    }

    private class KeyTrapListener
    implements Listener {
        private int insertionIndex = -1;

        KeyTrapListener() {
        }

        void clearInsertionIndex() {
            this.insertionIndex = -1;
        }

        private void deleteKeyStroke(List keyStrokes) {
            this.clearInsertionIndex();
            if (KeySequenceText.this.hasSelection()) {
                KeySequenceText.this.deleteSelection(keyStrokes, false);
            } else if (!keyStrokes.isEmpty()) {
                keyStrokes.remove(keyStrokes.size() - 1);
            }
        }

        public void handleEvent(Event event) {
            ArrayList keyStrokes = new ArrayList(KeySequenceText.this.getKeySequence().getKeyStrokes());
            if (event.type == 1) {
                this.handleKeyDown(event, keyStrokes);
            } else if (event.type == 2) {
                this.handleKeyUp(event, keyStrokes);
            }
            KeySequenceText.this.setKeySequence(KeySequence.getInstance(keyStrokes));
            event.doit = false;
        }

        private void handleKeyDown(Event event, List keyStrokes) {
            if (event.character == '\b' && event.stateMask == 0) {
                this.deleteKeyStroke(keyStrokes);
            } else {
                this.insertKeyStroke(event, keyStrokes);
            }
        }

        private void handleKeyUp(Event event, List keyStrokes) {
            if (KeySequenceText.this.hasIncompleteStroke()) {
                Event mockEvent = new Event();
                mockEvent.stateMask = (event.keyCode & SWT.MODIFIER_MASK) != 0 ? event.stateMask - event.keyCode : event.stateMask;
                int key = SWTKeySupport.convertEventToUnmodifiedAccelerator(mockEvent);
                KeyStroke remainingStroke = SWTKeySupport.convertAcceleratorToKeyStroke(key);
                if (!keyStrokes.isEmpty()) {
                    keyStrokes.remove(keyStrokes.size() - 1);
                }
                if (!remainingStroke.getModifierKeys().isEmpty()) {
                    keyStrokes.add(remainingStroke);
                }
            }
        }

        private void insertKeyStroke(Event event, List keyStrokes) {
            int key = SWTKeySupport.convertEventToUnmodifiedAccelerator(event);
            KeyStroke stroke = SWTKeySupport.convertAcceleratorToKeyStroke(key);
            if (SpecialKey.NUM_LOCK.equals(stroke.getNaturalKey()) || SpecialKey.CAPS_LOCK.equals(stroke.getNaturalKey()) || SpecialKey.SCROLL_LOCK.equals(stroke.getNaturalKey())) {
                return;
            }
            if (this.insertionIndex != -1) {
                if (stroke.isComplete()) {
                    KeySequenceText.this.insertStrokeAt(keyStrokes, stroke, this.insertionIndex);
                    this.clearInsertionIndex();
                }
            } else if (KeySequenceText.this.hasSelection()) {
                this.insertionIndex = KeySequenceText.this.deleteSelection(keyStrokes, stroke.isComplete());
                if (stroke.isComplete() || this.insertionIndex >= keyStrokes.size()) {
                    KeySequenceText.this.insertStrokeAt(keyStrokes, stroke, this.insertionIndex);
                    this.clearInsertionIndex();
                }
            } else {
                if (KeySequenceText.this.hasIncompleteStroke() && !keyStrokes.isEmpty()) {
                    keyStrokes.remove(keyStrokes.size() - 1);
                }
                if (keyStrokes.isEmpty() || this.insertionIndex >= keyStrokes.size() || KeySequenceText.this.isCursorInLastPosition()) {
                    KeySequenceText.this.insertStrokeAt(keyStrokes, stroke, keyStrokes.size());
                    this.clearInsertionIndex();
                } else {
                    this.insertionIndex = KeySequenceText.this.deleteSelection(keyStrokes, stroke.isComplete());
                    if (stroke.isComplete()) {
                        KeySequenceText.this.insertStrokeAt(keyStrokes, stroke, this.insertionIndex);
                        this.clearInsertionIndex();
                    }
                }
            }
        }
    }

    private class TraversalFilter
    implements Listener {
        TraversalFilter() {
        }

        public void handleEvent(Event event) {
            switch (event.detail) {
                case 0: 
                case 2: 
                case 4: 
                case 128: 
                case 256: 
                case 512: {
                    event.type = 0;
                    event.doit = false;
                    break;
                }
                case 8: 
                case 16: {
                    if ((event.stateMask & (SWT.MODIFIER_MASK ^ 0x20000)) != 0) {
                        event.type = 0;
                        event.doit = false;
                        break;
                    }
                }
                default: {
                    if (!KeySequenceText.this.hasIncompleteStroke()) break;
                    ArrayList keyStrokes = new ArrayList(KeySequenceText.this.getKeySequence().getKeyStrokes());
                    if (!keyStrokes.isEmpty()) {
                        keyStrokes.remove(keyStrokes.size() - 1);
                    }
                    KeySequenceText.this.setKeySequence(KeySequence.getInstance(keyStrokes));
                }
            }
        }
    }

    private class TraversalFilterManager
    implements FocusListener {
        private TraversalFilter filter;

        TraversalFilterManager() {
            this.filter = new TraversalFilter();
        }

        public void focusGained(FocusEvent event) {
            Display.getCurrent().addFilter(31, (Listener)this.filter);
        }

        public void focusLost(FocusEvent event) {
            Display.getCurrent().removeFilter(31, (Listener)this.filter);
        }
    }

    private class UpdateSequenceListener
    implements ModifyListener {
        UpdateSequenceListener() {
        }

        public void modifyText(ModifyEvent event) {
            try {
                KeySequence originalSequence = KeySequenceText.this.getKeySequence();
                String contents = KeySequenceText.this.getText();
                KeySequence newSequence = KeySequence.getInstance(contents);
                if (!originalSequence.equals(newSequence)) {
                    KeySequenceText.this.setKeySequence(newSequence);
                }
            }
            catch (ParseException e) {
                KeySequenceText.this.setKeySequence(KeySequenceText.this.getKeySequence());
            }
        }
    }
}

