/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class WorkbenchEditorsDialog
extends SelectionDialog {
    private IWorkbenchWindow window;
    private Table editorsTable;
    private Button saveSelected;
    private Button closeSelected;
    private Button selectClean;
    private Button invertSelection;
    private Button allSelection;
    private boolean showAllPersp = false;
    private int sortColumn;
    private List elements = new ArrayList();
    private HashMap imageCache = new HashMap(11);
    private HashMap disabledImageCache = new HashMap(11);
    private boolean reverse = false;
    private Collator collator = Collator.getInstance();
    private Rectangle bounds;
    private int[] columnsWidth;
    private static final String SORT = "sort";
    private static final String ALLPERSP = "allPersp";
    private static final String BOUNDS = "bounds";
    private static final String COLUMNS = "columns";
    private SelectionListener headerListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = WorkbenchEditorsDialog.this.editorsTable.indexOf((TableColumn)e.widget);
            if (index == WorkbenchEditorsDialog.this.sortColumn) {
                WorkbenchEditorsDialog.this.reverse = !WorkbenchEditorsDialog.this.reverse;
            } else {
                WorkbenchEditorsDialog.this.sortColumn = index;
            }
            WorkbenchEditorsDialog.this.updateItems();
        }
    };

    public WorkbenchEditorsDialog(IWorkbenchWindow window) {
        super(window.getShell());
        this.window = window;
        this.setTitle(WorkbenchMessages.getString("WorkbenchEditorsDialog.title"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        IDialogSettings s = this.getDialogSettings();
        if (s.get(ALLPERSP) == null) {
            this.sortColumn = 0;
        } else {
            this.showAllPersp = s.getBoolean(ALLPERSP);
            this.sortColumn = s.getInt(SORT);
            String[] array = s.getArray(BOUNDS);
            if (array != null) {
                this.bounds = new Rectangle(0, 0, 0, 0);
                this.bounds.x = new Integer(array[0]);
                this.bounds.y = new Integer(array[1]);
                this.bounds.width = new Integer(array[2]);
                this.bounds.height = new Integer(array[3]);
            }
            if ((array = s.getArray(COLUMNS)) != null) {
                this.columnsWidth = new int[array.length];
                int i = 0;
                while (i < this.columnsWidth.length) {
                    this.columnsWidth[i] = new Integer(array[i]);
                    ++i;
                }
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, "org.eclipse.ui.workbench_editors_dialog");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        Button button = this.getButton(1);
        if (button != null) {
            button.setText(WorkbenchMessages.getString("WorkbenchEditorsDialog.close"));
        }
    }

    protected void initializeBounds() {
        if (this.bounds != null) {
            this.getShell().setBounds(this.bounds);
        } else {
            super.initializeBounds();
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Font font = parent.getFont();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Label l = new Label(dialogArea, 0);
        l.setText(WorkbenchMessages.getString("WorkbenchEditorsDialog.label"));
        l.setFont(font);
        GridData data = new GridData(768);
        l.setLayoutData((Object)data);
        this.editorsTable = new Table(dialogArea, 68354);
        this.editorsTable.setLinesVisible(true);
        this.editorsTable.setHeaderVisible(true);
        this.editorsTable.setFont(font);
        final GridData tableData = new GridData(1808);
        tableData.heightHint = 16 * this.editorsTable.getItemHeight();
        tableData.widthHint = (int)(2.5 * (double)tableData.heightHint);
        this.editorsTable.setLayoutData((Object)tableData);
        this.editorsTable.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(tableData.widthHint, tableData.heightHint);
            }

            protected void layout(Composite composite, boolean flushCache) {
                TableColumn[] c = WorkbenchEditorsDialog.this.editorsTable.getColumns();
                if (WorkbenchEditorsDialog.this.columnsWidth == null) {
                    int w = ((WorkbenchEditorsDialog)WorkbenchEditorsDialog.this).editorsTable.getClientArea().width;
                    c[0].setWidth(w * 1 / 3);
                    c[1].setWidth(w - c[0].getWidth());
                } else {
                    c[0].setWidth(WorkbenchEditorsDialog.this.columnsWidth[0]);
                    c[1].setWidth(WorkbenchEditorsDialog.this.columnsWidth[1]);
                }
                WorkbenchEditorsDialog.this.editorsTable.setLayout(null);
            }
        });
        TableColumn tc = new TableColumn(this.editorsTable, 0);
        tc.setResizable(true);
        tc.setText(WorkbenchMessages.getString("WorkbenchEditorsDialog.name"));
        tc.addSelectionListener(this.headerListener);
        tc = new TableColumn(this.editorsTable, 0);
        tc.setResizable(true);
        tc.setText(WorkbenchMessages.getString("WorkbenchEditorsDialog.path"));
        tc.addSelectionListener(this.headerListener);
        Composite selectionButtons = new Composite(dialogArea, 0);
        Label compLabel = new Label(selectionButtons, 0);
        compLabel.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        selectionButtons.setLayout((Layout)layout);
        this.selectClean = new Button(selectionButtons, 8);
        this.selectClean.setText(WorkbenchMessages.getString("WorkbenchEditorsDialog.selectClean"));
        this.selectClean.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchEditorsDialog.this.editorsTable.setSelection(WorkbenchEditorsDialog.this.selectClean(WorkbenchEditorsDialog.this.editorsTable.getItems()));
                WorkbenchEditorsDialog.this.updateButtons();
            }
        });
        this.selectClean.setFont(font);
        this.setButtonLayoutData(this.selectClean);
        this.invertSelection = new Button(selectionButtons, 8);
        this.invertSelection.setText(WorkbenchMessages.getString("WorkbenchEditorsDialog.invertSelection"));
        this.invertSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchEditorsDialog.this.editorsTable.setSelection(WorkbenchEditorsDialog.this.invertedSelection(WorkbenchEditorsDialog.this.editorsTable.getItems(), WorkbenchEditorsDialog.this.editorsTable.getSelection()));
                WorkbenchEditorsDialog.this.updateButtons();
            }
        });
        this.invertSelection.setFont(font);
        this.setButtonLayoutData(this.invertSelection);
        this.allSelection = new Button(selectionButtons, 8);
        this.allSelection.setText(WorkbenchMessages.getString("WorkbenchEditorsDialog.allSelection"));
        this.allSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchEditorsDialog.this.editorsTable.setSelection(WorkbenchEditorsDialog.this.editorsTable.getItems());
                WorkbenchEditorsDialog.this.updateButtons();
            }
        });
        this.allSelection.setFont(font);
        this.setButtonLayoutData(this.allSelection);
        Composite actionButtons = new Composite(dialogArea, 0);
        Label actLabel = new Label(actionButtons, 0);
        actLabel.setFont(font);
        GridLayout actLayout = new GridLayout();
        actLayout.numColumns = 4;
        actionButtons.setLayout((Layout)actLayout);
        this.createButton(actionButtons, 0, WorkbenchMessages.getString("WorkbenchEditorsDialog.activate"), true);
        this.closeSelected = new Button(actionButtons, 8);
        this.closeSelected.setText(WorkbenchMessages.getString("WorkbenchEditorsDialog.closeSelected"));
        this.closeSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchEditorsDialog.this.closeItems(WorkbenchEditorsDialog.this.editorsTable.getSelection());
            }
        });
        this.closeSelected.setFont(font);
        this.setButtonLayoutData(this.closeSelected);
        this.saveSelected = new Button(actionButtons, 8);
        this.saveSelected.setText(WorkbenchMessages.getString("WorkbenchEditorsDialog.saveSelected"));
        this.saveSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchEditorsDialog.this.saveItems(WorkbenchEditorsDialog.this.editorsTable.getSelection(), null);
            }
        });
        this.saveSelected.setFont(font);
        this.setButtonLayoutData(this.saveSelected);
        final Button showAllPerspButton = new Button(dialogArea, 32);
        showAllPerspButton.setText(WorkbenchMessages.getString("WorkbenchEditorsDialog.showAllPersp"));
        showAllPerspButton.setSelection(this.showAllPersp);
        showAllPerspButton.setFont(font);
        this.setButtonLayoutData(showAllPerspButton);
        showAllPerspButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchEditorsDialog.this.showAllPersp = showAllPerspButton.getSelection();
                WorkbenchEditorsDialog.this.updateItems();
            }
        });
        this.updateItems();
        this.updateButtons();
        this.editorsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchEditorsDialog.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                WorkbenchEditorsDialog.this.okPressed();
            }
        });
        this.editorsTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Image i;
                Iterator images = WorkbenchEditorsDialog.this.imageCache.values().iterator();
                while (images.hasNext()) {
                    i = (Image)images.next();
                    i.dispose();
                }
                images = WorkbenchEditorsDialog.this.disabledImageCache.values().iterator();
                while (images.hasNext()) {
                    i = (Image)images.next();
                    i.dispose();
                }
            }
        });
        this.editorsTable.setFocus();
        return dialogArea;
    }

    private void updateButtons() {
        TableItem[] selectedItems = this.editorsTable.getSelection();
        boolean hasDirty = false;
        int i = 0;
        while (i < selectedItems.length) {
            Adapter editor = (Adapter)selectedItems[i].getData();
            if (editor.isDirty()) {
                hasDirty = true;
                break;
            }
            ++i;
        }
        this.saveSelected.setEnabled(hasDirty);
        TableItem[] allItems = this.editorsTable.getItems();
        boolean hasClean = false;
        int i2 = 0;
        while (i2 < allItems.length) {
            Adapter editor = (Adapter)allItems[i2].getData();
            if (!editor.isDirty()) {
                hasClean = true;
                break;
            }
            ++i2;
        }
        this.selectClean.setEnabled(hasClean);
        this.invertSelection.setEnabled(allItems.length > 0);
        this.closeSelected.setEnabled(selectedItems.length > 0);
        Button ok = this.getOkButton();
        if (ok != null) {
            ok.setEnabled(selectedItems.length == 1);
        }
    }

    private void closeItems(TableItem[] items) {
        if (items.length == 0) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            Adapter e = (Adapter)items[i].getData();
            e.close();
            ++i;
        }
        this.updateItems();
    }

    private void saveItems(TableItem[] items, IProgressMonitor monitor) {
        if (items.length == 0) {
            return;
        }
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
        pmd.open();
        int i = 0;
        while (i < items.length) {
            Adapter editor = (Adapter)items[i].getData();
            editor.save(pmd.getProgressMonitor());
            this.updateItem(items[i], editor);
            ++i;
        }
        pmd.close();
        this.updateItems();
    }

    private TableItem[] selectClean(TableItem[] items) {
        if (items.length == 0) {
            return new TableItem[0];
        }
        ArrayList<TableItem> cleanItems = new ArrayList<TableItem>(items.length);
        int i = 0;
        while (i < items.length) {
            Adapter editor = (Adapter)items[i].getData();
            if (!editor.isDirty()) {
                cleanItems.add(items[i]);
            }
            ++i;
        }
        TableItem[] result = new TableItem[cleanItems.size()];
        cleanItems.toArray(result);
        return result;
    }

    private TableItem[] invertedSelection(TableItem[] allItems, TableItem[] selectedItems) {
        if (allItems.length == 0) {
            return allItems;
        }
        ArrayList<TableItem> invertedSelection = new ArrayList<TableItem>(allItems.length - selectedItems.length);
        int i = 0;
        while (i < allItems.length) {
            block4: {
                int j = 0;
                while (j < selectedItems.length) {
                    if (allItems[i] != selectedItems[j]) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                invertedSelection.add(allItems[i]);
            }
            ++i;
        }
        TableItem[] result = new TableItem[invertedSelection.size()];
        invertedSelection.toArray(result);
        return result;
    }

    private void updateItem(TableItem item, Adapter editor) {
        item.setData((Object)editor);
        item.setText(editor.getText());
        Image[] images = editor.getImage();
        int i = 0;
        while (i < images.length) {
            if (images[i] != null) {
                item.setImage(i, images[i]);
            }
            ++i;
        }
    }

    private void updateEditors(IWorkbenchPage[] pages) {
        int j = 0;
        while (j < pages.length) {
            IEditorReference[] editors = pages[j].getEditorReferences();
            int k = 0;
            while (k < editors.length) {
                this.elements.add(new Adapter(editors[k]));
                ++k;
            }
            ++j;
        }
    }

    private void updateItems() {
        this.editorsTable.removeAll();
        this.elements = new ArrayList();
        if (this.showAllPersp) {
            IWorkbenchWindow[] windows = this.window.getWorkbench().getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                this.updateEditors(windows[i].getPages());
                ++i;
            }
        } else {
            IWorkbenchPage page = this.window.getActivePage();
            if (page != null) {
                this.updateEditors(new IWorkbenchPage[]{page});
            }
        }
        this.sort();
        IEditorPart selection = null;
        if (this.window.getActivePage() != null) {
            selection = this.window.getActivePage().getActiveEditor();
        }
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Adapter e = (Adapter)iterator.next();
            TableItem item = new TableItem(this.editorsTable, 0);
            this.updateItem(item, e);
            if (selection == null || selection != e.editorRef) continue;
            this.editorsTable.setSelection(new TableItem[]{item});
        }
        this.updateButtons();
    }

    private void sort() {
        if (this.sortColumn > this.editorsTable.getColumnCount() - 1) {
            this.sortColumn = 0;
        }
        Object[] a = new Adapter[this.elements.size()];
        this.elements.toArray(a);
        Arrays.sort(a);
        this.elements = Arrays.asList(a);
    }

    protected void okPressed() {
        TableItem[] items = this.editorsTable.getSelection();
        if (items.length != 1) {
            super.okPressed();
            return;
        }
        this.saveDialogSettings();
        Adapter selection = (Adapter)items[0].getData();
        super.okPressed();
        selection.activate();
    }

    private void saveDialogSettings() {
        IDialogSettings s = this.getDialogSettings();
        s.put(ALLPERSP, this.showAllPersp);
        s.put(SORT, this.sortColumn);
        this.bounds = this.getShell().getBounds();
        String[] array = new String[]{String.valueOf(this.bounds.x), String.valueOf(this.bounds.y), String.valueOf(this.bounds.width), String.valueOf(this.bounds.height)};
        s.put(BOUNDS, array);
        array = new String[this.editorsTable.getColumnCount()];
        int i = 0;
        while (i < array.length) {
            array[i] = String.valueOf(this.editorsTable.getColumn(i).getWidth());
            ++i;
        }
        s.put(COLUMNS, array);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings thisSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (thisSettings == null) {
            thisSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return thisSettings;
    }

    private class Adapter
    implements Comparable {
        IEditorReference editorRef;
        IEditorInput input;
        IEditorDescriptor desc;
        String[] text;
        Image[] images;

        Adapter(IEditorReference ref) {
            this.editorRef = ref;
        }

        Adapter(IEditorInput input, IEditorDescriptor desc) {
            this.input = input;
            this.desc = desc;
        }

        boolean isDirty() {
            if (this.editorRef == null) {
                return false;
            }
            return this.editorRef.isDirty();
        }

        boolean isOpened() {
            return this.editorRef != null;
        }

        void close() {
            if (this.editorRef == null) {
                return;
            }
            WorkbenchPage p = ((WorkbenchPartReference)((Object)this.editorRef)).getPane().getPage();
            p.closeEditor(this.editorRef, true);
        }

        void save(IProgressMonitor monitor) {
            if (this.editorRef == null) {
                return;
            }
            IEditorPart editor = (IEditorPart)this.editorRef.getPart(true);
            if (editor != null) {
                editor.doSave(monitor);
            }
        }

        String[] getText() {
            if (this.text != null) {
                return this.text;
            }
            this.text = new String[2];
            if (this.editorRef != null) {
                this.text[0] = this.editorRef.isDirty() ? "*" + this.editorRef.getTitle() : this.editorRef.getTitle();
                this.text[1] = this.editorRef.getTitleToolTip();
            } else {
                this.text[0] = this.input.getName();
                this.text[1] = this.input.getToolTipText();
            }
            return this.text;
        }

        Image[] getImage() {
            if (this.images != null) {
                return this.images;
            }
            this.images = new Image[2];
            if (this.editorRef != null) {
                this.images[0] = this.editorRef.getTitleImage();
                WorkbenchPage p = ((WorkbenchPartReference)((Object)this.editorRef)).getPane().getPage();
                IPerspectiveDescriptor persp = p.getPerspective();
                ImageDescriptor image = persp.getImageDescriptor();
                if (image == null) {
                    image = WorkbenchImages.getImageDescriptor("IMG_CTOOL_DEF_PERSPECTIVE");
                }
            } else {
                ImageDescriptor image = null;
                if (this.desc != null) {
                    image = this.desc.getImageDescriptor();
                }
                if (image == null) {
                    IEditorRegistry registry = WorkbenchPlugin.getDefault().getEditorRegistry();
                    image = registry.getImageDescriptor(this.input.getName());
                }
                if (image != null) {
                    this.images[0] = (Image)WorkbenchEditorsDialog.this.disabledImageCache.get(image);
                    if (this.images[0] == null) {
                        Image enabled = image.createImage();
                        Image disabled = new Image((Device)WorkbenchEditorsDialog.this.editorsTable.getDisplay(), enabled, 1);
                        enabled.dispose();
                        WorkbenchEditorsDialog.this.disabledImageCache.put(image, disabled);
                        this.images[0] = disabled;
                    }
                }
            }
            return this.images;
        }

        private void activate() {
            if (this.editorRef != null) {
                IEditorPart editor = this.editorRef.getEditor(true);
                WorkbenchPage p = (WorkbenchPage)editor.getEditorSite().getPage();
                Shell s = p.getWorkbenchWindow().getShell();
                if (s.getMinimized()) {
                    s.setMinimized(false);
                }
                s.moveAbove(null);
                p.getWorkbenchWindow().setActivePage(p);
                p.activate(editor);
            } else {
                IWorkbenchPage p = WorkbenchEditorsDialog.this.window.getActivePage();
                if (p != null) {
                    try {
                        p.openEditor(this.input, this.desc.getId(), true);
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                }
            }
        }

        public int compareTo(Object another) {
            Adapter adapter = (Adapter)another;
            int result = WorkbenchEditorsDialog.this.collator.compare(this.getText()[WorkbenchEditorsDialog.this.sortColumn], adapter.getText()[WorkbenchEditorsDialog.this.sortColumn]);
            if (result == 0) {
                int column = WorkbenchEditorsDialog.this.sortColumn == 0 ? 1 : 0;
                result = WorkbenchEditorsDialog.this.collator.compare(this.getText()[column], adapter.getText()[column]);
            }
            if (WorkbenchEditorsDialog.this.reverse) {
                return result * -1;
            }
            return result;
        }
    }
}

