/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.dialogs.ViewContentProvider;
import org.eclipse.ui.internal.dialogs.ViewLabelProvider;
import org.eclipse.ui.internal.dialogs.ViewSorter;
import org.eclipse.ui.internal.registry.Category;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;
import org.eclipse.ui.internal.registry.ViewRegistry;

public class ShowViewDialog
extends Dialog
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String DIALOG_SETTING_SECTION_NAME = "ShowViewDialog";
    private static final int LIST_HEIGHT = 300;
    private static final int LIST_WIDTH = 250;
    private static final String STORE_EXPANDED_FILTERED_CATEGORIES_ID = "ShowViewDialog.STORE_EXPANDED_FILTERED_CATEGORIES_ID";
    private static final String STORE_EXPANDED_UNFILTERED_CATEGORIES_ID = "ShowViewDialog.STORE_EXPANDED_UNFILTERED_CATEGORIES_ID";
    private static final String UNFILTERED_TAB_SELECTED = "ShowViewDialog.UNFILTERED_TAB_SELECTED";
    private TreeViewer filteredTree;
    private TreeViewer unfilteredTree;
    private Button okButton;
    private TabFolder tabFolder;
    private IViewDescriptor[] viewDescs = new IViewDescriptor[0];
    private IViewRegistry viewReg;

    public ShowViewDialog(Shell parentShell, IViewRegistry viewReg) {
        super(parentShell);
        this.viewReg = viewReg;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.saveWidgetValues();
        }
        super.buttonPressed(buttonId);
    }

    protected void cancelPressed() {
        this.viewDescs = new IViewDescriptor[0];
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.getString("ShowView.shellTitle"));
        WorkbenchHelp.setHelp((Control)shell, "org.eclipse.ui.show_view_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        if (WorkbenchActivityHelper.isFiltering()) {
            this.tabFolder = new TabFolder(composite, 0);
            this.tabFolder.setFont(parent.getFont());
            this.layoutTopControl((Control)this.tabFolder);
            this.filteredTree = this.createViewer((Composite)this.tabFolder, true);
            this.unfilteredTree = this.createViewer((Composite)this.tabFolder, false);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ShowViewDialog.this.tabFolder.getSelectionIndex() == 0) {
                        ShowViewDialog.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)ShowViewDialog.this.filteredTree, ShowViewDialog.this.filteredTree.getSelection()));
                    } else {
                        ShowViewDialog.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)ShowViewDialog.this.unfilteredTree, ShowViewDialog.this.unfilteredTree.getSelection()));
                    }
                }
            });
        } else {
            this.unfilteredTree = this.createViewer(composite, false);
            this.layoutTopControl(this.unfilteredTree.getControl());
        }
        this.restoreWidgetValues();
        return composite;
    }

    private TreeViewer createViewer(Composite parent, boolean filtering) {
        TreeViewer tree = new TreeViewer(parent, 2818);
        tree.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        tree.setContentProvider((IContentProvider)new ViewContentProvider(filtering));
        tree.setSorter((ViewerSorter)new ViewSorter((ViewRegistry)this.viewReg));
        tree.setInput((Object)this.viewReg);
        tree.addSelectionChangedListener((ISelectionChangedListener)this);
        tree.addDoubleClickListener((IDoubleClickListener)this);
        tree.getTree().setFont(parent.getFont());
        if (parent instanceof TabFolder) {
            TabItem tabItem = new TabItem((TabFolder)parent, 0);
            tabItem.setControl(tree.getControl());
            tabItem.setText(filtering ? ActivityMessages.getString("ActivityFiltering.filtered") : ActivityMessages.getString("ActivityFiltering.unfiltered"));
        }
        return tree;
    }

    public void doubleClick(DoubleClickEvent event) {
        TreeViewer tree = null;
        if (event.getViewer() instanceof TreeViewer) {
            tree = (TreeViewer)event.getViewer();
        }
        if (tree == null) {
            return;
        }
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (tree.isExpandable(element)) {
            tree.setExpandedState(element, !tree.getExpandedState(element));
        } else if (this.viewDescs.length > 0) {
            this.saveWidgetValues();
            this.setReturnCode(0);
            this.close();
        }
    }

    private void expandTree(String[] expandedCategoryIds, TreeViewer tree) {
        if (expandedCategoryIds == null) {
            return;
        }
        ViewRegistry reg = (ViewRegistry)this.viewReg;
        ArrayList<Category> categoriesToExpand = new ArrayList<Category>(expandedCategoryIds.length);
        int i = 0;
        while (i < expandedCategoryIds.length) {
            Category category = reg.findCategory(expandedCategoryIds[i]);
            if (category != null) {
                categoriesToExpand.add(category);
            }
            ++i;
        }
        if (!categoriesToExpand.isEmpty()) {
            tree.setExpandedElements(categoriesToExpand.toArray());
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTING_SECTION_NAME);
        if (section == null) {
            section = workbenchSettings.addNewSection(DIALOG_SETTING_SECTION_NAME);
        }
        return section;
    }

    public IViewDescriptor[] getSelection() {
        return this.viewDescs;
    }

    private void layoutTopControl(Control control) {
        GridData spec = new GridData(1808);
        spec.widthHint = 250;
        spec.heightHint = 300;
        control.setLayoutData((Object)spec);
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        this.expandTree(settings.getArray(STORE_EXPANDED_UNFILTERED_CATEGORIES_ID), this.unfilteredTree);
        if (WorkbenchActivityHelper.isFiltering()) {
            this.expandTree(settings.getArray(STORE_EXPANDED_FILTERED_CATEGORIES_ID), this.filteredTree);
            boolean unfilteredSelected = this.getDialogSettings().getBoolean(UNFILTERED_TAB_SELECTED);
            if (unfilteredSelected) {
                this.tabFolder.setSelection(1);
            }
        }
    }

    private void saveExpanded(IDialogSettings settings, TreeViewer tree, String key) {
        Object[] expandedElements = tree.getExpandedElements();
        String[] expandedCategoryIds = new String[expandedElements.length];
        int i = 0;
        while (i < expandedElements.length) {
            expandedCategoryIds[i] = ((Category)expandedElements[i]).getId();
            ++i;
        }
        settings.put(key, expandedCategoryIds);
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (WorkbenchActivityHelper.isFiltering()) {
            this.saveExpanded(settings, this.filteredTree, STORE_EXPANDED_FILTERED_CATEGORIES_ID);
        }
        this.saveExpanded(settings, this.unfilteredTree, STORE_EXPANDED_UNFILTERED_CATEGORIES_ID);
        if (WorkbenchActivityHelper.isFiltering()) {
            settings.put(UNFILTERED_TAB_SELECTED, this.tabFolder.getSelectionIndex() == 1);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelection(event);
        this.updateButtons();
    }

    protected void updateButtons() {
        this.okButton.setEnabled(this.getSelection() != null);
    }

    protected void updateSelection(SelectionChangedEvent event) {
        TreeViewer tree = null;
        if (event.getSelectionProvider() instanceof TreeViewer) {
            tree = (TreeViewer)event.getSelectionProvider();
        }
        if (tree == null) {
            return;
        }
        ArrayList descs = new ArrayList();
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Iterator i = sel.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof IViewDescriptor)) continue;
            descs.add(o);
        }
        this.viewDescs = new IViewDescriptor[descs.size()];
        descs.toArray(this.viewDescs);
    }
}

