/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.NewWizardCollectionSorter2;
import org.eclipse.ui.internal.dialogs.NewWizardSelectionPage;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WizardContentProvider;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardNode;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class NewWizardNewPage2
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String DIALOG_SETTING_SECTION_NAME = "NewWizardSelectionPage.";
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final int SIZING_LISTS_WIDTH = 150;
    private static final String STORE_EXPANDED_FILTERED_CATEGORIES_ID = "NewWizardSelectionPage.STORE_EXPANDED_FILTERED_CATEGORIES_ID";
    private static final String STORE_EXPANDED_UNFILTERED_CATEGORIES_ID = "NewWizardSelectionPage.STORE_EXPANDED_UNFILTERED_CATEGORIES_ID";
    private static final String STORE_SELECTED_FILTERED_ID = "NewWizardSelectionPage.STORE_SELECTED_FILTERED_ID";
    private static final String STORE_SELECTED_UNFILTERED_ID = "NewWizardSelectionPage.STORE_SELECTED_UNFILTERED_ID";
    private static final String UNFILTERED_TAB_SELECTED = "NewWizardSelectionPage..UNFILTERED_TAB_SELECTED";
    private TreeViewer filteredViewer;
    private TreeViewer unfilteredViewer;
    private NewWizardSelectionPage page;
    private Hashtable selectedWizards = new Hashtable();
    private IDialogSettings settings;
    private TabFolder tabFolder;
    private Text unfilteredDescriptionText;
    private Text filteredDescriptionText;
    private WizardCollectionElement wizardCategories;

    public NewWizardNewPage2(NewWizardSelectionPage mainPage, IWorkbench aWorkbench, WizardCollectionElement wizardCategories) {
        this.page = mainPage;
        this.wizardCategories = wizardCategories;
    }

    public void activate() {
        this.page.setDescription(WorkbenchMessages.getString("NewWizardNewPage.description"));
    }

    protected Control createControl(Composite parent) {
        Font wizardFont = parent.getFont();
        Composite outerContainer = new Composite(parent, 0);
        outerContainer.setFont(wizardFont);
        if (WorkbenchActivityHelper.isFiltering()) {
            outerContainer.setLayout((Layout)new FillLayout());
            this.tabFolder = new TabFolder(outerContainer, 0);
            this.tabFolder.setFont(parent.getFont());
            Composite container = new Composite((Composite)this.tabFolder, 0);
            container.setLayout((Layout)new GridLayout(2, true));
            this.filteredViewer = this.createViewer(container, true);
            this.filteredDescriptionText = this.createDescriptionText(container);
            this.createTab(container, true);
            container = new Composite((Composite)this.tabFolder, 0);
            container.setLayout((Layout)new GridLayout(2, true));
            this.unfilteredViewer = this.createViewer(container, false);
            this.unfilteredDescriptionText = this.createDescriptionText(container);
            this.createTab(container, false);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (NewWizardNewPage2.this.tabFolder.getSelectionIndex() == 0) {
                        NewWizardNewPage2.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)NewWizardNewPage2.this.filteredViewer, NewWizardNewPage2.this.filteredViewer.getSelection()));
                    } else {
                        NewWizardNewPage2.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)NewWizardNewPage2.this.unfilteredViewer, NewWizardNewPage2.this.unfilteredViewer.getSelection()));
                    }
                }
            });
        } else {
            outerContainer.setLayout((Layout)new GridLayout(2, true));
            this.unfilteredViewer = this.createViewer(outerContainer, false);
            this.unfilteredDescriptionText = this.createDescriptionText(outerContainer);
        }
        this.updateDescriptionText("");
        this.restoreWidgetValues();
        return outerContainer;
    }

    private Text createDescriptionText(Composite parent) {
        ScrolledComposite scroller = new ScrolledComposite(parent, 2560);
        scroller.setBackground(this.filteredViewer.getControl().getBackground());
        GridData data = new GridData(1808);
        data.widthHint = 150;
        scroller.setLayoutData((Object)data);
        scroller.setContent((Control)this.unfilteredDescriptionText);
        Text text = new Text((Composite)scroller, 72);
        text.setBackground(this.filteredViewer.getControl().getBackground());
        return text;
    }

    private void createTab(Composite container, boolean filtering) {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setControl((Control)container);
        tabItem.setText(filtering ? ActivityMessages.getString("ActivityFiltering.filtered") : ActivityMessages.getString("ActivityFiltering.unfiltered"));
    }

    private TreeViewer createViewer(Composite parent, boolean filtering) {
        Tree tree = new Tree(parent, 2820);
        TreeViewer treeViewer = new TreeViewer(tree);
        treeViewer.setContentProvider((IContentProvider)new WizardContentProvider(filtering));
        treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        treeViewer.setSorter((ViewerSorter)NewWizardCollectionSorter2.INSTANCE);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        if (this.wizardCategories.getParent(this.wizardCategories) == null) {
            treeViewer.setInput((Object)this.wizardCategories);
        } else {
            treeViewer.setInput((Object)new RootElementProxy(this.wizardCategories));
        }
        tree.setFont(parent.getFont());
        GridData data = new GridData(1808);
        data.widthHint = 150;
        boolean needsHint = DialogUtil.inRegularFontMode(tree.getParent());
        if (needsHint) {
            data.heightHint = 200;
        }
        tree.setLayoutData((Object)data);
        return treeViewer;
    }

    protected Composite createViewPane(Composite parent, int width, int height) {
        Composite paneWindow = new Composite(parent, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = width;
        spec.heightHint = height;
        paneWindow.setLayoutData((Object)spec);
        paneWindow.setLayout((Layout)new FillLayout());
        return paneWindow;
    }

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)event.getViewer(), event.getViewer().getSelection()));
        this.page.advanceToNextPage();
    }

    protected void expandPreviouslyExpandedCategories() {
        this.expandViewer(this.unfilteredViewer, STORE_EXPANDED_UNFILTERED_CATEGORIES_ID);
        if (WorkbenchActivityHelper.isFiltering()) {
            this.expandViewer(this.filteredViewer, STORE_EXPANDED_FILTERED_CATEGORIES_ID);
        }
    }

    private void expandViewer(TreeViewer viewer, String key) {
        String[] expandedCategoryPaths = this.settings.getArray(key);
        if (expandedCategoryPaths == null || expandedCategoryPaths.length == 0) {
            return;
        }
        ArrayList<WizardCollectionElement> categoriesToExpand = new ArrayList<WizardCollectionElement>(expandedCategoryPaths.length);
        int i = 0;
        while (i < expandedCategoryPaths.length) {
            WizardCollectionElement category = this.wizardCategories.findChildCollection((IPath)new Path(expandedCategoryPaths[i]));
            if (category != null) {
                categoriesToExpand.add(category);
            }
            ++i;
        }
        if (!categoriesToExpand.isEmpty()) {
            viewer.setExpandedElements(categoriesToExpand.toArray());
        }
    }

    protected Object getSingleSelection(IStructuredSelection selection) {
        return selection.size() == 1 ? selection.getFirstElement() : null;
    }

    protected void restoreWidgetValues() {
        this.expandPreviouslyExpandedCategories();
        this.selectPreviouslySelected();
    }

    private void saveViewerExpansion(TreeViewer viewer, String key) {
        Object[] expandedElements = viewer.getExpandedElements();
        ArrayList<String> expandedElementPaths = new ArrayList<String>(expandedElements.length);
        int i = 0;
        while (i < expandedElements.length) {
            if (expandedElements[i] instanceof WizardCollectionElement) {
                expandedElementPaths.add(((WizardCollectionElement)expandedElements[i]).getPath().toString());
            }
            ++i;
        }
        this.settings.put(key, expandedElementPaths.toArray(new String[expandedElementPaths.size()]));
    }

    private void saveViewerSelection(TreeViewer viewer, String key) {
        Object selected = this.getSingleSelection((IStructuredSelection)viewer.getSelection());
        if (selected != null) {
            if (selected instanceof WizardCollectionElement) {
                this.settings.put(key, ((WizardCollectionElement)selected).getPath().toString());
            } else {
                this.settings.put(key, ((WorkbenchWizardElement)selected).getID());
            }
        }
    }

    public void saveWidgetValues() {
        this.storeExpandedCategories();
        this.storeSelectedCategoryAndWizard();
    }

    public void selectionChanged(SelectionChangedEvent selectionEvent) {
        this.page.setErrorMessage(null);
        this.page.setMessage(null);
        Object selectedObject = this.getSingleSelection((IStructuredSelection)selectionEvent.getSelection());
        if (selectedObject instanceof WizardCollectionElement) {
            this.updateCategorySelection((WizardCollectionElement)selectedObject);
        } else if (selectedObject instanceof WorkbenchWizardElement) {
            this.updateWizardSelection((WorkbenchWizardElement)selectedObject);
        }
    }

    protected void selectPreviouslySelected() {
        boolean unfilteredSelected = this.settings.getBoolean(UNFILTERED_TAB_SELECTED);
        this.updateViewerSelection(this.unfilteredViewer, STORE_SELECTED_UNFILTERED_ID);
        if (WorkbenchActivityHelper.isFiltering()) {
            this.updateViewerSelection(this.filteredViewer, STORE_SELECTED_FILTERED_ID);
            if (unfilteredSelected) {
                this.tabFolder.setSelection(1);
                this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.unfilteredViewer, this.unfilteredViewer.getSelection()));
            }
        }
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.settings = settings;
    }

    protected void storeExpandedCategories() {
        this.saveViewerExpansion(this.unfilteredViewer, STORE_EXPANDED_UNFILTERED_CATEGORIES_ID);
        if (WorkbenchActivityHelper.isFiltering()) {
            this.saveViewerExpansion(this.filteredViewer, STORE_EXPANDED_FILTERED_CATEGORIES_ID);
        }
    }

    protected void storeSelectedCategoryAndWizard() {
        this.saveViewerSelection(this.unfilteredViewer, STORE_SELECTED_UNFILTERED_ID);
        if (WorkbenchActivityHelper.isFiltering()) {
            this.saveViewerSelection(this.filteredViewer, STORE_SELECTED_FILTERED_ID);
            this.settings.put(UNFILTERED_TAB_SELECTED, this.tabFolder.getSelectionIndex() == 1);
        }
    }

    private void updateCategorySelection(WizardCollectionElement selectedCategory) {
        this.page.selectWizardNode(null);
    }

    private void updateDescriptionText(String string) {
        if (this.unfilteredViewer.getControl().isFocusControl()) {
            this.updateDescriptionText(this.unfilteredDescriptionText, string);
        } else if (this.filteredViewer != null) {
            this.updateDescriptionText(this.filteredDescriptionText, string);
        }
    }

    private void updateDescriptionText(Text text, String string) {
        if (text != null && !text.isDisposed()) {
            text.setText(string);
            text.setSize(text.computeSize(-1, -1));
        }
    }

    private void updateViewerSelection(TreeViewer viewer, String key) {
        String selectedId = this.settings.get(key);
        if (selectedId == null) {
            return;
        }
        WorkbenchAdapter selected = this.wizardCategories.findChildCollection((IPath)new Path(selectedId));
        if (selected == null && (selected = this.wizardCategories.findWizard(selectedId, true)) == null) {
            return;
        }
        StructuredSelection selection = new StructuredSelection((Object)selected);
        viewer.setSelection((ISelection)selection);
    }

    private void updateWizardSelection(WorkbenchWizardElement selectedObject) {
        WorkbenchWizardNode selectedNode;
        if (this.selectedWizards.containsKey(selectedObject)) {
            selectedNode = (WorkbenchWizardNode)this.selectedWizards.get(selectedObject);
        } else {
            selectedNode = new WorkbenchWizardNode(this.page, selectedObject){

                public IWorkbenchWizard createWizard() throws CoreException {
                    return (INewWizard)this.wizardElement.createExecutableExtension();
                }
            };
            this.selectedWizards.put(selectedObject, selectedNode);
        }
        this.page.selectWizardNode(selectedNode);
        this.updateDescriptionText(selectedObject.getDescription());
    }

    private static final class RootElementProxy
    extends WorkbenchAdapter
    implements IAdaptable {
        private WizardCollectionElement[] elements;
        static /* synthetic */ Class class$0;

        public RootElementProxy(WizardCollectionElement element) {
            if (element.getWizards().length == 0) {
                Object[] children = element.getChildren(null);
                this.elements = new WizardCollectionElement[children.length];
                System.arraycopy(children, 0, this.elements, 0, this.elements.length);
            } else {
                this.elements = new WizardCollectionElement[]{element};
            }
        }

        public Object getAdapter(Class adapter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return this;
            }
            return null;
        }

        public Object[] getChildren(Object o) {
            return this.elements;
        }
    }
}

