/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.NewWizardSelectionPage;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.registry.NewWizardsRegistryReader;

public class NewWizard
extends Wizard {
    private static final String CATEGORY_SEPARATOR = "/";
    private String categoryId = null;
    private NewWizardSelectionPage mainPage;
    private boolean projectsOnly = false;
    private IStructuredSelection selection;
    private IWorkbench workbench;
    static /* synthetic */ Class class$0;

    public void addPages() {
        NewWizardsRegistryReader rdr = new NewWizardsRegistryReader(this.projectsOnly);
        WizardCollectionElement wizards = rdr.getWizardElements();
        if (this.categoryId != null) {
            WizardCollectionElement categories = wizards;
            StringTokenizer familyTokenizer = new StringTokenizer(this.categoryId, CATEGORY_SEPARATOR);
            while (familyTokenizer.hasMoreElements()) {
                if ((categories = this.getChildWithID(categories, familyTokenizer.nextToken())) == null) break;
            }
            if (categories != null) {
                wizards = categories;
            }
        }
        this.mainPage = new NewWizardSelectionPage(this.workbench, this.selection, wizards);
        this.addPage((IWizardPage)this.mainPage);
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    private WizardCollectionElement getChildWithID(WizardCollectionElement parent, String id) {
        Object[] children = parent.getChildren(null);
        int i = 0;
        while (i < children.length) {
            WizardCollectionElement currentChild = (WizardCollectionElement)children[i];
            if (currentChild.getId().equals(id)) {
                return currentChild;
            }
            ++i;
        }
        return null;
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        this.workbench = aWorkbench;
        this.selection = currentSelection;
        if (this.projectsOnly) {
            this.setWindowTitle(WorkbenchMessages.getString("NewProject.title"));
        } else {
            this.setWindowTitle(WorkbenchMessages.getString("NewWizard.title"));
        }
        this.setDefaultPageImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_WIZBAN_NEW_WIZ"));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        IWorkbenchActivitySupport support;
        this.mainPage.saveWidgetValues();
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.activities.IWorkbenchActivitySupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((support = (IWorkbenchActivitySupport)iWorkbench.getAdapter(clazz)) == null) {
            return true;
        }
        IActivityManager activityManager = support.getActivityManager();
        if (this.mainPage.getSelectedNode() instanceof IPluginContribution) {
            IIdentifier identifier = activityManager.getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)this.mainPage.getSelectedNode()));
            HashSet activities = new HashSet(activityManager.getEnabledActivityIds());
            if (activities.addAll(identifier.getActivityIds())) {
                support.setEnabledActivityIds(activities);
            }
        }
        return true;
    }

    public void setCategoryId(String id) {
        this.categoryId = id;
    }

    public void setProjectsOnly(boolean b) {
        this.projectsOnly = b;
    }
}

