/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.contexts.ContextEvent;
import org.eclipse.ui.contexts.ContextManagerEvent;
import org.eclipse.ui.contexts.IContext;
import org.eclipse.ui.contexts.IContextContextBinding;
import org.eclipse.ui.contexts.IMutableContextManager;
import org.eclipse.ui.internal.contexts.AbstractContextManager;
import org.eclipse.ui.internal.contexts.Context;
import org.eclipse.ui.internal.contexts.ContextContextBinding;
import org.eclipse.ui.internal.contexts.ContextContextBindingDefinition;
import org.eclipse.ui.internal.contexts.ContextDefinition;
import org.eclipse.ui.internal.contexts.ContextRegistryEvent;
import org.eclipse.ui.internal.contexts.ExtensionContextRegistry;
import org.eclipse.ui.internal.contexts.IContextRegistry;
import org.eclipse.ui.internal.contexts.IContextRegistryListener;
import org.eclipse.ui.internal.util.Util;

public final class MutableContextManager
extends AbstractContextManager
implements IMutableContextManager {
    private Map contextContextBindingsByParentContextId = new HashMap();
    private Map contextDefinitionsById = new HashMap();
    private IContextRegistry contextRegistry;
    private Map contextsById = new WeakHashMap();
    private Set definedContextIds = new HashSet();
    private Set enabledContextIds = new HashSet();
    static /* synthetic */ Class class$0;

    static boolean isContextDefinitionChildOf(String ancestor, String id, Map contextDefinitionsById) {
        HashSet<String> visited = new HashSet<String>();
        while (id != null && !visited.contains(id)) {
            ContextDefinition contextDefinition = (ContextDefinition)contextDefinitionsById.get(id);
            visited.add(id);
            if (contextDefinition == null || !Util.equals(id = contextDefinition.getParentId(), ancestor)) continue;
            return true;
        }
        return false;
    }

    public MutableContextManager() {
        this(new ExtensionContextRegistry(Platform.getExtensionRegistry()));
    }

    public MutableContextManager(IContextRegistry contextRegistry) {
        if (contextRegistry == null) {
            throw new NullPointerException();
        }
        this.contextRegistry = contextRegistry;
        this.contextRegistry.addContextRegistryListener(new IContextRegistryListener(){

            public void contextRegistryChanged(ContextRegistryEvent contextRegistryEvent) {
                MutableContextManager.this.readRegistry();
            }
        });
        this.readRegistry();
    }

    public IContext getContext(String contextId) {
        if (contextId == null) {
            throw new NullPointerException();
        }
        Context context = (Context)this.contextsById.get(contextId);
        if (context == null) {
            context = new Context(contextId);
            this.updateContext(context);
            this.contextsById.put(contextId, context);
        }
        return context;
    }

    public Set getDefinedContextIds() {
        return Collections.unmodifiableSet(this.definedContextIds);
    }

    public Set getEnabledContextIds() {
        return Collections.unmodifiableSet(this.enabledContextIds);
    }

    private void getRequiredContextIds(Set contextIds, Set requiredContextIds) {
        Iterator iterator = contextIds.iterator();
        while (iterator.hasNext()) {
            String contextId = (String)iterator.next();
            IContext context = this.getContext(contextId);
            HashSet<String> childContextIds = new HashSet<String>();
            Set contextContextBindings = context.getContextContextBindings();
            Iterator iterator2 = contextContextBindings.iterator();
            while (iterator2.hasNext()) {
                IContextContextBinding contextContextBinding = (IContextContextBinding)iterator2.next();
                childContextIds.add(contextContextBinding.getChildContextId());
            }
            childContextIds.removeAll(requiredContextIds);
            requiredContextIds.addAll(childContextIds);
            this.getRequiredContextIds(childContextIds, requiredContextIds);
        }
    }

    private void notifyContexts(Map contextEventsByContextId) {
        Iterator iterator = contextEventsByContextId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String contextId = (String)entry.getKey();
            ContextEvent contextEvent = (ContextEvent)entry.getValue();
            Context context = (Context)this.contextsById.get(contextId);
            if (context == null) continue;
            context.fireContextChanged(contextEvent);
        }
    }

    private void readRegistry() {
        ArrayList contextDefinitions = new ArrayList();
        contextDefinitions.addAll(this.contextRegistry.getContextDefinitions());
        HashMap contextDefinitionsById = new HashMap(ContextDefinition.contextDefinitionsById(contextDefinitions, false));
        Iterator<Object> iterator = contextDefinitionsById.values().iterator();
        while (iterator.hasNext()) {
            ContextDefinition contextDefinition = (ContextDefinition)iterator.next();
            String name = contextDefinition.getName();
            if (name != null && name.length() != 0) continue;
            iterator.remove();
        }
        iterator = contextDefinitionsById.keySet().iterator();
        while (iterator.hasNext()) {
            if (MutableContextManager.isContextDefinitionChildOf(null, (String)iterator.next(), contextDefinitionsById)) continue;
            iterator.remove();
        }
        Map contextContextBindingDefinitionsByParentContextId = ContextContextBindingDefinition.contextContextBindingDefinitionsByParentContextId(this.contextRegistry.getContextContextBindingDefinitions());
        HashMap<String, HashSet<ContextContextBinding>> contextContextBindingsByParentContextId = new HashMap<String, HashSet<ContextContextBinding>>();
        Iterator iterator2 = contextContextBindingDefinitionsByParentContextId.entrySet().iterator();
        while (iterator2.hasNext()) {
            Collection contextContextBindingDefinitions;
            Map.Entry entry = iterator2.next();
            String parentContextId = (String)entry.getKey();
            if (!contextDefinitionsById.containsKey(parentContextId) || (contextContextBindingDefinitions = (Collection)entry.getValue()) == null) continue;
            Iterator iterator22 = contextContextBindingDefinitions.iterator();
            while (iterator22.hasNext()) {
                ContextContextBindingDefinition contextContextBindingDefinition = (ContextContextBindingDefinition)iterator22.next();
                String childContextId = contextContextBindingDefinition.getChildContextId();
                if (!contextDefinitionsById.containsKey(childContextId)) continue;
                ContextContextBinding contextContextBinding = new ContextContextBinding(childContextId, parentContextId);
                HashSet<ContextContextBinding> contextContextBindings = (HashSet<ContextContextBinding>)contextContextBindingsByParentContextId.get(parentContextId);
                if (contextContextBindings == null) {
                    contextContextBindings = new HashSet<ContextContextBinding>();
                    contextContextBindingsByParentContextId.put(parentContextId, contextContextBindings);
                }
                contextContextBindings.add(contextContextBinding);
            }
        }
        this.contextContextBindingsByParentContextId = contextContextBindingsByParentContextId;
        this.contextDefinitionsById = contextDefinitionsById;
        boolean definedContextIdsChanged = false;
        HashSet definedContextIds = new HashSet(contextDefinitionsById.keySet());
        if (!definedContextIds.equals(this.definedContextIds)) {
            this.definedContextIds = definedContextIds;
            definedContextIdsChanged = true;
        }
        HashSet enabledContextIds = new HashSet(this.enabledContextIds);
        this.getRequiredContextIds(this.enabledContextIds, enabledContextIds);
        boolean enabledContextIdsChanged = false;
        if (!this.enabledContextIds.equals(enabledContextIds)) {
            this.enabledContextIds = enabledContextIds;
            enabledContextIdsChanged = true;
        }
        Map contextEventsByContextId = this.updateContexts(this.contextsById.keySet());
        if (definedContextIdsChanged || enabledContextIdsChanged) {
            this.fireContextManagerChanged(new ContextManagerEvent(this, definedContextIdsChanged, enabledContextIdsChanged));
        }
        if (contextEventsByContextId != null) {
            this.notifyContexts(contextEventsByContextId);
        }
    }

    public void setEnabledContextIds(Set enabledContextIds) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        enabledContextIds = Util.safeCopy(enabledContextIds, (Class)clazz);
        HashSet requiredContextIds = new HashSet(enabledContextIds);
        this.getRequiredContextIds(enabledContextIds, requiredContextIds);
        enabledContextIds = requiredContextIds;
        boolean contextManagerChanged = false;
        Map contextEventsByContextId = null;
        if (!this.enabledContextIds.equals(enabledContextIds)) {
            this.enabledContextIds = enabledContextIds;
            contextManagerChanged = true;
            contextEventsByContextId = this.updateContexts(this.definedContextIds);
        }
        if (contextManagerChanged) {
            this.fireContextManagerChanged(new ContextManagerEvent(this, false, true));
        }
        if (contextEventsByContextId != null) {
            this.notifyContexts(contextEventsByContextId);
        }
    }

    private ContextEvent updateContext(Context context) {
        Set contextContextBindings = (Set)this.contextContextBindingsByParentContextId.get(context.getId());
        boolean contextContextBindingsChanged = context.setContextContextBindings(contextContextBindings != null ? contextContextBindings : Collections.EMPTY_SET);
        ContextDefinition contextDefinition = (ContextDefinition)this.contextDefinitionsById.get(context.getId());
        boolean definedChanged = context.setDefined(contextDefinition != null);
        boolean enabledChanged = context.setEnabled(this.enabledContextIds.contains(context.getId()));
        boolean nameChanged = context.setName(contextDefinition != null ? contextDefinition.getName() : null);
        boolean parentIdChanged = context.setParentId(contextDefinition != null ? contextDefinition.getParentId() : null);
        if (contextContextBindingsChanged || definedChanged || enabledChanged || nameChanged || parentIdChanged) {
            return new ContextEvent(context, contextContextBindingsChanged, definedChanged, enabledChanged, nameChanged, parentIdChanged);
        }
        return null;
    }

    private Map updateContexts(Collection contextIds) {
        TreeMap<String, ContextEvent> contextEventsByContextId = new TreeMap<String, ContextEvent>();
        Iterator iterator = contextIds.iterator();
        while (iterator.hasNext()) {
            ContextEvent contextEvent;
            String contextId = (String)iterator.next();
            Context context = (Context)this.contextsById.get(contextId);
            if (context == null || (contextEvent = this.updateContext(context)) == null) continue;
            contextEventsByContextId.put(contextId, contextEvent);
        }
        return contextEventsByContextId;
    }
}

