/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands.ws;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.CommandHandlerServiceFactory;
import org.eclipse.ui.commands.CommandManagerFactory;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.ICompoundCommandHandlerService;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;

public class WorkbenchCommandSupport
implements IWorkbenchCommandSupport {
    private ICompoundCommandHandlerService compoundCommandHandlerService;
    private WorkbenchKeyboard keyboard;
    private volatile boolean keyFilterDisabled;
    private ICommandManager mutableCommandManager = CommandManagerFactory.getCommandManager();

    public WorkbenchCommandSupport(Workbench workbench) {
        this.compoundCommandHandlerService = CommandHandlerServiceFactory.getCompoundCommandHandlerService();
        this.keyboard = new WorkbenchKeyboard(workbench, this.getCommandManager());
        this.enableKeyFilter();
    }

    public void deregisterFromKeyBindings(Shell shell) {
        if (this.keyboard != null) {
            this.keyboard.deregister(shell);
        } else {
            String message = "deregisterFromKeyBindings: Global key bindings are not available.";
            WorkbenchPlugin.log(message, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)new Exception()));
        }
    }

    public final void disableKeyFilter() {
        WorkbenchKeyboard workbenchKeyboard = this.keyboard;
        synchronized (workbenchKeyboard) {
            Display currentDisplay = Display.getCurrent();
            Listener keyFilter = this.keyboard.getKeyDownFilter();
            currentDisplay.removeFilter(1, keyFilter);
            currentDisplay.removeFilter(31, keyFilter);
            this.keyFilterDisabled = true;
        }
    }

    public final void enableKeyFilter() {
        WorkbenchKeyboard workbenchKeyboard = this.keyboard;
        synchronized (workbenchKeyboard) {
            Display currentDisplay = Display.getCurrent();
            Listener keyFilter = this.keyboard.getKeyDownFilter();
            currentDisplay.addFilter(1, keyFilter);
            currentDisplay.addFilter(31, keyFilter);
            this.keyFilterDisabled = false;
        }
    }

    public ICommandManager getCommandManager() {
        return this.mutableCommandManager;
    }

    public ICompoundCommandHandlerService getCompoundCommandHandlerService() {
        return this.compoundCommandHandlerService;
    }

    public WorkbenchKeyboard getKeyboard() {
        return this.keyboard;
    }

    public final boolean isKeyFilterEnabled() {
        WorkbenchKeyboard workbenchKeyboard = this.keyboard;
        synchronized (workbenchKeyboard) {
            return !this.keyFilterDisabled;
        }
    }

    public void registerForKeyBindings(Shell shell, boolean dialogOnly) {
        if (this.keyboard != null) {
            this.keyboard.register(shell, dialogOnly);
        } else {
            String message = "registerForKeyBindings: Global key bindings are not available.";
            WorkbenchPlugin.log(message, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)new Exception()));
        }
    }
}

