/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.ui.commands.CommandEvent;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandListener;
import org.eclipse.ui.commands.IContextBinding;
import org.eclipse.ui.commands.IImageBinding;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.commands.NotDefinedException;
import org.eclipse.ui.internal.util.Util;

final class Command
implements ICommand {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL;
    private boolean active;
    private List activityBindings;
    private transient IContextBinding[] activityBindingsAsArray;
    private String categoryId;
    private List commandListeners;
    private Set commandsWithListeners;
    private boolean defined;
    private String description;
    private boolean enabled;
    private transient int hashCode;
    private transient boolean hashCodeComputed;
    private String id;
    private List imageBindings;
    private transient IImageBinding[] imageBindingsAsArray;
    private List keySequenceBindings;
    private transient IKeySequenceBinding[] keySequenceBindingsAsArray;
    private String name;
    private transient String string;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.Command");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    Command(Set commandsWithListeners, String id) {
        if (commandsWithListeners == null || id == null) {
            throw new NullPointerException();
        }
        this.commandsWithListeners = commandsWithListeners;
        this.id = id;
    }

    public void addCommandListener(ICommandListener commandListener) {
        if (commandListener == null) {
            throw new NullPointerException();
        }
        if (this.commandListeners == null) {
            this.commandListeners = new ArrayList();
        }
        if (!this.commandListeners.contains(commandListener)) {
            this.commandListeners.add(commandListener);
        }
        this.commandsWithListeners.add(this);
    }

    public int compareTo(Object object) {
        Command castedObject = (Command)object;
        int compareTo = Util.compare(this.active, castedObject.active);
        if (compareTo == 0 && (compareTo = Util.compare(this.activityBindingsAsArray, castedObject.activityBindingsAsArray)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.categoryId), (Comparable)((Object)castedObject.categoryId))) == 0 && (compareTo = Util.compare(this.defined, castedObject.defined)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.description), (Comparable)((Object)castedObject.description))) == 0 && (compareTo = Util.compare(this.enabled, castedObject.enabled)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)castedObject.id))) == 0 && (compareTo = Util.compare(this.imageBindingsAsArray, castedObject.imageBindingsAsArray)) == 0 && (compareTo = Util.compare(this.keySequenceBindingsAsArray, castedObject.keySequenceBindingsAsArray)) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)castedObject.name));
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Command)) {
            return false;
        }
        Command castedObject = (Command)object;
        boolean equals = true;
        equals &= Util.equals(this.active, castedObject.active);
        equals &= Util.equals(this.activityBindings, castedObject.activityBindings);
        equals &= Util.equals(this.categoryId, castedObject.categoryId);
        equals &= Util.equals(this.defined, castedObject.defined);
        equals &= Util.equals(this.description, castedObject.description);
        equals &= Util.equals(this.enabled, castedObject.enabled);
        equals &= Util.equals(this.id, castedObject.id);
        equals &= Util.equals(this.imageBindings, castedObject.imageBindings);
        equals &= Util.equals(this.keySequenceBindings, castedObject.keySequenceBindings);
        return equals &= Util.equals(this.name, castedObject.name);
    }

    void fireCommandChanged(CommandEvent commandEvent) {
        if (commandEvent == null) {
            throw new NullPointerException();
        }
        if (this.commandListeners != null) {
            int i = 0;
            while (i < this.commandListeners.size()) {
                ((ICommandListener)this.commandListeners.get(i)).commandChanged(commandEvent);
                ++i;
            }
        }
    }

    public List getContextBindings() {
        return this.activityBindings;
    }

    public String getCategoryId() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.categoryId;
    }

    public String getDescription() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public List getImageBindings() {
        return this.imageBindings;
    }

    public List getKeySequenceBindings() {
        return this.keySequenceBindings;
    }

    public String getName() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.name;
    }

    public int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.active);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.activityBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.categoryId);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.defined);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.description);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.enabled);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.imageBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.keySequenceBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.name);
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void removeCommandListener(ICommandListener commandListener) {
        if (commandListener == null) {
            throw new NullPointerException();
        }
        if (this.commandListeners != null) {
            this.commandListeners.remove(commandListener);
        }
        if (this.commandListeners.isEmpty()) {
            this.commandsWithListeners.remove(this);
        }
    }

    boolean setActive(boolean active) {
        if (active != this.active) {
            this.active = active;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setActivityBindings(List activityBindings) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.commands.IContextBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Util.equals(activityBindings = Util.safeCopy(activityBindings, (Class)clazz), this.activityBindings)) {
            this.activityBindings = activityBindings;
            this.activityBindingsAsArray = this.activityBindings.toArray(new IContextBinding[this.activityBindings.size()]);
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setCategoryId(String categoryId) {
        if (!Util.equals(categoryId, this.categoryId)) {
            this.categoryId = categoryId;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDefined(boolean defined) {
        if (defined != this.defined) {
            this.defined = defined;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDescription(String description) {
        if (!Util.equals(description, this.description)) {
            this.description = description;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setImageBindings(List imageBindings) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.commands.IImageBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Util.equals(imageBindings = Util.safeCopy(imageBindings, (Class)clazz), this.imageBindings)) {
            this.imageBindings = imageBindings;
            this.imageBindingsAsArray = this.imageBindings.toArray(new IImageBinding[this.imageBindings.size()]);
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setKeySequenceBindings(List keySequenceBindings) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ui.commands.IKeySequenceBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Util.equals(keySequenceBindings = Util.safeCopy(keySequenceBindings, (Class)clazz), this.keySequenceBindings)) {
            this.keySequenceBindings = keySequenceBindings;
            this.keySequenceBindingsAsArray = this.keySequenceBindings.toArray(new IKeySequenceBinding[this.keySequenceBindings.size()]);
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setName(String name) {
        if (!Util.equals(name, this.name)) {
            this.name = name;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.active);
            stringBuffer.append(',');
            stringBuffer.append(this.activityBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.categoryId);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(',');
            stringBuffer.append(this.description);
            stringBuffer.append(',');
            stringBuffer.append(this.enabled);
            stringBuffer.append(',');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.imageBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.keySequenceBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }
}

