/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.colors;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.colors.ColorDefinitionReader;

public class ColorDefinition
implements IPluginContribution {
    public static ColorDefinition[] definitions;
    public static final Comparator HIERARCHY_COMPARATOR;
    public static final Comparator ID_COMPARATOR;
    private String defaultsTo;
    private String description;
    private String id;
    private String label;
    private String pluginId;
    private String rawValue;
    static /* synthetic */ Class class$0;

    static {
        HIERARCHY_COMPARATOR = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String def0 = ((ColorDefinition)arg0).getDefaultsTo();
                String def1 = ((ColorDefinition)arg1).getDefaultsTo();
                if (def0 == null && def1 == null) {
                    return 0;
                }
                if (def0 == null) {
                    return -1;
                }
                if (def1 == null) {
                    return 1;
                }
                return this.compare(this.getDef(def0), this.getDef(def1));
            }

            private Object getDef(String id) {
                int idx = Arrays.binarySearch(ColorDefinition.getDefinitions(), id, ID_COMPARATOR);
                if (idx >= 0) {
                    return ColorDefinition.getDefinitions()[idx];
                }
                return null;
            }
        };
        ID_COMPARATOR = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String str0 = this.getCompareString(arg0);
                String str1 = this.getCompareString(arg1);
                return str0.compareTo(str1);
            }

            private String getCompareString(Object object) {
                if (object instanceof String) {
                    return (String)object;
                }
                return ((ColorDefinition)object).getId();
            }
        };
    }

    public static ColorDefinition[] getDefinitions() {
        if (definitions == null) {
            ColorDefinitionReader reader = new ColorDefinitionReader();
            Collection values = reader.readRegistry(Platform.getPluginRegistry());
            ArrayList sorted = new ArrayList(values);
            Collections.sort(sorted, ID_COMPARATOR);
            definitions = new ColorDefinition[sorted.size()];
            sorted.toArray(definitions);
        }
        return definitions;
    }

    public ColorDefinition(String label, String id, String defaultsTo, String value, String description, String pluginId) {
        this.label = label;
        this.id = id;
        this.defaultsTo = defaultsTo;
        this.rawValue = value;
        this.description = description;
        this.pluginId = pluginId;
    }

    private String extractSWTConstant(String value) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.SWT");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            Field[] fields = clazz2.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                if (field.getType() == Integer.TYPE && Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && value.equals(field.getName())) {
                    return this.formatSystemColor(field.getInt(null));
                }
                ++i;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private String formatSystemColor(int colorId) {
        Color color = Display.getCurrent().getSystemColor(colorId);
        return String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue();
    }

    public String getDefaultsTo() {
        return this.defaultsTo;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getValue() {
        if (this.rawValue == null) {
            return null;
        }
        if (!this.isDirectValue()) {
            return this.extractSWTConstant(this.rawValue);
        }
        return this.rawValue;
    }

    private boolean isDirectValue() {
        return this.rawValue == null ? true : this.rawValue.matches("\\d+,\\d+,\\d+");
    }

    public String toString() {
        return this.getId();
    }
}

