/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.ICategoryActivityBinding;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.internal.activities.ws.ActivityContentProvider;
import org.eclipse.ui.internal.activities.ws.ActivityLabelProvider;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.activities.ws.CategoryContentProvider;
import org.eclipse.ui.internal.activities.ws.CategoryLabelProvider;

public class ActivityEnabler {
    private ListViewer activitiesViewer;
    private IWorkbenchActivitySupport activitySupport;
    private CheckboxTableViewer categoryViewer;
    private Set checkedInSession = new HashSet(7);
    private Set uncheckedInSession = new HashSet(7);
    private String lastCategory = null;

    public ActivityEnabler(IWorkbenchActivitySupport activityManager) {
        this.activitySupport = activityManager;
    }

    private boolean categoryEnabled(String categoryId) {
        Collection categoryActivities = this.getCategoryActivities(categoryId);
        Set enabledActivities = this.activitySupport.getActivityManager().getEnabledActivityIds();
        return enabledActivities.containsAll(categoryActivities);
    }

    public Control createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout(2, true));
        Label label = new Label(mainComposite, 0);
        label.setText(ActivityMessages.getString("ActivityEnabler.categories"));
        label.setLayoutData((Object)new GridData(768));
        label = new Label(mainComposite, 0);
        label.setText(ActivityMessages.getString("ActivityEnabler.activities"));
        label.setLayoutData((Object)new GridData(768));
        this.categoryViewer = CheckboxTableViewer.newCheckList((Composite)mainComposite, (int)2048);
        this.categoryViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.categoryViewer.setContentProvider((IContentProvider)new CategoryContentProvider());
        this.categoryViewer.setLabelProvider((IBaseLabelProvider)new CategoryLabelProvider(this.activitySupport.getActivityManager()));
        this.categoryViewer.setSorter(new ViewerSorter());
        this.categoryViewer.setInput((Object)this.activitySupport.getActivityManager());
        this.categoryViewer.setSelection((ISelection)new StructuredSelection());
        this.setCategoryStates();
        this.activitiesViewer = new ListViewer(mainComposite);
        this.activitiesViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.activitiesViewer.setContentProvider((IContentProvider)new ActivityContentProvider());
        this.activitiesViewer.setLabelProvider((IBaseLabelProvider)new ActivityLabelProvider(this.activitySupport.getActivityManager()));
        this.activitiesViewer.setSorter(new ViewerSorter());
        this.activitiesViewer.setInput((Object)Collections.EMPTY_SET);
        this.activitiesViewer.getControl().setEnabled(false);
        this.categoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String categoryId;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty() && !(categoryId = (String)selection.getFirstElement()).equals(ActivityEnabler.this.lastCategory)) {
                    ActivityEnabler.this.lastCategory = categoryId;
                    ActivityEnabler.this.activitiesViewer.setInput((Object)ActivityEnabler.this.getCategoryActivities(categoryId));
                }
            }
        });
        this.categoryViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (event.getChecked()) {
                    if (!ActivityEnabler.this.uncheckedInSession.remove(element)) {
                        ActivityEnabler.this.checkedInSession.add(element);
                    }
                } else if (!ActivityEnabler.this.checkedInSession.remove(element)) {
                    ActivityEnabler.this.uncheckedInSession.add(element);
                }
            }
        });
        Object firstElement = this.categoryViewer.getElementAt(0);
        if (firstElement != null) {
            this.categoryViewer.setSelection((ISelection)new StructuredSelection(firstElement), true);
        }
        return mainComposite;
    }

    private Collection getCategoryActivities(String categoryId) {
        ICategory category = this.activitySupport.getActivityManager().getCategory(categoryId);
        Set activityBindings = category.getCategoryActivityBindings();
        ArrayList<String> categoryActivities = new ArrayList<String>(10);
        Iterator j = activityBindings.iterator();
        while (j.hasNext()) {
            ICategoryActivityBinding binding = (ICategoryActivityBinding)j.next();
            String activityId = binding.getActivityId();
            categoryActivities.add(activityId);
        }
        return categoryActivities;
    }

    private void setCategoryStates() {
        Set categories = this.activitySupport.getActivityManager().getDefinedCategoryIds();
        ArrayList<String> enabledCategories = new ArrayList<String>(10);
        Iterator i = categories.iterator();
        while (i.hasNext()) {
            String categoryId = (String)i.next();
            if (!this.categoryEnabled(categoryId)) continue;
            enabledCategories.add(categoryId);
        }
        this.categoryViewer.setCheckedElements(enabledCategories.toArray());
    }

    public void updateActivityStates() {
        String categoryId;
        HashSet enabledActivities = new HashSet(this.activitySupport.getActivityManager().getEnabledActivityIds());
        Iterator i = this.uncheckedInSession.iterator();
        while (i.hasNext()) {
            categoryId = (String)i.next();
            enabledActivities.removeAll(this.getCategoryActivities(categoryId));
        }
        i = this.checkedInSession.iterator();
        while (i.hasNext()) {
            categoryId = (String)i.next();
            enabledActivities.addAll(this.getCategoryActivities(categoryId));
        }
        this.activitySupport.setEnabledActivityIds(enabledActivities);
    }
}

