/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.activities.ActivityEvent;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.CategoryEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityActivityBinding;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IMutableActivityManager;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.internal.activities.AbstractActivityManager;
import org.eclipse.ui.internal.activities.Activity;
import org.eclipse.ui.internal.activities.ActivityActivityBinding;
import org.eclipse.ui.internal.activities.ActivityActivityBindingDefinition;
import org.eclipse.ui.internal.activities.ActivityDefinition;
import org.eclipse.ui.internal.activities.ActivityPatternBinding;
import org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition;
import org.eclipse.ui.internal.activities.ActivityRegistryEvent;
import org.eclipse.ui.internal.activities.Category;
import org.eclipse.ui.internal.activities.CategoryActivityBinding;
import org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryDefinition;
import org.eclipse.ui.internal.activities.ExtensionActivityRegistry;
import org.eclipse.ui.internal.activities.IActivityRegistry;
import org.eclipse.ui.internal.activities.IActivityRegistryListener;
import org.eclipse.ui.internal.activities.Identifier;
import org.eclipse.ui.internal.util.Util;

public final class MutableActivityManager
extends AbstractActivityManager
implements IMutableActivityManager {
    private Map activitiesById = new WeakHashMap();
    private Map activityActivityBindingsByParentActivityId = new HashMap();
    private Map activityDefinitionsById = new HashMap();
    private Map activityPatternBindingsByActivityId = new HashMap();
    private IActivityRegistry activityRegistry;
    private Map categoriesById = new WeakHashMap();
    private Map categoryActivityBindingsByCategoryId = new HashMap();
    private Map categoryDefinitionsById = new HashMap();
    private Set definedActivityIds = new HashSet();
    private Set definedCategoryIds = new HashSet();
    private Set enabledActivityIds = new HashSet();
    private Map identifiersById = new WeakHashMap();
    static /* synthetic */ Class class$0;

    public MutableActivityManager() {
        this(new ExtensionActivityRegistry(Platform.getExtensionRegistry()));
    }

    public MutableActivityManager(IActivityRegistry activityRegistry) {
        if (activityRegistry == null) {
            throw new NullPointerException();
        }
        this.activityRegistry = activityRegistry;
        this.activityRegistry.addActivityRegistryListener(new IActivityRegistryListener(){

            public void activityRegistryChanged(ActivityRegistryEvent activityRegistryEvent) {
                MutableActivityManager.this.readRegistry();
            }
        });
        this.readRegistry();
    }

    public IActivity getActivity(String activityId) {
        if (activityId == null) {
            throw new NullPointerException();
        }
        Activity activity = (Activity)this.activitiesById.get(activityId);
        if (activity == null) {
            activity = new Activity(activityId);
            this.updateActivity(activity);
            this.activitiesById.put(activityId, activity);
        }
        return activity;
    }

    public ICategory getCategory(String categoryId) {
        if (categoryId == null) {
            throw new NullPointerException();
        }
        Category category = (Category)this.categoriesById.get(categoryId);
        if (category == null) {
            category = new Category(categoryId);
            this.updateCategory(category);
            this.categoriesById.put(categoryId, category);
        }
        return category;
    }

    public Set getDefinedActivityIds() {
        return Collections.unmodifiableSet(this.definedActivityIds);
    }

    public Set getDefinedCategoryIds() {
        return Collections.unmodifiableSet(this.definedCategoryIds);
    }

    public Set getEnabledActivityIds() {
        return Collections.unmodifiableSet(this.enabledActivityIds);
    }

    public IIdentifier getIdentifier(String identifierId) {
        if (identifierId == null) {
            throw new NullPointerException();
        }
        Identifier identifier = (Identifier)this.identifiersById.get(identifierId);
        if (identifier == null) {
            identifier = new Identifier(identifierId);
            this.updateIdentifier(identifier);
            this.identifiersById.put(identifierId, identifier);
        }
        return identifier;
    }

    private void getRequiredActivityIds(Set activityIds, Set requiredActivityIds) {
        Iterator iterator = activityIds.iterator();
        while (iterator.hasNext()) {
            String activityId = (String)iterator.next();
            IActivity activity = this.getActivity(activityId);
            HashSet<String> childActivityIds = new HashSet<String>();
            Set activityActivityBindings = activity.getActivityActivityBindings();
            Iterator iterator2 = activityActivityBindings.iterator();
            while (iterator2.hasNext()) {
                IActivityActivityBinding activityActivityBinding = (IActivityActivityBinding)iterator2.next();
                childActivityIds.add(activityActivityBinding.getChildActivityId());
            }
            childActivityIds.removeAll(requiredActivityIds);
            requiredActivityIds.addAll(childActivityIds);
            this.getRequiredActivityIds(childActivityIds, requiredActivityIds);
        }
    }

    public boolean isMatch(String string, Set activityIds) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        activityIds = Util.safeCopy(activityIds, (Class)clazz);
        Iterator iterator = activityIds.iterator();
        while (iterator.hasNext()) {
            String activityId = (String)iterator.next();
            Activity activity = (Activity)this.getActivity(activityId);
            if (!activity.isMatch(string)) continue;
            return true;
        }
        return false;
    }

    private void notifyActivities(Map activityEventsByActivityId) {
        Iterator iterator = activityEventsByActivityId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String activityId = (String)entry.getKey();
            ActivityEvent activityEvent = (ActivityEvent)entry.getValue();
            Activity activity = (Activity)this.activitiesById.get(activityId);
            if (activity == null) continue;
            activity.fireActivityChanged(activityEvent);
        }
    }

    private void notifyCategories(Map categoryEventsByCategoryId) {
        Iterator iterator = categoryEventsByCategoryId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String categoryId = (String)entry.getKey();
            CategoryEvent categoryEvent = (CategoryEvent)entry.getValue();
            Category category = (Category)this.categoriesById.get(categoryId);
            if (category == null) continue;
            category.fireCategoryChanged(categoryEvent);
        }
    }

    private void notifyIdentifiers(Map identifierEventsByIdentifierId) {
        Iterator iterator = identifierEventsByIdentifierId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String identifierId = (String)entry.getKey();
            IdentifierEvent identifierEvent = (IdentifierEvent)entry.getValue();
            Identifier identifier = (Identifier)this.identifiersById.get(identifierId);
            if (identifier == null) continue;
            identifier.fireIdentifierChanged(identifierEvent);
        }
    }

    private void readRegistry() {
        ArrayList activityDefinitions = new ArrayList();
        activityDefinitions.addAll(this.activityRegistry.getActivityDefinitions());
        HashMap activityDefinitionsById = new HashMap(ActivityDefinition.activityDefinitionsById(activityDefinitions, false));
        Iterator iterator = activityDefinitionsById.values().iterator();
        while (iterator.hasNext()) {
            ActivityDefinition activityDefinition = (ActivityDefinition)iterator.next();
            String name = activityDefinition.getName();
            if (name != null && name.length() != 0) continue;
            iterator.remove();
        }
        ArrayList categoryDefinitions = new ArrayList();
        categoryDefinitions.addAll(this.activityRegistry.getCategoryDefinitions());
        HashMap categoryDefinitionsById = new HashMap(CategoryDefinition.categoryDefinitionsById(categoryDefinitions, false));
        Iterator iterator2 = categoryDefinitionsById.values().iterator();
        while (iterator2.hasNext()) {
            CategoryDefinition categoryDefinition = (CategoryDefinition)iterator2.next();
            String name = categoryDefinition.getName();
            if (name != null && name.length() != 0) continue;
            iterator2.remove();
        }
        Map activityActivityBindingDefinitionsByParentActivityId = ActivityActivityBindingDefinition.activityActivityBindingDefinitionsByParentActivityId(this.activityRegistry.getActivityActivityBindingDefinitions());
        HashMap<String, HashSet<ActivityActivityBinding>> activityActivityBindingsByParentActivityId = new HashMap<String, HashSet<ActivityActivityBinding>>();
        Iterator iterator3 = activityActivityBindingDefinitionsByParentActivityId.entrySet().iterator();
        while (iterator3.hasNext()) {
            Collection activityActivityBindingDefinitions;
            Map.Entry entry = iterator3.next();
            String parentActivityId = (String)entry.getKey();
            if (!activityDefinitionsById.containsKey(parentActivityId) || (activityActivityBindingDefinitions = (Collection)entry.getValue()) == null) continue;
            Iterator iterator22 = activityActivityBindingDefinitions.iterator();
            while (iterator22.hasNext()) {
                ActivityActivityBindingDefinition activityActivityBindingDefinition = (ActivityActivityBindingDefinition)iterator22.next();
                String childActivityId = activityActivityBindingDefinition.getChildActivityId();
                if (!activityDefinitionsById.containsKey(childActivityId)) continue;
                ActivityActivityBinding activityActivityBinding = new ActivityActivityBinding(childActivityId, parentActivityId);
                HashSet<ActivityActivityBinding> activityActivityBindings = (HashSet<ActivityActivityBinding>)activityActivityBindingsByParentActivityId.get(parentActivityId);
                if (activityActivityBindings == null) {
                    activityActivityBindings = new HashSet<ActivityActivityBinding>();
                    activityActivityBindingsByParentActivityId.put(parentActivityId, activityActivityBindings);
                }
                activityActivityBindings.add(activityActivityBinding);
            }
        }
        Map activityPatternBindingDefinitionsByActivityId = ActivityPatternBindingDefinition.activityPatternBindingDefinitionsByActivityId(this.activityRegistry.getActivityPatternBindingDefinitions());
        HashMap<String, HashSet<ActivityPatternBinding>> activityPatternBindingsByActivityId = new HashMap<String, HashSet<ActivityPatternBinding>>();
        Iterator iterator4 = activityPatternBindingDefinitionsByActivityId.entrySet().iterator();
        while (iterator4.hasNext()) {
            Collection activityPatternBindingDefinitions;
            Map.Entry entry = iterator4.next();
            String activityId = (String)entry.getKey();
            if (!activityDefinitionsById.containsKey(activityId) || (activityPatternBindingDefinitions = (Collection)entry.getValue()) == null) continue;
            Iterator iterator23 = activityPatternBindingDefinitions.iterator();
            while (iterator23.hasNext()) {
                ActivityPatternBindingDefinition activityPatternBindingDefinition = (ActivityPatternBindingDefinition)iterator23.next();
                String pattern = activityPatternBindingDefinition.getPattern();
                if (pattern == null || pattern.length() == 0) continue;
                ActivityPatternBinding activityPatternBinding = new ActivityPatternBinding(activityId, Pattern.compile(pattern));
                HashSet<ActivityPatternBinding> activityPatternBindings = (HashSet<ActivityPatternBinding>)activityPatternBindingsByActivityId.get(activityId);
                if (activityPatternBindings == null) {
                    activityPatternBindings = new HashSet<ActivityPatternBinding>();
                    activityPatternBindingsByActivityId.put(activityId, activityPatternBindings);
                }
                activityPatternBindings.add(activityPatternBinding);
            }
        }
        Map categoryActivityBindingDefinitionsByCategoryId = CategoryActivityBindingDefinition.categoryActivityBindingDefinitionsByCategoryId(this.activityRegistry.getCategoryActivityBindingDefinitions());
        HashMap<String, HashSet<CategoryActivityBinding>> categoryActivityBindingsByCategoryId = new HashMap<String, HashSet<CategoryActivityBinding>>();
        Iterator iterator5 = categoryActivityBindingDefinitionsByCategoryId.entrySet().iterator();
        while (iterator5.hasNext()) {
            Collection categoryActivityBindingDefinitions;
            Map.Entry entry = iterator5.next();
            String categoryId = (String)entry.getKey();
            if (!categoryDefinitionsById.containsKey(categoryId) || (categoryActivityBindingDefinitions = (Collection)entry.getValue()) == null) continue;
            Iterator iterator24 = categoryActivityBindingDefinitions.iterator();
            while (iterator24.hasNext()) {
                CategoryActivityBindingDefinition categoryActivityBindingDefinition = (CategoryActivityBindingDefinition)iterator24.next();
                String activityId = categoryActivityBindingDefinition.getActivityId();
                if (!activityDefinitionsById.containsKey(activityId)) continue;
                CategoryActivityBinding categoryActivityBinding = new CategoryActivityBinding(activityId, categoryId);
                HashSet<CategoryActivityBinding> categoryActivityBindings = (HashSet<CategoryActivityBinding>)categoryActivityBindingsByCategoryId.get(categoryId);
                if (categoryActivityBindings == null) {
                    categoryActivityBindings = new HashSet<CategoryActivityBinding>();
                    categoryActivityBindingsByCategoryId.put(categoryId, categoryActivityBindings);
                }
                categoryActivityBindings.add(categoryActivityBinding);
            }
        }
        this.activityActivityBindingsByParentActivityId = activityActivityBindingsByParentActivityId;
        this.activityDefinitionsById = activityDefinitionsById;
        this.activityPatternBindingsByActivityId = activityPatternBindingsByActivityId;
        this.categoryActivityBindingsByCategoryId = categoryActivityBindingsByCategoryId;
        this.categoryDefinitionsById = categoryDefinitionsById;
        boolean definedActivityIdsChanged = false;
        HashSet definedActivityIds = new HashSet(activityDefinitionsById.keySet());
        if (!definedActivityIds.equals(this.definedActivityIds)) {
            this.definedActivityIds = definedActivityIds;
            definedActivityIdsChanged = true;
        }
        boolean definedCategoryIdsChanged = false;
        HashSet definedCategoryIds = new HashSet(categoryDefinitionsById.keySet());
        if (!definedCategoryIds.equals(this.definedCategoryIds)) {
            this.definedCategoryIds = definedCategoryIds;
            definedCategoryIdsChanged = true;
        }
        HashSet enabledActivityIds = new HashSet(this.enabledActivityIds);
        this.getRequiredActivityIds(this.enabledActivityIds, enabledActivityIds);
        boolean enabledActivityIdsChanged = false;
        if (!this.enabledActivityIds.equals(enabledActivityIds)) {
            this.enabledActivityIds = enabledActivityIds;
            enabledActivityIdsChanged = true;
        }
        Map activityEventsByActivityId = this.updateActivities(this.activitiesById.keySet());
        Map categoryEventsByCategoryId = this.updateCategories(this.categoriesById.keySet());
        Map identifierEventsByIdentifierId = this.updateIdentifiers(this.identifiersById.keySet());
        if (definedActivityIdsChanged || definedCategoryIdsChanged || enabledActivityIdsChanged) {
            this.fireActivityManagerChanged(new ActivityManagerEvent(this, definedActivityIdsChanged, definedCategoryIdsChanged, enabledActivityIdsChanged));
        }
        if (activityEventsByActivityId != null) {
            this.notifyActivities(activityEventsByActivityId);
        }
        if (categoryEventsByCategoryId != null) {
            this.notifyCategories(categoryEventsByCategoryId);
        }
        if (identifierEventsByIdentifierId != null) {
            this.notifyIdentifiers(identifierEventsByIdentifierId);
        }
    }

    public void setEnabledActivityIds(Set enabledActivityIds) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        enabledActivityIds = Util.safeCopy(enabledActivityIds, (Class)clazz);
        HashSet requiredActivityIds = new HashSet(enabledActivityIds);
        this.getRequiredActivityIds(enabledActivityIds, requiredActivityIds);
        enabledActivityIds = requiredActivityIds;
        boolean activityManagerChanged = false;
        Map activityEventsByActivityId = null;
        if (!this.enabledActivityIds.equals(enabledActivityIds)) {
            this.enabledActivityIds = enabledActivityIds;
            activityManagerChanged = true;
            activityEventsByActivityId = this.updateActivities(this.definedActivityIds);
        }
        Map identifierEventsByIdentifierId = this.updateIdentifiers(this.identifiersById.keySet());
        if (activityManagerChanged) {
            this.fireActivityManagerChanged(new ActivityManagerEvent(this, false, false, true));
        }
        if (activityEventsByActivityId != null) {
            this.notifyActivities(activityEventsByActivityId);
        }
        if (identifierEventsByIdentifierId != null) {
            this.notifyIdentifiers(identifierEventsByIdentifierId);
        }
    }

    private Map updateActivities(Collection activityIds) {
        TreeMap<String, ActivityEvent> activityEventsByActivityId = new TreeMap<String, ActivityEvent>();
        Iterator iterator = activityIds.iterator();
        while (iterator.hasNext()) {
            ActivityEvent activityEvent;
            String activityId = (String)iterator.next();
            Activity activity = (Activity)this.activitiesById.get(activityId);
            if (activity == null || (activityEvent = this.updateActivity(activity)) == null) continue;
            activityEventsByActivityId.put(activityId, activityEvent);
        }
        return activityEventsByActivityId;
    }

    private ActivityEvent updateActivity(Activity activity) {
        Set activityActivityBindings = (Set)this.activityActivityBindingsByParentActivityId.get(activity.getId());
        boolean activityActivityBindingsChanged = activity.setActivityActivityBindings(activityActivityBindings != null ? activityActivityBindings : Collections.EMPTY_SET);
        Set activityPatternBindings = (Set)this.activityPatternBindingsByActivityId.get(activity.getId());
        boolean activityPatternBindingsChanged = activity.setActivityPatternBindings(activityPatternBindings != null ? activityPatternBindings : Collections.EMPTY_SET);
        ActivityDefinition activityDefinition = (ActivityDefinition)this.activityDefinitionsById.get(activity.getId());
        boolean definedChanged = activity.setDefined(activityDefinition != null);
        boolean enabledChanged = activity.setEnabled(this.enabledActivityIds.contains(activity.getId()));
        boolean nameChanged = activity.setName(activityDefinition != null ? activityDefinition.getName() : null);
        if (activityActivityBindingsChanged || activityPatternBindingsChanged || definedChanged || enabledChanged || nameChanged) {
            return new ActivityEvent(activity, activityActivityBindingsChanged, activityPatternBindingsChanged, definedChanged, enabledChanged, nameChanged);
        }
        return null;
    }

    private Map updateCategories(Collection categoryIds) {
        TreeMap<String, CategoryEvent> categoryEventsByCategoryId = new TreeMap<String, CategoryEvent>();
        Iterator iterator = categoryIds.iterator();
        while (iterator.hasNext()) {
            CategoryEvent categoryEvent;
            String categoryId = (String)iterator.next();
            Category category = (Category)this.categoriesById.get(categoryId);
            if (category == null || (categoryEvent = this.updateCategory(category)) == null) continue;
            categoryEventsByCategoryId.put(categoryId, categoryEvent);
        }
        return categoryEventsByCategoryId;
    }

    private CategoryEvent updateCategory(Category category) {
        Set categoryActivityBindings = (Set)this.categoryActivityBindingsByCategoryId.get(category.getId());
        boolean categoryActivityBindingsChanged = category.setCategoryActivityBindings(categoryActivityBindings != null ? categoryActivityBindings : Collections.EMPTY_SET);
        CategoryDefinition categoryDefinition = (CategoryDefinition)this.categoryDefinitionsById.get(category.getId());
        boolean definedChanged = category.setDefined(categoryDefinition != null);
        boolean nameChanged = category.setName(categoryDefinition != null ? categoryDefinition.getName() : null);
        if (categoryActivityBindingsChanged || definedChanged || nameChanged) {
            return new CategoryEvent(category, categoryActivityBindingsChanged, definedChanged, nameChanged);
        }
        return null;
    }

    private IdentifierEvent updateIdentifier(Identifier identifier) {
        String id = identifier.getId();
        HashSet<String> activityIds = new HashSet<String>();
        Iterator iterator = this.definedActivityIds.iterator();
        while (iterator.hasNext()) {
            String activityId = (String)iterator.next();
            Activity activity = (Activity)this.getActivity(activityId);
            if (!activity.isMatch(id)) continue;
            activityIds.add(activityId);
        }
        boolean enabled = this.isMatch(id, this.enabledActivityIds) || !this.isMatch(id, this.definedActivityIds);
        boolean activityIdsChanged = identifier.setActivityIds(activityIds);
        boolean enabledChanged = identifier.setEnabled(enabled);
        if (activityIdsChanged || enabledChanged) {
            return new IdentifierEvent(identifier, activityIdsChanged, enabledChanged);
        }
        return null;
    }

    private Map updateIdentifiers(Collection identifierIds) {
        TreeMap<String, IdentifierEvent> identifierEventsByIdentifierId = new TreeMap<String, IdentifierEvent>();
        Iterator iterator = identifierIds.iterator();
        while (iterator.hasNext()) {
            IdentifierEvent identifierEvent;
            String identifierId = (String)iterator.next();
            Identifier identifier = (Identifier)this.identifiersById.get(identifierId);
            if (identifier == null || (identifierEvent = this.updateIdentifier(identifier)) == null) continue;
            identifierEventsByIdentifierId.put(identifierId, identifierEvent);
        }
        return identifierEventsByIdentifierId;
    }
}

