/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.ui.activities.ActivityEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityActivityBinding;
import org.eclipse.ui.activities.IActivityListener;
import org.eclipse.ui.activities.IActivityPatternBinding;
import org.eclipse.ui.activities.NotDefinedException;
import org.eclipse.ui.internal.util.Util;

final class Activity
implements IActivity {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL;
    private static final Set strongReferences;
    private Set activityActivityBindings;
    private transient IActivityActivityBinding[] activityActivityBindingsAsArray;
    private List activityListeners;
    private Set activityPatternBindings;
    private transient IActivityPatternBinding[] activityPatternBindingsAsArray;
    private boolean defined;
    private boolean enabled;
    private transient int hashCode;
    private transient boolean hashCodeComputed;
    private String id;
    private String name;
    private transient String string;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.activities.Activity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
        strongReferences = new HashSet();
    }

    Activity(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.id = id;
    }

    public void addActivityListener(IActivityListener activityListener) {
        if (activityListener == null) {
            throw new NullPointerException();
        }
        if (this.activityListeners == null) {
            this.activityListeners = new ArrayList();
        }
        if (!this.activityListeners.contains(activityListener)) {
            this.activityListeners.add(activityListener);
        }
        strongReferences.add(this);
    }

    public int compareTo(Object object) {
        Activity castedObject = (Activity)object;
        int compareTo = Util.compare(this.activityActivityBindingsAsArray, castedObject.activityActivityBindingsAsArray);
        if (compareTo == 0 && (compareTo = Util.compare(this.activityPatternBindingsAsArray, castedObject.activityPatternBindingsAsArray)) == 0 && (compareTo = Util.compare(this.defined, castedObject.defined)) == 0 && (compareTo = Util.compare(this.enabled, castedObject.enabled)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)castedObject.id))) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)castedObject.name));
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Activity)) {
            return false;
        }
        Activity castedObject = (Activity)object;
        boolean equals = true;
        equals &= Util.equals(this.activityActivityBindings, castedObject.activityActivityBindings);
        equals &= Util.equals(this.activityPatternBindings, castedObject.activityPatternBindings);
        equals &= Util.equals(this.defined, castedObject.defined);
        equals &= Util.equals(this.enabled, castedObject.enabled);
        equals &= Util.equals(this.id, castedObject.id);
        return equals &= Util.equals(this.name, castedObject.name);
    }

    void fireActivityChanged(ActivityEvent activityEvent) {
        if (activityEvent == null) {
            throw new NullPointerException();
        }
        if (this.activityListeners != null) {
            int i = 0;
            while (i < this.activityListeners.size()) {
                ((IActivityListener)this.activityListeners.get(i)).activityChanged(activityEvent);
                ++i;
            }
        }
    }

    public Set getActivityActivityBindings() {
        return this.activityActivityBindings;
    }

    public Set getActivityPatternBindings() {
        return this.activityPatternBindings;
    }

    public String getId() {
        return this.id;
    }

    public String getName() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.name;
    }

    public int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.activityActivityBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.activityPatternBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.defined);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.enabled);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.name);
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMatch(String string) {
        if (this.isDefined()) {
            Iterator iterator = this.activityPatternBindings.iterator();
            while (iterator.hasNext()) {
                IActivityPatternBinding activityPatternBinding = (IActivityPatternBinding)iterator.next();
                if (!activityPatternBinding.getPattern().matcher(string).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public void removeActivityListener(IActivityListener activityListener) {
        if (activityListener == null) {
            throw new NullPointerException();
        }
        if (this.activityListeners != null) {
            this.activityListeners.remove(activityListener);
        }
        if (this.activityListeners.isEmpty()) {
            strongReferences.remove(this);
        }
    }

    boolean setActivityActivityBindings(Set activityActivityBindings) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.activities.IActivityActivityBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Util.equals(activityActivityBindings = Util.safeCopy(activityActivityBindings, (Class)clazz), this.activityActivityBindings)) {
            this.activityActivityBindings = activityActivityBindings;
            this.activityActivityBindingsAsArray = this.activityActivityBindings.toArray(new IActivityActivityBinding[this.activityActivityBindings.size()]);
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setActivityPatternBindings(Set activityPatternBindings) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.activities.IActivityPatternBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Util.equals(activityPatternBindings = Util.safeCopy(activityPatternBindings, (Class)clazz), this.activityPatternBindings)) {
            this.activityPatternBindings = activityPatternBindings;
            this.activityPatternBindingsAsArray = this.activityPatternBindings.toArray(new IActivityPatternBinding[this.activityPatternBindings.size()]);
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDefined(boolean defined) {
        if (defined != this.defined) {
            this.defined = defined;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setName(String name) {
        if (!Util.equals(name, this.name)) {
            this.name = name;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.activityActivityBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.activityPatternBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(',');
            stringBuffer.append(this.enabled);
            stringBuffer.append(',');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }
}

