/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkingSet;
import org.eclipse.ui.internal.WorkingSetComparator;
import org.eclipse.ui.internal.dialogs.WorkingSetEditWizard;
import org.eclipse.ui.internal.dialogs.WorkingSetSelectionDialog;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;

public class WorkingSetManager
implements IWorkingSetManager {
    private static final String WORKING_SET_STATE_FILENAME = "workingsets.xml";
    private static final int MRU_SIZE = 5;
    private SortedSet workingSets = new TreeSet(new WorkingSetComparator());
    private List recentWorkingSets = new ArrayList();
    private ListenerList propertyChangeListeners = new ListenerList();
    static /* synthetic */ Class class$0;

    public void addRecentWorkingSet(IWorkingSet workingSet) {
        this.internalAddRecentWorkingSet(workingSet);
        this.saveState();
    }

    public void addWorkingSet(IWorkingSet workingSet) {
        Assert.isTrue((!this.workingSets.contains(workingSet) ? 1 : 0) != 0, (String)"working set already registered");
        this.workingSets.add(workingSet);
        this.saveState();
        this.firePropertyChange("workingSetAdd", null, workingSet);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public IWorkingSet createWorkingSet(String name, IAdaptable[] elements) {
        return new WorkingSet(name, elements);
    }

    public IWorkingSet createWorkingSet(IMemento memento) {
        return this.restoreWorkingSet(memento);
    }

    public IWorkingSetEditWizard createWorkingSetEditWizard(IWorkingSet workingSet) {
        String editPageId = workingSet.getId();
        WorkingSetRegistry registry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        IWorkingSetPage editPage = null;
        if (editPageId != null) {
            editPage = registry.getWorkingSetPage(editPageId);
        }
        if (editPage == null && (editPage = registry.getDefaultWorkingSetPage()) == null) {
            return null;
        }
        WorkingSetEditWizard editWizard = new WorkingSetEditWizard(editPage);
        editWizard.setSelection(workingSet);
        return editWizard;
    }

    public IWorkingSetSelectionDialog createWorkingSetSelectionDialog(Shell parent) {
        return this.createWorkingSetSelectionDialog(parent, true);
    }

    public IWorkingSetSelectionDialog createWorkingSetSelectionDialog(Shell parent, boolean multi) {
        return new WorkingSetSelectionDialog(parent, multi);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WorkingSetManager) {
            WorkingSetManager workingSetManager = (WorkingSetManager)object;
            return workingSetManager.workingSets.equals(this.workingSets);
        }
        return false;
    }

    private void firePropertyChange(String changeId, Object oldValue, Object newValue) {
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, changeId, oldValue, newValue);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Object[] listeners = WorkingSetManager.this.propertyChangeListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                    ++i;
                }
            }
        });
    }

    public IWorkingSet[] getRecentWorkingSets() {
        return this.recentWorkingSets.toArray(new IWorkingSet[this.recentWorkingSets.size()]);
    }

    public IWorkingSet getWorkingSet(String name) {
        if (name == null || this.workingSets == null) {
            return null;
        }
        Iterator iter = this.workingSets.iterator();
        while (iter.hasNext()) {
            IWorkingSet workingSet = (IWorkingSet)iter.next();
            if (!name.equals(workingSet.getName())) continue;
            return workingSet;
        }
        return null;
    }

    public int hashCode() {
        return this.workingSets.hashCode();
    }

    public IWorkingSet[] getWorkingSets() {
        return this.workingSets.toArray(new IWorkingSet[this.workingSets.size()]);
    }

    private File getWorkingSetStateFile() {
        IPath path = WorkbenchPlugin.getDefault().getStateLocation();
        path = path.append(WORKING_SET_STATE_FILENAME);
        return path.toFile();
    }

    private void internalAddRecentWorkingSet(IWorkingSet workingSet) {
        this.recentWorkingSets.remove(workingSet);
        this.recentWorkingSets.add(0, workingSet);
        if (this.recentWorkingSets.size() > 5) {
            this.recentWorkingSets.remove(5);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove((Object)listener);
    }

    public void removeWorkingSet(IWorkingSet workingSet) {
        boolean workingSetRemoved = this.workingSets.remove(workingSet);
        boolean recentWorkingSetRemoved = this.recentWorkingSets.remove(workingSet);
        if (workingSetRemoved || recentWorkingSetRemoved) {
            this.saveState();
            this.firePropertyChange("workingSetRemove", workingSet, null);
        }
    }

    private void restoreMruList(IMemento memento) {
        IMemento[] mruWorkingSets = memento.getChildren("mruList");
        int i = mruWorkingSets.length - 1;
        while (i >= 0) {
            IWorkingSet workingSet;
            String workingSetName = mruWorkingSets[i].getString("name");
            if (workingSetName != null && (workingSet = this.getWorkingSet(workingSetName)) != null) {
                this.internalAddRecentWorkingSet(workingSet);
            }
            --i;
        }
    }

    public void restoreState() {
        File stateFile = this.getWorkingSetStateFile();
        if (stateFile.exists()) {
            try {
                FileInputStream input = new FileInputStream(stateFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, "utf-8"));
                XMLMemento memento = XMLMemento.createReadRoot(reader);
                this.restoreWorkingSetState(memento);
                this.restoreMruList(memento);
                reader.close();
            }
            catch (IOException e) {
                MessageDialog.openError(null, (String)WorkbenchMessages.getString("ProblemRestoringWorkingSetState.title"), (String)WorkbenchMessages.getString("ProblemRestoringWorkingSetState.message"));
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError(null, (String)WorkbenchMessages.getString("ProblemRestoringWorkingSetState.title"), (String)WorkbenchMessages.getString("ProblemRestoringWorkingSetState.message"), (IStatus)e.getStatus());
            }
        }
    }

    private IWorkingSet restoreWorkingSet(IMemento memento) {
        IElementFactory factory;
        String factoryID = memento.getString("factoryID");
        if (factoryID == null) {
            factoryID = "org.eclipse.ui.internal.WorkingSetFactory";
        }
        if ((factory = PlatformUI.getWorkbench().getElementFactory(factoryID)) == null) {
            WorkbenchPlugin.log("Unable to restore working set - cannot instantiate factory: " + factoryID);
            return null;
        }
        IAdaptable adaptable = factory.createElement(memento);
        if (adaptable == null) {
            WorkbenchPlugin.log("Unable to restore working set - cannot instantiate working set: " + factoryID);
            return null;
        }
        if (!(adaptable instanceof IWorkingSet)) {
            WorkbenchPlugin.log("Unable to restore working set - element is not an IWorkingSet: " + factoryID);
            return null;
        }
        return (IWorkingSet)adaptable;
    }

    private void restoreWorkingSetState(IMemento memento) {
        IMemento[] children = memento.getChildren("workingSet");
        int i = 0;
        while (i < children.length) {
            IWorkingSet workingSet = this.restoreWorkingSet(children[i]);
            if (workingSet != null) {
                this.workingSets.add(workingSet);
                this.firePropertyChange("workingSetAdd", null, workingSet);
            }
            ++i;
        }
    }

    private void saveState() {
        XMLMemento memento = XMLMemento.createWriteRoot("workingSetManager");
        File stateFile = this.getWorkingSetStateFile();
        this.saveWorkingSetState(memento);
        this.saveMruList(memento);
        try {
            FileOutputStream stream = new FileOutputStream(stateFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
            memento.save(writer);
            writer.close();
        }
        catch (IOException e) {
            stateFile.delete();
            MessageDialog.openError(null, (String)WorkbenchMessages.getString("ProblemSavingWorkingSetState.title"), (String)WorkbenchMessages.getString("ProblemSavingWorkingSetState.message"));
        }
    }

    private void saveMruList(IMemento memento) {
        Iterator iterator = this.recentWorkingSets.iterator();
        while (iterator.hasNext()) {
            IWorkingSet workingSet = (IWorkingSet)iterator.next();
            IMemento mruMemento = memento.createChild("mruList");
            mruMemento.putString("name", workingSet.getName());
        }
    }

    private void saveWorkingSetState(IMemento memento) {
        Iterator iterator = this.workingSets.iterator();
        while (iterator.hasNext()) {
            IWorkingSet workingSet = (IWorkingSet)iterator.next();
            IPersistableElement persistable = null;
            if (workingSet instanceof IPersistableElement) {
                persistable = workingSet;
            } else if (workingSet instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)workingSet;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.IPersistableElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                persistable = (IPersistableElement)iAdaptable.getAdapter((Class)clazz);
            }
            if (persistable == null) continue;
            IMemento workingSetMemento = memento.createChild("workingSet");
            workingSetMemento.putString("factoryID", persistable.getFactoryId());
            persistable.saveState(workingSetMemento);
        }
    }

    public void workingSetChanged(IWorkingSet changedWorkingSet, String propertyChangeId) {
        this.saveState();
        this.firePropertyChange(propertyChangeId, null, changedWorkingSet);
    }
}

