/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.PlatformUIPreferenceListener;
import org.eclipse.ui.internal.SharedImages;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkingSetManager;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.IViewRegistry;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.registry.PreferencePageRegistryReader;
import org.eclipse.ui.internal.registry.ViewRegistry;
import org.eclipse.ui.internal.registry.ViewRegistryReader;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WorkbenchPlugin
extends AbstractUIPlugin {
    private static WorkbenchPlugin inst;
    private EditorRegistry editorRegistry;
    private DecoratorManager decoratorManager;
    private WorkingSetManager workingSetManager;
    private WorkingSetRegistry workingSetRegistry;
    public static boolean DEBUG;
    public static String PI_WORKBENCH;
    private static char PREFERENCE_PAGE_CATEGORY_SEPARATOR;
    private PreferenceManager preferenceManager;
    private ViewRegistry viewRegistry;
    private PerspectiveRegistry perspRegistry;
    private ActionSetRegistry actionSetRegistry;
    private SharedImages sharedImages;
    private AboutInfo aboutInfo = null;

    static {
        DEBUG = false;
        PI_WORKBENCH = "org.eclipse.ui";
        PREFERENCE_PAGE_CATEGORY_SEPARATOR = (char)47;
    }

    public WorkbenchPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        inst = this;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        IPluginDescriptor plugin = element.getDeclaringExtension().getDeclaringPluginDescriptor();
        if (plugin.isPluginActivated()) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    protected ImageRegistry createImageRegistry() {
        return WorkbenchImages.getImageRegistry();
    }

    public ActionSetRegistry getActionSetRegistry() {
        if (this.actionSetRegistry == null) {
            this.actionSetRegistry = new ActionSetRegistry();
        }
        return this.actionSetRegistry;
    }

    public static WorkbenchPlugin getDefault() {
        return inst;
    }

    public IEditorRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = new EditorRegistry();
        }
        return this.editorRegistry;
    }

    public IElementFactory getElementFactory(String targetID) {
        IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint(PI_WORKBENCH, "elementFactories");
        if (extensionPoint == null) {
            WorkbenchPlugin.log("Unable to find element factory. Extension point: elementFactories not found");
            return null;
        }
        IConfigurationElement targetElement = null;
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            String strID = configElements[j].getAttribute("id");
            if (strID.equals(targetID)) {
                targetElement = configElements[j];
                break;
            }
            ++j;
        }
        if (targetElement == null) {
            WorkbenchPlugin.log("Unable to find element factory: " + targetID);
            return null;
        }
        IElementFactory factory = null;
        try {
            factory = (IElementFactory)WorkbenchPlugin.createExtension(targetElement, "class");
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create element factory.", e.getStatus());
            factory = null;
        }
        return factory;
    }

    public IPerspectiveRegistry getPerspectiveRegistry() {
        if (this.perspRegistry == null) {
            this.perspRegistry = new PerspectiveRegistry();
            this.perspRegistry.load();
        }
        return this.perspRegistry;
    }

    public IWorkingSetManager getWorkingSetManager() {
        if (this.workingSetManager == null) {
            this.workingSetManager = new WorkingSetManager();
            this.workingSetManager.restoreState();
        }
        return this.workingSetManager;
    }

    public WorkingSetRegistry getWorkingSetRegistry() {
        if (this.workingSetRegistry == null) {
            this.workingSetRegistry = new WorkingSetRegistry();
            this.workingSetRegistry.load();
        }
        return this.workingSetRegistry;
    }

    public PreferenceManager getPreferenceManager() {
        if (this.preferenceManager == null) {
            this.preferenceManager = new PreferenceManager(PREFERENCE_PAGE_CATEGORY_SEPARATOR);
            PreferencePageRegistryReader registryReader = new PreferencePageRegistryReader(this.getWorkbench());
            List pageContributions = registryReader.getPreferenceContributions(Platform.getPluginRegistry());
            Iterator iterator = pageContributions.iterator();
            while (iterator.hasNext()) {
                this.preferenceManager.addToRoot((IPreferenceNode)iterator.next());
            }
        }
        return this.preferenceManager;
    }

    public ISharedImages getSharedImages() {
        if (this.sharedImages == null) {
            this.sharedImages = new SharedImages();
        }
        return this.sharedImages;
    }

    public IViewRegistry getViewRegistry() {
        if (this.viewRegistry == null) {
            this.viewRegistry = new ViewRegistry();
            try {
                ViewRegistryReader reader = new ViewRegistryReader();
                reader.readViews(Platform.getPluginRegistry(), this.viewRegistry);
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("Unable to read view registry.", e.getStatus());
            }
        }
        return this.viewRegistry;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        JFacePreferences.setPreferenceStore((IPreferenceStore)store);
        store.setDefault("wb.save.workbench.state", false);
        store.setDefault("wb.code.editors.on.exit", false);
        store.setDefault("wb.show.title.bar", true);
        store.setDefault("wb.show.menu.bar", true);
        store.setDefault("wb.show.tool.bar", true);
        store.setDefault("wb.show.shortcut.bar", true);
        store.setDefault("wb.show.status.line", true);
        store.setDefault("EDITORLIST_PULLDOWN_ACTIVE", false);
        store.setDefault("EDITORLIST_DISPLAY_FULL_NAME", false);
        store.setDefault("STICKY_CYCLE", false);
        store.setDefault("REUSE_OPEN_EDITORS_BOOLEAN", false);
        store.setDefault("REUSE_DIRTY_EDITORS", true);
        store.setDefault("REUSE_OPEN_EDITORS", 8);
        store.setDefault("OPEN_ON_SINGLE_CLICK", false);
        store.setDefault("SELECT_ON_HOVER", false);
        store.setDefault("OPEN_AFTER_DELAY", false);
        store.setDefault("RECENT_FILES", 4);
        store.setDefault("VIEW_TAB_POSITION", 128);
        store.setDefault("EDITOR_TAB_POSITION", 128);
        store.setDefault("EDITOR_TAB_WIDTH", 3);
        store.setDefault("OPEN_VIEW_MODE", 0);
        store.setDefault("OPEN_PERSPECTIVE_MODE", 0);
        store.setDefault("ENABLED_DECORATORS", "");
        store.setDefault("EDITORLIST_SELECTION_SCOPE", 1);
        store.setDefault("EDITORLIST_SORT_CRITERIA", 0);
        store.setDefault("COLOR_ICONS", false);
        store.setDefault("SHOW_SHORTCUT_BAR", true);
        store.setDefault("SHOW_STATUS_LINE", true);
        store.setDefault("SHOW_TOOL_BAR", true);
        store.setDefault("MULTI_KEY_ASSIST", false);
        store.setDefault("MULTI_KEY_ASSIST_TIME", 1);
        store.setDefault("USE_DEFAULT_THEME", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"ERROR_COLOR", (RGB)new RGB(255, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"HYPERLINK_COLOR", (RGB)new RGB(0, 0, 153));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"ACTIVE_HYPERLINK_COLOR", (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)JFacePreferences.SCHEME_TAB_SELECTION_BACKGROUND, (RGB)PreferenceConverter.COLOR_DEFAULT_DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)JFacePreferences.SCHEME_TAB_SELECTION_FOREGROUND, (RGB)PreferenceConverter.COLOR_DEFAULT_DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)JFacePreferences.SCHEME_TAB_BACKGROUND, (RGB)PreferenceConverter.COLOR_DEFAULT_DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)JFacePreferences.SCHEME_TAB_FOREGROUND, (RGB)PreferenceConverter.COLOR_DEFAULT_DEFAULT);
        store.setDefault("ENABLE_CONFIGURABLE_PROJECT_WIZARD", false);
        store.setDefault("SINGLE_CLICK_METHOD", 0);
        store.setDefault("ENABLE_COOL_BARS", true);
        store.setDefault("ENABLE_NEW_MENUS", true);
        store.setDefault("DISABLE_DIALOG_FONT", false);
        store.setDefault("showProgressIndicator", true);
        FontRegistry registry = JFaceResources.getFontRegistry();
        this.initializeFont("org.eclipse.jface.dialogfont", registry, store);
        this.initializeFont("org.eclipse.jface.bannerfont", registry, store);
        this.initializeFont("org.eclipse.jface.headerfont", registry, store);
        this.initializeFont("org.eclipse.jface.textfont", registry, store);
        store.addPropertyChangeListener((IPropertyChangeListener)new PlatformUIPreferenceListener());
    }

    private void initializeFont(String fontKey, FontRegistry registry, IPreferenceStore store) {
        FontData[] fontData = registry.getFontData(fontKey);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)fontKey, (FontData[])fontData);
    }

    public static void log(String message) {
        WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
        System.err.println(message);
    }

    public static void log(String message, IStatus status) {
        if (message != null) {
            WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
            System.err.println(String.valueOf(message) + "\nReason:");
        }
        WorkbenchPlugin.getDefault().getLog().log(status);
        System.err.println(status.getMessage());
    }

    public void setWorkbench(IWorkbench aWorkbench) {
    }

    public DecoratorManager getDecoratorManager() {
        if (this.decoratorManager == null) {
            this.decoratorManager = new DecoratorManager();
            this.decoratorManager.restoreListeners();
        }
        return this.decoratorManager;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startup() throws CoreException {
        block21: {
            block19: {
                block18: {
                    locationPath = this.getStateLocation();
                    newLocation = locationPath.toFile();
                    oldLocation = new File(newLocation, "..//org.eclipse.ui");
                    try {
                        oldLocation = oldLocation.getCanonicalFile();
                    }
                    catch (IOException var4_4) {
                        // empty catch block
                    }
                    markerFileName = ".copiedStateFiles_Marker";
                    markerFile = new File(oldLocation, markerFileName);
                    if (markerFile.exists()) {
                        return;
                    }
                    try {
                        list = newLocation.list();
                        if (list != null && list.length != 0) {
                            var15_8 = null;
                            break block18;
                        }
                        oldList = oldLocation.list();
                        if (oldList == null) break block19;
                        if (oldList.length == 0) {
                            break block19;
                        }
                        b = new byte[1024];
                        i = 0;
                        while (i < oldList.length) {
                            string = oldList[i];
                            try {
                                oldFile = new File(oldLocation, string);
                                in = new FileInputStream(oldFile);
                                out = new FileOutputStream(new File(newLocation, string));
                                read = in.read(b);
                                while (true) {
                                    if (read < 0) {
                                        in.close();
                                        out.close();
                                        break;
                                    }
                                    out.write(b, 0, read);
                                    read = in.read(b);
                                }
                            }
                            catch (IOException e) {
                                new File(newLocation, string).delete();
                            }
                            ++i;
                        }
                        break block21;
                    }
                    catch (Throwable var16_25) {
                        var15_10 = null;
                        try {
                            new FileOutputStream(markerFile).close();
                            throw var16_25;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var16_25;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [6 : 253->268)] { 
lbl59:
                // 1 sources

                new FileOutputStream(markerFile).close();
                return;
lbl61:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            var15_9 = null;
            ** try [egrp 3[TRYBLOCK] [6 : 253->268)] { 
lbl67:
            // 1 sources

            new FileOutputStream(markerFile).close();
            return;
lbl69:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        var15_11 = null;
        try {}
        catch (IOException e) {
            return;
        }
        new FileOutputStream(markerFile).close();
    }

    private void initializeProductInfo() {
        IPlatformConfiguration conf = BootLoader.getCurrentPlatformConfiguration();
        String featureId = conf.getPrimaryFeatureIdentifier();
        IPlatformConfiguration.IFeatureEntry feature = null;
        if (featureId != null) {
            feature = conf.findConfiguredFeatureEntry(featureId);
        }
        String versionId = null;
        String pluginId = null;
        if (feature != null) {
            versionId = feature.getFeatureVersion();
            pluginId = feature.getFeaturePluginIdentifier();
        }
        AboutInfo newAboutInfo = null;
        if (versionId != null && pluginId != null) {
            newAboutInfo = AboutInfo.readFeatureInfo(featureId, versionId, pluginId);
        }
        if (newAboutInfo == null) {
            newAboutInfo = new AboutInfo(featureId);
        }
        this.aboutInfo = newAboutInfo;
    }

    public String getAppName() {
        if (this.aboutInfo == null) {
            this.initializeProductInfo();
        }
        return this.aboutInfo.getAppName();
    }

    public String getProductName() {
        if (this.aboutInfo == null) {
            this.initializeProductInfo();
        }
        return this.aboutInfo.getProductName();
    }

    public ImageDescriptor getWindowImage() {
        if (this.aboutInfo == null) {
            this.initializeProductInfo();
        }
        return this.aboutInfo.getWindowImage();
    }
}

