/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationHistory;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.commands.IWorkbenchPageCommandSupport;
import org.eclipse.ui.contexts.IWorkbenchPageContextSupport;
import org.eclipse.ui.internal.CompatibleWorkbenchPage;
import org.eclipse.ui.internal.DetachedWindow;
import org.eclipse.ui.internal.EditorArea;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorPresentation;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.EditorWorkbook;
import org.eclipse.ui.internal.MultiEditorInnerPane;
import org.eclipse.ui.internal.NavigationHistory;
import org.eclipse.ui.internal.PageSelectionService;
import org.eclipse.ui.internal.PartListenerList;
import org.eclipse.ui.internal.PartListenerList2;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PerspectivePresentation;
import org.eclipse.ui.internal.SetPagePerspectiveAction;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.WorkingSetManager;
import org.eclipse.ui.internal.commands.ws.WorkbenchPageCommandSupport;
import org.eclipse.ui.internal.contexts.ws.WorkbenchPageContextSupport;
import org.eclipse.ui.internal.dialogs.CustomizePerspectiveDialog;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.MultiEditor;

public class WorkbenchPage
extends CompatibleWorkbenchPage
implements IWorkbenchPage {
    private WorkbenchWindow window;
    private IAdaptable input;
    private IWorkingSet workingSet;
    private Composite composite;
    private ControlListener resizeListener;
    private IWorkbenchPart activePart;
    private ActivationList activationList = new ActivationList();
    private IEditorPart lastActiveEditor;
    private EditorManager editorMgr;
    private EditorPresentation editorPresentation;
    private PartListenerList partListeners = new PartListenerList();
    private PartListenerList2 partListeners2 = new PartListenerList2();
    private ListenerList propertyChangeListeners = new ListenerList();
    private PageSelectionService selectionService = new PageSelectionService(this);
    private IActionBars actionBars;
    private ViewFactory viewFactory;
    private PerspectiveList perspList = new PerspectiveList();
    private PerspectiveDescriptor deferredActivePersp;
    private NavigationHistory navigationHistory = new NavigationHistory(this);
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("workingSetRemove".equals(property) && event.getOldValue().equals(WorkbenchPage.this.workingSet)) {
                WorkbenchPage.this.setWorkingSet(null);
                return;
            }
            if (!"PROP_VISIBILITY".equals(property)) return;
            WorkbenchPartReference ref = (WorkbenchPartReference)((PartPane)event.getSource()).getPartReference();
            ref.getPart(Boolean.TRUE.equals(event.getNewValue()));
            if (ref == null) {
                return;
            }
            if (Boolean.TRUE.equals(event.getNewValue())) {
                String label = "visible::" + ref.getTitle();
                try {
                    UIStats.start(UIStats.NOTIFY_PART_LISTENERS, label);
                    WorkbenchPage.this.partListeners2.firePartVisible(ref);
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
                    throw throwable;
                }
                {
                    Object var5_9 = null;
                    UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
                    return;
                }
            }
            String label = "hidden::" + ref.getTitle();
            try {
                UIStats.start(UIStats.NOTIFY_PART_LISTENERS, label);
                WorkbenchPage.this.partListeners2.firePartHidden(ref);
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
                throw throwable;
            }
            {
                Object var5_11 = null;
            }
            UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
        }
    };
    private ActionSwitcher actionSwitcher = new ActionSwitcher();
    private IWorkbenchPageCommandSupport workbenchPageCommandSupport;
    private IWorkbenchPageContextSupport workbenchPageContextSupport;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public WorkbenchPage(WorkbenchWindow w, String layoutID, IAdaptable input) throws WorkbenchException {
        if (layoutID == null) {
            throw new WorkbenchException(WorkbenchMessages.getString("WorkbenchPage.UndefinedPerspective"));
        }
        this.init(w, layoutID, input);
    }

    public WorkbenchPage(WorkbenchWindow w, IAdaptable input) throws WorkbenchException {
        this.init(w, null, input);
    }

    public void activate(IWorkbenchPart part) {
        if (!this.certifyPart(part)) {
            return;
        }
        if (this.window.isClosing()) {
            return;
        }
        if (this.isZoomed() && this.partChangeAffectsZoom(this.getReference(part))) {
            this.zoomOut();
        }
        if (part instanceof MultiEditor) {
            part = ((MultiEditor)part).getActiveEditor();
        }
        if (this.window.getActivePage() == this) {
            this.bringToTop(part);
            this.setActivePart(part);
        } else {
            this.activationList.setActive(part);
            this.activePart = part;
        }
    }

    private void activatePart(final IWorkbenchPart part) {
        Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.getString("WorkbenchPage.ErrorActivatingView")){

            public void run() {
                if (part != null) {
                    part.setFocus();
                    PartSite site = (PartSite)part.getSite();
                    site.getPane().showFocus(true);
                    WorkbenchPage.this.updateTabList(part);
                    SubActionBars bars = (SubActionBars)site.getActionBars();
                    bars.partChanged(part);
                }
            }
        });
    }

    public void addFastView(IViewReference ref) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return;
        }
        if (this.isZoomed() && this.partChangeAffectsZoom(ref)) {
            this.zoomOut();
        }
        persp.addFastView(ref);
        if (ref.getPart(false) == this.activePart) {
            this.activate(this.activationList.getActive());
        }
        this.window.getFastViewBar().update(true);
        this.window.firePerspectiveChanged(this, this.getPerspective(), "fastViewAdd");
    }

    public void addPartListener(IPartListener l) {
        this.partListeners.addPartListener(l);
    }

    public void addPartListener(IPartListener2 l) {
        this.partListeners2.addPartListener(l);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.selectionService.addSelectionListener(listener);
    }

    public void addSelectionListener(String partId, ISelectionListener listener) {
        this.selectionService.addSelectionListener(partId, listener);
    }

    public void addPostSelectionListener(ISelectionListener listener) {
        this.selectionService.addPostSelectionListener(listener);
    }

    public void addPostSelectionListener(String partId, ISelectionListener listener) {
        this.selectionService.addPostSelectionListener(partId, listener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void bringToTop(IWorkbenchPart part) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) return;
        if (!this.certifyPart(part)) {
            return;
        }
        if (this.isZoomed() && this.partChangeAffectsZoom(this.getReference(part))) {
            return;
        }
        String label = part != null ? part.getTitle() : "none";
        boolean broughtToTop = false;
        try {
            UIStats.start(UIStats.BRING_PART_TO_TOP, label);
            if (part instanceof IEditorPart) {
                IEditorReference ref = (IEditorReference)this.getReference(part);
                broughtToTop = this.getEditorManager().setVisibleEditor(ref, false);
                this.actionSwitcher.updateTopEditor((IEditorPart)part);
                if (broughtToTop) {
                    this.lastActiveEditor = null;
                }
            } else if (part instanceof IViewPart) {
                IViewReference ref = (IViewReference)this.getReference(part);
                broughtToTop = persp.bringToTop(ref);
            }
            if (broughtToTop) {
                this.activationList.setActive(part);
                this.firePartBroughtToTop(part);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            UIStats.end(UIStats.BRING_PART_TO_TOP, label);
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        UIStats.end(UIStats.BRING_PART_TO_TOP, label);
    }

    private void busyResetPerspective() {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        Perspective oldPersp = this.getActivePerspective();
        IPerspectiveRegistry reg = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        PerspectiveDescriptor desc = (PerspectiveDescriptor)reg.findPerspectiveWithId(oldPersp.getDesc().getId());
        if (desc == null) {
            desc = (PerspectiveDescriptor)reg.findPerspectiveWithId(((PerspectiveDescriptor)oldPersp.getDesc()).getOriginalId());
        }
        if (desc == null) {
            return;
        }
        IContributionItem item = this.window.findPerspectiveShortcut(oldPersp.getDesc(), this);
        if (item == null) {
            return;
        }
        Perspective newPersp = this.createPerspective(desc);
        if (newPersp == null) {
            return;
        }
        this.perspList.swap(oldPersp, newPersp);
        SetPagePerspectiveAction action = (SetPagePerspectiveAction)((ActionContributionItem)item).getAction();
        action.setPerspective(newPersp.getDesc());
        this.setPerspective(newPersp);
        this.window.firePerspectiveChanged(this, desc, "reset");
        this.disposePerspective(oldPersp);
        this.resetToolBarLayout();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void busySetPerspective(IPerspectiveDescriptor desc) {
        String label;
        block6: {
            block5: {
                label = desc.getId();
                try {
                    UIStats.start(UIStats.SWITCH_PERSPECTIVE, label);
                    PerspectiveDescriptor realDesc = (PerspectiveDescriptor)desc;
                    Perspective newPersp = this.findPerspective(realDesc);
                    if (newPersp == null) {
                        newPersp = this.createPerspective(realDesc);
                        if (newPersp == null) {
                            Object var5_5 = null;
                            break block5;
                        }
                        this.window.addPerspectiveShortcut(realDesc, this);
                    }
                    this.setPerspective(newPersp);
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    UIStats.end(UIStats.SWITCH_PERSPECTIVE, label);
                    throw throwable;
                }
            }
            UIStats.end(UIStats.SWITCH_PERSPECTIVE, label);
            return;
        }
        Object var5_7 = null;
        UIStats.end(UIStats.SWITCH_PERSPECTIVE, label);
    }

    private IViewPart busyShowView(String viewID, boolean activate) throws PartInitException {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return null;
        }
        IViewReference ref = persp.findView(viewID);
        IViewPart view = null;
        if (ref != null) {
            view = ref.getView(true);
        }
        if (view != null) {
            if (activate) {
                this.activate(view);
            } else {
                this.bringToTop(view);
            }
            return view;
        }
        view = persp.showView(viewID);
        if (view != null) {
            this.zoomOutIfNecessary(view);
            if (activate) {
                this.activate(view);
            } else {
                this.bringToTop(view);
            }
            this.window.firePerspectiveChanged(this, this.getPerspective(), "viewShow");
            this.window.getFastViewBar().update(true);
        }
        return view;
    }

    private boolean certifyPart(IWorkbenchPart part) {
        if (part != null && !(part.getSite() instanceof PartSite)) {
            return false;
        }
        if (part instanceof IEditorPart) {
            IEditorReference ref = (IEditorReference)this.getReference(part);
            return this.getEditorManager().containsEditor(ref);
        }
        if (part instanceof IViewPart) {
            Perspective persp = this.getActivePerspective();
            return persp != null && persp.containsView((IViewPart)part);
        }
        return false;
    }

    public boolean close() {
        final boolean[] ret = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ret[0] = WorkbenchPage.this.window.closePage(WorkbenchPage.this, true);
            }
        });
        return ret[0];
    }

    public boolean closeAllSavedEditors() {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        boolean deactivated = false;
        IEditorReference[] editors = this.getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            IEditorReference editor = editors[i];
            IWorkbenchPart part = editor.getPart(false);
            if (!editor.isDirty()) {
                if (part == this.activePart) {
                    deactivated = true;
                    this.setActivePart(null);
                } else if (this.lastActiveEditor == part) {
                    this.lastActiveEditor = null;
                    this.actionSwitcher.updateTopEditor(null);
                }
                this.getEditorManager().closeEditor(editor);
                this.activationList.remove(editor);
                this.firePartClosed(editor);
                this.disposePart(editor);
            }
            ++i;
        }
        if (deactivated) {
            this.activate(this.activationList.getActive());
        }
        this.window.firePerspectiveChanged(this, this.getPerspective(), "editorClose");
        this.lastPartClosePerspective();
        return true;
    }

    public boolean closeAllEditors(boolean save) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (save && !this.getEditorManager().saveAll(true, true)) {
            return false;
        }
        boolean deactivate = this.activePart instanceof IEditorPart;
        if (deactivate) {
            this.setActivePart(null);
        }
        this.lastActiveEditor = null;
        this.actionSwitcher.updateTopEditor(null);
        IEditorReference[] editors = this.getEditorManager().getEditors();
        this.getEditorManager().closeAll();
        int i = 0;
        while (i < editors.length) {
            IEditorReference editor = editors[i];
            this.activationList.remove(editor);
            this.firePartClosed(editor);
            this.disposePart(editor);
            ++i;
        }
        if (!this.window.isClosing() && deactivate) {
            this.activate(this.activationList.getActive());
        }
        this.window.firePerspectiveChanged(this, this.getPerspective(), "editorClose");
        this.lastPartClosePerspective();
        return true;
    }

    public boolean closeEditor(IEditorReference editorRef, boolean save) {
        IEditorPart editor = editorRef.getEditor(false);
        if (editor != null) {
            return this.closeEditor(editor, save);
        }
        this.getEditorManager().closeEditor(editorRef);
        this.activationList.remove(editorRef);
        this.firePartClosed(editorRef);
        return true;
    }

    public boolean closeEditor(IEditorPart editor, boolean save) {
        if (!this.certifyPart(editor)) {
            return false;
        }
        if (save && !this.getEditorManager().saveEditor(editor, true)) {
            return false;
        }
        boolean partWasVisible = editor == this.getActiveEditor();
        IEditorReference ref = (IEditorReference)this.getReference(editor);
        this.activationList.remove(ref);
        boolean partWasActive = editor == this.activePart;
        this.getEditorManager().closeEditor(ref);
        this.firePartClosed(ref);
        this.disposePart(ref);
        this.window.firePerspectiveChanged(this, this.getPerspective(), "editorClose");
        if (partWasActive) {
            IWorkbenchPart top = this.activationList.getTopEditor();
            this.zoomOutIfNecessary(top);
            if (top == null) {
                this.actionSwitcher.updateTopEditor(null);
                if (this.lastActiveEditor == editor) {
                    this.lastActiveEditor = null;
                }
                top = this.activationList.getActive();
            }
            if (top != null) {
                this.activate(top);
            } else {
                this.setActivePart(null);
            }
        } else if (partWasVisible) {
            IEditorPart top = this.activationList.getTopEditor();
            this.zoomOutIfNecessary(top);
            if (top != null) {
                boolean isTop = this.editorMgr.getVisibleEditor() == top;
                this.bringToTop(top);
                if (isTop) {
                    this.firePartBroughtToTop(top);
                }
            } else {
                this.actionSwitcher.updateTopEditor(top);
            }
        }
        this.lastPartClosePerspective();
        return true;
    }

    void closePerspective(IPerspectiveDescriptor desc, boolean save) {
        Perspective persp = this.findPerspective(desc);
        if (persp != null) {
            this.closePerspective(persp, save, true);
        }
    }

    void closePerspective(Perspective persp, boolean save, boolean closePage) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (this.perspList.size() == 1 && this.getEditorManager().getEditorCount() > 0 && !this.closeAllEditors(save)) {
            return;
        }
        boolean isActive = this.perspList.getActive() == persp;
        this.window.removePerspectiveShortcut(persp.getDesc(), this);
        if (isActive) {
            this.setPerspective(this.perspList.getNextActive());
        }
        this.disposePerspective(persp);
        if (closePage && this.perspList.size() == 0) {
            this.close();
        }
    }

    void closeAllPerspectives() {
        if (this.perspList.isEmpty()) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (!this.closeAllEditors(true)) {
            return;
        }
        this.setPerspective((Perspective)null);
        PerspectiveList oldList = this.perspList;
        this.perspList = new PerspectiveList();
        Iterator iterator = oldList.iterator();
        while (iterator.hasNext()) {
            this.closePerspective((Perspective)iterator.next(), false, false);
        }
        this.close();
    }

    private void createClientComposite() {
        final Composite parent = this.window.getClientComposite();
        this.composite = new Composite(parent, 0);
        this.composite.setVisible(false);
        this.composite.setBounds(parent.getClientArea());
        this.resizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                WorkbenchPage.this.composite.setBounds(parent.getClientArea());
            }
        };
        parent.addControlListener(this.resizeListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Perspective createPerspective(PerspectiveDescriptor desc) {
        Perspective perspective;
        String label = desc.getId();
        try {
            try {
                UIStats.start(UIStats.CREATE_PERSPECTIVE, label);
                Perspective persp = new Perspective(desc, this);
                this.perspList.add(persp);
                this.window.firePerspectiveOpened(this, desc);
                IViewReference[] refs = persp.getViewReferences();
                int i = 0;
                while (true) {
                    if (i >= refs.length) {
                        perspective = persp;
                        Object var7_10 = null;
                        break;
                    }
                    IViewReference ref = refs[i];
                    if (ref != null) {
                        this.addPart(ref);
                    }
                    ++i;
                }
            }
            catch (WorkbenchException e) {
                if (!((Workbench)this.window.getWorkbench()).isStarting()) {
                    MessageDialog.openError((Shell)this.window.getShell(), (String)WorkbenchMessages.getString("Error"), (String)WorkbenchMessages.format("Workbench.showPerspectiveError", new String[]{desc.getId()}));
                }
                Perspective perspective2 = null;
                Object var7_11 = null;
                UIStats.end(UIStats.CREATE_PERSPECTIVE, label);
                return perspective2;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            UIStats.end(UIStats.CREATE_PERSPECTIVE, label);
            throw throwable;
        }
        UIStats.end(UIStats.CREATE_PERSPECTIVE, label);
        return perspective;
    }

    public void openTracker(ViewPane pane) {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            persp.openTracker(pane);
        }
    }

    protected void addPart(IWorkbenchPartReference ref) {
        this.activationList.add(ref);
    }

    protected void removePart(IWorkbenchPartReference ref) {
        this.activationList.remove(ref);
    }

    private void deactivatePart(IWorkbenchPart part) {
        if (part != null) {
            PartSite site = (PartSite)part.getSite();
            site.getPane().showFocus(false);
        }
    }

    private void disposePart(IWorkbenchPartReference ref) {
        final WorkbenchPartReference ref0 = (WorkbenchPartReference)ref;
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                ref0.dispose();
            }

            public void handleException(Throwable e) {
            }
        });
    }

    public void dispose() {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        this.closeAllEditors(false);
        IViewReference[] refs = this.viewFactory.getViews();
        Iterator iterator = this.perspList.iterator();
        while (iterator.hasNext()) {
            Perspective perspective = (Perspective)iterator.next();
            this.window.removePerspectiveShortcut(perspective.getDesc(), this);
            this.window.firePerspectiveClosed(this, perspective.getDesc());
            perspective.dispose();
        }
        this.perspList = new PerspectiveList();
        final int[] errors = new int[1];
        int i = 0;
        while (i < refs.length) {
            final WorkbenchPartReference ref = (WorkbenchPartReference)((Object)refs[i]);
            this.firePartClosed(refs[i]);
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    ref.dispose();
                }

                public void handleException(Throwable e) {
                    errors[0] = errors[0] + 1;
                }
            });
            ++i;
        }
        if (errors[0] > 0) {
            String message = errors[0] == 1 ? WorkbenchMessages.getString("WorkbenchPage.oneErrorClosingPage") : WorkbenchMessages.getString("WorkbenchPage.multipleErrorsRestoring");
            MessageDialog.openError(null, (String)WorkbenchMessages.getString("Error"), (String)message);
        }
        this.activePart = null;
        this.activationList = new ActivationList();
        this.editorPresentation.dispose();
        this.window.getClientComposite().removeControlListener(this.resizeListener);
        this.composite.dispose();
        this.navigationHistory.dispose();
    }

    private void disposePerspective(Perspective persp) {
        IViewReference[] refs = persp.getViewReferences();
        this.perspList.remove(persp);
        this.window.firePerspectiveClosed(this, persp.getDesc());
        persp.dispose();
        int i = 0;
        while (i < refs.length) {
            IViewReference ref = refs[i];
            boolean exists = this.viewFactory.hasView(ref.getId());
            if (!exists) {
                this.firePartClosed(ref);
                this.activationList.remove(ref);
                this.disposePart(ref);
            }
            ++i;
        }
    }

    public INavigationHistory getNavigationHistory() {
        return this.navigationHistory;
    }

    public boolean editActionSets() {
        boolean ret;
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return false;
        }
        CustomizePerspectiveDialog dlg = new CustomizePerspectiveDialog(this.window.getShell(), persp);
        boolean bl = ret = dlg.open() == 0;
        if (ret) {
            this.window.updateActionSets();
            this.window.firePerspectiveChanged(this, this.getPerspective(), "reset");
        }
        return ret;
    }

    public Perspective findPerspective(IPerspectiveDescriptor desc) {
        Iterator iterator = this.perspList.iterator();
        while (iterator.hasNext()) {
            Perspective mgr = (Perspective)iterator.next();
            if (!desc.getId().equals(mgr.getDesc().getId())) continue;
            return mgr;
        }
        return null;
    }

    public IViewPart findView(String id) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return null;
        }
        IViewReference ref = persp.findView(id);
        if (ref == null) {
            return null;
        }
        IViewPart view = ref.getView(true);
        ViewPane pane = (ViewPane)((WorkbenchPartReference)((Object)ref)).getPane();
        Control ctrl = pane.getControl();
        if (ctrl == null) {
            pane.createControl(this.getClientComposite());
        }
        return view;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void firePartActivated(IWorkbenchPart part) {
        String label = "activate::" + (part != null ? part.getTitle() : "none");
        try {
            UIStats.start(UIStats.NOTIFY_PART_LISTENERS, label);
            this.partListeners.firePartActivated(part);
            this.partListeners2.firePartActivated(this.getReference(part));
            this.selectionService.partActivated(part);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void firePartBroughtToTop(IWorkbenchPart part) {
        String label = "bringToTop::" + (part != null ? part.getTitle() : "none");
        try {
            UIStats.start(UIStats.NOTIFY_PART_LISTENERS, label);
            this.partListeners.firePartBroughtToTop(part);
            this.partListeners2.firePartBroughtToTop(this.getReference(part));
            this.selectionService.partBroughtToTop(part);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void firePartClosed(IWorkbenchPartReference ref) {
        String label = "close" + ref.getTitle();
        try {
            UIStats.start(UIStats.NOTIFY_PART_LISTENERS, label);
            IWorkbenchPart part = ref.getPart(false);
            if (part != null) {
                this.partListeners.firePartClosed(part);
                this.selectionService.partClosed(part);
            }
            this.partListeners2.firePartClosed(ref);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void firePartDeactivated(IWorkbenchPart part) {
        String label = "deactivate" + (part != null ? part.getTitle() : "none");
        try {
            UIStats.start(UIStats.NOTIFY_PART_LISTENERS, label);
            this.partListeners.firePartDeactivated(part);
            this.partListeners2.firePartDeactivated(this.getReference(part));
            this.selectionService.partDeactivated(part);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void firePartOpened(IWorkbenchPart part) {
        String label = "deactivate" + (part != null ? part.getTitle() : "none");
        try {
            UIStats.start(UIStats.NOTIFY_PART_LISTENERS, label);
            this.partListeners.firePartOpened(part);
            this.partListeners2.firePartOpened(this.getReference(part));
            this.selectionService.partOpened(part);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void firePartInputChanged(IWorkbenchPart part) {
        String label = "inputChanged" + (part != null ? part.getTitle() : "none");
        try {
            UIStats.start(UIStats.NOTIFY_PART_LISTENERS, label);
            this.partListeners2.firePartInputChanged(this.getReference(part));
            this.selectionService.partInputChanged(part);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        UIStats.end(UIStats.NOTIFY_PART_LISTENERS, label);
    }

    private void firePropertyChange(String changeId, Object oldValue, Object newValue) {
        Object[] listeners = this.propertyChangeListeners.getListeners();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, changeId, oldValue, newValue);
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    public IActionBars getActionBars() {
        if (this.actionBars == null) {
            this.actionBars = new WWinActionBars(this.window);
        }
        return this.actionBars;
    }

    public IActionSetDescriptor[] getActionSets() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getActionSets();
        }
        return new IActionSetDescriptor[0];
    }

    public IEditorPart getActiveEditor() {
        return this.getEditorManager().getVisibleEditor();
    }

    public IWorkbenchPart getActivePart() {
        return this.activePart;
    }

    public IWorkbenchPartReference getActivePartReference() {
        return this.getReference(this.activePart);
    }

    public Perspective getActivePerspective() {
        return this.perspList.getActive();
    }

    public Composite getClientComposite() {
        return this.composite;
    }

    private EditorManager getEditorManager() {
        return this.editorMgr;
    }

    public PerspectivePresentation getPerspectivePresentation() {
        if (this.getActivePerspective() != null) {
            return this.getActivePerspective().getPresentation();
        }
        return null;
    }

    public EditorPresentation getEditorPresentation() {
        return this.editorPresentation;
    }

    public IEditorPart[] getEditors() {
        final IEditorReference[] refs = this.getEditorReferences();
        final ArrayList result = new ArrayList(refs.length);
        Display d = this.getWorkbenchWindow().getShell().getDisplay();
        d.syncExec(new Runnable(){

            public void run() {
                int i = 0;
                while (i < refs.length) {
                    IWorkbenchPart part = refs[i].getPart(true);
                    if (part != null) {
                        result.add(part);
                    }
                    ++i;
                }
            }
        });
        IEditorPart[] editors = new IEditorPart[result.size()];
        return result.toArray(editors);
    }

    public IEditorPart[] getDirtyEditors() {
        return this.getEditorManager().getDirtyEditors();
    }

    public IEditorPart findEditor(IEditorInput input) {
        return this.getEditorManager().findEditor(input);
    }

    public IEditorReference[] getEditorReferences() {
        return this.getEditorManager().getEditors();
    }

    public IViewReference[] getFastViews() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getFastViews();
        }
        return new IViewReference[0];
    }

    public IAdaptable getInput() {
        return this.input;
    }

    public String getLabel() {
        Perspective persp;
        String label = WorkbenchMessages.getString("WorkbenchPage.UnknownLabel");
        if (this.input != null) {
            IWorkbenchAdapter adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IWorkbenchAdapter)this.input.getAdapter((Class)clazz)) != null) {
                label = adapter.getLabel(this.input);
            }
        }
        if ((persp = this.getActivePerspective()) != null) {
            label = WorkbenchMessages.format("WorkbenchPage.PerspectiveFormat", new Object[]{label, persp.getDesc().getLabel()});
        } else if (this.deferredActivePersp != null) {
            label = WorkbenchMessages.format("WorkbenchPage.PerspectiveFormat", new Object[]{label, this.deferredActivePersp.getLabel()});
        }
        return label;
    }

    public ArrayList getNewWizardActionIds() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getNewWizardActionIds();
        }
        return new ArrayList();
    }

    public IPerspectiveDescriptor getPerspective() {
        if (this.deferredActivePersp != null) {
            return this.deferredActivePersp;
        }
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getDesc();
        }
        return null;
    }

    public ArrayList getPerspectiveActionIds() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getPerspectiveActionIds();
        }
        return new ArrayList();
    }

    public ISelection getSelection() {
        return this.selectionService.getSelection();
    }

    public ISelection getSelection(String partId) {
        return this.selectionService.getSelection(partId);
    }

    public ArrayList getShowInPartIds() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getShowInPartIds();
        }
        return new ArrayList();
    }

    public void performedShowIn(String partId) {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            persp.performedShowIn(partId);
        }
    }

    public void sortShowInPartIds(ArrayList partIds) {
        final Perspective persp = this.getActivePerspective();
        if (persp != null) {
            Collections.sort(partIds, new Comparator(){

                public int compare(Object a, Object b) {
                    long tb;
                    long ta = persp.getShowInTime((String)a);
                    return ta == (tb = persp.getShowInTime((String)b)) ? 0 : (ta > tb ? -1 : 1);
                }
            });
        }
    }

    public ArrayList getShowViewActionIds() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getShowViewActionIds();
        }
        return new ArrayList();
    }

    protected WorkbenchWindow getUnprotectedWindow() {
        return this.window;
    }

    public ViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new ViewFactory(this, WorkbenchPlugin.getDefault().getViewRegistry());
        }
        return this.viewFactory;
    }

    public IViewReference[] getViewReferences() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getViewReferences();
        }
        return new IViewReference[0];
    }

    public IViewPart[] getViews() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            IViewReference[] refs = persp.getViewReferences();
            ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>(refs.length);
            int i = 0;
            while (i < refs.length) {
                IWorkbenchPart part = refs[i].getPart(true);
                if (part != null) {
                    parts.add(part);
                }
                ++i;
            }
            IViewPart[] result = new IViewPart[parts.size()];
            return parts.toArray(result);
        }
        return new IViewPart[0];
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.window;
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public void hideActionSet(String actionSetID) {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            persp.hideActionSet(actionSetID);
            this.window.updateActionSets();
            this.window.firePerspectiveChanged(this, this.getPerspective(), "actionSetHide");
        }
    }

    public void hideView(IViewReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        if (part != null) {
            this.hideView((IViewPart)part);
        } else if (this.isFastView(ref)) {
            this.hideView(this.getActivePerspective(), ref);
        }
    }

    public void hideView(IViewPart view) {
        Perspective persp = this.getActivePerspective();
        if (persp == null || !this.certifyPart(view)) {
            return;
        }
        IViewReference ref = (IViewReference)this.getReference(view);
        if (this.isZoomed() && !this.isFastView(ref)) {
            this.zoomOut();
        }
        if (!persp.canCloseView(view)) {
            return;
        }
        if (view == this.activePart) {
            IWorkbenchPart prevActive = this.activationList.getPreviouslyActive();
            if (prevActive != null) {
                this.activate(prevActive);
            } else {
                this.setActivePart(null);
            }
        }
        this.hideView(persp, ref);
    }

    private void hideView(Perspective persp, IViewReference ref) {
        persp.hideView(ref);
        boolean exists = this.viewFactory.hasView(ref.getId());
        if (!exists) {
            this.firePartClosed(ref);
            this.disposePart(ref);
            this.activationList.remove(ref);
            this.activePart = this.activationList.getActive();
        }
        this.window.firePerspectiveChanged(this, this.getPerspective(), "viewHide");
        this.window.getFastViewBar().update(true);
        this.lastPartClosePerspective();
    }

    private void lastPartClosePerspective() {
        Perspective persp = this.getActivePerspective();
        if (persp != null && this.getActivePart() == null && persp.getViewReferences().length == 0 && this.getEditorReferences().length == 0) {
            this.closePerspective(persp, false, true);
        }
    }

    private void init(WorkbenchWindow w, String layoutID, IAdaptable input) throws WorkbenchException {
        this.window = w;
        this.input = input;
        this.createClientComposite();
        this.editorPresentation = new EditorPresentation(this);
        this.editorMgr = new EditorManager(this.window, this, this.editorPresentation);
        if (layoutID != null) {
            PerspectiveDescriptor desc = (PerspectiveDescriptor)WorkbenchPlugin.getDefault().getPerspectiveRegistry().findPerspectiveWithId(layoutID);
            if (desc == null) {
                throw new WorkbenchException(WorkbenchMessages.getString("WorkbenchPage.ErrorRecreatingPerspective"));
            }
            Perspective persp = this.createPerspective(desc);
            if (persp == null) {
                return;
            }
            this.perspList.setActive(persp);
            this.window.firePerspectiveActivated(this, desc);
        }
        this.workbenchPageCommandSupport = new WorkbenchPageCommandSupport(this);
        this.workbenchPageContextSupport = new WorkbenchPageContextSupport(this);
    }

    public boolean isPartVisible(IWorkbenchPart part) {
        return ((PartSite)part.getSite()).getPane().isVisible();
    }

    public boolean isEditorAreaVisible() {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return false;
        }
        return persp.isEditorAreaVisible();
    }

    public boolean isFastView(IViewReference ref) {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.isFastView(ref);
        }
        return false;
    }

    public IViewReference getActiveFastView() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            return persp.getActiveFastView();
        }
        return null;
    }

    protected boolean isSaveNeeded() {
        return this.getEditorManager().isSaveAllNeeded();
    }

    public boolean isZoomed() {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return false;
        }
        if (persp.getPresentation() == null) {
            return false;
        }
        return persp.getPresentation().isZoomed();
    }

    private boolean needToZoomOut(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            if (this.getActivePart() instanceof IViewPart) {
                return true;
            }
            EditorSite site = (EditorSite)part.getSite();
            EditorPane pane = (EditorPane)site.getPane();
            EditorWorkbook book = pane.getWorkbook();
            return !book.equals(book.getEditorArea().getActiveWorkbook());
        }
        if (part instanceof IViewPart) {
            return !this.isFastView((IViewReference)this.getReference(part)) && !part.equals(this.getActivePart());
        }
        return true;
    }

    protected void onActivate() {
        Iterator iterator = this.perspList.iterator();
        while (iterator.hasNext()) {
            Perspective perspective = (Perspective)iterator.next();
            this.window.addPerspectiveShortcut(perspective.getDesc(), this);
        }
        this.composite.setVisible(true);
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            this.window.selectPerspectiveShortcut(persp.getDesc(), this, true);
            persp.onActivate();
            this.updateVisibility(null, persp);
        }
        if (this.activePart == null && persp != null) {
            IViewReference[] refs = persp.getViewReferences();
            int i = 0;
            while (i < refs.length) {
                IViewReference ref = refs[i];
                if (ref != null) {
                    this.activePart = ref.getPart(false);
                    if (this.activePart != null) break;
                }
                ++i;
            }
        }
        if (this.activePart != null) {
            this.activationList.setActive(this.activePart);
            this.activatePart(this.activePart);
            this.actionSwitcher.updateActivePart(this.activePart);
            if (this.activePart instanceof IEditorPart) {
                this.lastActiveEditor = (IEditorPart)this.activePart;
                this.actionSwitcher.updateTopEditor((IEditorPart)this.activePart);
            } else {
                IEditorPart editor = this.editorMgr.getVisibleEditor();
                if (editor != null) {
                    this.actionSwitcher.updateTopEditor(editor);
                    PartSite site = (PartSite)editor.getSite();
                    SubActionBars bars = (SubActionBars)site.getActionBars();
                    bars.partChanged(editor);
                }
            }
            this.firePartActivated(this.activePart);
        } else {
            this.composite.setFocus();
        }
    }

    protected void onDeactivate() {
        if (this.activePart != null) {
            this.deactivatePart(this.activePart);
            this.actionSwitcher.updateActivePart(null);
            this.firePartDeactivated(this.activePart);
        }
        this.actionSwitcher.updateTopEditor(null);
        this.lastActiveEditor = null;
        if (this.getActivePerspective() != null) {
            this.getActivePerspective().onDeactivate();
        }
        this.composite.setVisible(false);
        Iterator iterator = this.perspList.iterator();
        while (iterator.hasNext()) {
            Perspective perspective = (Perspective)iterator.next();
            this.window.removePerspectiveShortcut(perspective.getDesc(), this);
        }
    }

    public void reuseEditor(IReusableEditor editor, IEditorInput input) {
        editor.setInput(input);
        this.firePartInputChanged(editor);
    }

    public IEditorPart openEditor(IEditorInput input, String editorID) throws PartInitException {
        return this.openEditor(input, editorID, true);
    }

    public IEditorPart openEditor(final IEditorInput input, final String editorID, final boolean activate) throws PartInitException {
        if (input == null || editorID == null) {
            throw new IllegalArgumentException();
        }
        final IEditorPart[] result = new IEditorPart[1];
        final PartInitException[] ex = new PartInitException[1];
        BusyIndicator.showWhile((Display)this.window.getClientComposite().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    result[0] = WorkbenchPage.this.busyOpenEditor(input, editorID, activate);
                }
                catch (PartInitException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        return result[0];
    }

    private IEditorPart busyOpenEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IEditorPart editor = this.getEditorManager().findEditor(input);
        if (editor != null) {
            if ("org.eclipse.ui.systemExternalEditor".equals(editorID)) {
                if (editor.isDirty()) {
                    MessageDialog dialog = new MessageDialog(this.getWorkbenchWindow().getShell(), WorkbenchMessages.getString("Save"), null, WorkbenchMessages.format("WorkbenchPage.editorAlreadyOpenedMsg", new String[]{input.getName()}), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    int saveFile = dialog.open();
                    if (saveFile == 0) {
                        try {
                            final IEditorPart editorToSave = editor;
                            this.getWorkbenchWindow().run(false, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    editorToSave.doSave(monitor);
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            throw (RuntimeException)e.getTargetException();
                        }
                        catch (InterruptedException e) {
                            return null;
                        }
                    } else if (saveFile == 2) {
                        return null;
                    }
                }
            } else {
                this.showEditor(activate, editor);
                return editor;
            }
        }
        IEditorPart oldVisibleEditor = this.getEditorManager().getVisibleEditor();
        IEditorReference ref = null;
        ref = this.getEditorManager().openEditor(editorID, input, true);
        if (ref != null) {
            editor = ref.getEditor(true);
            this.addPart(ref);
        }
        if (editor != null) {
            this.zoomOutIfNecessary(editor);
            this.setEditorAreaVisible(true);
            if (activate) {
                if (editor instanceof MultiEditor) {
                    this.activate(((MultiEditor)editor).getActiveEditor());
                } else {
                    this.activate(editor);
                }
            } else {
                IEditorPart visibleEditor;
                this.activationList.setActive(editor);
                if (this.activePart != null) {
                    this.activationList.setActive(this.activePart);
                }
                if ((visibleEditor = this.getEditorManager().getVisibleEditor()) == editor && oldVisibleEditor != editor) {
                    this.actionSwitcher.updateTopEditor(editor);
                    this.firePartBroughtToTop(editor);
                } else {
                    this.bringToTop(editor);
                }
            }
            this.window.firePerspectiveChanged(this, this.getPerspective(), "editorOpen");
        }
        return editor;
    }

    private void showEditor(boolean activate, IEditorPart editor) {
        this.zoomOutIfNecessary(editor);
        this.setEditorAreaVisible(true);
        if (activate) {
            this.activate(editor);
        } else {
            this.bringToTop(editor);
        }
    }

    public boolean isEditorPinned(IEditorPart editor) {
        return !((EditorSite)editor.getEditorSite()).getReuseEditor();
    }

    private boolean partChangeAffectsZoom(IWorkbenchPartReference ref) {
        PartPane pane = ((WorkbenchPartReference)ref).getPane();
        if (pane instanceof MultiEditorInnerPane) {
            pane = ((MultiEditorInnerPane)pane).getParentPane();
        }
        return this.getActivePerspective().getPresentation().partChangeAffectsZoom(pane);
    }

    public void removeFastView(IViewReference ref) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
        }
        persp.removeFastView(ref);
        this.window.getFastViewBar().update(true);
        this.window.firePerspectiveChanged(this, this.getPerspective(), "fastViewRemove");
    }

    public void removePartListener(IPartListener l) {
        this.partListeners.removePartListener(l);
    }

    public void removePartListener(IPartListener2 l) {
        this.partListeners2.removePartListener(l);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove((Object)listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.selectionService.removeSelectionListener(listener);
    }

    public void removeSelectionListener(String partId, ISelectionListener listener) {
        this.selectionService.removeSelectionListener(partId, listener);
    }

    public void removePostSelectionListener(ISelectionListener listener) {
        this.selectionService.removePostSelectionListener(listener);
    }

    public void removePostSelectionListener(String partId, ISelectionListener listener) {
        this.selectionService.removePostSelectionListener(partId, listener);
    }

    public void requestActivation(IWorkbenchPart part) {
        if (!this.certifyPart(part)) {
            return;
        }
        this.setActivePart(part);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetPerspective() {
        CoolBarManager mgr = this.window.getCoolBarManager();
        try {
            mgr.getControl().setRedraw(false);
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    WorkbenchPage.this.busyResetPerspective();
                }
            });
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            mgr.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        mgr.getControl().setRedraw(true);
    }

    public IStatus restoreState(IMemento memento, IPerspectiveDescriptor activeDescritor) {
        MultiStatus multiStatus;
        String pageName = memento.getString("label");
        String label = pageName == null ? "" : "::" + pageName;
        try {
            UIStats.start(UIStats.RESTORE_WORKBENCH, "WorkbenchPage" + label);
            if (pageName == null) {
                pageName = "";
            }
            MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.format("WorkbenchPage.unableToRestorePerspective", new String[]{pageName}), null);
            String workingSetName = memento.getString("workingSet");
            if (workingSetName != null) {
                WorkingSetManager workingSetManager = (WorkingSetManager)this.getWorkbenchWindow().getWorkbench().getWorkingSetManager();
                this.setWorkingSet(workingSetManager.getWorkingSet(workingSetName));
            }
            IMemento childMem = memento.getChild("editors");
            result.merge(this.getEditorManager().restoreState(childMem));
            childMem = memento.getChild("views");
            if (childMem != null) {
                result.merge(this.getViewFactory().restoreState(childMem));
            }
            childMem = memento.getChild("perspectives");
            String activePartID = childMem.getString("activePart");
            String activePerspectiveID = childMem.getString("activePerspective");
            IMemento[] perspMems = childMem.getChildren("perspective");
            Perspective activePerspective = null;
            int i = 0;
            while (i < perspMems.length) {
                try {
                    Perspective persp = new Perspective(null, this);
                    result.merge(persp.restoreState(perspMems[i]));
                    IPerspectiveDescriptor desc = persp.getDesc();
                    if (desc.equals(activeDescritor)) {
                        activePerspective = persp;
                    } else if (activePerspective == null && desc.getId().equals(activePerspectiveID)) {
                        activePerspective = persp;
                    }
                    this.perspList.add(persp);
                }
                catch (WorkbenchException persp) {
                    // empty catch block
                }
                ++i;
            }
            boolean restoreActivePerspective = false;
            if (activeDescritor == null) {
                restoreActivePerspective = true;
            } else if (activePerspective != null && activePerspective.getDesc().equals(activeDescritor)) {
                restoreActivePerspective = true;
            } else {
                restoreActivePerspective = false;
                activePerspective = this.createPerspective((PerspectiveDescriptor)activeDescritor);
                if (activePerspective == null) {
                    result.merge((IStatus)new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("Workbench.showPerspectiveError", new String[]{activeDescritor.getId()}), null));
                }
            }
            this.perspList.setActive(activePerspective);
            activePerspective = this.perspList.getActive();
            if (activePerspective == null) {
                activePerspective = this.perspList.getNextActive();
                this.perspList.setActive(activePerspective);
                result.merge(activePerspective.restoreState());
            }
            if (activePerspective != null && restoreActivePerspective) {
                result.merge(activePerspective.restoreState());
            }
            if (activePerspective != null) {
                this.window.firePerspectiveActivated(this, activePerspective.getDesc());
                if (activePartID != null) {
                    IViewReference ref = activePerspective.findView(activePartID);
                    IViewPart view = null;
                    if (ref != null) {
                        view = ref.getView(true);
                    }
                    if (view != null) {
                        this.activePart = view;
                    }
                }
            }
            if ((childMem = memento.getChild("navigationHistory")) != null) {
                this.navigationHistory.restoreState(childMem);
            } else if (this.getActiveEditor() != null) {
                this.navigationHistory.markEditor(this.getActiveEditor());
            }
            multiStatus = result;
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            UIStats.end(UIStats.RESTORE_WORKBENCH, "WorkbenchPage" + label);
            throw throwable;
        }
        UIStats.end(UIStats.RESTORE_WORKBENCH, "WorkbenchPage" + label);
        return multiStatus;
    }

    public boolean saveAllEditors(boolean confirm) {
        return this.getEditorManager().saveAll(confirm, false);
    }

    protected boolean savePart(ISaveablePart saveable, IWorkbenchPart part, boolean confirm) {
        return this.getEditorManager().savePart(saveable, part, confirm);
    }

    public boolean saveEditor(IEditorPart editor, boolean confirm) {
        return this.savePart(editor, editor, confirm);
    }

    public void savePerspective() {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
        }
        persp.saveDesc();
    }

    public void savePerspectiveAs(IPerspectiveDescriptor newDesc) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return;
        }
        IPerspectiveDescriptor oldDesc = persp.getDesc();
        if (this.isZoomed()) {
            this.zoomOut();
        }
        persp.saveDescAs(newDesc);
        this.window.updatePerspectiveShortcut(oldDesc, newDesc, this);
    }

    public IStatus saveState(IMemento memento) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.format("WorkbenchPage.unableToSavePerspective", new String[]{this.getLabel()}), null);
        IMemento childMem = memento.createChild("editors");
        result.merge(this.editorMgr.saveState(childMem));
        childMem = memento.createChild("views");
        result.merge(this.getViewFactory().saveState(childMem));
        childMem = memento.createChild("perspectives");
        if (this.getPerspective() != null) {
            childMem.putString("activePerspective", this.getPerspective().getId());
        }
        if (this.getActivePart() != null) {
            childMem.putString("activePart", this.getActivePart().getSite().getId());
        }
        Iterator iterator = this.perspList.iterator();
        while (iterator.hasNext()) {
            Perspective persp = (Perspective)iterator.next();
            IMemento gChildMem = childMem.createChild("perspective");
            result.merge(persp.saveState(gChildMem));
        }
        if (this.workingSet != null) {
            memento.putString("workingSet", this.workingSet.getName());
        }
        this.navigationHistory.saveState(memento.createChild("navigationHistory"));
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setActivePart(IWorkbenchPart newPart) {
        if (this.activePart == newPart) {
            return;
        }
        boolean markLocation = newPart != this.lastActiveEditor;
        String label = newPart != null ? newPart.getTitle() : "none";
        try {
            IWorkbenchPart oldPart;
            UIStats.start(UIStats.ACTIVATE_PART, label);
            Perspective persp = this.getActivePerspective();
            if (persp != null) {
                persp.partActivated(newPart);
            }
            if ((oldPart = this.activePart) != null) {
                this.deactivatePart(oldPart);
            }
            this.activePart = newPart;
            if (newPart != null) {
                this.activationList.setActive(newPart);
                if (newPart instanceof IEditorPart) {
                    this.lastActiveEditor = (IEditorPart)newPart;
                    IEditorReference ref = (IEditorReference)this.getReference(this.lastActiveEditor);
                    this.editorMgr.setVisibleEditor(ref, true);
                }
            }
            this.activatePart(this.activePart);
            if (markLocation && this.activePart != null && this.activePart instanceof IEditorPart) {
                this.navigationHistory.markEditor((IEditorPart)this.activePart);
            }
            if (oldPart != null) {
                this.firePartDeactivated(oldPart);
            }
            this.actionSwitcher.updateActivePart(newPart);
            if (newPart != null) {
                this.firePartActivated(newPart);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            UIStats.end(UIStats.ACTIVATE_PART, label);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        UIStats.end(UIStats.ACTIVATE_PART, label);
    }

    public void setEditorAreaVisible(boolean showEditorArea) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return;
        }
        if (showEditorArea == persp.isEditorAreaVisible()) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (showEditorArea) {
            persp.showEditorArea();
            this.window.firePerspectiveChanged(this, this.getPerspective(), "editorAreaShow");
        } else {
            persp.hideEditorArea();
            if (this.activePart instanceof IEditorPart) {
                IEditorPart e = (IEditorPart)this.activePart;
                this.setActivePart(null);
                this.actionSwitcher.updateTopEditor(e);
            }
            this.window.firePerspectiveChanged(this, this.getPerspective(), "editorAreaHide");
        }
    }

    private void setPerspective(Perspective newPersp) {
        IStatus status;
        Perspective oldPersp = this.getActivePerspective();
        if (oldPersp == newPersp) {
            return;
        }
        if (newPersp != null && (status = newPersp.restoreState()).getSeverity() != 0) {
            String title = WorkbenchMessages.getString("WorkbenchPage.problemRestoringTitle");
            String msg = WorkbenchMessages.getString("WorkbenchPage.errorReadingState");
            ErrorDialog.openError((Shell)this.getWorkbenchWindow().getShell(), (String)title, (String)msg, (IStatus)status);
        }
        this.actionSwitcher.updateTopEditor(null);
        IWorkbenchPart oldActivePart = this.activePart;
        this.setActivePart(null);
        if (oldPersp != null) {
            oldPersp.onDeactivate();
            this.window.selectPerspectiveShortcut(oldPersp.getDesc(), this, false);
        }
        this.perspList.setActive(newPersp);
        if (newPersp != null) {
            newPersp.onActivate();
            this.window.firePerspectiveActivated(this, newPersp.getDesc());
            this.window.selectPerspectiveShortcut(newPersp.getDesc(), this, true);
        } else {
            oldActivePart = null;
        }
        this.window.updateActionSets();
        this.window.getFastViewBar().update(true);
        this.updateVisibility(oldPersp, newPersp);
        if (oldActivePart != null) {
            String id = oldActivePart.getSite().getId();
            oldPersp.setOldPartID(id);
            if (oldActivePart instanceof IEditorPart && this.isEditorAreaVisible()) {
                this.activate(oldActivePart);
            } else if (oldActivePart instanceof IViewPart) {
                IEditorPart ed = this.editorMgr.getVisibleEditor();
                if (ed != null) {
                    this.actionSwitcher.updateTopEditor(ed);
                }
                if (this.findView(id) != null) {
                    this.activate(oldActivePart);
                } else {
                    this.activateOldPart(newPersp);
                }
            } else {
                this.activateOldPart(newPersp);
            }
        } else {
            IEditorPart ed = this.editorMgr.getVisibleEditor();
            if (ed != null) {
                this.actionSwitcher.updateTopEditor(ed);
            } else {
                this.activateOldPart(newPersp);
            }
        }
        if (this.getActivePart() == null && this.activationList.getActive() != null) {
            this.activate(this.activationList.getActive());
        }
        if (this.editorPresentation != null) {
            this.editorPresentation.showVisibleEditor();
        }
    }

    private void updateVisibility(Perspective oldPersp, Perspective newPersp) {
        PartPane pane;
        int i;
        IViewReference[] refs;
        HashSet<PartPane> set = new HashSet<PartPane>();
        if (oldPersp != null) {
            refs = oldPersp.getViewReferences();
            i = 0;
            while (i < refs.length) {
                pane = ((WorkbenchPartReference)((Object)refs[i])).getPane();
                if (pane != null) {
                    set.add(pane);
                }
                ++i;
            }
        }
        if (newPersp != null) {
            refs = newPersp.getViewReferences();
            i = 0;
            while (i < refs.length) {
                pane = ((WorkbenchPartReference)((Object)refs[i])).getPane();
                if (pane != null) {
                    set.add(pane);
                }
                ++i;
            }
            PerspectivePresentation pres = newPersp.getPresentation();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                PartPane pane2 = (PartPane)iter.next();
                boolean isVisible = pres.isPartVisible(pane2.getID());
                pane2.setVisible(isVisible);
            }
        } else {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                pane = (PartPane)iter.next();
                pane.setVisible(false);
            }
        }
    }

    private void activateOldPart(Perspective newPersp) {
        if (this.window.isClosing()) {
            return;
        }
        if (newPersp != null) {
            String oldID = newPersp.getOldPartID();
            IViewPart prevOldPart = null;
            if (oldID != null) {
                prevOldPart = this.findView(oldID);
            }
            if (prevOldPart != null) {
                this.activate(prevOldPart);
            } else if (this.isEditorAreaVisible()) {
                this.activate(this.getActiveEditor());
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPerspective(final IPerspectiveDescriptor desc) {
        CoolBarManager mgr = this.window.getCoolBarManager();
        try {
            mgr.getControl().setRedraw(false);
            this.getClientComposite().setRedraw(false);
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    WorkbenchPage.this.busySetPerspective(desc);
                }
            });
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.getClientComposite().setRedraw(true);
            mgr.getControl().setRedraw(true);
            IWorkbenchPart part = this.getActivePart();
            if (part == null) throw throwable;
            part.setFocus();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.getClientComposite().setRedraw(true);
        mgr.getControl().setRedraw(true);
        IWorkbenchPart part = this.getActivePart();
        if (part == null) return;
        part.setFocus();
    }

    protected void resetToolBarLayout() {
        this.window.getCoolBarManager().resetLayout();
    }

    public void setWorkingSet(IWorkingSet newWorkingSet) {
        IWorkingSet oldWorkingSet = this.workingSet;
        this.workingSet = newWorkingSet;
        if (oldWorkingSet != newWorkingSet) {
            this.firePropertyChange("workingSetReplace", oldWorkingSet, newWorkingSet);
        }
        if (newWorkingSet != null) {
            WorkbenchPlugin.getDefault().getWorkingSetManager().addPropertyChangeListener(this.propertyChangeListener);
        } else {
            WorkbenchPlugin.getDefault().getWorkingSetManager().removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void showActionSet(String actionSetID) {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            persp.showActionSet(actionSetID);
            this.window.updateActionSets();
            this.window.firePerspectiveChanged(this, this.getPerspective(), "actionSetShow");
        }
    }

    public IViewPart showView(String viewID) throws PartInitException {
        return this.showView(viewID, true);
    }

    public IViewPart showView(final String viewID, final boolean activate) throws PartInitException {
        final Object[] result = new Object[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    result[0] = WorkbenchPage.this.busyShowView(viewID, activate);
                }
                catch (PartInitException e) {
                    result[0] = e;
                }
            }
        });
        if (result[0] instanceof IViewPart) {
            return (IViewPart)result[0];
        }
        if (result[0] instanceof PartInitException) {
            throw (PartInitException)((Object)result[0]);
        }
        throw new PartInitException(WorkbenchMessages.getString("WorkbenchPage.AbnormalWorkbenchCondition"));
    }

    public void toggleFastView(IViewReference ref) {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            persp.toggleFastView(ref);
            if (ref != persp.getActiveFastView()) {
                IWorkbenchPart previouslyActive = this.activationList.getPreviouslyActive();
                IEditorPart activeEditor = this.getActiveEditor();
                if (activeEditor != null && previouslyActive instanceof IEditorPart) {
                    this.setActivePart(activeEditor);
                } else {
                    this.setActivePart(previouslyActive);
                }
            }
        }
    }

    public void toggleZoom(IWorkbenchPartReference ref) {
        Perspective persp = this.getActivePerspective();
        if (persp == null) {
            return;
        }
        PartPane pane = ((WorkbenchPartReference)ref).getPane();
        if (pane.getWindow() instanceof DetachedWindow) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
            return;
        }
        persp.getPresentation().zoomIn(ref);
        this.activate(ref.getPart(true));
    }

    public void updateActionBars() {
        this.window.updateActionBars();
    }

    private void updateTabList(IWorkbenchPart part) {
        PartSite site = (PartSite)part.getSite();
        PartPane pane = site.getPane();
        if (pane instanceof ViewPane) {
            ViewPane viewPane = (ViewPane)pane;
            Control[] tabList = viewPane.getTabList();
            if (pane.getWindow() instanceof DetachedWindow) {
                viewPane.getControl().getShell().setTabList(tabList);
            } else {
                this.getClientComposite().setTabList(tabList);
            }
        } else if (pane instanceof EditorPane) {
            EditorArea ea = ((EditorPane)pane).getWorkbook().getEditorArea();
            ea.updateTabList();
            this.getClientComposite().setTabList(new Control[]{ea.getParent()});
        }
    }

    public void updateTitle(IViewReference ref) {
        if (this.isFastView(ref)) {
            this.window.getFastViewBar().update(true);
        }
    }

    void zoomOut() {
        Perspective persp = this.getActivePerspective();
        if (persp != null) {
            persp.getPresentation().zoomOut();
        }
    }

    private void zoomOutIfNecessary(IWorkbenchPart part) {
        if (this.isZoomed() && this.needToZoomOut(part)) {
            this.zoomOut();
        }
    }

    public int getEditorReuseThreshold() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        return store.getInt("REUSE_OPEN_EDITORS");
    }

    public void setEditorReuseThreshold(int openEditors) {
    }

    public IEditorReference[] getSortedEditors() {
        return this.activationList.getEditors();
    }

    protected IPerspectiveDescriptor[] getOpenedPerspectives() {
        Perspective[] opened = this.perspList.getSortedPerspectives();
        IPerspectiveDescriptor[] result = new IPerspectiveDescriptor[opened.length];
        int i = 0;
        while (i < result.length) {
            result[i] = opened[i].getDesc();
            ++i;
        }
        return result;
    }

    protected IPerspectiveDescriptor[] getSortedPerspectives() {
        Perspective[] sortedArray = this.perspList.getSortedPerspectives();
        IPerspectiveDescriptor[] result = new IPerspectiveDescriptor[sortedArray.length];
        int i = 0;
        while (i < result.length) {
            result[i] = sortedArray[i].getDesc();
            ++i;
        }
        return result;
    }

    public IWorkbenchPartReference[] getSortedParts() {
        return this.activationList.getParts();
    }

    public IWorkbenchPartReference getReference(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        PartPane pane = ((PartSite)part.getSite()).getPane();
        if (pane instanceof MultiEditorInnerPane) {
            MultiEditorInnerPane innerPane = (MultiEditorInnerPane)pane;
            return innerPane.getParentPane().getPartReference();
        }
        if (pane == null) {
            IViewReference[] refs = this.getViewReferences();
            int i = 0;
            while (i < refs.length) {
                if (refs[i].getPart(false) == part) {
                    return refs[i];
                }
                ++i;
            }
            return null;
        }
        return pane.getPartReference();
    }

    public IWorkbenchPageCommandSupport getCommandSupport() {
        return this.workbenchPageCommandSupport;
    }

    public IWorkbenchPageContextSupport getContextSupport() {
        return this.workbenchPageContextSupport;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.commands.IWorkbenchPageCommandSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getCommandSupport();
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ui.contexts.IWorkbenchPageContextSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            return this.getContextSupport();
        }
        return null;
    }

    private class ActionSwitcher {
        private IWorkbenchPart activePart;
        private IEditorPart topEditor;
        private ArrayList actionSets = new ArrayList();

        ActionSwitcher() {
        }

        public void updateActivePart(IWorkbenchPart newPart) {
            if (this.activePart == newPart) {
                return;
            }
            boolean isNewPartAnEditor = newPart instanceof IEditorPart;
            if (isNewPartAnEditor) {
                String oldId = null;
                if (this.topEditor != null) {
                    oldId = this.topEditor.getSite().getId();
                }
                String newId = newPart.getSite().getId();
                if (this.activePart == this.topEditor && newId.equals(oldId)) {
                    return;
                }
                if (oldId != null && !oldId.equals(newId)) {
                    this.deactivateContributions(this.topEditor, true);
                }
                if (this.activePart != null && this.activePart != this.topEditor) {
                    this.deactivateContributions(this.activePart, true);
                }
                if (!newId.equals(oldId) || this.activePart != this.topEditor) {
                    this.activateContributions(newPart, true);
                }
            } else if (newPart == null) {
                if (this.activePart != null) {
                    this.deactivateContributions(this.activePart, true);
                }
            } else {
                if (this.activePart != null) {
                    this.deactivateContributions(this.activePart, this.activePart instanceof IViewPart);
                }
                this.activateContributions(newPart, true);
            }
            ArrayList newActionSets = null;
            newActionSets = isNewPartAnEditor || this.activePart == this.topEditor && newPart == null ? this.calculateActionSets(newPart, null) : this.calculateActionSets(newPart, this.topEditor);
            if (!this.updateActionSets(newActionSets)) {
                WorkbenchPage.this.updateActionBars();
            }
            if (isNewPartAnEditor) {
                this.topEditor = (IEditorPart)newPart;
            } else if (this.activePart == this.topEditor && newPart == null) {
                this.topEditor = null;
            }
            this.activePart = newPart;
        }

        public void updateTopEditor(IEditorPart newEditor) {
            ArrayList newActionSets;
            if (this.topEditor == newEditor) {
                return;
            }
            String oldId = null;
            if (this.topEditor != null) {
                oldId = this.topEditor.getSite().getId();
            }
            String newId = null;
            if (newEditor != null) {
                newId = newEditor.getSite().getId();
            }
            if (oldId == null ? newId == null : oldId.equals(newId)) {
                this.topEditor = newEditor;
                return;
            }
            if (this.topEditor != null) {
                this.deactivateContributions(this.topEditor, true);
            }
            if (newEditor != null) {
                this.activateContributions(newEditor, false);
            }
            if (!this.updateActionSets(newActionSets = this.calculateActionSets(this.activePart, newEditor))) {
                WorkbenchPage.this.updateActionBars();
            }
            this.topEditor = newEditor;
        }

        private void activateContributions(IWorkbenchPart part, boolean enable) {
            PartSite site = (PartSite)part.getSite();
            SubActionBars actionBars = (SubActionBars)site.getActionBars();
            actionBars.activate(enable);
        }

        private void deactivateContributions(IWorkbenchPart part, boolean remove) {
            PartSite site = (PartSite)part.getSite();
            SubActionBars actionBars = (SubActionBars)site.getActionBars();
            actionBars.deactivate(remove);
        }

        private ArrayList calculateActionSets(IWorkbenchPart part, IEditorPart editor) {
            int i;
            ArrayList<IActionSetDescriptor> newActionSets = new ArrayList<IActionSetDescriptor>();
            if (part != null) {
                IActionSetDescriptor[] partActionSets = WorkbenchPlugin.getDefault().getActionSetRegistry().getActionSetsFor(part.getSite().getId());
                i = 0;
                while (i < partActionSets.length) {
                    newActionSets.add(partActionSets[i]);
                    ++i;
                }
            }
            if (editor != null && editor != part) {
                IActionSetDescriptor[] editorActionSets = WorkbenchPlugin.getDefault().getActionSetRegistry().getActionSetsFor(editor.getSite().getId());
                i = 0;
                while (i < editorActionSets.length) {
                    newActionSets.add(editorActionSets[i]);
                    ++i;
                }
            }
            return newActionSets;
        }

        private boolean updateActionSets(ArrayList newActionSets) {
            if (this.actionSets.equals(newActionSets)) {
                return false;
            }
            Perspective persp = WorkbenchPage.this.getActivePerspective();
            if (persp == null) {
                this.actionSets = newActionSets;
                return false;
            }
            int i = 0;
            while (i < this.actionSets.size()) {
                persp.hideActionSet(((IActionSetDescriptor)this.actionSets.get(i)).getId());
                ++i;
            }
            i = 0;
            while (i < newActionSets.size()) {
                persp.showActionSet(((IActionSetDescriptor)newActionSets.get(i)).getId());
                ++i;
            }
            this.actionSets = newActionSets;
            WorkbenchPage.this.window.updateActionSets();
            WorkbenchPage.this.window.firePerspectiveChanged(WorkbenchPage.this, WorkbenchPage.this.getPerspective(), "actionSetShow");
            return true;
        }
    }

    private class ActivationList {
        List parts = new ArrayList();

        ActivationList() {
        }

        void setActive(IWorkbenchPart part) {
            if (this.parts.size() <= 0) {
                return;
            }
            PartPane pane = ((PartSite)part.getSite()).getPane();
            if (pane instanceof MultiEditorInnerPane) {
                MultiEditorInnerPane innerPane = (MultiEditorInnerPane)pane;
                this.setActive(innerPane.getParentPane().getPartReference().getPart(true));
            } else {
                IWorkbenchPartReference ref = WorkbenchPage.this.getReference(part);
                if (ref == this.parts.get(this.parts.size() - 1)) {
                    return;
                }
                this.parts.remove(ref);
                this.parts.add(ref);
            }
            pane.addPropertyChangeListener(WorkbenchPage.this.propertyChangeListener);
        }

        void setActive(IWorkbenchPartReference ref) {
            this.setActive(ref.getPart(true));
        }

        void add(IWorkbenchPartReference ref) {
            PartPane pane;
            if (this.parts.indexOf(ref) >= 0) {
                return;
            }
            IWorkbenchPart part = ref.getPart(false);
            if (part != null && (pane = ((PartSite)part.getSite()).getPane()) instanceof MultiEditorInnerPane) {
                MultiEditorInnerPane innerPane = (MultiEditorInnerPane)pane;
                this.add(innerPane.getParentPane().getPartReference());
                return;
            }
            pane = ((WorkbenchPartReference)ref).getPane();
            if (pane != null) {
                pane.addPropertyChangeListener(WorkbenchPage.this.propertyChangeListener);
            }
            this.parts.add(0, ref);
        }

        IWorkbenchPart getActive() {
            if (this.parts.isEmpty()) {
                return null;
            }
            return this.getActive(this.parts.size() - 1);
        }

        IWorkbenchPart getPreviouslyActive() {
            if (this.parts.size() < 2) {
                return null;
            }
            return this.getActive(this.parts.size() - 2);
        }

        private IWorkbenchPart getActive(int start) {
            IViewReference[] views = WorkbenchPage.this.getViewReferences();
            int i = start;
            while (i >= 0) {
                IWorkbenchPartReference ref = (IWorkbenchPartReference)this.parts.get(i);
                if (ref instanceof IViewReference) {
                    if (!((IViewReference)ref).isFastView()) {
                        int j = 0;
                        while (j < views.length) {
                            if (views[j] == ref) {
                                return ref.getPart(true);
                            }
                            ++j;
                        }
                    }
                } else {
                    return ref.getPart(true);
                }
                --i;
            }
            return null;
        }

        int indexOf(IWorkbenchPart part) {
            return this.parts.indexOf(WorkbenchPage.this.getReference(part));
        }

        boolean remove(IWorkbenchPartReference ref) {
            PartPane pane = ((WorkbenchPartReference)ref).getPane();
            if (pane != null) {
                pane.removePropertyChangeListener(WorkbenchPage.this.propertyChangeListener);
            }
            return this.parts.remove(ref);
        }

        private IEditorReference[] getEditors() {
            ArrayList<IWorkbenchPartReference> editors = new ArrayList<IWorkbenchPartReference>(this.parts.size());
            Iterator i = this.parts.iterator();
            while (i.hasNext()) {
                IWorkbenchPartReference part = (IWorkbenchPartReference)i.next();
                if (!(part instanceof IEditorReference)) continue;
                editors.add(part);
            }
            return editors.toArray(new IEditorReference[editors.size()]);
        }

        private IWorkbenchPartReference[] getParts() {
            IViewReference[] views = WorkbenchPage.this.getViewReferences();
            ArrayList<IWorkbenchPartReference> resultList = new ArrayList<IWorkbenchPartReference>(this.parts.size());
            Iterator iterator = this.parts.iterator();
            block0: while (iterator.hasNext()) {
                IWorkbenchPartReference ref = (IWorkbenchPartReference)iterator.next();
                if (ref instanceof IViewReference) {
                    int i = 0;
                    while (i < views.length) {
                        if (views[i] == ref) {
                            resultList.add(ref);
                            continue block0;
                        }
                        ++i;
                    }
                    continue;
                }
                resultList.add(ref);
            }
            IWorkbenchPartReference[] result = new IWorkbenchPartReference[resultList.size()];
            return resultList.toArray(result);
        }

        IEditorPart getTopEditor() {
            IEditorReference[] editors = this.getEditors();
            if (editors.length > 0) {
                return editors[editors.length - 1].getEditor(true);
            }
            return null;
        }
    }

    private class PerspectiveList {
        private List openedList = new ArrayList(15);
        private List usedList = new ArrayList(15);
        private Perspective active;

        public Perspective[] getSortedPerspectives() {
            Perspective[] result = new Perspective[this.usedList.size()];
            return this.usedList.toArray(result);
        }

        public boolean add(Perspective perspective) {
            this.openedList.add(perspective);
            this.usedList.add(0, perspective);
            return true;
        }

        public Iterator iterator() {
            return this.openedList.iterator();
        }

        public Perspective[] getOpenedPerspectives() {
            Perspective[] result = new Perspective[this.openedList.size()];
            return this.openedList.toArray(result);
        }

        public boolean remove(Perspective perspective) {
            if (this.active == perspective) {
                this.active = null;
            }
            this.usedList.remove(perspective);
            return this.openedList.remove(perspective);
        }

        public void swap(Perspective oldPerspective, Perspective newPerspective) {
            int oldIndex = this.openedList.indexOf(oldPerspective);
            int newIndex = this.openedList.indexOf(newPerspective);
            if (oldIndex < 0 || newIndex < 0) {
                return;
            }
            this.openedList.set(oldIndex, newPerspective);
            this.openedList.set(newIndex, oldPerspective);
        }

        public boolean isEmpty() {
            return this.openedList.isEmpty();
        }

        public Perspective getActive() {
            return this.active;
        }

        public Perspective getNextActive() {
            if (this.active == null) {
                if (this.usedList.isEmpty()) {
                    return null;
                }
                return (Perspective)this.usedList.get(this.usedList.size() - 1);
            }
            if (this.usedList.size() < 2) {
                return null;
            }
            return (Perspective)this.usedList.get(this.usedList.size() - 2);
        }

        public int size() {
            return this.openedList.size();
        }

        public void setActive(Perspective perspective) {
            if (perspective == this.active) {
                return;
            }
            this.active = perspective;
            if (perspective != null) {
                this.usedList.remove(perspective);
                this.usedList.add(perspective);
            }
        }
    }
}

