/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.CTabFolder2;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.IWorkbenchDragSource;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PartTabFolder;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.RootLayoutContainer;
import org.eclipse.ui.internal.ViewActionBuilder;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.part.WorkbenchPart;

public class ViewPane
extends PartPane
implements IPropertyListener {
    private boolean fast = false;
    private ToolBar viewToolBar;
    private ToolBarManager viewToolBarMgr;
    ToolBar isvToolBar;
    private ToolBarManager isvToolBarMgr;
    private MenuManager isvMenuMgr;
    private ToolItem pullDownButton;
    private boolean showMenuButton = false;
    private Sash fastViewSash;
    private SystemContribution systemContribution = new SystemContribution();

    public ViewPane(IViewReference ref, WorkbenchPage page) {
        super(ref, page);
        this.fast = ref.isFastView();
    }

    public void createControl(Composite parent) {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            return;
        }
        super.createControl(parent);
        if (this.control.getContent() == null) {
            this.control.setTabList(new Control[]{this.isvToolBar, this.viewToolBar});
        } else {
            this.control.setTabList(new Control[]{this.viewToolBar, this.control.getContent()});
        }
    }

    protected void createChildControl() {
        IWorkbenchPart[] part = new IWorkbenchPart[]{this.partReference.getPart(false)};
        if (part[0] == null) {
            return;
        }
        if (this.control == null || this.control.getContent() != null) {
            return;
        }
        super.createChildControl();
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                ViewActionBuilder builder = new ViewActionBuilder();
                IViewPart part = (IViewPart)ViewPane.this.getViewReference().getPart(true);
                if (part != null) {
                    builder.readActionExtensions(part);
                    ActionDescriptor[] actionDescriptors = builder.getExtendedActions();
                    KeyBindingService keyBindingService = (KeyBindingService)part.getSite().getKeyBindingService();
                    if (actionDescriptors != null) {
                        int i = 0;
                        while (i < actionDescriptors.length) {
                            PluginAction action;
                            ActionDescriptor actionDescriptor = actionDescriptors[i];
                            if (actionDescriptor != null && (action = actionDescriptors[i].getAction()) != null && action.getActionDefinitionId() != null) {
                                keyBindingService.registerAction((IAction)action);
                            }
                            ++i;
                        }
                    }
                }
                ViewPane.this.updateActionBars();
            }

            public void handleException(Throwable e) {
            }
        });
    }

    protected WorkbenchPart createErrorPart(WorkbenchPart oldPart) {
        class ErrorViewPart
        extends ViewPart {
            private Text text;
            final /* synthetic */ ViewPane this$0;

            ErrorViewPart(ViewPane viewPane) {
                this.this$0 = viewPane;
            }

            public void createPartControl(Composite parent) {
                this.text = new Text(parent, 74);
                this.text.setForeground(JFaceColors.getErrorText((Display)this.text.getDisplay()));
                this.text.setBackground(this.text.getDisplay().getSystemColor(22));
                this.text.setText(WorkbenchMessages.getString("ViewPane.errorMessage"));
            }

            public void setFocus() {
                if (this.text != null) {
                    this.text.setFocus();
                }
            }

            public void setSite(IWorkbenchPartSite site) {
                super.setSite(site);
            }

            public void setTitle(String title) {
                super.setTitle(title);
            }
        }
        ErrorViewPart newPart = new ErrorViewPart(this);
        PartSite site = (PartSite)oldPart.getSite();
        newPart.setSite(site);
        newPart.setTitle(site.getRegisteredName());
        site.setPart(newPart);
        return newPart;
    }

    public boolean isDragAllowed(Point p) {
        return !this.isZoomed();
    }

    protected void createTitleBar() {
        if (this.viewToolBar != null) {
            return;
        }
        this.updateTitles();
        this.getPartReference().addPropertyListener(this);
        this.viewToolBar = new ToolBar((Composite)this.control, 0x800040);
        this.control.setTopRight((Control)this.viewToolBar);
        this.viewToolBar.setBackground(JFaceColors.getTabFolderSelectionBackground((Display)this.control.getDisplay()));
        this.control.setBackground(JFaceColors.getTabFolderSelectionBackground((Display)this.control.getDisplay()));
        this.viewToolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (ViewPane.this.viewToolBar.getItem(new Point(event.x, event.y)) == null) {
                    ViewPane.this.doZoom();
                }
            }
        });
        this.viewToolBarMgr = new PaneToolBarManager(this.viewToolBar);
        this.viewToolBarMgr.add((IContributionItem)this.systemContribution);
        this.isvToolBar = new ToolBar((Composite)this.control, 0x800040);
        this.control.setTopCenter((Control)this.isvToolBar);
        this.isvToolBar.setBackground(JFaceColors.getTabFolderSelectionBackground((Display)this.control.getDisplay()));
        this.isvToolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (ViewPane.this.isvToolBar.getItem(new Point(event.x, event.y)) == null) {
                    ViewPane.this.doZoom();
                }
            }
        });
        this.isvToolBarMgr = new PaneToolBarManager(this.isvToolBar);
    }

    public void dispose() {
        super.dispose();
        if (this.isvMenuMgr != null) {
            this.isvMenuMgr.dispose();
        }
        if (this.isvToolBarMgr != null) {
            this.isvToolBarMgr.dispose();
        }
        if (this.viewToolBarMgr != null) {
            this.viewToolBarMgr.dispose();
        }
    }

    public void doHide() {
        this.getPage().hideView(this.getViewReference());
    }

    protected void doMakeFast() {
        this.getPage().addFastView(this.getViewReference());
    }

    protected void doMinimize() {
        this.getPage().toggleFastView(this.getViewReference());
    }

    protected void doDock() {
        this.getPage().removeFastView(this.getViewReference());
    }

    public Control getDragHandle() {
        return this.viewToolBar;
    }

    public MenuManager getMenuManager() {
        if (this.isvMenuMgr == null) {
            this.isvMenuMgr = new PaneMenuManager();
        }
        return this.isvMenuMgr;
    }

    public Control[] getTabList() {
        PartTabFolder tf;
        CTabFolder2 f;
        Control c = this.getControl();
        if (this.getContainer() instanceof PartTabFolder && (f = (CTabFolder2)(tf = (PartTabFolder)this.getContainer()).getControl()).getItemCount() > 1) {
            if ((f.getStyle() & 0x80) != 0) {
                return new Control[]{f, c};
            }
            return new Control[]{c, f};
        }
        return new Control[]{c};
    }

    public ToolBarManager getToolBarManager() {
        return this.isvToolBarMgr;
    }

    public IViewReference getViewReference() {
        return (IViewReference)this.getPartReference();
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 1) {
            this.updateTitles();
        }
    }

    public void setFast(boolean b) {
        this.fast = b;
        if (this.viewToolBarMgr != null) {
            this.viewToolBarMgr.update(true);
        }
    }

    public void setFastViewSash(Sash s) {
        this.fastViewSash = s;
    }

    void shellActivated() {
    }

    void shellDeactivated() {
    }

    void setActive(boolean active) {
        if (this.getContainer() instanceof PartTabFolder) {
            ((PartTabFolder)this.getContainer()).setActive(active);
        }
        if (active) {
            Color color = WorkbenchColors.getSystemColor(29);
            this.getControl().setBackground(color);
            this.viewToolBar.setBackground(color);
            this.isvToolBar.setBackground(color);
        } else {
            Color color = JFaceColors.getTabFolderSelectionBackground((Display)this.isvToolBar.getDisplay());
            this.getControl().setBackground(color);
            this.viewToolBar.setBackground(color);
            this.isvToolBar.setBackground(color);
        }
    }

    public void showFocus(boolean inFocus) {
        this.setActive(inFocus);
    }

    public void showPaneMenu() {
    }

    private boolean isFastView() {
        return this.page.isFastView(this.getViewReference());
    }

    protected PartPane.Sashes findSashes() {
        PartPane.Sashes result = new PartPane.Sashes();
        if (this.isFastView()) {
            result.right = this.fastViewSash;
            return result;
        }
        RootLayoutContainer container = this.getRootContainer();
        if (container == null) {
            return result;
        }
        if (this.getContainer() instanceof PartTabFolder) {
            container.findSashes((PartTabFolder)this.getContainer(), result);
        } else {
            container.findSashes(this, result);
        }
        return result;
    }

    protected void addFastViewMenuItem(Menu parent, boolean isFastView) {
        MenuItem item = new MenuItem(parent, 32);
        item.setText(WorkbenchMessages.getString("ViewPane.fastView"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ViewPane.this.isFastView()) {
                    ViewPane.this.doDock();
                } else {
                    ViewPane.this.doMakeFast();
                }
            }
        });
        item.setSelection(isFastView);
        if (isFastView) {
            item = new MenuItem(parent, 0);
            item.setText(WorkbenchMessages.getString("ViewPane.minimizeView"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ViewPane.this.doMinimize();
                }
            });
            item.setEnabled(true);
        }
    }

    protected void addMoveItems(Menu moveMenu) {
        boolean moveAllowed = !this.isZoomed() && !this.isFastView();
        MenuItem item = new MenuItem(moveMenu, 0);
        item.setText(WorkbenchMessages.getString("ViewPane.moveView"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewPane.this.page.openTracker(ViewPane.this);
            }
        });
        item.setEnabled(moveAllowed);
        item = new MenuItem(moveMenu, 0);
        item.setText(WorkbenchMessages.getString("ViewPane.moveFolder"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ILayoutContainer container = ViewPane.this.getContainer();
                if (container instanceof PartTabFolder) {
                    ((PartTabFolder)container).openTracker((PartTabFolder)container);
                }
            }
        });
        item.setEnabled(moveAllowed && this.getContainer() instanceof PartTabFolder);
    }

    public boolean hasViewMenu() {
        if (this.isvMenuMgr == null) {
            return false;
        }
        return this.pullDownButton != null && !this.pullDownButton.isDisposed();
    }

    public void showViewMenu() {
        if (!this.hasViewMenu()) {
            return;
        }
        if (this.isFastView() && this.page.getActiveFastView() != this.getViewReference()) {
            return;
        }
        Menu aMenu = this.isvMenuMgr.createContextMenu(this.getControl());
        Rectangle bounds = this.pullDownButton.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.viewToolBar.toDisplay(topLeft);
        aMenu.setLocation(topLeft.x, topLeft.y);
        aMenu.setVisible(true);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode());
    }

    public void updateActionBars() {
        if (this.isvMenuMgr != null) {
            this.isvMenuMgr.updateAll(false);
        }
        if (this.viewToolBarMgr != null) {
            this.viewToolBarMgr.update(false);
        }
        if (this.isvToolBarMgr != null) {
            this.isvToolBarMgr.update(false);
        }
    }

    public void updateTitles() {
    }

    public int getType() {
        return 1;
    }

    public LayoutPart targetPartFor(IWorkbenchDragSource dragSource) {
        if (this.isZoomed()) {
            return this;
        }
        ILayoutContainer container = this.getContainer();
        if (container instanceof PartTabFolder) {
            return (PartTabFolder)container;
        }
        return this;
    }

    class PaneToolBarManager
    extends ToolBarManager {
        public PaneToolBarManager(ToolBar paneToolBar) {
            super(paneToolBar);
        }

        protected void relayout(ToolBar toolBar, int oldCount, int newCount) {
            toolBar.layout();
            Composite parent = toolBar.getParent();
            parent.layout();
            if (parent.getParent() != null) {
                parent.getParent().layout();
            }
        }
    }

    class PaneMenuManager
    extends MenuManager {
        public PaneMenuManager() {
            super("View Local Menu");
        }

        protected void update(boolean force, boolean recursive) {
            if (ViewPane.this.showMenuButton != !this.isEmpty()) {
                ViewPane.this.viewToolBarMgr.update(true);
            }
            super.update(force, recursive);
        }
    }

    class SystemContribution
    extends ContributionItem {
        SystemContribution() {
        }

        public boolean isDynamic() {
            return true;
        }

        public void fill(ToolBar toolbar, int index) {
            ViewPane.this.showMenuButton = ViewPane.this.isvMenuMgr != null && !ViewPane.this.isvMenuMgr.isEmpty();
            if (ViewPane.this.showMenuButton) {
                ViewPane.this.pullDownButton = new ToolItem(toolbar, 8, index++);
                Image hoverImage = WorkbenchImages.getImage("IMG_LCL_VIEW_MENU_HOVER");
                ViewPane.this.pullDownButton.setDisabledImage(hoverImage);
                ViewPane.this.pullDownButton.setImage(hoverImage);
                ViewPane.this.pullDownButton.setToolTipText(WorkbenchMessages.getString("Menu"));
                ViewPane.this.pullDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ SystemContribution this$1;
                    {
                        this.this$1 = systemContribution;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        SystemContribution.access$0(this.this$1).showViewMenu();
                    }
                });
            } else {
                ViewPane.this.pullDownButton = null;
            }
            if (ViewPane.this.fast) {
                ToolItem dockButton = new ToolItem(toolbar, 32, index++);
                dockButton.setSelection(true);
                Image hoverImage = WorkbenchImages.getImage("IMG_LCL_PIN_VIEW_HOVER");
                dockButton.setDisabledImage(hoverImage);
                dockButton.setImage(hoverImage);
                dockButton.setToolTipText(WorkbenchMessages.getString("ViewPane.pin"));
                dockButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ SystemContribution this$1;
                    {
                        this.this$1 = systemContribution;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        SystemContribution.access$0(this.this$1).doDock();
                    }
                });
                ToolItem minimizeButton = new ToolItem(toolbar, 8, index++);
                hoverImage = WorkbenchImages.getImage("IMG_LCL_MIN_VIEW_HOVER");
                minimizeButton.setDisabledImage(hoverImage);
                minimizeButton.setImage(hoverImage);
                minimizeButton.setToolTipText(WorkbenchMessages.getString("ViewPane.minimize"));
                minimizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ SystemContribution this$1;
                    {
                        this.this$1 = systemContribution;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        SystemContribution.access$0(this.this$1).doMinimize();
                    }
                });
            }
        }

        static /* synthetic */ ViewPane access$0(SystemContribution systemContribution) {
            return systemContribution.ViewPane.this;
        }
    }
}

