/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.ColorSchemeService;
import org.eclipse.swt.custom.CTabFolder2;
import org.eclipse.swt.custom.CTabFolderAdapter;
import org.eclipse.swt.custom.CTabFolderCloseListener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListListener;
import org.eclipse.swt.custom.CTabItem2;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.internal.CTabPartDragDrop;
import org.eclipse.ui.internal.EditorArea;
import org.eclipse.ui.internal.EditorList;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorWorkbook;
import org.eclipse.ui.internal.EditorsInformationControl;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.IWorkbenchDragSource;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartDragDrop;
import org.eclipse.ui.internal.PartTabFolder;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class TabbedEditorWorkbook
extends EditorWorkbook {
    private IPreferenceStore preferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
    private int tabLocation = -1;
    private CTabFolder2 tabFolder = null;
    private Map mapTabToEditor = new HashMap();
    private ToolBar pullDownBar;
    private ToolItem pullDownButton;
    private EditorList editorList;
    private ViewForm listComposite;
    private boolean assignFocusOnSelection = true;
    private boolean ignoreTabFocusHide = false;
    private boolean handleTabSelection = true;
    private boolean mouseDownListenerAdded = false;
    private boolean usePulldown = false;

    public TabbedEditorWorkbook(EditorArea editorArea) {
        super(editorArea);
        if (this.tabLocation == -1) {
            this.tabLocation = this.preferenceStore.getInt("EDITOR_TAB_POSITION");
        }
    }

    protected Object createItem(EditorPane editorPane) {
        return this.createTab(editorPane);
    }

    private CTabItem2 createTab(EditorPane editorPane) {
        return this.createTab(editorPane, this.tabFolder.getItemCount());
    }

    private CTabItem2 createTab(EditorPane editorPane, int index) {
        CTabItem2 tab = new CTabItem2(this.tabFolder, 0, index);
        this.mapTabToEditor.put(tab, editorPane);
        this.enableDrag(editorPane);
        this.updateEditorTab((IEditorReference)editorPane.getPartReference());
        if (this.tabFolder.getItemCount() == 1 && this.tabFolder.getTopRight() != null) {
            this.pullDownBar.setVisible(true);
        }
        return tab;
    }

    protected void setControlSize() {
        EditorPane visibleEditor = this.getVisibleEditor();
        if (visibleEditor == null || this.getControl() == null) {
            return;
        }
        Rectangle bounds = PartTabFolder.calculatePageBounds(this.tabFolder);
        visibleEditor.setBounds(bounds);
        visibleEditor.moveAbove((Control)this.tabFolder);
    }

    protected void createPresentation(Composite parent) {
        this.usePulldown = this.preferenceStore.getBoolean("EDITORLIST_PULLDOWN_ACTIVE");
        this.tabFolder = new CTabFolder2(parent, 0x804 | this.tabLocation);
        this.tabFolder.setBorderVisible(false);
        ColorSchemeService.setTabColors((CTabFolder2)this.tabFolder);
        this.tabFolder.setTabList(new Control[0]);
        this.tabFolder.setData((Object)this);
        this.tabFolder.addCTabFolderCloseListener((CTabFolderCloseListener)new CTabFolderAdapter(){

            public void itemClosed(CTabFolderEvent e) {
                e.doit = false;
                EditorPane pane = (EditorPane)TabbedEditorWorkbook.this.mapTabToEditor.get(e.item);
                pane.doHide();
            }
        });
        int shellStyle = 16408;
        int tableStyle = 768;
        final EditorsInformationControl info = new EditorsInformationControl(this.tabFolder.getShell(), shellStyle, tableStyle);
        this.tabFolder.addCTabFolderListListener(new CTabFolderListListener(){

            public void showList(CTabFolderEvent event) {
                Point p = TabbedEditorWorkbook.this.tabFolder.toDisplay(event.rect.x, event.rect.y);
                p.y += event.rect.height;
                this.showList(TabbedEditorWorkbook.this.tabFolder.getShell(), p.x, p.y);
            }

            void showList(Shell parentShell, int x, int y) {
                info.setInput(TabbedEditorWorkbook.this);
                Point size = info.computeSizeHint();
                int minX = 50;
                int minY = 300;
                if (size.x < minX) {
                    size.x = minX;
                }
                if (size.y < minY) {
                    size.y = minY;
                }
                info.setSize(size.x, size.y);
                info.setLocation(new Point(x, y));
                info.setVisible(true);
                info.setFocus();
                info.getTableViewer().getTable().getShell().addListener(27, new Listener(this, info){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ EditorsInformationControl val$info;
                    {
                        this.this$1 = var1_1;
                        this.val$info = editorsInformationControl;
                    }

                    public void handleEvent(Event event) {
                        this.val$info.setVisible(false);
                    }
                });
            }

            void showList(Display display, int x, int y) {
                Shell shell = new Shell(TabbedEditorWorkbook.this.tabFolder.getShell(), 16392);
                shell.addFocusListener(new FocusListener(this, shell){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Shell val$shell;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                    }

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        if (!this.val$shell.getDisplay().getActiveShell().equals(this.val$shell)) {
                            this.val$shell.dispose();
                        }
                    }
                });
                FillLayout fl = new FillLayout(512);
                fl.marginHeight = 3;
                fl.marginWidth = 3;
                shell.setLayout((Layout)fl);
                Text text = new Text((Composite)shell, 4);
                Table table = new Table((Composite)shell, 0);
                CTabItem2[] items = TabbedEditorWorkbook.this.tabFolder.getItems();
                String[] stringItems = new String[items.length];
                int i = 0;
                while (i < items.length) {
                    CTabItem2 tab = items[i];
                    stringItems[i] = tab.getText();
                    TableItem item = new TableItem(table, 0);
                    item.setText(tab.getText());
                    item.setImage(tab.getImage());
                    ++i;
                }
                int idx = TabbedEditorWorkbook.this.tabFolder.getSelectionIndex();
                if (idx != -1) {
                    table.setSelection(idx);
                }
                Listener listener = new Listener(this, table, shell, text, stringItems, idx){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Table val$table;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ Text val$text;
                    private final /* synthetic */ String[] val$stringItems;
                    private final /* synthetic */ int val$idx;
                    {
                        this.this$1 = var1_1;
                        this.val$table = table;
                        this.val$shell = shell;
                        this.val$text = text;
                        this.val$stringItems = stringArray;
                        this.val$idx = n;
                    }

                    public void handleEvent(Event e) {
                        block0 : switch (e.type) {
                            case 16: {
                                if (!e.widget.equals(this.val$table)) break;
                                this.val$shell.dispose();
                                break;
                            }
                            case 24: {
                                String s = this.val$text.getText();
                                if (s.length() == 0) break;
                                int i = 0;
                                while (i < this.val$stringItems.length) {
                                    String item = this.val$stringItems[i];
                                    if (item.toLowerCase(Locale.getDefault()).startsWith(s.toLowerCase(Locale.getDefault()))) {
                                        this.val$table.setSelection(i);
                                        break block0;
                                    }
                                    ++i;
                                }
                                break;
                            }
                            case 4: 
                            case 14: {
                                int index = this.val$table.getSelectionIndex();
                                if (index != this.val$idx) {
                                    TabbedEditorWorkbook.access$1(2.access$0(this.this$1)).setSelection(index);
                                    2.access$0(this.this$1).setFocus();
                                }
                                this.val$shell.dispose();
                                2.access$0(this.this$1).handleTabSelection((Widget)TabbedEditorWorkbook.access$1(2.access$0(this.this$1)).getSelection());
                            }
                        }
                    }
                };
                text.addListener(24, listener);
                text.addListener(14, listener);
                table.addListener(4, listener);
                table.addListener(14, listener);
                table.addListener(16, listener);
                Point size = shell.computeSize(-1, -1);
                Rectangle displayRect = TabbedEditorWorkbook.this.tabFolder.getMonitor().getClientArea();
                size.y = Math.min(displayRect.height / 3, size.y);
                shell.setSize(size);
                shell.setLocation(x, y);
                shell.open();
                text.setFocus();
            }

            static /* synthetic */ TabbedEditorWorkbook access$0(2 var0) {
                return var0.TabbedEditorWorkbook.this;
            }
        });
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabbedEditorWorkbook.this.handleTabSelection(e.item);
            }
        });
        this.tabFolder.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                TabbedEditorWorkbook.this.setControlSize();
            }
        });
        this.tabFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                Rectangle clientArea = TabbedEditorWorkbook.this.tabFolder.getClientArea();
                if ((TabbedEditorWorkbook.this.tabFolder.getStyle() & 0x80) != 0 ? event.y > clientArea.y : event.y < clientArea.y + clientArea.height) {
                    return;
                }
                TabbedEditorWorkbook.this.doZoom();
            }

            public void mouseDown(MouseEvent e) {
                EditorPane visibleEditor = TabbedEditorWorkbook.this.getVisibleEditor();
                if (visibleEditor != null) {
                    CTabItem2 item = TabbedEditorWorkbook.this.getTab(visibleEditor);
                    visibleEditor.setFocus();
                    Rectangle bounds = item.getBounds();
                    if (bounds.contains(e.x, e.y) && e.button == 1 && TabbedEditorWorkbook.this.overImage(item, e.x)) {
                        visibleEditor.showPaneMenu();
                    }
                }
            }
        });
        this.tabFolder.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                EditorPane visibleEditor = TabbedEditorWorkbook.this.getVisibleEditor();
                if (event.type == 35 && visibleEditor != null) {
                    CTabItem2 item = TabbedEditorWorkbook.this.getTab(visibleEditor);
                    visibleEditor.setFocus();
                    Rectangle bounds = item.getBounds();
                    Point pt = TabbedEditorWorkbook.this.tabFolder.toControl(event.x, event.y);
                    if (bounds.contains(pt.x, pt.y)) {
                        visibleEditor.showPaneMenu((Control)TabbedEditorWorkbook.this.tabFolder, new Point(event.x, event.y));
                    }
                }
            }
        });
        if (!this.mouseDownListenerAdded && this.getEditorArea() != null) {
            this.tabFolder.addListener(3, this.getEditorArea().getMouseDownListener());
            this.mouseDownListenerAdded = true;
        }
        this.editorList = new EditorList(this.getEditorArea().getWorkbenchWindow(), this);
        this.pullDownBar = new ToolBar((Composite)this.tabFolder, 0x800000);
        this.pullDownButton = new ToolItem(this.pullDownBar, 8);
        Image hotImage = WorkbenchImages.getImage("IMG_LCL_VIEW_MENU_HOVER");
        this.pullDownButton.setDisabledImage(hotImage);
        this.pullDownButton.setImage(hotImage);
        this.pullDownButton.setToolTipText(WorkbenchMessages.getString("EditorList.button.toolTip"));
        this.pullDownButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TabbedEditorWorkbook.this.openEditorList();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.usePulldown) {
            this.tabFolder.setTopRight((Control)this.pullDownBar);
            this.pullDownBar.setVisible(true);
        } else {
            this.pullDownBar.setVisible(false);
            this.tabFolder.setTopRight(null);
        }
        this.tabFolder.MIN_TAB_WIDTH = this.preferenceStore.getInt("EDITOR_TAB_WIDTH");
    }

    protected void handleTabSelection(Widget tabItem) {
        EditorPane pane;
        if (this.handleTabSelection && (pane = (EditorPane)this.mapTabToEditor.get(tabItem)) != null) {
            this.setVisibleEditor(pane);
            if (this.assignFocusOnSelection) {
                this.ignoreTabFocusHide = true;
                pane.setFocus();
                this.ignoreTabFocusHide = false;
            }
        }
    }

    private CTabItem2 getTab(LayoutPart child) {
        Iterator tabs = this.mapTabToEditor.keySet().iterator();
        while (tabs.hasNext()) {
            CTabItem2 tab = (CTabItem2)tabs.next();
            if (this.mapTabToEditor.get(tab) != child) continue;
            return tab;
        }
        return null;
    }

    public boolean isDragAllowed(EditorPane pane, Point p) {
        CTabItem2 tab = this.getTab(pane);
        return tab != null && this.overImage(tab, p.x);
    }

    private boolean overImage(CTabItem2 item, int x) {
        if (item.getImage() == null) {
            return false;
        }
        Rectangle imageBounds = item.getImage().getBounds();
        return x < item.getBounds().x + imageBounds.x + imageBounds.width;
    }

    private void closeEditorList() {
        this.editorList.destroyControl();
    }

    public void openEditorList() {
        if (this.listComposite != null) {
            return;
        }
        Shell parent = this.getEditorArea().getWorkbenchWindow().getShell();
        this.listComposite = new ViewForm((Composite)parent, 2048);
        this.listComposite.setVisible(false);
        this.listComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TabbedEditorWorkbook.this.listComposite = null;
            }
        });
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (TabbedEditorWorkbook.this.listComposite != null) {
                    TabbedEditorWorkbook.this.closeEditorList();
                }
            }
        });
        Control editorListControl = this.editorList.createControl((Composite)this.listComposite);
        editorListControl.setVisible(false);
        Table editorsTable = (Table)editorListControl;
        TableItem[] items = editorsTable.getItems();
        if (items.length == 0) {
            this.listComposite.dispose();
            return;
        }
        this.listComposite.setContent(editorListControl);
        this.listComposite.pack();
        this.setEditorListBounds(parent);
        this.listComposite.setVisible(true);
        this.listComposite.moveAbove(null);
        editorListControl.setVisible(true);
        editorListControl.setFocus();
        editorsTable.showSelection();
        editorListControl.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                if (TabbedEditorWorkbook.this.listComposite != null) {
                    TabbedEditorWorkbook.this.closeEditorList();
                }
            }
        });
    }

    private void setEditorListBounds(Shell parent) {
        int MAX_ITEMS = 20;
        Rectangle r = this.listComposite.getBounds();
        int width = r.width;
        int height = Math.min(r.height, 20 * ((Table)this.editorList.getControl()).getItemHeight());
        Rectangle bounds = this.tabFolder.getClientArea();
        Point point = new Point(bounds.x + bounds.width - width, bounds.y);
        if (this.tabLocation == 1024) {
            point.y = bounds.y + bounds.height - height - 1;
        }
        point = this.tabFolder.toDisplay(point);
        point = parent.toControl(point);
        this.listComposite.setBounds(this.listComposite.computeTrim(point.x, point.y, width, height));
    }

    public void resizeEditorList() {
        Shell parent = this.getEditorArea().getWorkbenchWindow().getShell();
        this.listComposite.pack();
        this.setEditorListBounds(parent);
    }

    public void showPaneMenu() {
        EditorPane visibleEditor = this.getVisibleEditor();
        if (visibleEditor != null) {
            CTabItem2 item = this.getTab(visibleEditor);
            Rectangle bounds = item.getBounds();
            visibleEditor.showPaneMenu((Control)this.tabFolder, this.tabFolder.toDisplay(new Point(bounds.x, bounds.height)));
        }
    }

    protected void checkEnableDrag() {
        if (this.tabFolder != null && this.tabFolder.getItemCount() == 1) {
            this.enableDrag(this);
        }
    }

    protected void disposePresentation() {
        int i = 0;
        while (i < this.tabFolder.getItemCount()) {
            CTabItem2 tab = this.tabFolder.getItem(i);
            if (tab.getDisabledImage() != null) {
                tab.getDisabledImage().dispose();
            }
            ++i;
        }
        this.tabFolder.dispose();
        this.tabFolder = null;
        this.mouseDownListenerAdded = false;
        this.mapTabToEditor.clear();
    }

    protected void drawGradient(Color fgColor, Color[] bgColors, int[] bgPercents, boolean active) {
        this.tabFolder.setSelectionForeground(fgColor);
        this.tabFolder.setBorderVisible(active);
        if (bgPercents == null) {
            this.tabFolder.setSelectionBackground(bgColors[0]);
        } else {
            this.tabFolder.setSelectionBackground(bgColors, bgPercents);
        }
        this.tabFolder.update();
    }

    public int getMinimumHeight() {
        if (this.tabFolder != null && !this.tabFolder.isDisposed() && this.getItemCount() > 0) {
            return this.tabFolder.computeTrim((int)0, (int)0, (int)0, (int)0).height - 1;
        }
        return super.getMinimumHeight();
    }

    public Control getControl() {
        return this.tabFolder;
    }

    public Control[] getTabList() {
        if (this.tabFolder == null) {
            return new Control[0];
        }
        EditorPane visibleEditor = this.getVisibleEditor();
        if (visibleEditor == null) {
            return new Control[]{this.tabFolder};
        }
        if ((this.tabFolder.getStyle() & 0x80) != 0) {
            return new Control[]{this.tabFolder, visibleEditor.getControl()};
        }
        return new Control[]{visibleEditor.getControl(), this.tabFolder};
    }

    public void showVisibleEditor() {
        if (this.tabFolder != null) {
            this.tabFolder.showSelection();
        }
    }

    protected void disposeItem(EditorPane editorPane) {
        this.removeTab(this.getTab(editorPane));
        if (this.tabFolder.getItemCount() == 0) {
            this.pullDownBar.setVisible(false);
        }
    }

    private void removeTab(CTabItem2 tab) {
        if (this.tabFolder != null && tab != null) {
            this.mapTabToEditor.remove(tab);
            if (tab.getDisabledImage() != null) {
                tab.getDisabledImage().dispose();
            }
            this.assignFocusOnSelection = false;
            tab.dispose();
            this.assignFocusOnSelection = true;
        }
    }

    public void setContainer(ILayoutContainer container) {
        super.setContainer(container);
        if (!this.mouseDownListenerAdded && this.getEditorArea() != null && this.tabFolder != null) {
            this.tabFolder.addListener(3, this.getEditorArea().getMouseDownListener());
            this.mouseDownListenerAdded = true;
        }
    }

    protected void setVisibleItem(EditorPane editorPane) {
        CTabItem2 key = this.getTab(editorPane);
        if (key != null) {
            int index = this.tabFolder.indexOf(key);
            this.tabFolder.setSelection(index);
        }
    }

    public void tabFocusHide() {
        if (!this.ignoreTabFocusHide) {
            super.tabFocusHide();
        }
    }

    protected void updateItem(EditorPane editorPane) {
        Image disableImage;
        CTabItem2 tab = this.getTab(editorPane);
        if (tab == null) {
            return;
        }
        IEditorReference ref = editorPane.getEditorReference();
        String title = ref.getTitle();
        if (ref.isDirty()) {
            title = "*" + title;
        }
        tab.setText(title);
        boolean useColorIcons = ActionContributionItem.getUseColorIconsInToolbars();
        Image image = ref.getTitleImage();
        if (image == null || image.isDisposed()) {
            tab.setImage(null);
            if (!useColorIcons && (disableImage = tab.getDisabledImage()) != null) {
                disableImage.dispose();
                tab.setDisabledImage(null);
            }
        } else if (!image.equals((Object)tab.getImage())) {
            tab.setImage(image);
            if (!useColorIcons) {
                disableImage = tab.getDisabledImage();
                if (disableImage != null) {
                    disableImage.dispose();
                }
                disableImage = new Image((Device)tab.getDisplay(), image, 1);
                tab.setDisabledImage(disableImage);
            }
        }
        String toolTip = ref.getTitleToolTip();
        tab.setToolTipText(toolTip);
        tab.getParent().update();
    }

    protected void disposeAllItems() {
        this.handleTabSelection = false;
        Iterator tabs = this.mapTabToEditor.keySet().iterator();
        while (tabs.hasNext()) {
            CTabItem2 tab = (CTabItem2)tabs.next();
            if (tab.getDisabledImage() != null) {
                tab.getDisabledImage().dispose();
            }
            tab.dispose();
        }
        this.pullDownBar.setVisible(false);
        this.mapTabToEditor.clear();
        this.handleTabSelection = true;
    }

    public void reorderTab(EditorPane pane, int x, int y) {
        int targetIndex;
        CTabItem2 targetTab;
        CTabItem2 sourceTab = this.getTab(pane);
        if (sourceTab == null) {
            return;
        }
        Point location = new Point(1, 1);
        if ((this.tabFolder.getStyle() & 0x400) != 0) {
            location.y = this.tabFolder.getSize().y - 4;
        }
        if (x > location.x) {
            location.x = x;
        }
        if ((targetTab = this.tabFolder.getItem(location)) == null) {
            if (this.tabFolder.indexOf(sourceTab) != this.tabFolder.getItemCount() - 1) {
                this.reorderTab(pane, sourceTab, -1);
            }
            return;
        }
        if (targetTab == sourceTab) {
            return;
        }
        int sourceIndex = this.tabFolder.indexOf(sourceTab);
        if (sourceIndex == (targetIndex = this.tabFolder.indexOf(targetTab)) - 1) {
            return;
        }
        if (sourceIndex < targetIndex) {
            --targetIndex;
        }
        this.reorderTab(pane, sourceTab, targetIndex);
    }

    public void reorderTab(EditorPane pane, int newIndex) {
        this.reorderTab(pane, this.getTab(pane), newIndex);
    }

    private void reorderTab(EditorPane pane, CTabItem2 sourceTab, int newIndex) {
        int oldIndex = this.tabFolder.indexOf(sourceTab);
        if (newIndex < 0) {
            if (oldIndex == this.tabFolder.getItemCount() - 1) {
                return;
            }
            if (oldIndex == newIndex) {
                return;
            }
        }
        boolean wasVisible = this.tabFolder.getSelection() == sourceTab;
        this.disableDrag(pane);
        this.removeTab(sourceTab);
        CTabItem2 newTab = newIndex < 0 ? this.createTab(pane) : this.createTab(pane, newIndex);
        CTabPartDragDrop partDragDrop = (CTabPartDragDrop)this.getDragSource(pane);
        partDragDrop.setTab(newTab);
        List editors = this.getEditorList();
        editors.remove(pane);
        if (newIndex < 0) {
            editors.add(pane);
        } else {
            editors.add(newIndex, pane);
        }
        if (wasVisible) {
            this.tabFolder.setSelection(newTab);
            this.setVisibleEditor(pane);
        }
    }

    protected PartDragDrop createDragSource(IWorkbenchDragSource dragSource) {
        if (dragSource.getType() != 2) {
            return null;
        }
        return new CTabPartDragDrop(dragSource, this.tabFolder, this.getTab(dragSource.getPart()));
    }
}

