/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.internal.IWorkbenchDragSource;
import org.eclipse.ui.internal.PartDragDrop;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;

public class ShortcutBarPartDragDrop
extends PartDragDrop {
    private ToolItem draggedItem;

    public ShortcutBarPartDragDrop(IWorkbenchDragSource itemPart, Control shortcutBar) {
        super(itemPart, shortcutBar);
    }

    protected void isDragAllowed(Point position) {
        ToolBar toolBar = this.getToolBar();
        this.draggedItem = toolBar.getItem(position);
        if (this.draggedItem == null) {
            return;
        }
        if (this.draggedItem.getData("FastView") == null) {
            return;
        }
        super.isDragAllowed(position);
    }

    private ToolBar getToolBar() {
        return (ToolBar)this.getDragControl();
    }

    ToolItem getDraggedItem() {
        return this.draggedItem;
    }

    protected Rectangle getSourceBounds() {
        IViewReference ref = (IViewReference)this.draggedItem.getData("FastView");
        WorkbenchPage page = (WorkbenchPage)ref.getPage();
        Perspective persp = page.getActivePerspective();
        Rectangle rect = persp.getFastViewBounds(ref);
        return rect;
    }

    protected boolean hasMovedEnough(MouseEvent e) {
        ToolItem currentItem = this.getToolBar().getItem(new Point(e.x, e.y));
        return super.hasMovedEnough(e) && currentItem != this.draggedItem;
    }
}

