/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class SetPagePerspectiveAction
extends Action {
    private WorkbenchPage page;
    private IPerspectiveDescriptor persp;

    public SetPagePerspectiveAction(IPerspectiveDescriptor perspective, WorkbenchPage workbenchPage) {
        super(WorkbenchMessages.getString("SetPagePerspectiveAction.text"));
        this.setChecked(false);
        this.persp = perspective;
        this.page = workbenchPage;
        this.update(this.persp);
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.switch_to_perspective_action_context");
    }

    WorkbenchPage getPage() {
        return this.page;
    }

    IPerspectiveDescriptor getPerspective() {
        return this.persp;
    }

    public boolean handles(IPerspectiveDescriptor perspective, WorkbenchPage workbenchPage) {
        return this.persp == perspective && this.page == workbenchPage;
    }

    public void setPerspective(IPerspectiveDescriptor newPerspective) {
        this.persp = newPerspective;
    }

    public void run() {
        this.page.setPerspective(this.persp);
        this.setChecked(this.page.getPerspective() == this.persp);
    }

    public void update(IPerspectiveDescriptor newDesc) {
        this.persp = newDesc;
        this.setToolTipText(WorkbenchMessages.format("SetPagePerspectiveAction.toolTip", new Object[]{this.persp.getLabel()}));
        ImageDescriptor image = this.persp.getImageDescriptor();
        ImageDescriptor mainImage = this.adjustMainImage(this.persp.getImageDescriptor());
        if (image != null) {
            this.setImageDescriptor(mainImage);
            this.setHoverImageDescriptor(null);
        } else {
            this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_DEF_PERSPECTIVE"));
            this.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_DEF_PERSPECTIVE_HOVER"));
        }
        this.setText(this.persp.getLabel());
    }

    public boolean showTextInToolBar() {
        return true;
    }

    private ImageDescriptor adjustMainImage(ImageDescriptor start) {
        return start;
    }

    private class ResizedDescriptor
    extends ImageDescriptor {
        ImageData cachedData;

        ResizedDescriptor(ImageData data) {
            this.cachedData = data;
        }

        public ImageData getImageData() {
            return this.cachedData;
        }
    }
}

