/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.PageEventAction;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;

public class SaveAllAction
extends PageEventAction
implements IPropertyListener {
    private List partsWithListeners = new ArrayList(1);

    public SaveAllAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("SaveAll.text"), window);
        this.setToolTipText(WorkbenchMessages.getString("SaveAll.toolTip"));
        this.setId("saveAll");
        this.setEnabled(false);
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.save_all_action_context");
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_SAVEALL_EDIT"));
        this.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_SAVEALL_EDIT_HOVER"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_SAVEALL_EDIT_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.file.saveAll");
    }

    public void pageActivated(IWorkbenchPage page) {
        super.pageActivated(page);
        this.updateState();
    }

    public void pageClosed(IWorkbenchPage page) {
        super.pageClosed(page);
        this.updateState();
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        if (part instanceof IEditorPart) {
            part.removePropertyListener(this);
            this.partsWithListeners.remove(part);
            this.updateState();
        }
    }

    public void partOpened(IWorkbenchPart part) {
        super.partOpened(part);
        if (part instanceof IEditorPart) {
            part.addPropertyListener(this);
            this.partsWithListeners.add(part);
            this.updateState();
        }
    }

    public void propertyChanged(Object source, int propID) {
        if (source instanceof IEditorPart && propID == 257) {
            this.updateState();
        }
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            page.saveAllEditors(false);
        }
    }

    protected void updateState() {
        IWorkbenchPage page = this.getActivePage();
        this.setEnabled(page != null && page.getDirtyEditors().length > 0);
    }

    public void dispose() {
        super.dispose();
        Iterator it = this.partsWithListeners.iterator();
        while (it.hasNext()) {
            IWorkbenchPart part = (IWorkbenchPart)it.next();
            part.removePropertyListener(this);
        }
        this.partsWithListeners.clear();
    }
}

