/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.DetachedPlaceHolder;
import org.eclipse.ui.internal.DetachedWindow;
import org.eclipse.ui.internal.EditorArea;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorWorkbook;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.IPartDropListener;
import org.eclipse.ui.internal.IWorkbenchDragDropPart;
import org.eclipse.ui.internal.IWorkbenchDragSource;
import org.eclipse.ui.internal.IWorkbenchDropTarget;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.PartDragDrop;
import org.eclipse.ui.internal.PartDropEvent;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartTabFolder;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.RootLayoutContainer;
import org.eclipse.ui.internal.ShortcutBarPart;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchWindow;

public class PerspectivePresentation {
    private WorkbenchPage page;
    private Composite parentWidget;
    private RootLayoutContainer mainLayout;
    private IWorkbenchPartReference zoomPart;
    private ArrayList detachedWindowList = new ArrayList(1);
    private ArrayList detachedPlaceHolderList = new ArrayList(1);
    private boolean detachable = false;
    private boolean active = false;
    private boolean wasFastViewActive = false;
    private Map dragParts = new HashMap();
    private IPartDropListener partDropListener;
    private static final int MIN_DETACH_WIDTH = 150;
    private static final int MIN_DETACH_HEIGHT = 250;

    public PerspectivePresentation(WorkbenchPage workbenchPage, RootLayoutContainer mainLayout) {
        this.page = workbenchPage;
        this.mainLayout = mainLayout;
        this.detachable = false;
        Composite client = workbenchPage.getClientComposite();
        if (client != null) {
            Composite testChild = new Composite(client, 0);
            this.detachable = testChild.isReparentable();
            testChild.dispose();
        }
        this.partDropListener = new IPartDropListener(){

            public void dragOver(PartDropEvent e) {
                PerspectivePresentation.this.onPartDragOver(e);
            }

            public void drop(PartDropEvent e) {
                PerspectivePresentation.this.onPartDrop(e);
            }
        };
    }

    public void activate(Composite parent) {
        if (this.active) {
            return;
        }
        this.parentWidget = parent;
        Vector children = new Vector();
        this.collectViewPanes(children, this.mainLayout.getChildren());
        Enumeration enumeration = children.elements();
        while (enumeration.hasMoreElements()) {
            LayoutPart part = (LayoutPart)enumeration.nextElement();
            part.reparent(parent);
        }
        this.mainLayout.createControl(parent);
        int i = 0;
        int length = this.detachedWindowList.size();
        while (i < length) {
            DetachedWindow dwindow = (DetachedWindow)((Object)this.detachedWindowList.get(i));
            dwindow.open();
            ++i;
        }
        this.enableAllDrag();
        this.enableAllDrop();
        this.active = true;
    }

    public void addPart(LayoutPart part) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        LayoutPart placeholder = null;
        LayoutPart testPart = this.findPart(part.getID());
        if (testPart != null && testPart instanceof PartPlaceholder) {
            placeholder = (PartPlaceholder)testPart;
        }
        if (placeholder == null) {
            part.reparent(this.mainLayout.getParent());
            LayoutPart relative = this.mainLayout.findBottomRight();
            if (relative != null && !(relative instanceof EditorArea)) {
                this.stack(part, relative);
            } else {
                this.mainLayout.add(part);
            }
        } else {
            ILayoutContainer container = placeholder.getContainer();
            if (container != null) {
                if (container instanceof DetachedPlaceHolder) {
                    DetachedPlaceHolder holder = (DetachedPlaceHolder)container;
                    this.detachedPlaceHolderList.remove(holder);
                    container.remove(testPart);
                    DetachedWindow window = new DetachedWindow(this.page);
                    this.detachedWindowList.add(window);
                    window.create();
                    part.createControl((Composite)window.getShell());
                    window.getShell().setBounds(holder.getBounds());
                    window.open();
                    ViewPane pane = (ViewPane)part;
                    window.getShell().setText(pane.getPartReference().getTitle());
                    window.add(pane, this.partDropListener);
                    LayoutPart[] otherChildren = holder.getChildren();
                    int i = 0;
                    while (i < otherChildren.length) {
                        part.getContainer().add(otherChildren[i]);
                        ++i;
                    }
                } else {
                    if (container instanceof ContainerPlaceholder) {
                        ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)container;
                        ILayoutContainer parentContainer = containerPlaceholder.getContainer();
                        container = (ILayoutContainer)((Object)containerPlaceholder.getRealContainer());
                        if (container instanceof LayoutPart) {
                            parentContainer.replace(containerPlaceholder, (LayoutPart)((Object)container));
                        }
                        containerPlaceholder.setRealContainer(null);
                    }
                    if (container instanceof PartTabFolder) {
                        PartTabFolder folder = (PartTabFolder)container;
                        part.reparent(folder.getControl().getParent());
                    } else {
                        part.reparent(this.mainLayout.getParent());
                    }
                    container.replace(placeholder, part);
                }
            }
        }
        if (part instanceof ViewPane) {
            this.enableDrag((ViewPane)part);
        }
        this.enableDrop(part);
    }

    public boolean canDetach() {
        return this.detachable;
    }

    public boolean bringPartToTop(LayoutPart part) {
        ILayoutContainer container = part.getContainer();
        if (container != null && container instanceof PartTabFolder) {
            PartTabFolder folder = (PartTabFolder)container;
            int nIndex = folder.indexOf(part);
            if (folder.getSelection() != nIndex) {
                folder.setSelection(nIndex);
                return true;
            }
        }
        return false;
    }

    public boolean isPartVisible(String partId) {
        LayoutPart part = this.findPart(partId);
        if (part == null) {
            return false;
        }
        if (part instanceof PartPlaceholder) {
            return false;
        }
        ILayoutContainer container = part.getContainer();
        if (container != null && container instanceof ContainerPlaceholder) {
            return false;
        }
        if (container != null && container instanceof PartTabFolder) {
            PartTabFolder folder = (PartTabFolder)container;
            if (folder.getVisiblePart() == null) {
                return false;
            }
            return part.getID().equals(folder.getVisiblePart().getID());
        }
        return true;
    }

    public boolean willPartBeVisible(String partId) {
        LayoutPart part = this.findPart(partId);
        if (part == null) {
            return false;
        }
        ILayoutContainer container = part.getContainer();
        if (container != null && container instanceof ContainerPlaceholder) {
            container = (ILayoutContainer)((Object)((ContainerPlaceholder)container).getRealContainer());
        }
        if (container != null && container instanceof PartTabFolder) {
            PartTabFolder folder = (PartTabFolder)container;
            if (folder.getVisiblePart() == null) {
                return false;
            }
            return part.getID().equals(folder.getVisiblePart().getID());
        }
        return true;
    }

    private DetachedWindow[] collectDetachedWindows(Window[] windows) {
        DetachedWindow[] result = new DetachedWindow[]{};
        int i = 0;
        int length = windows.length;
        while (i < length) {
            if (windows[i] instanceof DetachedWindow && ((DetachedWindow)windows[i]).belongsToWorkbenchPage(this.page)) {
                DetachedWindow[] newResult = new DetachedWindow[result.length + 1];
                System.arraycopy(result, 0, newResult, 0, result.length);
                newResult[result.length] = (DetachedWindow)windows[i];
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    public void openTracker(ViewPane pane) {
        PartDragDrop dnd = (PartDragDrop)this.dragParts.get(pane);
        dnd.openTracker();
    }

    private void collectDragParts(List result, LayoutPart[] parts) {
        int i = 0;
        int length = parts.length;
        while (i < length) {
            LayoutPart part = parts[i];
            if (part instanceof ViewPane) {
                result.add(part);
            } else if (part instanceof ILayoutContainer) {
                this.collectDragParts(result, ((ILayoutContainer)((Object)part)).getChildren());
            }
            ++i;
        }
    }

    private PartPlaceholder[] collectPlaceholders() {
        PartPlaceholder[] results = this.collectPlaceholders(this.mainLayout.getChildren());
        if (this.detachable) {
            int i = 0;
            int length = this.detachedWindowList.size();
            while (i < length) {
                DetachedWindow win = (DetachedWindow)((Object)this.detachedWindowList.get(i));
                PartPlaceholder[] moreResults = this.collectPlaceholders(win.getChildren());
                if (moreResults.length > 0) {
                    int newLength = results.length + moreResults.length;
                    PartPlaceholder[] newResults = new PartPlaceholder[newLength];
                    System.arraycopy(results, 0, newResults, 0, results.length);
                    System.arraycopy(moreResults, 0, newResults, results.length, moreResults.length);
                    results = newResults;
                }
                ++i;
            }
        }
        return results;
    }

    private PartPlaceholder[] collectPlaceholders(LayoutPart[] parts) {
        PartPlaceholder[] result = new PartPlaceholder[]{};
        int i = 0;
        int length = parts.length;
        while (i < length) {
            LayoutPart part = parts[i];
            if (part instanceof ILayoutContainer) {
                PartPlaceholder[] newParts = this.collectPlaceholders(((ILayoutContainer)((Object)part)).getChildren());
                PartPlaceholder[] newResult = new PartPlaceholder[result.length + newParts.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(newParts, 0, newResult, result.length, newParts.length);
                result = newResult;
            } else if (part instanceof PartPlaceholder) {
                PartPlaceholder[] newResult = new PartPlaceholder[result.length + 1];
                System.arraycopy(result, 0, newResult, 0, result.length);
                newResult[result.length] = (PartPlaceholder)part;
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    public void collectViewPanes(List result) {
        this.collectViewPanes(result, this.mainLayout.getChildren());
        if (this.detachable) {
            int i = 0;
            int length = this.detachedWindowList.size();
            while (i < length) {
                DetachedWindow win = (DetachedWindow)((Object)this.detachedWindowList.get(i));
                this.collectViewPanes(result, win.getChildren());
                ++i;
            }
        }
    }

    private void collectViewPanes(List result, LayoutPart[] parts) {
        int i = 0;
        int length = parts.length;
        while (i < length) {
            LayoutPart part = parts[i];
            if (part instanceof ViewPane) {
                result.add(part);
            } else if (part instanceof ILayoutContainer) {
                this.collectViewPanes(result, ((ILayoutContainer)((Object)part)).getChildren());
            }
            ++i;
        }
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.disableAllDrag();
        Composite parent = this.mainLayout.getParent();
        Vector children = new Vector();
        this.collectViewPanes(children, this.mainLayout.getChildren());
        int i = 0;
        int length = this.detachedWindowList.size();
        while (i < length) {
            DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i));
            this.collectViewPanes(children, window.getChildren());
            ++i;
        }
        Enumeration enumeration = children.elements();
        while (enumeration.hasMoreElements()) {
            LayoutPart part = (LayoutPart)enumeration.nextElement();
            part.reparent(parent);
        }
        this.mainLayout.dispose();
        int i2 = 0;
        int length2 = this.detachedWindowList.size();
        while (i2 < length2) {
            DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i2));
            window.close();
            ++i2;
        }
        this.active = false;
    }

    private void derefPart(LayoutPart part) {
        Window oldWindow = part.getWindow();
        ILayoutContainer oldContainer = part.getContainer();
        part.reparent(this.mainLayout.getParent());
        if (oldContainer == null) {
            return;
        }
        oldContainer.remove(part);
        this.updateContainerVisibleTab(oldContainer);
        LayoutPart[] children = oldContainer.getChildren();
        if (oldWindow instanceof WorkbenchWindow) {
            LayoutPart parent;
            ILayoutContainer parentContainer;
            boolean hasChildren;
            boolean bl = hasChildren = children != null && children.length > 0;
            if (hasChildren) {
                int childVisible = 0;
                int i = 0;
                while (i < children.length) {
                    if (children[i].getControl() != null) {
                        ++childVisible;
                    }
                    ++i;
                }
                if (oldContainer instanceof PartTabFolder) {
                    PartTabFolder folder = (PartTabFolder)oldContainer;
                    if (childVisible == 0) {
                        ILayoutContainer parentContainer2 = folder.getContainer();
                        int i2 = 0;
                        while (i2 < children.length) {
                            folder.remove(children[i2]);
                            parentContainer2.add(children[i2]);
                            ++i2;
                        }
                        hasChildren = false;
                    } else if (childVisible == 1) {
                        LayoutTree layout = this.mainLayout.getLayoutTree();
                        layout = layout.find(folder);
                        layout.setBounds(layout.getBounds());
                    }
                }
            }
            if (!hasChildren && oldContainer instanceof LayoutPart && (parentContainer = (parent = (LayoutPart)((Object)oldContainer)).getContainer()) != null) {
                parentContainer.remove(parent);
                parent.dispose();
            }
        } else if (oldWindow instanceof DetachedWindow) {
            if (children == null || children.length == 0) {
                oldWindow.getShell().setRedraw(true);
                oldWindow.close();
                this.detachedWindowList.remove(oldWindow);
            } else {
                boolean allInvisible = true;
                int i = 0;
                int length = children.length;
                while (i < length) {
                    if (!(children[i] instanceof PartPlaceholder)) {
                        allInvisible = false;
                        break;
                    }
                    ++i;
                }
                if (allInvisible) {
                    DetachedPlaceHolder placeholder = new DetachedPlaceHolder("", oldWindow.getShell().getBounds());
                    int i3 = 0;
                    int length2 = children.length;
                    while (i3 < length2) {
                        oldContainer.remove(children[i3]);
                        children[i3].setContainer(placeholder);
                        placeholder.add(children[i3]);
                        ++i3;
                    }
                    this.detachedPlaceHolderList.add(placeholder);
                    oldWindow.close();
                    this.detachedWindowList.remove(oldWindow);
                }
            }
        }
    }

    private void detach(IWorkbenchDragSource source, int x, int y) {
        ILayoutContainer container;
        if (!this.detachable) {
            return;
        }
        LayoutPart part = source.getPart();
        Point size = part.getSize();
        if ((size.x == 0 || size.y == 0) && (container = part.getContainer()) instanceof LayoutPart) {
            size = ((LayoutPart)((Object)container)).getSize();
        }
        int width = Math.max(size.x, 150);
        int height = Math.max(size.y, 250);
        DetachedWindow window = new DetachedWindow(this.page);
        this.detachedWindowList.add(window);
        window.create();
        window.getShell().setBounds(x, y, width, height);
        window.open();
        if (part instanceof PartTabFolder) {
            window.getShell().setRedraw(false);
            this.parentWidget.setRedraw(false);
            LayoutPart visiblePart = ((PartTabFolder)part).getVisiblePart();
            LayoutPart[] children = ((PartTabFolder)part).getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof ViewPane) {
                    this.derefPart(children[i]);
                    ViewPane pane = (ViewPane)children[i];
                    window.getShell().setText(pane.getPartReference().getTitle());
                    window.add(pane, this.partDropListener);
                }
                ++i;
            }
            if (visiblePart != null) {
                this.bringPartToTop(visiblePart);
                visiblePart.setFocus();
            }
            window.getShell().setRedraw(true);
            this.parentWidget.setRedraw(true);
        } else {
            this.derefPart(part);
            ViewPane pane = (ViewPane)part;
            window.getShell().setText(pane.getPartReference().getTitle());
            window.add(pane, this.partDropListener);
            part.setFocus();
        }
    }

    public void addDetachedPart(LayoutPart part) {
        if (!this.detachable) {
            this.addPart(part);
            return;
        }
        int width = 300;
        int height = 300;
        Rectangle bounds = this.parentWidget.getShell().getBounds();
        int x = bounds.x + (bounds.width - width) / 2;
        int y = bounds.y + (bounds.height - height) / 2;
        DetachedWindow window = new DetachedWindow(this.page);
        this.detachedWindowList.add(window);
        window.create();
        part.createControl((Composite)window.getShell());
        ViewPane pane = (ViewPane)part;
        window.getShell().setText(pane.getPartReference().getTitle());
        window.add(pane, this.partDropListener);
        window.getShell().setBounds(x, y, width, height);
        window.open();
        part.setFocus();
        this.enableDrag(pane);
        this.enableDrop(part);
    }

    private void disableAllDrag() {
        Iterator iterator = this.dragParts.values().iterator();
        while (iterator.hasNext()) {
            PartDragDrop part = (PartDragDrop)iterator.next();
            ILayoutContainer container = part.getSourcePart().getContainer();
            if (container instanceof PartTabFolder) {
                ((PartTabFolder)container).disableDrag(part.getSourcePart());
            }
            part.dispose();
        }
        this.dragParts.clear();
    }

    void disableDrag(ViewPane part) {
        ILayoutContainer container;
        if (this.dragParts.containsKey(part)) {
            PartDragDrop partDragDrop = (PartDragDrop)this.dragParts.get(part);
            partDragDrop.dispose();
            this.dragParts.remove(part);
        }
        if ((container = part.getContainer()) instanceof PartTabFolder) {
            ((PartTabFolder)container).disableDrag(part);
        }
    }

    public void disposeSashes() {
        this.mainLayout.disposeSashes();
    }

    private void enableAllDrag() {
        Vector draggableParts = new Vector();
        this.collectDragParts(draggableParts, this.mainLayout.getChildren());
        int i = 0;
        int length = this.detachedWindowList.size();
        while (i < length) {
            DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i));
            this.collectDragParts(draggableParts, window.getChildren());
            ++i;
        }
        Enumeration enumeration = draggableParts.elements();
        while (enumeration.hasMoreElements()) {
            IWorkbenchDragSource part = (IWorkbenchDragSource)enumeration.nextElement();
            if (part.getType() != 1) continue;
            this.enableDrag(part);
        }
    }

    private void enableAllDrop() {
        Vector dropTargets = new Vector();
        this.collectDropTargets(dropTargets, this.mainLayout.getChildren());
        int i = 0;
        int length = this.detachedWindowList.size();
        while (i < length) {
            DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i));
            this.collectDropTargets(dropTargets, window.getChildren());
            ++i;
        }
        Enumeration enumeration = dropTargets.elements();
        while (enumeration.hasMoreElements()) {
            LayoutPart part = (LayoutPart)enumeration.nextElement();
            this.enableDrop(part);
        }
    }

    void enableDrag(IWorkbenchDragSource part) {
        ILayoutContainer container;
        Control control = part.getControl();
        if (control != null) {
            PartDragDrop dragSource = new PartDragDrop(part, control);
            dragSource.addDropListener(this.partDropListener);
            this.dragParts.put(part, dragSource);
        }
        if ((container = part.getContainer()) instanceof PartTabFolder) {
            ((PartTabFolder)container).enableDrag(part, this.partDropListener);
        }
    }

    private void enableDrop(LayoutPart part) {
        Control control = part.getControl();
        if (control != null) {
            control.setData((Object)part);
        }
    }

    private LayoutPart findPart(String id) {
        LayoutPart part = this.findPart(id, this.mainLayout.getChildren());
        if (part != null) {
            return part;
        }
        int i = 0;
        int length = this.detachedWindowList.size();
        while (i < length) {
            DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i));
            part = this.findPart(id, window.getChildren());
            if (part != null) {
                return part;
            }
            ++i;
        }
        i = 0;
        while (i < this.detachedPlaceHolderList.size()) {
            DetachedPlaceHolder holder = (DetachedPlaceHolder)this.detachedPlaceHolderList.get(i);
            part = this.findPart(id, holder.getChildren());
            if (part != null) {
                return part;
            }
            ++i;
        }
        return null;
    }

    private LayoutPart findPart(String id, LayoutPart[] parts) {
        int i = 0;
        int length = parts.length;
        while (i < length) {
            LayoutPart part = parts[i];
            if (part.getID().equals(id)) {
                return part;
            }
            if (!(part instanceof EditorArea) && part instanceof ILayoutContainer && (part = this.findPart(id, ((ILayoutContainer)((Object)part)).getChildren())) != null) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public boolean hasPlaceholder(String id) {
        LayoutPart testPart = this.findPart(id);
        return testPart != null && testPart instanceof PartPlaceholder;
    }

    public RootLayoutContainer getLayout() {
        return this.mainLayout;
    }

    public boolean isActive() {
        return this.active;
    }

    private boolean isFastView(IWorkbenchPartReference ref) {
        if (ref instanceof IViewReference) {
            WorkbenchPage page = (WorkbenchPage)ref.getPage();
            return page.isFastView((IViewReference)ref);
        }
        return false;
    }

    public boolean isZoomed() {
        return this.zoomPart != null;
    }

    private void makeFast(IWorkbenchDragSource source) {
        LayoutPart part = source.getPart();
        if (part instanceof PartTabFolder) {
            LayoutPart[] children = ((PartTabFolder)part).getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof ViewPane) {
                    this.page.addFastView(((ViewPane)children[i]).getViewReference());
                }
                ++i;
            }
        } else {
            this.page.addFastView(((ViewPane)part).getViewReference());
        }
    }

    private void movePart(IWorkbenchDragDropPart source, int position, IWorkbenchDragDropPart relative) {
        LayoutPart part = source.getPart();
        LayoutPart relativePart = relative.getPart();
        ILayoutContainer newContainer = relativePart.getContainer();
        if (newContainer instanceof RootLayoutContainer) {
            Window window;
            RootLayoutContainer sashContainer = (RootLayoutContainer)newContainer;
            int relativePosition = 1;
            if (position == 2) {
                relativePosition = 2;
            } else if (position == 3) {
                relativePosition = 3;
            } else if (position == 4) {
                relativePosition = 4;
            }
            if (part instanceof PartTabFolder && (window = part.getWindow()) instanceof DetachedWindow) {
                window.getShell().setRedraw(false);
                this.parentWidget.setRedraw(false);
                LayoutPart visiblePart = ((PartTabFolder)part).getVisiblePart();
                PartTabFolder folder = new PartTabFolder();
                sashContainer.add(folder, relativePosition, 0.5f, relativePart);
                LayoutPart[] children = ((PartTabFolder)part).getChildren();
                int i = 0;
                while (i < children.length) {
                    this.derefPart(children[i]);
                    folder.add(children[i]);
                    if (children[i] instanceof ViewPane) {
                        folder.enableDrag((ViewPane)children[i], this.partDropListener);
                    }
                    ++i;
                }
                if (visiblePart != null) {
                    this.bringPartToTop(visiblePart);
                    visiblePart.setFocus();
                }
                this.parentWidget.setRedraw(true);
                return;
            }
            ILayoutContainer oldContainer = part.getContainer();
            if (oldContainer != sashContainer) {
                this.derefPart(part);
                PartTabFolder folder = new PartTabFolder();
                sashContainer.add(folder, relativePosition, 0.5f, relativePart);
                folder.add(part);
                folder.enableDrag((ViewPane)part, this.partDropListener);
            } else {
                sashContainer.move(part, relativePosition, relativePart);
            }
            part.setFocus();
        } else if (newContainer instanceof PartTabFolder) {
            this.movePart(part, position, (PartTabFolder)newContainer);
        }
    }

    void onPartDragOver(PartDropEvent e) {
        Window window;
        Perspective persp = this.page.getActivePerspective();
        if (persp.getActiveFastView() != null) {
            if (e.dragSource instanceof ViewPane) {
                IViewReference ref = (IViewReference)((ViewPane)e.dragSource).getPartReference();
                if (ref == persp.getActiveFastView()) {
                    persp.setActiveFastView(null, 0);
                }
            } else if (e.dragSource instanceof ShortcutBarPart && persp.getActiveFastView() != null) {
                WorkbenchWindow window2 = (WorkbenchWindow)this.page.getWorkbenchWindow();
                ToolItem icon = window2.getFastViewDND().getDraggedItem();
                IViewReference ref = (IViewReference)icon.getData("FastView");
                if (ref == persp.getActiveFastView()) {
                    persp.setActiveFastView(null, 0);
                } else {
                    persp.setActiveFastView(null);
                }
                this.wasFastViewActive = true;
            }
        }
        if (e.dragSource instanceof ShortcutBarPart) {
            this.onFastViewIconDrag(e);
            return;
        }
        int offScreenPosition = 6;
        if (!this.detachable) {
            offScreenPosition = 0;
        }
        if (e.dragSource != null && e.dropTarget != null && e.dragSource.getWorkbenchWindow() != e.dropTarget.getWorkbenchWindow()) {
            e.dropTarget = null;
            e.relativePosition = offScreenPosition;
            return;
        }
        if (e.dropTarget instanceof ShortcutBarPart) {
            IViewReference ref;
            if (e.dragSource instanceof ViewPane && this.isFastView(ref = (IViewReference)((ViewPane)e.dragSource).getPartReference())) {
                e.dropTarget = null;
                e.relativePosition = 0;
                return;
            }
            e.relativePosition = 5;
            return;
        }
        if (e.dropTarget instanceof EditorArea) {
            if (e.relativePosition == 5) {
                e.dropTarget = null;
                e.relativePosition = offScreenPosition;
                return;
            }
            return;
        }
        if (e.relativePosition == 6) {
            if (!this.detachable) {
                e.relativePosition = 0;
                return;
            }
            window = e.dragSource.getWindow();
            if (window instanceof DetachedWindow) {
                if (e.dragSource instanceof PartTabFolder) {
                    e.relativePosition = 0;
                    return;
                }
                ILayoutContainer container = e.dragSource.getContainer();
                if (container instanceof PartTabFolder && ((PartTabFolder)container).getItemCount() == 1) {
                    e.relativePosition = 0;
                    return;
                }
            }
            return;
        }
        if (e.dropTarget == null && e.relativePosition != 6) {
            e.dropTarget = null;
            e.relativePosition = offScreenPosition;
            return;
        }
        if (!(e.dropTarget instanceof ViewPane) && !(e.dropTarget instanceof PartTabFolder)) {
            e.dropTarget = null;
            e.relativePosition = offScreenPosition;
            return;
        }
        if (e.dragSource instanceof ViewPane) {
            if (e.dragSource == e.dropTarget) {
                if (e.relativePosition == 5) {
                    e.dropTarget = null;
                    e.relativePosition = 0;
                    return;
                }
                ILayoutContainer container = e.dragSource.getContainer();
                if (!(container instanceof PartTabFolder)) {
                    e.dropTarget = null;
                    e.relativePosition = 0;
                    return;
                }
                if (((PartTabFolder)container).getItemCount() == 1) {
                    e.dropTarget = null;
                    e.relativePosition = 0;
                    return;
                }
            }
            if (e.dragSource.getContainer() == e.dropTarget && ((PartTabFolder)e.dropTarget).getItemCount() == 1) {
                e.dropTarget = null;
                e.relativePosition = 0;
                return;
            }
            window = e.dropTarget.getWindow();
            if (window instanceof DetachedWindow) {
                e.relativePosition = 5;
                return;
            }
            return;
        }
        if (e.dragSource instanceof PartTabFolder) {
            if (e.dragSource == e.dropTarget) {
                e.dropTarget = null;
                e.relativePosition = 0;
                return;
            }
            if (e.dropTarget instanceof ViewPane && e.dropTarget.getContainer() == e.dragSource) {
                e.dropTarget = null;
                e.relativePosition = 0;
                return;
            }
            window = e.dropTarget.getWindow();
            if (window instanceof DetachedWindow) {
                e.relativePosition = 5;
                return;
            }
            return;
        }
        e.dropTarget = null;
        e.relativePosition = offScreenPosition;
    }

    private void onFastViewIconDrag(PartDropEvent e) {
        if (!(e.dropTarget instanceof ViewPane || e.dropTarget instanceof PartTabFolder || e.dropTarget instanceof EditorArea || e.dropTarget instanceof ShortcutBarPart)) {
            e.dropTarget = null;
            e.relativePosition = 0;
        }
        if (e.dropTarget instanceof EditorArea && e.relativePosition == 5) {
            e.dropTarget = null;
            e.relativePosition = 0;
        }
        if (e.dropTarget instanceof ShortcutBarPart && e.relativePosition != 5) {
            e.dropTarget = null;
            e.relativePosition = 0;
        }
    }

    void onPartDrop(PartDropEvent e) {
        Object window;
        IViewReference ref;
        if (e.relativePosition == 0) {
            WorkbenchWindow window2;
            ToolItem icon;
            IViewReference ref2;
            Perspective persp = this.page.getActivePerspective();
            if (e.dragSource instanceof ViewPane) {
                IViewReference ref3 = (IViewReference)((ViewPane)e.dragSource).getPartReference();
                if (this.isFastView(ref3)) {
                    persp.setActiveFastView(ref3);
                }
            } else if (e.dragSource instanceof ShortcutBarPart && (ref2 = (IViewReference)(icon = (window2 = (WorkbenchWindow)this.page.getWorkbenchWindow()).getFastViewDND().getDraggedItem()).getData("FastView")) == persp.getPreviousActiveFastView() && this.wasFastViewActive) {
                persp.setActiveFastView(ref2);
            }
            this.wasFastViewActive = false;
            return;
        }
        this.wasFastViewActive = false;
        if (e.dragSource instanceof ViewPane && this.isFastView(ref = (IViewReference)((ViewPane)e.dragSource).getPartReference())) {
            this.page.removeFastView(ref);
        }
        if (e.dragSource instanceof ShortcutBarPart && !(e.dropTarget instanceof ShortcutBarPart)) {
            window = (WorkbenchWindow)this.page.getWorkbenchWindow();
            ToolItem icon = ((WorkbenchWindow)window).getFastViewDND().getDraggedItem();
            IViewReference ref4 = (IViewReference)icon.getData("FastView");
            if (ref4.getPart(true) == null) {
                return;
            }
            e.dragSource = ((WorkbenchPartReference)((Object)ref4)).getPane();
            this.page.removeFastView(ref4);
        }
        switch (e.relativePosition) {
            case 6: {
                window = e.dragSource.getWindow();
                if (window instanceof DetachedWindow) {
                    if (e.dragSource instanceof PartTabFolder) {
                        window.getShell().setLocation(e.x, e.y);
                        break;
                    }
                    ILayoutContainer container = e.dragSource.getContainer();
                    if (container instanceof PartTabFolder && ((PartTabFolder)container).getItemCount() == 1) {
                        window.getShell().setLocation(e.x, e.y);
                        break;
                    }
                }
                if (this.isZoomed()) {
                    this.zoomOut();
                }
                this.detach(e.dragSource, e.x, e.y);
                break;
            }
            case 5: {
                if (this.isZoomed()) {
                    this.zoomOut();
                }
                if (e.dropTarget instanceof ShortcutBarPart) {
                    if (e.dragSource instanceof ShortcutBarPart) {
                        this.moveFastView((ShortcutBarPart)e.dragSource, new Point(e.cursorX, e.cursorY));
                        break;
                    }
                    this.makeFast(e.dragSource);
                    if (!(e.dragSource instanceof ViewPane)) break;
                    ViewPane pane = (ViewPane)e.dragSource;
                    Point point = pane.getControl().toDisplay(new Point(e.cursorX, e.cursorY));
                    Point destination = ((ShortcutBarPart)e.dropTarget).getControl().toControl(point);
                    this.reorderFastViews((ShortcutBarPart)e.dropTarget, ((ViewPane)e.dragSource).getViewReference(), destination);
                    break;
                }
                if (e.dragSource instanceof ViewPane && e.dropTarget instanceof PartTabFolder && e.dragSource.getContainer() == e.dropTarget) {
                    ((PartTabFolder)e.dropTarget).reorderTab((ViewPane)e.dragSource, e.cursorX, e.cursorY);
                    break;
                }
                this.stack(e.dragSource, e.dropTarget);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.isZoomed()) {
                    this.zoomOut();
                }
                this.movePart(e.dragSource, e.relativePosition, e.dropTarget);
            }
        }
    }

    private void moveFastView(ShortcutBarPart shortcutBarPart, Point point) {
        WorkbenchWindow window = (WorkbenchWindow)this.page.getWorkbenchWindow();
        ToolItem draggedItem = window.getFastViewDND().getDraggedItem();
        IViewReference draggedView = (IViewReference)draggedItem.getData("FastView");
        this.reorderFastViews(shortcutBarPart, draggedView, point);
    }

    private void reorderFastViews(ShortcutBarPart shortcutBarPart, IViewReference draggedView, Point point) {
        IViewReference destinationView = null;
        boolean placeAtEnd = true;
        ToolBar bar = (ToolBar)shortcutBarPart.getControl();
        ToolItem destItem = bar.getItem(point);
        if (destItem != null) {
            destinationView = (IViewReference)destItem.getData("FastView");
            placeAtEnd = false;
        }
        this.page.getActivePerspective().moveFastView(draggedView, destinationView, placeAtEnd);
        ((WorkbenchWindow)this.page.getWorkbenchWindow()).getFastViewBar().update(true);
    }

    public boolean partChangeAffectsZoom(PartPane pane) {
        if (this.zoomPart == null) {
            return false;
        }
        if (pane.getWindow().getShell() != this.page.getWorkbenchWindow().getShell()) {
            return false;
        }
        if (pane.isZoomed()) {
            return false;
        }
        if (this.isFastView(pane.getPartReference())) {
            return false;
        }
        PartPane zoomPane = ((WorkbenchPartReference)this.zoomPart).getPane();
        return !(pane instanceof EditorPane) || !(zoomPane instanceof EditorPane) || !((EditorPane)pane).getWorkbook().equals(((EditorPane)zoomPane).getWorkbook());
    }

    public void removePart(LayoutPart part) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (part instanceof ViewPane) {
            this.disableDrag((ViewPane)part);
        }
        Composite parent = this.mainLayout.getParent();
        part.reparent(parent);
        ILayoutContainer container = part.getContainer();
        if (container != null) {
            container.replace(part, new PartPlaceholder(part.getID()));
            this.updateContainerVisibleTab(container);
            if (container == this.mainLayout) {
                return;
            }
            LayoutPart[] children = container.getChildren();
            if (children != null) {
                boolean allInvisible = true;
                int i = 0;
                int length = children.length;
                while (i < length) {
                    if (!(children[i] instanceof PartPlaceholder)) {
                        allInvisible = false;
                        break;
                    }
                    ++i;
                }
                if (allInvisible && container instanceof LayoutPart) {
                    LayoutPart cPart = (LayoutPart)((Object)container);
                    Window oldWindow = cPart.getWindow();
                    if (oldWindow instanceof WorkbenchWindow) {
                        if (container instanceof PartTabFolder) {
                            ((PartTabFolder)container).dispose();
                        }
                        ILayoutContainer parentContainer = cPart.getContainer();
                        ContainerPlaceholder placeholder = new ContainerPlaceholder(cPart.getID());
                        placeholder.setRealContainer(container);
                        parentContainer.replace(cPart, placeholder);
                    } else if (oldWindow instanceof DetachedWindow) {
                        DetachedPlaceHolder placeholder = new DetachedPlaceHolder("", oldWindow.getShell().getBounds());
                        int i2 = 0;
                        int length2 = children.length;
                        while (i2 < length2) {
                            children[i2].getContainer().remove(children[i2]);
                            children[i2].setContainer(placeholder);
                            placeholder.add(children[i2]);
                            ++i2;
                        }
                        this.detachedPlaceHolderList.add(placeholder);
                        oldWindow.close();
                        this.detachedWindowList.remove(oldWindow);
                    }
                }
            }
        }
    }

    public void replacePlaceholderWithPart(LayoutPart part) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        PartPlaceholder[] placeholders = this.collectPlaceholders();
        int i = 0;
        int length = placeholders.length;
        while (i < length) {
            ILayoutContainer container;
            if (placeholders[i].getID().equals(part.getID()) && (container = placeholders[i].getContainer()) != null) {
                if (container instanceof ContainerPlaceholder) {
                    ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)container;
                    ILayoutContainer parentContainer = containerPlaceholder.getContainer();
                    container = (ILayoutContainer)((Object)containerPlaceholder.getRealContainer());
                    if (container instanceof LayoutPart) {
                        parentContainer.replace(containerPlaceholder, (LayoutPart)((Object)container));
                    }
                    containerPlaceholder.setRealContainer(null);
                }
                container.replace(placeholders[i], part);
                return;
            }
            ++i;
        }
    }

    public IStatus restoreState(IMemento memento) {
        IMemento childMem = memento.getChild("mainWindow");
        IStatus r = this.mainLayout.restoreState(childMem);
        if (this.detachable) {
            IMemento[] detachedWindows = memento.getChildren("detachedWindow");
            int nX = 0;
            while (nX < detachedWindows.length) {
                DetachedWindow win = new DetachedWindow(this.page);
                this.detachedWindowList.add(win);
                win.restoreState(detachedWindows[nX]);
                ++nX;
            }
            IMemento[] childrenMem = memento.getChildren("hiddenWindow");
            int i = 0;
            int length = childrenMem.length;
            while (i < length) {
                DetachedPlaceHolder holder = new DetachedPlaceHolder("", new Rectangle(0, 0, 0, 0));
                holder.restoreState(childrenMem[i]);
                this.detachedPlaceHolderList.add(holder);
                ++i;
            }
        }
        return r;
    }

    public IStatus saveState(IMemento memento) {
        IMemento childMem = memento.createChild("mainWindow");
        IStatus r = this.mainLayout.saveState(childMem);
        if (this.detachable) {
            int i = 0;
            int length = this.detachedWindowList.size();
            while (i < length) {
                DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i));
                childMem = memento.createChild("detachedWindow");
                window.saveState(childMem);
                ++i;
            }
            i = 0;
            length = this.detachedPlaceHolderList.size();
            while (i < length) {
                DetachedPlaceHolder holder = (DetachedPlaceHolder)this.detachedPlaceHolderList.get(i);
                childMem = memento.createChild("hiddenWindow");
                holder.saveState(childMem);
                ++i;
            }
        }
        return r;
    }

    private void stack(IWorkbenchDragDropPart source, IWorkbenchDragDropPart target) {
        this.parentWidget.setRedraw(false);
        LayoutPart part = source.getPart();
        LayoutPart refPart = target.getPart();
        if (part instanceof PartTabFolder) {
            LayoutPart visiblePart = ((PartTabFolder)part).getVisiblePart();
            LayoutPart[] children = ((PartTabFolder)part).getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof ViewPane) {
                    this.stackView((ViewPane)children[i], refPart);
                }
                ++i;
            }
            if (visiblePart != null) {
                this.bringPartToTop(visiblePart);
                visiblePart.setFocus();
            }
        } else {
            this.stackView((ViewPane)part, refPart);
            this.bringPartToTop(part);
            part.setFocus();
        }
        this.parentWidget.setRedraw(true);
    }

    private void stackView(ViewPane newPart, LayoutPart refPart) {
        this.derefPart(newPart);
        ILayoutContainer newContainer = refPart instanceof ILayoutContainer ? (ILayoutContainer)((Object)refPart) : refPart.getContainer();
        if (newContainer instanceof PartTabFolder) {
            PartTabFolder folder = (PartTabFolder)newContainer;
            Composite newParent = folder.getParent();
            newPart.reparent(newParent);
            folder.add(newPart);
            folder.enableDrag(newPart, this.partDropListener);
        } else if (newContainer instanceof RootLayoutContainer) {
            PartTabFolder folder = new PartTabFolder();
            ((RootLayoutContainer)newContainer).replace(refPart, folder);
            folder.add(refPart);
            folder.add(newPart);
            if (refPart instanceof ViewPane) {
                folder.enableDrag((ViewPane)refPart, this.partDropListener);
            }
            folder.enableDrag(newPart, this.partDropListener);
        }
    }

    private void updateContainerVisibleTab(ILayoutContainer container) {
        if (!(container instanceof PartTabFolder)) {
            return;
        }
        PartTabFolder folder = (PartTabFolder)container;
        LayoutPart[] parts = folder.getChildren();
        if (parts.length < 1) {
            return;
        }
        PartPane selPart = null;
        int topIndex = 0;
        IWorkbenchPartReference[] sortedPartsArray = this.page.getSortedParts();
        List<IWorkbenchPartReference> sortedParts = Arrays.asList(sortedPartsArray);
        int i = 0;
        while (i < parts.length) {
            IWorkbenchPartReference part;
            int index;
            if (parts[i] instanceof PartPane && (index = sortedParts.indexOf(part = ((PartPane)parts[i]).getPartReference())) >= topIndex) {
                topIndex = index;
                selPart = (PartPane)parts[i];
            }
            ++i;
        }
        if (selPart != null) {
            selPart.getPartReference().getPart(true);
            int selIndex = folder.indexOf(selPart);
            if (folder.getSelection() != selIndex) {
                folder.setSelection(selIndex);
            }
        }
    }

    public void zoomIn(IWorkbenchPartReference ref) {
        PartPane pane = ((WorkbenchPartReference)ref).getPane();
        this.zoomPart = ref;
        if (pane instanceof ViewPane) {
            this.parentWidget.setRedraw(false);
            ILayoutContainer parentContainer = ((ViewPane)pane).getContainer();
            if (parentContainer instanceof PartTabFolder) {
                PartTabFolder parent = (PartTabFolder)parentContainer;
                Perspective persp = this.page.getActivePerspective();
                if (persp != null && ref instanceof IViewReference && this.page.isFastView((IViewReference)ref)) {
                    persp.hideFastViewSash();
                }
                this.mainLayout.zoomIn(parent);
                pane.setZoomed(true);
                this.parentWidget.setRedraw(true);
            }
        } else if (pane instanceof EditorPane) {
            this.parentWidget.setRedraw(false);
            EditorWorkbook wb = ((EditorPane)pane).getWorkbook();
            EditorArea ea = wb.getEditorArea();
            this.mainLayout.zoomIn(ea);
            ea.zoomIn(wb);
            wb.zoomIn();
            pane.setZoomed(true);
            this.parentWidget.setRedraw(true);
        } else {
            this.zoomPart = null;
            return;
        }
    }

    public void zoomOut() {
        if (this.zoomPart == null) {
            return;
        }
        PartPane pane = ((WorkbenchPartReference)this.zoomPart).getPane();
        if (pane instanceof ViewPane) {
            this.parentWidget.setRedraw(false);
            this.mainLayout.zoomOut();
            pane.setZoomed(false);
            Perspective persp = this.page.getActivePerspective();
            if (persp != null && this.zoomPart instanceof IViewReference && this.page.isFastView((IViewReference)this.zoomPart)) {
                persp.showFastView((IViewReference)this.zoomPart);
            }
            this.parentWidget.setRedraw(true);
        } else if (pane instanceof EditorPane) {
            this.parentWidget.setRedraw(false);
            EditorWorkbook wb = ((EditorPane)pane).getWorkbook();
            EditorArea ea = wb.getEditorArea();
            wb.zoomOut();
            ea.zoomOut();
            this.mainLayout.zoomOut();
            pane.setZoomed(false);
            this.parentWidget.setRedraw(true);
        } else {
            this.parentWidget.setRedraw(false);
            this.mainLayout.zoomOut();
            this.parentWidget.setRedraw(true);
        }
        this.zoomPart = null;
    }

    private void collectDropTargets(List result, IWorkbenchDropTarget[] parts) {
        int i = 0;
        int length = parts.length;
        while (i < length) {
            parts[i].addDropTargets(result);
            ++i;
        }
    }
}

