/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;

public class PerspectiveContributionItem
extends ContributionItem {
    private static final Image image = WorkbenchImages.getImageDescriptor("IMG_CTOOL_NEW_PAGE").createImage();
    private static final Image hotImage = WorkbenchImages.getImageDescriptor("IMG_CTOOL_NEW_PAGE_HOVER").createImage();
    private ToolItem widget = null;
    private ToolBar parentWidget = null;
    private MenuManager menuMgr = new MenuManager();

    public PerspectiveContributionItem(IWorkbenchWindow window) {
        this.menuMgr.add(ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window));
    }

    public void fill(ToolBar parent, int index) {
        if (this.widget == null && parent != null) {
            this.parentWidget = parent;
            this.widget = index >= 0 ? new ToolItem(parent, 8, index) : new ToolItem(parent, 8);
            this.widget.setToolTipText(WorkbenchMessages.getString("PerspectiveContributionItem.toolTip"));
            if (ActionContributionItem.getUseColorIconsInToolbars()) {
                this.widget.setImage(hotImage);
            } else {
                this.widget.setImage(image);
                this.widget.setHotImage(hotImage);
            }
            this.widget.setData((Object)this);
            this.widget.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    PerspectiveContributionItem.this.menuMgr.update(true);
                    PerspectiveContributionItem.this.popUpMenu(event, PerspectiveContributionItem.this.menuMgr.createContextMenu((Control)PerspectiveContributionItem.this.parentWidget));
                }
            });
        }
    }

    private void popUpMenu(SelectionEvent event, Menu menu) {
        Point pt = new Point(event.x, event.y);
        pt = this.parentWidget.toDisplay(pt);
        menu.setLocation(pt.x, pt.y);
        menu.setVisible(true);
    }
}

