/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.commands.CommandHandlerServiceFactory;
import org.eclipse.ui.commands.ICompoundCommandHandlerService;
import org.eclipse.ui.contexts.ContextActivationServiceFactory;
import org.eclipse.ui.contexts.ICompoundContextActivationService;
import org.eclipse.ui.internal.EditorArea;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorWorkbook;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PerspectivePresentation;
import org.eclipse.ui.internal.RootLayoutContainer;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveExtensionReader;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;

public class Perspective {
    private PerspectiveDescriptor descriptor;
    protected WorkbenchPage page;
    protected LayoutPart editorArea;
    private PartPlaceholder editorHolder;
    private ViewFactory viewFactory;
    private ArrayList visibleActionSets;
    private ArrayList alwaysOnActionSets;
    private ArrayList alwaysOffActionSets;
    private ArrayList newWizardActionIds;
    private ArrayList showViewActionIds;
    private ArrayList perspectiveActionIds;
    private ArrayList fastViews;
    private ArrayList showInPartIds;
    private HashMap showInTimes = new HashMap();
    private IViewReference activeFastView;
    private IViewReference previousActiveFastView;
    private IMemento memento;
    protected PerspectivePresentation presentation;
    private static final String VERSION_STRING = "0.016";
    private static final int SASH_SIZE = 3;
    private static final int FASTVIEW_HIDE_STEPS = 5;
    private static final long FASTVIEW_HIDE_MIN_DURATION = 50L;
    private static final long FASTVIEW_HIDE_MAX_DURATION = 250L;
    private static final RGB RGB_COLOR1 = new RGB(132, 130, 132);
    private static final RGB RGB_COLOR2 = new RGB(143, 141, 138);
    private static final RGB RGB_COLOR3 = new RGB(171, 168, 165);
    private Color borderColor1;
    private Color borderColor2;
    private Color borderColor3;
    private Map mapFastViewToWidthRatio = new HashMap();
    private Sash fastViewSash;
    Listener resizeListener = new Listener(){

        public void handleEvent(Event event) {
            ViewPane pane;
            if (event.type == 11 && Perspective.this.activeFastView != null && !(pane = Perspective.this.getPane(Perspective.this.activeFastView)).isZoomed()) {
                Rectangle bounds = pane.getBounds();
                bounds.height = Math.max(0, ((Perspective)Perspective.this).getClientComposite().getSize().y);
                float ratio = Perspective.this.getFastViewWidthRatio(pane.getID());
                bounds.width = Math.max(0, (int)((float)((Perspective)Perspective.this).getClientComposite().getSize().x * ratio));
                pane.setBounds(bounds);
                Perspective.this.fastViewSash.setBounds(bounds.width - 3, bounds.y, 3, bounds.height - 3);
                Perspective.this.fastViewSash.moveAbove(null);
            }
        }
    };
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent event) {
            if (Perspective.this.borderColor1 == null) {
                Perspective.this.borderColor1 = WorkbenchColors.getColor(RGB_COLOR1);
            }
            if (Perspective.this.borderColor2 == null) {
                Perspective.this.borderColor2 = WorkbenchColors.getColor(RGB_COLOR2);
            }
            if (Perspective.this.borderColor3 == null) {
                Perspective.this.borderColor3 = WorkbenchColors.getColor(RGB_COLOR3);
            }
            Point size = Perspective.this.fastViewSash.getSize();
            Rectangle d = new Rectangle(0, 0, size.x, size.y);
            GC gc = event.gc;
            gc.setForeground(Perspective.this.borderColor1);
            gc.drawLine(d.x, d.y, d.x, d.y + d.height);
            gc.setForeground(Perspective.this.borderColor2);
            gc.drawLine(d.x + 1, d.y + 1, d.x + 1, d.y + d.height);
            gc.setForeground(Perspective.this.borderColor3);
            gc.drawLine(d.x + 2, d.y + 2, d.x + 2, d.y + d.height);
        }
    };
    private SelectionAdapter selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.detail == 1 && Perspective.this.activeFastView != null) {
                Perspective.this.checkDragLimit(e);
            }
            if (e.detail != 1 && Perspective.this.activeFastView != null) {
                ViewPane pane = Perspective.this.getPane(Perspective.this.activeFastView);
                Rectangle bounds = pane.getBounds();
                bounds.width = Math.max(0, e.x - bounds.x);
                pane.setBounds(bounds);
                Float newRatio = new Float((float)bounds.width / (float)((Perspective)Perspective.this).getClientComposite().getSize().x);
                Perspective.this.mapFastViewToWidthRatio.put(pane.getID(), newRatio);
                Perspective.this.updateFastViewSashBounds(bounds);
                Perspective.this.fastViewSash.moveAbove(null);
            }
        }
    };
    private String oldPartID = null;
    private boolean shouldHideEditorsOnActivate = false;
    private final ICompoundCommandHandlerService compoundCommandHandlerService = CommandHandlerServiceFactory.getCompoundCommandHandlerService();
    private final ICompoundContextActivationService compoundContextActivationService = ContextActivationServiceFactory.getCompoundContextActivationService();

    public Perspective(PerspectiveDescriptor desc, WorkbenchPage page) throws WorkbenchException {
        this(page);
        this.descriptor = desc;
        if (desc != null) {
            this.createPresentation(desc);
        }
    }

    protected Perspective(WorkbenchPage page) throws WorkbenchException {
        this.page = page;
        this.editorArea = page.getEditorPresentation().getLayoutPart();
        this.viewFactory = page.getViewFactory();
        this.visibleActionSets = new ArrayList(2);
        this.alwaysOnActionSets = new ArrayList(2);
        this.alwaysOffActionSets = new ArrayList(2);
        this.fastViews = new ArrayList(2);
    }

    public ICompoundCommandHandlerService getCompoundCommandHandlerService() {
        return this.compoundCommandHandlerService;
    }

    public ICompoundContextActivationService getCompoundContextActivationService() {
        return this.compoundContextActivationService;
    }

    public void addFastView(IViewReference ref) {
        ViewPane pane = (ViewPane)((WorkbenchPartReference)((Object)ref)).getPane();
        if (!this.isFastView(ref)) {
            if (this.presentation.hasPlaceholder(pane.getID()) || pane.getContainer() != null) {
                this.presentation.removePart(pane);
            }
            this.presentation.enableDrag(pane);
            this.fastViews.add(ref);
            pane.setFast(true);
            Control ctrl = pane.getControl();
            if (ctrl != null) {
                ctrl.setEnabled(false);
            }
        }
    }

    public boolean bringToTop(IViewReference ref) {
        if (this.isFastView(ref)) {
            this.setActiveFastView(ref);
            return true;
        }
        return this.presentation.bringPartToTop(this.getPane(ref));
    }

    public boolean canCloseView(IViewPart view) {
        return true;
    }

    private void checkDragLimit(SelectionEvent event) {
        if ((float)event.x < (float)this.getClientComposite().getSize().x * 0.05f) {
            event.x = (int)((float)this.getClientComposite().getSize().x * 0.05f);
        }
        if ((float)event.x > (float)this.getClientComposite().getSize().x * 0.95f) {
            event.x = (int)((float)this.getClientComposite().getSize().x * 0.95f);
        }
    }

    public boolean containsView(IViewPart view) {
        String id = view.getSite().getId();
        IViewReference ref = this.findView(id);
        if (ref == null) {
            return false;
        }
        return view == ref.getPart(false);
    }

    private void createInitialActionSets(List stringList) {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        Iterator iter = stringList.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            IActionSetDescriptor desc = reg.findActionSet(id);
            if (desc != null) {
                this.visibleActionSets.add(desc);
                continue;
            }
            WorkbenchPlugin.log("Unable to find Action Set: " + id);
        }
    }

    private void createPresentation(PerspectiveDescriptor persp) throws WorkbenchException {
        if (persp.hasCustomDefinition()) {
            this.loadCustomPersp(persp);
        } else {
            this.loadPredefinedPersp(persp);
        }
    }

    public void dispose() {
        if (this.presentation == null) {
            return;
        }
        this.presentation.deactivate();
        this.presentation.disposeSashes();
        IViewReference[] refs = this.getViewReferences();
        int i = 0;
        int length = refs.length;
        while (i < length) {
            this.getViewFactory().releaseView(refs[i].getId());
            ++i;
        }
        if (this.fastViewSash != null) {
            this.fastViewSash.dispose();
            this.fastViewSash = null;
        }
        this.mapFastViewToWidthRatio.clear();
    }

    public IViewReference findView(String id) {
        IViewReference[] refs = this.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IViewReference ref = refs[i];
            if (id.equals(ref.getId())) {
                return ref;
            }
            ++i;
        }
        return null;
    }

    public IActionSetDescriptor[] getActionSets() {
        int size = this.visibleActionSets.size();
        IActionSetDescriptor[] array = new IActionSetDescriptor[size];
        int i = 0;
        while (i < size) {
            array[i] = (IActionSetDescriptor)this.visibleActionSets.get(i);
            ++i;
        }
        return array;
    }

    private Composite getClientComposite() {
        return this.page.getClientComposite();
    }

    public IPerspectiveDescriptor getDesc() {
        return this.descriptor;
    }

    Rectangle getFastViewBounds(IViewReference ref) {
        Rectangle bounds = this.page.getClientComposite().getBounds();
        float ratio = this.getFastViewWidthRatio(ref.getId());
        bounds.width = (int)(ratio * (float)this.getClientComposite().getSize().x);
        return bounds;
    }

    public IViewReference[] getFastViews() {
        IViewReference[] array = new IViewReference[this.fastViews.size()];
        this.fastViews.toArray(array);
        return array;
    }

    public ArrayList getNewWizardActionIds() {
        return this.newWizardActionIds;
    }

    private ViewPane getPane(IViewReference ref) {
        return (ViewPane)((WorkbenchPartReference)((Object)ref)).getPane();
    }

    public ArrayList getPerspectiveActionIds() {
        return this.perspectiveActionIds;
    }

    public PerspectivePresentation getPresentation() {
        return this.presentation;
    }

    private float getFastViewWidthRatio(String id) {
        Float f = (Float)this.mapFastViewToWidthRatio.get(id);
        if (f != null) {
            return f.floatValue();
        }
        IViewRegistry reg = WorkbenchPlugin.getDefault().getViewRegistry();
        float ratio = reg.find(id).getFastViewWidthRatio();
        this.mapFastViewToWidthRatio.put(id, new Float(ratio));
        return ratio;
    }

    public ArrayList getShowInPartIds() {
        return this.showInPartIds;
    }

    public long getShowInTime(String partId) {
        Long t = (Long)this.showInTimes.get(partId);
        return t == null ? 0L : t;
    }

    public ArrayList getShowViewActionIds() {
        return this.showViewActionIds;
    }

    IViewReference getPreviousActiveFastView() {
        return this.previousActiveFastView;
    }

    private ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public void openTracker(ViewPane pane) {
        this.presentation.openTracker(pane);
    }

    public IViewReference[] getViewReferences() {
        if (this.presentation == null) {
            return new IViewReference[0];
        }
        ArrayList panes = new ArrayList(5);
        this.presentation.collectViewPanes(panes);
        IViewReference[] resultArray = new IViewReference[panes.size() + this.fastViews.size()];
        int nView = 0;
        int i = 0;
        while (i < this.fastViews.size()) {
            resultArray[nView] = (IViewReference)this.fastViews.get(i);
            ++nView;
            ++i;
        }
        i = 0;
        while (i < panes.size()) {
            ViewPane pane = (ViewPane)panes.get(i);
            resultArray[nView] = pane.getViewReference();
            ++nView;
            ++i;
        }
        return resultArray;
    }

    public void hideActionSet(String id) {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor desc = reg.findActionSet(id);
        if (this.alwaysOnActionSets.contains(desc)) {
            return;
        }
        if (desc != null) {
            this.visibleActionSets.remove(desc);
        }
    }

    protected void hideEditorArea() {
        if (!this.isEditorAreaVisible()) {
            return;
        }
        this.editorHolder = new PartPlaceholder(this.editorArea.getID());
        this.presentation.getLayout().replace(this.editorArea, this.editorHolder);
        if (this.editorArea.getControl() != null) {
            this.editorArea.getControl().setEnabled(false);
        }
        this.setEditorAreaVisible(false);
    }

    private void hideFastView(IViewReference ref, int steps) {
        this.setFastViewIconSelection(ref, false);
        ViewPane pane = this.getPane(ref);
        if (this.fastViewSash != null) {
            this.fastViewSash.setBounds(0, 0, 0, 0);
        }
        Control ctrl = pane.getControl();
        if (steps != 0) {
            Rectangle bounds = pane.getBounds();
            int increment = bounds.width / steps;
            long endTime = System.currentTimeMillis() + 250L;
            long minStepTime = 50L / (long)steps;
            int i = 0;
            while (i <= bounds.width - 2) {
                long time = System.currentTimeMillis();
                ctrl.setLocation(-i, bounds.y);
                ctrl.getParent().update();
                long afterTime = System.currentTimeMillis();
                if (afterTime >= endTime) break;
                long stepDuration = afterTime - time;
                if (stepDuration < minStepTime) {
                    try {
                        Thread.sleep(minStepTime - stepDuration);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                i += increment;
            }
        }
        pane.setVisible(false);
        pane.setFastViewSash(null);
        ctrl.setEnabled(false);
    }

    void hideFastViewSash() {
        if (this.fastViewSash != null) {
            this.fastViewSash.setBounds(0, 0, 0, 0);
        }
    }

    public boolean hideView(IViewReference ref) {
        ViewPane pane = this.getPane(ref);
        if (this.isFastView(ref)) {
            this.fastViews.remove(ref);
            if (pane != null) {
                pane.setFast(false);
            }
            if (this.activeFastView == ref) {
                this.setActiveFastView(null);
            }
            if (pane != null) {
                pane.getControl().setEnabled(true);
            }
        } else {
            this.presentation.removePart(pane);
        }
        this.getViewFactory().releaseView(ref.getId());
        return true;
    }

    protected boolean isEditorAreaVisible() {
        return this.editorHolder == null;
    }

    public boolean isFastView(IViewReference ref) {
        return this.fastViews.contains(ref);
    }

    private void loadCustomPersp(PerspectiveDescriptor persp) {
        PerspectiveRegistry perspRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        try {
            IMemento memento = perspRegistry.getCustomPersp(persp.getId());
            MultiStatus status = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.format("Perspective.unableToRestorePerspective", new String[]{persp.getLabel()}), null);
            status.merge(this.restoreState(memento));
            status.merge(this.restoreState());
            if (status.getSeverity() != 0) {
                this.unableToOpenPerspective(persp, (IStatus)status);
            }
        }
        catch (IOException e) {
            this.unableToOpenPerspective(persp, null);
        }
        catch (WorkbenchException e) {
            this.unableToOpenPerspective(persp, e.getStatus());
        }
    }

    private void unableToOpenPerspective(PerspectiveDescriptor persp, IStatus status) {
        PerspectiveRegistry perspRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        perspRegistry.deletePerspective(persp);
        String title = WorkbenchMessages.getString("Perspective.problemRestoringTitle");
        String msg = WorkbenchMessages.getString("Perspective.errorReadingState");
        if (status == null) {
            MessageDialog.openError(null, (String)title, (String)msg);
        } else {
            ErrorDialog.openError(null, (String)title, (String)msg, (IStatus)status);
        }
    }

    private void loadPredefinedPersp(PerspectiveDescriptor persp) throws WorkbenchException {
        IPerspectiveFactory factory = null;
        try {
            factory = persp.createFactory();
        }
        catch (CoreException e) {
            throw new WorkbenchException(WorkbenchMessages.format("Perspective.unableToLoad", new Object[]{persp.getId()}));
        }
        RootLayoutContainer container = new RootLayoutContainer(this.page);
        PageLayout layout = new PageLayout(container, this.getViewFactory(), this.editorArea, this.descriptor);
        factory.createInitialLayout(layout);
        PerspectiveExtensionReader extender = new PerspectiveExtensionReader();
        extender.extendLayout(this.descriptor.getId(), layout);
        this.mapFastViewToWidthRatio.putAll(layout.getFastViewToWidthRatioMap());
        this.createInitialActionSets(layout.getActionSets());
        this.alwaysOnActionSets.addAll(this.visibleActionSets);
        this.newWizardActionIds = layout.getNewWizardActionIds();
        this.showViewActionIds = layout.getShowViewActionIds();
        this.perspectiveActionIds = layout.getPerspectiveActionIds();
        this.showInPartIds = layout.getShowInPartIds();
        this.fastViews = layout.getFastViews();
        this.presentation = new PerspectivePresentation(this.page, container);
        if (!layout.isEditorAreaVisible()) {
            this.hideEditorArea();
        }
    }

    protected void onActivate() {
        if (this.editorArea.getControl() != null) {
            if (this.isEditorAreaVisible()) {
                this.editorArea.getControl().setEnabled(true);
                this.setEditorAreaVisible(true);
            } else {
                this.editorArea.getControl().setEnabled(false);
                this.setEditorAreaVisible(false);
            }
        }
        int i = 0;
        while (i < this.fastViews.size()) {
            ViewPane pane = this.getPane((IViewReference)this.fastViews.get(i));
            if (pane != null) {
                Control ctrl = pane.getControl();
                if (ctrl == null) {
                    pane.createControl(this.getClientComposite());
                    ctrl = pane.getControl();
                }
                this.presentation.enableDrag(pane);
                ctrl.setEnabled(false);
            }
            ++i;
        }
        this.setAllPinsVisible(true);
        this.presentation.activate(this.getClientComposite());
        this.getClientComposite().addListener(11, this.resizeListener);
        if (this.shouldHideEditorsOnActivate) {
            this.hideEditorArea();
            this.shouldHideEditorsOnActivate = false;
        }
    }

    protected void onDeactivate() {
        this.getClientComposite().removeListener(11, this.resizeListener);
        this.presentation.deactivate();
        this.setActiveFastView(null);
        this.setAllPinsVisible(false);
        int i = 0;
        while (i < this.fastViews.size()) {
            ViewPane pane = this.getPane((IViewReference)this.fastViews.get(i));
            if (pane != null) {
                this.presentation.disableDrag(pane);
                Control ctrl = pane.getControl();
                if (ctrl != null) {
                    ctrl.setEnabled(true);
                }
            }
            ++i;
        }
    }

    public void partActivated(IWorkbenchPart activePart) {
        if (this.activeFastView != null && this.activeFastView.getPart(false) != activePart) {
            this.setActiveFastView(null);
        }
    }

    public void performedShowIn(String partId) {
        this.showInTimes.put(partId, new Long(System.currentTimeMillis()));
    }

    public void removeFastView(IViewReference ref) {
        ViewPane pane = this.getPane(ref);
        if (this.isFastView(ref)) {
            if (this.activeFastView == ref) {
                this.setActiveFastView(null);
            }
            this.fastViews.remove(ref);
            pane.setFast(false);
            Control ctrl = pane.getControl();
            if (ctrl != null) {
                ctrl.setEnabled(true);
            }
            this.presentation.disableDrag(pane);
            this.presentation.addPart(pane);
        }
    }

    public IStatus restoreState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("Perspective.problemsRestoringPerspective"), null);
        this.descriptor = new PerspectiveDescriptor(null, null, null);
        result.add(this.descriptor.restoreState(memento));
        PerspectiveDescriptor desc = (PerspectiveDescriptor)WorkbenchPlugin.getDefault().getPerspectiveRegistry().findPerspectiveWithId(this.descriptor.getId());
        if (desc != null) {
            this.descriptor = desc;
        }
        this.memento = memento;
        IMemento[] views = memento.getChildren("view");
        result.merge(this.createReferences(views));
        memento = memento.getChild("fastViews");
        if (memento != null) {
            views = memento.getChildren("view");
            result.merge(this.createReferences(views));
        }
        return result;
    }

    private IStatus createReferences(IMemento[] views) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("Perspective.problemsRestoringViews"), null);
        int x = 0;
        while (x < views.length) {
            IMemento childMem = views[x];
            String viewID = childMem.getString("id");
            try {
                if (!"true".equals(childMem.getString("removed"))) {
                    this.viewFactory.createView(viewID);
                }
            }
            catch (PartInitException e) {
                childMem.putString("removed", "true");
                result.add((IStatus)new Status(4, "org.eclipse.ui", 0, e.getMessage(), (Throwable)((Object)e)));
            }
            ++x;
        }
        return result;
    }

    public IStatus restoreState() {
        String id;
        IActionSetDescriptor d;
        String actionSetID;
        if (this.memento == null) {
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("Perspective.problemsRestoringPerspective"), null);
        IMemento memento = this.memento;
        this.memento = null;
        IMemento boundsMem = memento.getChild("window");
        if (boundsMem != null) {
            Rectangle r = new Rectangle(0, 0, 0, 0);
            r.x = boundsMem.getInteger("x");
            r.y = boundsMem.getInteger("y");
            r.height = boundsMem.getInteger("height");
            r.width = boundsMem.getInteger("width");
            if (this.page.getWorkbenchWindow().getPages().length == 0) {
                this.page.getWorkbenchWindow().getShell().setBounds(r);
            }
        }
        RootLayoutContainer mainLayout = new RootLayoutContainer(this.page);
        PerspectivePresentation pres = new PerspectivePresentation(this.page, mainLayout);
        result.merge(pres.restoreState(memento.getChild("layout")));
        pres.replacePlaceholderWithPart(this.editorArea);
        IMemento[] views = memento.getChildren("view");
        int x = 0;
        while (x < views.length) {
            IMemento childMem = views[x];
            String viewID = childMem.getString("id");
            WorkbenchPartReference ref = (WorkbenchPartReference)((Object)this.viewFactory.getView(viewID));
            if (ref == null) {
                result.add((IStatus)new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("Perspective.couldNotFind", new String[]{viewID}), null));
            } else {
                if (ref.getPane() == null) {
                    ref.setPane(new ViewPane((IViewReference)((Object)ref), this.page));
                }
                this.page.addPart(ref);
                if (pres.willPartBeVisible(ref.getId())) {
                    IStatus restoreStatus = this.viewFactory.restoreView((IViewReference)((Object)ref));
                    result.add(restoreStatus);
                    if (restoreStatus.getSeverity() == 0) {
                        IViewPart view = (IViewPart)ref.getPart(true);
                        if (view != null) {
                            ViewSite site = (ViewSite)view.getSite();
                            ViewPane pane = (ViewPane)site.getPane();
                            pres.replacePlaceholderWithPart(pane);
                        }
                    } else {
                        this.page.removePart(ref);
                    }
                } else {
                    pres.replacePlaceholderWithPart(ref.getPane());
                }
            }
            ++x;
        }
        IMemento fastViewsMem = memento.getChild("fastViews");
        if (fastViewsMem != null) {
            views = fastViewsMem.getChildren("view");
            int x2 = 0;
            while (x2 < views.length) {
                IMemento childMem = views[x2];
                String viewID = childMem.getString("id");
                Float ratio = childMem.getFloat("ratio");
                if (ratio == null) {
                    Integer viewWidth = childMem.getInteger("width");
                    ratio = viewWidth == null ? new Float(0.3f) : new Float((float)viewWidth.intValue() / (float)this.getClientComposite().getSize().x);
                }
                this.mapFastViewToWidthRatio.put(viewID, ratio);
                WorkbenchPartReference ref = (WorkbenchPartReference)((Object)this.viewFactory.getView(viewID));
                if (ref == null) {
                    WorkbenchPlugin.log("Could not create view: '" + viewID + "'.");
                    result.add((IStatus)new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("Perspective.couldNotFind", new String[]{viewID}), null));
                } else {
                    this.fastViews.add(ref);
                    if (ref.getPane() == null) {
                        ref.setPane(new ViewPane((IViewReference)((Object)ref), this.page));
                    }
                    this.page.addPart(ref);
                }
                ++x2;
            }
        }
        IMemento[] actions = memento.getChildren("actionSet");
        ArrayList<String> actionsArray = new ArrayList<String>(actions.length);
        int x3 = 0;
        while (x3 < actions.length) {
            actionSetID = actions[x3].getString("id");
            actionsArray.add(actionSetID);
            ++x3;
        }
        this.createInitialActionSets(actionsArray);
        actions = memento.getChildren("alwaysOnActionSet");
        x3 = 0;
        while (x3 < actions.length) {
            actionSetID = actions[x3].getString("id");
            d = WorkbenchPlugin.getDefault().getActionSetRegistry().findActionSet(actionSetID);
            if (d != null) {
                this.alwaysOnActionSets.add(d);
            }
            ++x3;
        }
        actions = memento.getChildren("alwaysOffActionSet");
        x3 = 0;
        while (x3 < actions.length) {
            actionSetID = actions[x3].getString("id");
            d = WorkbenchPlugin.getDefault().getActionSetRegistry().findActionSet(actionSetID);
            if (d != null) {
                this.alwaysOffActionSets.add(d);
            }
            ++x3;
        }
        actions = memento.getChildren("show_view_action");
        this.showViewActionIds = new ArrayList(actions.length);
        x3 = 0;
        while (x3 < actions.length) {
            id = actions[x3].getString("id");
            this.showViewActionIds.add(id);
            ++x3;
        }
        actions = memento.getChildren("show_in_time");
        x3 = 0;
        while (x3 < actions.length) {
            id = actions[x3].getString("id");
            String timeStr = actions[x3].getString("time");
            if (id != null && timeStr != null) {
                try {
                    long time = Long.parseLong(timeStr);
                    this.showInTimes.put(id, new Long(time));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++x3;
        }
        this.showInPartIds = this.getShowInIdsFromRegistry();
        actions = memento.getChildren("new_wizard_action");
        this.newWizardActionIds = new ArrayList(actions.length);
        x3 = 0;
        while (x3 < actions.length) {
            id = actions[x3].getString("id");
            this.newWizardActionIds.add(id);
            ++x3;
        }
        actions = memento.getChildren("perspective_action");
        this.perspectiveActionIds = new ArrayList(actions.length);
        x3 = 0;
        while (x3 < actions.length) {
            id = actions[x3].getString("id");
            this.perspectiveActionIds.add(id);
            ++x3;
        }
        this.presentation = pres;
        Integer areaVisible = memento.getInteger("editorAreaVisible");
        this.shouldHideEditorsOnActivate = areaVisible != null && areaVisible == 0;
        return result;
    }

    private ArrayList getShowInIdsFromRegistry() {
        PerspectiveExtensionReader reader = new PerspectiveExtensionReader();
        reader.setIncludeOnlyTags(new String[]{"showInPart"});
        PageLayout layout = new PageLayout();
        reader.extendLayout(this.descriptor.getOriginalId(), layout);
        return layout.getShowInPartIds();
    }

    public void saveDesc() {
        this.saveDescAs(this.descriptor);
    }

    public void saveDescAs(IPerspectiveDescriptor desc) {
        PerspectiveDescriptor realDesc = (PerspectiveDescriptor)desc;
        PerspectiveRegistry perspRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        XMLMemento memento = XMLMemento.createWriteRoot("perspective");
        IStatus status = this.saveState(memento, realDesc, false);
        if (status.getSeverity() == 4) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.getString("Perspective.problemSavingTitle"), (String)WorkbenchMessages.getString("Perspective.problemSavingMessage"), (IStatus)status);
            return;
        }
        try {
            perspRegistry.saveCustomPersp(realDesc, memento);
            this.descriptor = realDesc;
        }
        catch (IOException e) {
            perspRegistry.deletePerspective(realDesc);
            MessageDialog.openError(null, (String)WorkbenchMessages.getString("Perspective.problemSavingTitle"), (String)WorkbenchMessages.getString("Perspective.problemSavingMessage"));
        }
    }

    public IStatus saveState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("Perspective.problemsSavingPerspective"), null);
        result.merge(this.saveState(memento, this.descriptor, true));
        return result;
    }

    private IStatus saveState(IMemento memento, PerspectiveDescriptor p, boolean saveInnerViewState) {
        IMemento childMem;
        IMemento viewMemento;
        IViewReference ref;
        String str;
        IMemento child;
        IActionSetDescriptor desc;
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("Perspective.problemsSavingPerspective"), null);
        if (this.memento != null) {
            memento.putMemento(this.memento);
            return result;
        }
        memento.putString("version", VERSION_STRING);
        result.add(p.saveState(memento));
        if (!saveInnerViewState) {
            Rectangle bounds = this.page.getWorkbenchWindow().getShell().getBounds();
            IMemento boundsMem = memento.createChild("window");
            boundsMem.putInteger("x", bounds.x);
            boundsMem.putInteger("y", bounds.y);
            boundsMem.putInteger("height", bounds.height);
            boundsMem.putInteger("width", bounds.width);
        }
        Iterator<Object> iterator = this.visibleActionSets.iterator();
        while (iterator.hasNext()) {
            desc = (IActionSetDescriptor)iterator.next();
            child = memento.createChild("actionSet");
            child.putString("id", desc.getId());
        }
        iterator = this.alwaysOnActionSets.iterator();
        while (iterator.hasNext()) {
            desc = (IActionSetDescriptor)iterator.next();
            child = memento.createChild("alwaysOnActionSet");
            child.putString("id", desc.getId());
        }
        iterator = this.alwaysOffActionSets.iterator();
        while (iterator.hasNext()) {
            desc = (IActionSetDescriptor)iterator.next();
            child = memento.createChild("alwaysOffActionSet");
            child.putString("id", desc.getId());
        }
        iterator = this.showViewActionIds.iterator();
        while (iterator.hasNext()) {
            str = (String)iterator.next();
            child = memento.createChild("show_view_action");
            child.putString("id", str);
        }
        iterator = this.showInTimes.keySet().iterator();
        while (iterator.hasNext()) {
            String id = (String)iterator.next();
            Long time = (Long)this.showInTimes.get(id);
            IMemento child2 = memento.createChild("show_in_time");
            child2.putString("id", id);
            child2.putString("time", time.toString());
        }
        iterator = this.newWizardActionIds.iterator();
        while (iterator.hasNext()) {
            str = (String)iterator.next();
            child = memento.createChild("new_wizard_action");
            child.putString("id", str);
        }
        iterator = this.perspectiveActionIds.iterator();
        while (iterator.hasNext()) {
            str = (String)iterator.next();
            child = memento.createChild("perspective_action");
            child.putString("id", str);
        }
        ArrayList viewPanes = new ArrayList(5);
        this.presentation.collectViewPanes(viewPanes);
        iterator = viewPanes.iterator();
        int errors = 0;
        while (iterator.hasNext()) {
            ViewPane pane = (ViewPane)iterator.next();
            ref = pane.getViewReference();
            viewMemento = memento.createChild("view");
            viewMemento.putString("id", ref.getId());
        }
        if (this.fastViews.size() > 0) {
            childMem = memento.createChild("fastViews");
            iterator = this.fastViews.iterator();
            while (iterator.hasNext()) {
                ref = (IViewReference)iterator.next();
                viewMemento = childMem.createChild("view");
                String id = ref.getId();
                viewMemento.putString("id", id);
                float ratio = this.getFastViewWidthRatio(id);
                viewMemento.putFloat("ratio", ratio);
            }
        }
        if (errors > 0) {
            String message = WorkbenchMessages.getString("Perspective.multipleErrors");
            if (errors == 1) {
                message = WorkbenchMessages.getString("Perspective.oneError");
            }
            MessageDialog.openError(null, (String)WorkbenchMessages.getString("Error"), (String)message);
        }
        childMem = memento.createChild("layout");
        result.add(this.presentation.saveState(childMem));
        if (this.isEditorAreaVisible()) {
            memento.putInteger("editorAreaVisible", 1);
        } else {
            memento.putInteger("editorAreaVisible", 0);
        }
        return result;
    }

    public void setActionSets(IActionSetDescriptor[] newArray) {
        IActionSetDescriptor desc;
        ArrayList turnedOff = (ArrayList)this.visibleActionSets.clone();
        int i = 0;
        while (i < newArray.length) {
            desc = newArray[i];
            turnedOff.remove(desc);
            if (!this.visibleActionSets.contains(desc)) {
                this.alwaysOnActionSets.add(desc);
                this.alwaysOffActionSets.remove(desc);
            }
            ++i;
        }
        i = 0;
        while (i < turnedOff.size()) {
            desc = (IActionSetDescriptor)turnedOff.get(i);
            this.alwaysOnActionSets.remove(desc);
            this.alwaysOffActionSets.add(desc);
            ++i;
        }
        this.visibleActionSets.clear();
        int newSize = newArray.length;
        int i2 = 0;
        while (i2 < newSize) {
            this.visibleActionSets.add(newArray[i2]);
            ++i2;
        }
    }

    public IViewReference getActiveFastView() {
        return this.activeFastView;
    }

    void setActiveFastView(IViewReference ref, int steps) {
        if (this.activeFastView == ref) {
            return;
        }
        if (this.activeFastView != null) {
            this.previousActiveFastView = this.activeFastView;
        }
        if (this.activeFastView != null) {
            ViewPane pane = this.getPane(this.activeFastView);
            if (pane.isZoomed()) {
                this.presentation.zoomOut();
            }
            this.hideFastView(this.activeFastView, steps);
        }
        this.activeFastView = ref;
        if (this.activeFastView != null) {
            this.showFastView(this.activeFastView);
        }
    }

    void setActiveFastView(IViewReference ref) {
        this.setActiveFastView(ref, 5);
    }

    private void setAllPinsVisible(boolean visible) {
        Iterator iter = this.fastViews.iterator();
        while (iter.hasNext()) {
            ViewPane pane = this.getPane((IViewReference)iter.next());
            if (pane == null) continue;
            pane.setFast(visible);
        }
    }

    private void setFastViewIconSelection(IViewReference ref, boolean selected) {
        WorkbenchWindow window = (WorkbenchWindow)this.page.getWorkbenchWindow();
        ToolBar bar = window.getFastViewBar().getControl();
        ToolItem[] items = bar.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData("FastView") == ref) {
                items[i].setSelection(selected);
            }
            ++i;
        }
    }

    public void setNewWizardActionIds(ArrayList newList) {
        this.newWizardActionIds = newList;
    }

    public void setPerspectiveActionIds(ArrayList list) {
        this.perspectiveActionIds = list;
    }

    public void setShowInPartIds(ArrayList list) {
        this.showInPartIds = list;
    }

    public void setShowViewActionIds(ArrayList list) {
        this.showViewActionIds = list;
    }

    public void showActionSet(String id) {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor desc = reg.findActionSet(id);
        if (this.alwaysOffActionSets.contains(desc)) {
            return;
        }
        if (desc != null && !this.visibleActionSets.contains(desc)) {
            this.visibleActionSets.add(desc);
        }
    }

    protected void showEditorArea() {
        if (this.isEditorAreaVisible()) {
            return;
        }
        if (this.editorArea.getControl() != null) {
            this.editorArea.getControl().setEnabled(true);
        }
        this.setEditorAreaVisible(true);
        this.presentation.getLayout().replace(this.editorHolder, this.editorArea);
        this.editorHolder = null;
    }

    private void setEditorAreaVisible(boolean visible) {
        ArrayList workbooks = ((EditorArea)this.editorArea).getEditorWorkbooks();
        Iterator iter = workbooks.iterator();
        while (iter.hasNext()) {
            EditorWorkbook workbook = (EditorWorkbook)iter.next();
            workbook.setVisible(visible);
            EditorPane pane = workbook.getVisibleEditor();
            if (pane == null) continue;
            pane.setVisible(visible);
        }
        this.editorArea.setVisible(visible);
    }

    void showFastView(IViewReference ref) {
        if (ref.getPart(true) == null) {
            return;
        }
        ViewPane pane = this.getPane(ref);
        Control ctrl = pane.getControl();
        if (ctrl == null) {
            pane.createControl(this.getClientComposite());
            ctrl = pane.getControl();
        }
        ctrl.setEnabled(true);
        Composite parent = ctrl.getParent();
        Rectangle bounds = this.getFastViewBounds(ref);
        pane.setVisible(true);
        pane.setBounds(bounds);
        pane.moveAbove(null);
        pane.setFocus();
        if (this.fastViewSash == null) {
            this.fastViewSash = new Sash(parent, 512);
            this.fastViewSash.addPaintListener(this.paintListener);
            this.fastViewSash.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    Perspective.this.fastViewSash.removePaintListener(Perspective.this.paintListener);
                }

                public void focusLost(FocusEvent e) {
                    Perspective.this.fastViewSash.addPaintListener(Perspective.this.paintListener);
                }
            });
            this.fastViewSash.addSelectionListener((SelectionListener)this.selectionListener);
        }
        pane.setFastViewSash(this.fastViewSash);
        this.updateFastViewSashBounds(bounds);
        this.fastViewSash.moveAbove(null);
        this.setFastViewIconSelection(ref, true);
    }

    public void updateFastViewSashBounds(Rectangle partBounds) {
        this.fastViewSash.setBounds(partBounds.x + partBounds.width - 1, partBounds.y + 1, 3, partBounds.height - 2);
    }

    public IViewPart showView(String viewID) throws PartInitException {
        ViewFactory factory = this.getViewFactory();
        IViewReference ref = factory.createView(viewID);
        IViewPart part = (IViewPart)ref.getPart(false);
        if (part == null) {
            IStatus status = factory.restoreView(ref);
            if (status.getSeverity() == 4) {
                if (status.getException() instanceof PartInitException) {
                    throw (PartInitException)((Object)status.getException());
                }
                throw new PartInitException(status);
            }
            part = (IViewPart)ref.getPart(false);
        }
        ViewSite site = (ViewSite)part.getSite();
        ViewPane pane = (ViewPane)site.getPane();
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        int openViewMode = store.getInt("OPEN_VIEW_MODE");
        if (this.presentation.hasPlaceholder(viewID)) {
            this.presentation.addPart(pane);
        } else if (openViewMode == 0) {
            this.presentation.addPart(pane);
        } else if (openViewMode == 2 && this.presentation.canDetach()) {
            this.presentation.addDetachedPart(pane);
        } else {
            this.showFastView(ref);
            this.addFastView(ref);
        }
        return part;
    }

    public void toggleFastView(IViewReference ref) {
        if (ref == this.activeFastView) {
            this.setActiveFastView(null);
        } else {
            this.setActiveFastView(ref);
        }
    }

    public String getOldPartID() {
        return this.oldPartID;
    }

    public void setOldPartID(String oldPartID) {
        this.oldPartID = oldPartID;
    }

    void moveFastView(IViewReference draggedView, IViewReference destinationView, boolean placeAtEnd) {
        if (draggedView == destinationView) {
            return;
        }
        this.fastViews.remove(draggedView);
        if (placeAtEnd) {
            this.fastViews.add(draggedView);
        } else if (destinationView == null) {
            this.fastViews.add(0, draggedView);
        } else {
            this.fastViews.add(this.fastViews.indexOf(destinationView), draggedView);
        }
    }
}

