/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.ui.internal.IPartDropListener;
import org.eclipse.ui.internal.IWorkbenchDragSource;
import org.eclipse.ui.internal.IWorkbenchDropTarget;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartDropEvent;
import org.eclipse.ui.internal.WorkbenchImages;

public class PartDragDrop {
    public static final int INVALID = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int CENTER = 5;
    public static final int OFFSCREEN = 6;
    private static final int HYSTERESIS = 10;
    private static final int MARGIN = 10;
    private static final Cursor[] cursors = new Cursor[7];
    private IWorkbenchDragSource sourcePart;
    private Control dragControl;
    private int xAnchor;
    private int yAnchor;
    private boolean isDragAllowed = false;
    private IPartDropListener[] dropListeners;
    private MouseMoveListener mouseMoveListener;
    private MouseListener mouseListener;
    private Listener dragListener;

    public PartDragDrop(IWorkbenchDragSource dragPart, Control dragHandle) {
        this.sourcePart = dragPart;
        this.dragControl = dragHandle;
        this.dragListener = new Listener(){

            public void handleEvent(Event event) {
                Point position = event.display.getCursorLocation();
                Control control = event.display.getCursorControl();
                if (control != null) {
                    PartDragDrop.this.isDragAllowed(control.toControl(position));
                }
            }
        };
        this.dragControl.addListener(29, this.dragListener);
        this.mouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                PartDragDrop.this.handleMouseMove(event);
            }
        };
        this.dragControl.addMouseMoveListener(this.mouseMoveListener);
        this.mouseListener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                PartDragDrop.this.handleMouseDoubleClick(e);
            }

            public void mouseUp(MouseEvent e) {
                PartDragDrop.this.handleMouseUp(e);
            }
        };
        this.dragControl.addMouseListener(this.mouseListener);
    }

    public void addDropListener(IPartDropListener listener) {
        if (listener == null) {
            return;
        }
        if (this.dropListeners == null) {
            this.dropListeners = new IPartDropListener[1];
            this.dropListeners[0] = listener;
        } else {
            IPartDropListener[] newDropListeners = new IPartDropListener[this.dropListeners.length + 1];
            System.arraycopy(this.dropListeners, 0, newDropListeners, 0, this.dropListeners.length);
            newDropListeners[this.dropListeners.length] = listener;
            this.dropListeners = newDropListeners;
        }
    }

    private PartDropEvent createDropEvent(Tracker tracker) {
        int vmargin;
        Display display = this.dragControl.getDisplay();
        Control targetControl = display.getCursorControl();
        PartDropEvent event = new PartDropEvent();
        Rectangle rect = tracker.getRectangles()[0];
        event.x = rect.x;
        event.y = rect.y;
        event.dragSource = this.sourcePart;
        if (targetControl == null) {
            event.relativePosition = 6;
            return event;
        }
        LayoutPart targetPart = this.getTargetPart(targetControl);
        if (targetPart == null) {
            event.relativePosition = 0;
            return event;
        }
        event.dropTarget = targetPart;
        Control c = targetPart.getControl();
        if (c == null) {
            event.relativePosition = 0;
            return event;
        }
        Point p = c.toControl(display.getCursorLocation());
        Point e = c.getSize();
        int hmargin = Math.min(e.x / 3, 10);
        Rectangle inner = new Rectangle(hmargin, vmargin = Math.min(e.y / 3, 10), e.x - hmargin * 2, e.y - vmargin * 2);
        if (inner.contains(p)) {
            event.relativePosition = 5;
        } else {
            p.x -= e.x / 2;
            p.y -= e.y / 2;
            double a = Math.atan2(p.y * e.x, p.x * e.y) * 57.29577951308232;
            event.relativePosition = a >= -135.0 && a < -45.0 ? 3 : (a > -45.0 && a < 45.0 ? 2 : (a > 45.0 && a < 135.0 ? 4 : 1));
        }
        return event;
    }

    public void dispose() {
        if (this.dragControl != null && !this.dragControl.isDisposed()) {
            this.dragControl.removeMouseMoveListener(this.mouseMoveListener);
            this.dragControl.removeMouseListener(this.mouseListener);
            this.dragControl.removeListener(29, this.dragListener);
        }
        this.dragControl = null;
        int i = 0;
        int length = cursors.length;
        while (i < length) {
            if (cursors[i] != null && !cursors[i].isDisposed()) {
                cursors[i].dispose();
            }
            PartDragDrop.cursors[i] = null;
            ++i;
        }
        this.dropListeners = null;
        this.sourcePart = null;
    }

    private Cursor getCursor(Display display, int code) {
        if (cursors[code] == null) {
            ImageDescriptor source = null;
            ImageDescriptor mask = null;
            switch (code) {
                case 1: {
                    source = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_LEFT_SOURCE");
                    mask = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_LEFT_MASK");
                    PartDragDrop.cursors[1] = new Cursor((Device)display, source.getImageData(), mask.getImageData(), 16, 16);
                    break;
                }
                case 2: {
                    source = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_RIGHT_SOURCE");
                    mask = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_RIGHT_MASK");
                    PartDragDrop.cursors[2] = new Cursor((Device)display, source.getImageData(), mask.getImageData(), 16, 16);
                    break;
                }
                case 3: {
                    source = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_TOP_SOURCE");
                    mask = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_TOP_MASK");
                    PartDragDrop.cursors[3] = new Cursor((Device)display, source.getImageData(), mask.getImageData(), 16, 16);
                    break;
                }
                case 4: {
                    source = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_BOTTOM_SOURCE");
                    mask = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_BOTTOM_MASK");
                    PartDragDrop.cursors[4] = new Cursor((Device)display, source.getImageData(), mask.getImageData(), 16, 16);
                    break;
                }
                case 5: {
                    source = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_STACK_SOURCE");
                    mask = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_STACK_MASK");
                    PartDragDrop.cursors[5] = new Cursor((Device)display, source.getImageData(), mask.getImageData(), 16, 16);
                    break;
                }
                case 6: {
                    source = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_OFFSCREEN_SOURCE");
                    mask = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_OFFSCREEN_MASK");
                    PartDragDrop.cursors[6] = new Cursor((Device)display, source.getImageData(), mask.getImageData(), 16, 16);
                    break;
                }
                default: {
                    source = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_INVALID_SOURCE");
                    mask = WorkbenchImages.getImageDescriptor("IMG_OBJS_DND_INVALID_MASK");
                    PartDragDrop.cursors[0] = new Cursor((Device)display, source.getImageData(), mask.getImageData(), 16, 16);
                }
            }
        }
        return cursors[code];
    }

    protected Control getDragControl() {
        return this.dragControl;
    }

    protected Rectangle getSourceBounds() {
        return this.sourcePart.getControl().getBounds();
    }

    public IWorkbenchDragSource getSourcePart() {
        return this.sourcePart;
    }

    private LayoutPart getTargetPart(Control target) {
        while (target != null) {
            Object data = target.getData();
            if (data instanceof IWorkbenchDropTarget) {
                IWorkbenchDropTarget dropTarget = (IWorkbenchDropTarget)data;
                if (this.isValid(this.sourcePart, dropTarget)) {
                    return dropTarget.targetPartFor(this.sourcePart);
                }
                return null;
            }
            target = target.getParent();
        }
        return null;
    }

    protected boolean hasMovedEnough(MouseEvent e) {
        int dx = e.x - this.xAnchor;
        int dy = e.y - this.yAnchor;
        return Math.abs(dx) >= 10 || Math.abs(dy) >= 10;
    }

    protected void handleMouseDoubleClick(MouseEvent e) {
        this.isDragAllowed = false;
    }

    protected void handleMouseMove(MouseEvent e) {
        if (!this.isDragAllowed) {
            return;
        }
        if (!this.hasMovedEnough(e)) {
            return;
        }
        if (!this.sourcePart.isDragAllowed(new Point(e.x, e.y))) {
            return;
        }
        this.openTracker();
    }

    protected void isDragAllowed(Point position) {
        if (this.getSourceBounds().width == 0 || this.getSourceBounds().height == 0) {
            return;
        }
        if (!this.sourcePart.isDragAllowed(position)) {
            return;
        }
        this.isDragAllowed = true;
        this.xAnchor = position.x;
        this.yAnchor = position.y;
    }

    public void openTracker() {
        final Display display = this.dragControl.getDisplay();
        final Tracker tracker = new Tracker(display, 0);
        tracker.addListener(10, new Listener(){

            public void handleEvent(Event event) {
                PartDropEvent dropEvent = PartDragDrop.this.createDropEvent(tracker);
                Point p = PartDragDrop.this.dragControl.toControl(display.getCursorLocation());
                dropEvent.cursorX = p.x;
                dropEvent.cursorY = p.y;
                if (PartDragDrop.this.dropListeners != null) {
                    int i = 0;
                    int length = PartDragDrop.this.dropListeners.length;
                    while (i < length) {
                        PartDragDrop.this.dropListeners[i].dragOver(dropEvent);
                        ++i;
                    }
                }
                Cursor cursor = PartDragDrop.this.getCursor(display, dropEvent.relativePosition);
                tracker.setCursor(cursor);
            }
        });
        Control sourceControl = this.sourcePart.getControl();
        Rectangle sourceBounds = this.getSourceBounds();
        Point sourcePos = new Point(sourceBounds.x, sourceBounds.y);
        if (!(sourceControl instanceof Shell)) {
            sourcePos = sourceControl.getParent().toDisplay(sourcePos);
        }
        if (this.isDragAllowed) {
            Point anchorPos = this.dragControl.toDisplay(new Point(this.xAnchor, this.yAnchor));
            Point cursorPos = display.getCursorLocation();
            sourceBounds.x = sourcePos.x - (anchorPos.x - cursorPos.x);
            sourceBounds.y = sourcePos.y - (anchorPos.y - cursorPos.y);
        } else {
            sourceBounds.x = sourcePos.x + 10;
            sourceBounds.y = sourcePos.y + 10;
        }
        tracker.setRectangles(new Rectangle[]{sourceBounds});
        boolean trackingOk = tracker.open();
        this.isDragAllowed = false;
        PartDropEvent event = this.createDropEvent(tracker);
        Point p1 = this.dragControl.toControl(display.getCursorLocation());
        event.cursorX = p1.x;
        event.cursorY = p1.y;
        if (!this.dragControl.isDisposed()) {
            this.dragControl.setCursor(null);
        }
        if (this.dropListeners != null) {
            int length;
            int i;
            if (trackingOk) {
                i = 0;
                length = this.dropListeners.length;
                while (i < length) {
                    this.dropListeners[i].dragOver(event);
                    ++i;
                }
            } else {
                event.relativePosition = 0;
            }
            i = 0;
            length = this.dropListeners.length;
            while (i < length) {
                this.dropListeners[i].drop(event);
                ++i;
            }
        }
        tracker.dispose();
    }

    protected void handleMouseUp(MouseEvent e) {
        this.isDragAllowed = false;
    }

    public void removeDropListener(IPartDropListener listener) {
        if (listener == null) {
            return;
        }
        int index = -1;
        int i = 0;
        int length = this.dropListeners.length;
        while (i < length) {
            if (this.dropListeners[i].equals(listener)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.dropListeners.length == 1) {
            this.dropListeners = null;
        } else {
            IPartDropListener[] newListeners = new IPartDropListener[this.dropListeners.length - 1];
            System.arraycopy(this.dropListeners, 0, newListeners, 0, index);
            System.arraycopy(this.dropListeners, index + 1, newListeners, index, newListeners.length - index);
            this.dropListeners = newListeners;
        }
    }

    private boolean isValid(IWorkbenchDragSource source, IWorkbenchDropTarget dropTarget) {
        return (source.getType() & dropTarget.getType()) > 0;
    }
}

