/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.IObjectContributor;
import org.eclipse.ui.internal.LegacyResourceSupport;

public abstract class ObjectContributorManager {
    private static final List EMPTY_LIST = Arrays.asList(new Object[0]);
    protected Map contributors = new Hashtable(5);
    protected Map objectLookup = null;
    protected Map adapterLookup = null;
    static /* synthetic */ Class class$0;

    private void addContributorsFor(List types, List result) {
        Iterator classes = types.iterator();
        while (classes.hasNext()) {
            Class clazz = (Class)classes.next();
            List contributorList = (List)this.contributors.get(clazz.getName());
            if (contributorList == null) continue;
            result.addAll(contributorList);
        }
    }

    protected final List computeClassOrder(Class extensibleClass) {
        ArrayList result = new ArrayList(4);
        Class clazz = extensibleClass;
        while (clazz != null) {
            result.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    protected final List computeInterfaceOrder(List classList) {
        ArrayList result = new ArrayList(4);
        HashMap seen = new HashMap(4);
        Iterator list = classList.iterator();
        while (list.hasNext()) {
            Class[] interfaces = ((Class)list.next()).getInterfaces();
            this.internalComputeInterfaceOrder(interfaces, result, seen);
        }
        return result;
    }

    public void flushLookup() {
        this.objectLookup = null;
        this.adapterLookup = null;
    }

    private void cacheAdapterLookup(Class adapterClass, List results) {
        if (this.adapterLookup == null) {
            this.adapterLookup = new HashMap();
        }
        this.adapterLookup.put(adapterClass, results);
    }

    private void cacheObjectLookup(Class objectClass, List results) {
        if (this.objectLookup == null) {
            this.objectLookup = new HashMap();
        }
        this.objectLookup.put(objectClass, results);
    }

    public Collection getContributors() {
        return Collections.unmodifiableCollection(this.contributors.values());
    }

    protected List getContributors(Class objectClass) {
        List objectList = null;
        if (this.objectLookup != null) {
            objectList = (List)this.objectLookup.get(objectClass);
        }
        if (objectList == null) {
            objectList = this.addContributorsFor(objectClass);
            if (objectList.size() == 0) {
                objectList = EMPTY_LIST;
            }
            this.cacheObjectLookup(objectClass, objectList);
        }
        return objectList;
    }

    protected List addContributorsFor(Class objectClass) {
        List classList = this.computeClassOrder(objectClass);
        ArrayList result = new ArrayList();
        this.addContributorsFor(classList, result);
        classList = this.computeInterfaceOrder(classList);
        this.addContributorsFor(classList, result);
        return result;
    }

    protected List getContributors(Object object) {
        Class<?> objectClass = object.getClass();
        Object adapted = this.getAdaptedResource(object);
        if (adapted == null) {
            return this.getContributors(objectClass);
        }
        return this.getContributors(objectClass, adapted.getClass());
    }

    public boolean hasContributorsFor(Object object) {
        List contributors = this.getContributors(object);
        return contributors.size() > 0;
    }

    private void internalComputeInterfaceOrder(Class[] interfaces, List result, Map seen) {
        ArrayList<Class> newInterfaces = new ArrayList<Class>(seen.size());
        int i = 0;
        while (i < interfaces.length) {
            Class interfac = interfaces[i];
            if (seen.get(interfac) == null) {
                result.add(interfac);
                seen.put(interfac, interfac);
                newInterfaces.add(interfac);
            }
            ++i;
        }
        Iterator newList = newInterfaces.iterator();
        while (newList.hasNext()) {
            this.internalComputeInterfaceOrder(((Class)newList.next()).getInterfaces(), result, seen);
        }
    }

    public boolean isApplicableTo(IStructuredSelection selection, IObjectContributor contributor) {
        Iterator elements = selection.iterator();
        while (elements.hasNext()) {
            if (contributor.isApplicableTo(elements.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isApplicableTo(List list, IObjectContributor contributor) {
        Iterator elements = list.iterator();
        while (elements.hasNext()) {
            if (contributor.isApplicableTo(elements.next())) continue;
            return false;
        }
        return true;
    }

    public void registerContributor(IObjectContributor contributor, String targetType) {
        Vector<IObjectContributor> contributorList = (Vector<IObjectContributor>)this.contributors.get(targetType);
        if (contributorList == null) {
            contributorList = new Vector<IObjectContributor>(5);
            this.contributors.put(targetType, contributorList);
        }
        contributorList.addElement(contributor);
        this.flushLookup();
    }

    public void unregisterAllContributors() {
        this.contributors = new Hashtable(5);
        this.flushLookup();
    }

    public void unregisterContributor(IObjectContributor contributor, String targetType) {
        Vector contributorList = (Vector)this.contributors.get(targetType);
        if (contributorList == null) {
            return;
        }
        contributorList.removeElement(contributor);
        this.flushLookup();
    }

    public void unregisterContributors(String targetType) {
        this.contributors.remove(targetType);
        this.flushLookup();
    }

    protected List getContributors(Class objectClass, Class resourceClass) {
        List objectList = null;
        List<IObjectContributor> resourceList = null;
        if (this.objectLookup != null) {
            objectList = (List)this.objectLookup.get(objectClass);
        }
        if (this.adapterLookup != null) {
            resourceList = (ArrayList)this.adapterLookup.get(resourceClass);
        }
        if (objectList == null) {
            objectList = this.addContributorsFor(objectClass);
            if (objectList.size() == 0) {
                objectList = EMPTY_LIST;
            }
            this.cacheObjectLookup(objectClass, objectList);
        }
        if (resourceList == null) {
            List contributors = this.addContributorsFor(resourceClass);
            resourceList = new ArrayList(contributors.size());
            Iterator iterator = contributors.iterator();
            while (iterator.hasNext()) {
                IObjectContributor contributor = (IObjectContributor)iterator.next();
                if (!contributor.canAdapt()) continue;
                resourceList.add(contributor);
            }
            if (resourceList.size() == 0) {
                resourceList = EMPTY_LIST;
            }
            this.cacheAdapterLookup(resourceClass, resourceList);
        }
        ArrayList results = new ArrayList(objectList.size() + resourceList.size());
        results.addAll(objectList);
        results.addAll(resourceList);
        return results;
    }

    protected Object getAdaptedResource(Object object) {
        Class resourceClass = LegacyResourceSupport.getResourceClass();
        if (resourceClass == null) {
            return null;
        }
        if (resourceClass.isInstance(object)) {
            return null;
        }
        if (object instanceof IAdaptable) {
            Object result;
            Method m;
            IAdaptable adaptable = (IAdaptable)object;
            Class contributorResourceAdapterClass = LegacyResourceSupport.getIContributorResourceAdapterClass();
            if (contributorResourceAdapterClass == null) {
                return null;
            }
            Object resourceAdapter = adaptable.getAdapter(contributorResourceAdapterClass);
            if (resourceAdapter == null) {
                try {
                    Class c = LegacyResourceSupport.getDefaultContributorResourceAdapterClass();
                    m = c.getDeclaredMethod("getDefault", new Class[0]);
                    resourceAdapter = m.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    return null;
                }
            }
            try {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.runtime.IAdaptable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                m = contributorResourceAdapterClass.getDeclaredMethod("getAdaptedResource", classArray);
                result = m.invoke(resourceAdapter, adaptable);
            }
            catch (Exception e) {
                return null;
            }
            return result;
        }
        return null;
    }
}

