/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.commands.IMutableCommandHandlerService;
import org.eclipse.ui.contexts.IMutableContextActivationService;
import org.eclipse.ui.internal.commands.ActionHandler;

final class KeyBindingService
implements IKeyBindingService {
    private Map handlersByCommandId = new HashMap();
    private IMutableCommandHandlerService mutableCommandHandlerService;
    private IMutableContextActivationService mutableContextActivationService;

    KeyBindingService(IMutableCommandHandlerService mutableCommandHandlerService, IMutableContextActivationService mutableContextActivationService) {
        this.mutableCommandHandlerService = mutableCommandHandlerService;
        this.mutableContextActivationService = mutableContextActivationService;
    }

    public String[] getScopes() {
        Set scopes = this.mutableContextActivationService.getActiveContextIds();
        return scopes.toArray(new String[scopes.size()]);
    }

    public void setScopes(String[] scopes) {
        this.mutableContextActivationService.setActiveContextIds(new HashSet<String>(Arrays.asList(scopes)));
    }

    public void registerAction(IAction action) {
        String commandId = action.getActionDefinitionId();
        if (commandId != null) {
            this.handlersByCommandId.put(commandId, new ActionHandler(action));
            this.mutableCommandHandlerService.setHandlersByCommandId(this.handlersByCommandId);
        }
    }

    public void unregisterAction(IAction action) {
        String commandId = action.getActionDefinitionId();
        if (commandId != null) {
            this.handlersByCommandId.remove(commandId);
            this.mutableCommandHandlerService.setHandlersByCommandId(this.handlersByCommandId);
        }
    }
}

