/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.WorkbenchMessages;

public class IniFileReader {
    private static final Status OK_STATUS = new Status(0, "org.eclipse.ui", 0, "", null);
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final String NLS_TAG = "$nl$";
    private String featureId;
    private String pluginId;
    private String iniFilename;
    private String propertiesFilename;
    private String mappingsFilename;
    private Properties ini = null;
    private PropertyResourceBundle properties = null;
    private String[] mappings = null;
    private IPluginDescriptor pluginDescriptor = null;

    public IniFileReader(String featureId, String pluginId, String iniFilename, String propertiesFilename, String mappingsFilename) {
        if (featureId == null || pluginId == null || iniFilename == null) {
            throw new IllegalArgumentException();
        }
        this.featureId = featureId;
        this.pluginId = pluginId;
        this.iniFilename = iniFilename;
        this.propertiesFilename = propertiesFilename;
        this.mappingsFilename = mappingsFilename;
    }

    public IStatus load() {
        if (this.ini != null) {
            return OK_STATUS;
        }
        IPluginRegistry reg = Platform.getPluginRegistry();
        this.pluginDescriptor = reg.getPluginDescriptor(this.pluginId);
        if (this.pluginDescriptor == null) {
            String message = WorkbenchMessages.format("IniFileReader.MissingDesc", new Object[]{this.featureId});
            return new Status(4, "org.eclipse.ui", 0, message, null);
        }
        URL iniURL = null;
        IOException ioe = null;
        try {
            iniURL = this.pluginDescriptor.find(new Path(NLS_TAG).append(this.iniFilename));
            if (iniURL != null) {
                iniURL = Platform.resolve((URL)iniURL);
            }
        }
        catch (IOException e) {
            ioe = e;
        }
        if (iniURL == null) {
            String message = WorkbenchMessages.format("IniFileReader.OpenINIError", new Object[]{this.iniFilename});
            return new Status(4, "org.eclipse.ui", 0, message, (Throwable)ioe);
        }
        URL propertiesURL = null;
        if (this.propertiesFilename != null & this.propertiesFilename.length() > 0) {
            try {
                propertiesURL = this.pluginDescriptor.find(new Path(NLS_TAG).append(this.propertiesFilename));
                if (propertiesURL != null) {
                    propertiesURL = Platform.resolve((URL)propertiesURL);
                }
            }
            catch (IOException e) {
                String message = WorkbenchMessages.format("IniFileReader.OpenPropError", new Object[]{this.propertiesFilename});
                return new Status(4, "org.eclipse.ui", 0, message, (Throwable)e);
            }
        }
        URL mappingsURL = null;
        if (this.mappingsFilename != null && this.mappingsFilename.length() > 0) {
            try {
                mappingsURL = this.pluginDescriptor.find(new Path(NLS_TAG).append(this.mappingsFilename));
                if (mappingsURL != null) {
                    mappingsURL = Platform.resolve((URL)mappingsURL);
                }
            }
            catch (IOException e) {
                String message = WorkbenchMessages.format("IniFileReader.OpenMapError", new Object[]{this.mappingsFilename});
                return new Status(4, "org.eclipse.ui", 0, message, (Throwable)e);
            }
        }
        return this.load(iniURL, propertiesURL, mappingsURL);
    }

    public String getString(String key, boolean doNls, Hashtable runtimeMappings) {
        if (this.ini == null) {
            return null;
        }
        String value = this.ini.getProperty(key);
        if (value != null && doNls) {
            return this.getResourceString(value, runtimeMappings);
        }
        return value;
    }

    public ImageDescriptor getImage(String key) {
        if (this.ini == null) {
            return null;
        }
        URL url = this.getURL(key);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return null;
    }

    public URL getURL(String key) {
        if (this.ini == null) {
            return null;
        }
        URL url = null;
        String fileName = this.ini.getProperty(key);
        if (fileName != null) {
            if (this.pluginDescriptor == null) {
                return null;
            }
            url = this.pluginDescriptor.find((IPath)new Path(fileName));
        }
        return url;
    }

    public String getFeaturePluginLabel() {
        if (this.pluginDescriptor == null) {
            return null;
        }
        return this.pluginDescriptor.getLabel();
    }

    public String getProviderName() {
        if (this.pluginDescriptor == null) {
            return null;
        }
        return this.pluginDescriptor.getProviderName();
    }

    private String getResourceString(String value, Hashtable runtimeMappings) {
        String dflt;
        if (value == null) {
            return null;
        }
        String s = value.trim();
        if (!s.startsWith(KEY_PREFIX)) {
            return s;
        }
        if (s.startsWith(KEY_DOUBLE_PREFIX)) {
            return s.substring(1);
        }
        int ix = s.indexOf(" ");
        String key = ix == -1 ? s : s.substring(0, ix);
        String string = dflt = ix == -1 ? s : s.substring(ix + 1);
        if (this.properties == null) {
            return dflt;
        }
        String result = null;
        try {
            result = this.properties.getString(key.substring(1));
        }
        catch (MissingResourceException e) {
            return dflt;
        }
        if (runtimeMappings != null) {
            Enumeration e = runtimeMappings.keys();
            while (e.hasMoreElements()) {
                String keyValue = (String)e.nextElement();
                int i = result.indexOf(keyValue);
                if (i == -1) continue;
                String s1 = result.substring(0, i);
                String s2 = (String)runtimeMappings.get(keyValue);
                String s3 = result.substring(i + keyValue.length());
                result = String.valueOf(s1) + s2 + s3;
            }
        }
        if (result.indexOf(123) != -1) {
            result = MessageFormat.format(result, this.mappings);
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus load(URL iniURL, URL propertiesURL, URL mappingsURL) {
        block36: {
            block35: {
                block34: {
                    is = null;
                    try {
                        try {
                            is = iniURL.openStream();
                            this.ini = new Properties();
                            this.ini.load(is);
                        }
                        catch (IOException e) {
                            this.ini = null;
                            message = WorkbenchMessages.format("IniFileReader.ReadIniError", new Object[]{iniURL});
                            var9_12 = new Status(4, "org.eclipse.ui", 0, message, (Throwable)e);
                            var7_16 = null;
                            try {
                                if (is == null) return var9_12;
                                is.close();
                                return var9_12;
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            return var9_12;
                        }
                    }
                    catch (Throwable var8_23) {
                        var7_17 = null;
                        ** try [egrp 2[TRYBLOCK] [3 : 88->101)] { 
lbl25:
                        // 1 sources

                        if (is == null) throw var8_23;
                        is.close();
                        throw var8_23;
lbl28:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var8_23;
                    }
                    {
                        var7_18 = null;
                    }
                    ** try [egrp 2[TRYBLOCK] [3 : 88->101)] { 
lbl33:
                    // 1 sources

                    if (is != null) {
                        is.close();
                    }
                    break block34;
lbl36:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (propertiesURL == null) break block35;
                is = null;
                try {
                    try {
                        is = propertiesURL.openStream();
                        this.properties = new PropertyResourceBundle(is);
                    }
                    catch (IOException e) {
                        this.properties = null;
                        message = WorkbenchMessages.format("IniFileReader.ReadPropError", new Object[]{propertiesURL});
                        var9_13 = new Status(4, "org.eclipse.ui", 0, message, (Throwable)e);
                        var7_18 = null;
                        try {
                            if (is == null) return var9_13;
                            is.close();
                            return var9_13;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return var9_13;
                    }
                }
                catch (Throwable var8_24) {
                    var7_18 = null;
                    ** try [egrp 6[TRYBLOCK] [7 : 193->206)] { 
lbl63:
                    // 1 sources

                    if (is == null) throw var8_24;
                    is.close();
                    throw var8_24;
lbl66:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var8_24;
                }
                {
                    var7_18 = null;
                }
                ** try [egrp 6[TRYBLOCK] [7 : 193->206)] { 
lbl71:
                // 1 sources

                if (is != null) {
                    is.close();
                }
                break block35;
lbl74:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
            }
            bundle = null;
            if (mappingsURL == null) break block36;
            is = null;
            try {
                try {
                    is = mappingsURL.openStream();
                    bundle = new PropertyResourceBundle(is);
                }
                catch (IOException e) {
                    bundle = null;
                    message = WorkbenchMessages.format("IniFileReader.ReadMapError", new Object[]{mappingsURL});
                    var10_22 = new Status(4, "org.eclipse.ui", 0, message, (Throwable)e);
                    var8_25 = null;
                    try {
                        if (is == null) return var10_22;
                        is.close();
                        return var10_22;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return var10_22;
                }
            }
            catch (Throwable var9_14) {
                var8_26 = null;
                ** try [egrp 10[TRYBLOCK] [11 : 297->310)] { 
lbl102:
                // 1 sources

                if (is == null) throw var9_14;
                is.close();
                throw var9_14;
lbl105:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                throw var9_14;
            }
            {
                var8_27 = null;
            }
            ** try [egrp 10[TRYBLOCK] [11 : 297->310)] { 
lbl110:
            // 1 sources

            if (is != null) {
                is.close();
            }
            break block36;
lbl113:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
        }
        mappingsList = new ArrayList<String>();
        if (bundle != null) {
            found = true;
            i = 0;
            while (found) {
                try {
                    mappingsList.add(bundle.getString(Integer.toString(i)));
                }
                catch (MissingResourceException e) {
                    found = false;
                }
                ++i;
            }
        }
        this.mappings = mappingsList.toArray(new String[mappingsList.size()]);
        return IniFileReader.OK_STATUS;
    }
}

