/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.registry.EditorDescriptor;

public class EditorSite
extends PartSite
implements IEditorSite {
    static final int PROP_REUSE_EDITOR = -257;
    private EditorDescriptor desc;
    private boolean reuseEditor = true;
    private ListenerList propChangeListeners = new ListenerList(1);

    public EditorSite(IEditorPart editor, WorkbenchPage page, EditorDescriptor desc) {
        super(editor, page);
        if (desc != null) {
            this.desc = desc;
            if (desc.getConfigurationElement() != null) {
                this.setConfigurationElement(desc.getConfigurationElement());
            }
        }
    }

    public IEditorActionBarContributor getActionBarContributor() {
        EditorActionBars bars = (EditorActionBars)this.getActionBars();
        if (bars != null) {
            return bars.getEditorContributor();
        }
        return null;
    }

    public IEditorActionBarContributor getExtensionActionBarContributor() {
        EditorActionBars bars = (EditorActionBars)this.getActionBars();
        if (bars != null) {
            return bars.getExtensionContributor();
        }
        return null;
    }

    public IEditorPart getEditorPart() {
        return (IEditorPart)this.getPart();
    }

    public EditorDescriptor getEditorDescriptor() {
        return this.desc;
    }

    public boolean getReuseEditor() {
        return this.reuseEditor;
    }

    public void setReuseEditor(boolean reuse) {
        this.reuseEditor = reuse;
        this.firePropertyChange(-257);
    }

    protected String getInitialScopeId() {
        return "org.eclipse.ui.textEditorScope";
    }

    public void addPropertyListener(IPropertyListener l) {
        this.propChangeListeners.add((Object)l);
    }

    public void removePropertyListener(IPropertyListener l) {
        this.propChangeListeners.remove((Object)l);
    }

    private void firePropertyChange(final int propertyId) {
        Object[] array = this.propChangeListeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            final IPropertyListener l = (IPropertyListener)array[nX];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.propertyChanged(EditorSite.this, propertyId);
                }

                public void handleException(Throwable e) {
                    super.handleException(e);
                    EditorSite.this.propChangeListeners.remove((Object)l);
                }
            });
            ++nX;
        }
    }
}

