/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorActionBuilder;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorPresentation;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.EditorWorkbook;
import org.eclipse.ui.internal.MultiEditorInnerPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.editorsupport.ComponentSupport;
import org.eclipse.ui.internal.misc.ExternalEditor;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;
import org.eclipse.ui.part.MultiEditor;
import org.eclipse.ui.part.MultiEditorInput;

public class EditorManager {
    private EditorPresentation editorPresentation;
    private WorkbenchWindow window;
    private WorkbenchPage page;
    private Map actionCache = new HashMap();
    private MultiStatus closingEditorStatus = null;
    private static final String RESOURCES_TO_SAVE_MESSAGE = WorkbenchMessages.getString("EditorManager.saveResourcesMessage");
    private static final String SAVE_RESOURCES_TITLE = WorkbenchMessages.getString("EditorManager.saveResourcesTitle");
    static /* synthetic */ Class class$0;

    public EditorManager(WorkbenchWindow window, WorkbenchPage workbenchPage, EditorPresentation pres) {
        this.window = window;
        this.page = workbenchPage;
        this.editorPresentation = pres;
    }

    public void closeAll() {
        IEditorReference[] editors = this.editorPresentation.getEditors();
        this.editorPresentation.closeAllEditors();
        int i = 0;
        while (i < editors.length) {
            IEditorPart part = (IEditorPart)editors[i].getPart(false);
            if (part != null) {
                PartSite site = (PartSite)part.getSite();
                this.disposeEditorActionBars((EditorActionBars)site.getActionBars());
                site.dispose();
            }
            ++i;
        }
    }

    public void closeEditor(IEditorReference ref) {
        IEditorPart part;
        boolean createdStatus = false;
        if (this.closingEditorStatus == null) {
            createdStatus = true;
            this.closingEditorStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("EditorManager.unableToOpenEditors"), null);
        }
        if ((part = ref.getEditor(false)) != null) {
            EditorSite site;
            if (part instanceof MultiEditor) {
                IEditorPart[] innerEditors = ((MultiEditor)part).getInnerEditors();
                int i = 0;
                while (i < innerEditors.length) {
                    EditorSite site2 = (EditorSite)innerEditors[i].getEditorSite();
                    this.editorPresentation.closeEditor(innerEditors[i]);
                    this.disposeEditorActionBars((EditorActionBars)site2.getActionBars());
                    site2.dispose();
                    ++i;
                }
            } else {
                site = (EditorSite)part.getEditorSite();
                if (site.getPane() instanceof MultiEditorInnerPane) {
                    MultiEditorInnerPane pane = (MultiEditorInnerPane)site.getPane();
                    this.page.closeEditor((IEditorReference)pane.getParentPane().getPartReference(), true);
                    return;
                }
            }
            site = (EditorSite)part.getEditorSite();
            this.editorPresentation.closeEditor(part);
            this.disposeEditorActionBars((EditorActionBars)site.getActionBars());
            site.dispose();
        } else {
            this.editorPresentation.closeEditor(ref);
            ((Editor)ref).dispose();
        }
        if (createdStatus) {
            if (this.closingEditorStatus.getSeverity() == 4) {
                ErrorDialog.openError((Shell)this.window.getShell(), (String)WorkbenchMessages.getString("EditorManager.unableToRestoreEditorTitle"), null, (IStatus)this.closingEditorStatus, (int)6);
            }
            this.closingEditorStatus = null;
        }
    }

    private List collectDirtyEditors() {
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(3);
        IEditorReference[] editors = this.editorPresentation.getEditors();
        int i = 0;
        while (i < editors.length) {
            IEditorPart part = (IEditorPart)editors[i].getPart(false);
            if (part != null && part.isDirty()) {
                result.add(part);
            }
            ++i;
        }
        return result;
    }

    public boolean containsEditor(IEditorReference ref) {
        IEditorReference[] editors = this.editorPresentation.getEditors();
        int i = 0;
        while (i < editors.length) {
            if (ref == editors[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private EditorActionBars createEditorActionBars(EditorDescriptor desc) {
        EditorActionBuilder builder;
        String type = desc.getId();
        EditorActionBars actionBars = (EditorActionBars)this.actionCache.get(type);
        if (actionBars != null) {
            actionBars.addRef();
            return actionBars;
        }
        actionBars = new EditorActionBars((WWinActionBars)this.page.getActionBars(), type);
        actionBars.addRef();
        this.actionCache.put(type, actionBars);
        IEditorActionBarContributor contr = desc.createActionBarContributor();
        if (contr != null) {
            actionBars.setEditorContributor(contr);
            contr.init(actionBars, this.page);
        }
        if ((contr = (builder = new EditorActionBuilder()).readActionExtensions(desc, actionBars)) != null) {
            actionBars.setExtensionContributor(contr);
            contr.init(actionBars, this.page);
        }
        return actionBars;
    }

    private EditorActionBars createEmptyEditorActionBars() {
        String type = String.valueOf(System.currentTimeMillis());
        EditorActionBars actionBars = new EditorActionBars((WWinActionBars)this.page.getActionBars(), type);
        actionBars.addRef();
        this.actionCache.put(type, actionBars);
        return actionBars;
    }

    private void disposeEditorActionBars(EditorActionBars actionBars) {
        actionBars.removeRef();
        if (actionBars.getRef() <= 0) {
            String type = actionBars.getEditorType();
            this.actionCache.remove(type);
            actionBars.dispose();
        }
    }

    public IEditorPart findEditor(IEditorInput input) {
        IEditorReference[] editors = this.editorPresentation.getEditors();
        int i = 0;
        while (i < editors.length) {
            IEditorPart part = (IEditorPart)editors[i].getPart(false);
            if (part != null && input.equals(part.getEditorInput())) {
                return part;
            }
            ++i;
        }
        String name = input.getName();
        IPersistableElement persistable = input.getPersistable();
        if (name == null || persistable == null) {
            return null;
        }
        String id = persistable.getFactoryId();
        if (id == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < editors.length) {
            IEditorPart editor;
            Editor e = (Editor)editors[i2];
            if (name.equals(e.getName()) && id.equals(e.getFactoryId()) && (editor = e.getEditor(true)) != null && input.equals(editor.getEditorInput())) {
                return editor;
            }
            ++i2;
        }
        return null;
    }

    private Display getDisplay() {
        return this.window.getShell().getDisplay();
    }

    public int getEditorCount() {
        return this.editorPresentation.getEditors().length;
    }

    private IEditorRegistry getEditorRegistry() {
        return WorkbenchPlugin.getDefault().getEditorRegistry();
    }

    public IEditorPart[] getDirtyEditors() {
        List dirtyEditors = this.collectDirtyEditors();
        return dirtyEditors.toArray(new IEditorPart[dirtyEditors.size()]);
    }

    public IEditorReference[] getEditors() {
        return this.editorPresentation.getEditors();
    }

    public IEditorPart getVisibleEditor() {
        IEditorReference ref = this.editorPresentation.getVisibleEditor();
        if (ref == null) {
            return null;
        }
        return (IEditorPart)ref.getPart(true);
    }

    public boolean isSaveAllNeeded() {
        IEditorReference[] editors = this.editorPresentation.getEditors();
        int i = 0;
        while (i < editors.length) {
            IEditorReference ed = editors[i];
            if (ed.isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IEditorReference findReusableEditor(EditorDescriptor desc) {
        IEditorReference[] editors = this.page.getSortedEditors();
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean reuse = store.getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
        if (!reuse) {
            return null;
        }
        if (editors.length < this.page.getEditorReuseThreshold()) {
            return null;
        }
        IEditorReference dirtyEditor = null;
        int i = 0;
        while (i < editors.length) {
            IEditorReference editor = editors[i];
            if (!editor.isPinned()) {
                if (editor.isDirty()) {
                    if (dirtyEditor == null) {
                        dirtyEditor = editor;
                    }
                } else {
                    return editor;
                }
            }
            ++i;
        }
        if (dirtyEditor == null) {
            return null;
        }
        boolean reuseDirty = store.getBoolean("REUSE_DIRTY_EDITORS");
        if (!reuseDirty) {
            return null;
        }
        MessageDialog dialog = new MessageDialog(this.window.getShell(), WorkbenchMessages.getString("EditorManager.reuseEditorDialogTitle"), null, WorkbenchMessages.format("EditorManager.saveChangesQuestion", new String[]{dirtyEditor.getName()}), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, WorkbenchMessages.getString("EditorManager.openNewEditorLabel")}, 0);
        int result = dialog.open();
        if (result == 0) {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(dialog.getShell());
            pmd.open();
            dirtyEditor.getEditor(true).doSave(pmd.getProgressMonitor());
            pmd.close();
        } else if (result == 2 || result == -1) {
            return null;
        }
        return dirtyEditor;
    }

    public IEditorReference openEditor(String editorId, IEditorInput input, boolean setVisible) throws PartInitException {
        if (editorId == null || input == null) {
            throw new IllegalArgumentException();
        }
        IEditorRegistry reg = this.getEditorRegistry();
        EditorDescriptor desc = (EditorDescriptor)reg.findEditor(editorId);
        if (desc == null) {
            throw new PartInitException(WorkbenchMessages.format("EditorManager.unknownEditorIDMessage", new Object[]{editorId}));
        }
        IEditorReference result = this.openEditorFromDescriptor(new Editor(), desc, input);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IEditorReference openEditorFromDescriptor(IEditorReference ref, EditorDescriptor desc, IEditorInput input) throws PartInitException {
        IEditorReference result = ref;
        if (desc.isInternal()) {
            result = this.reuseInternalEditor(desc, input);
            if (result == null) {
                result = ref;
                this.openInternalEditor(ref, desc, input, true);
            }
        } else if (desc.getId().equals("org.eclipse.ui.systemInPlaceEditor")) {
            result = this.openSystemInPlaceEditor(ref, desc, input);
        } else if (desc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            IPathEditorInput pathInput = this.getPathEditorInput(input);
            if (pathInput == null) throw new PartInitException(WorkbenchMessages.getString("EditorManager.systemEditorError"));
            result = this.openSystemExternalEditor(pathInput.getPath());
        } else {
            if (!desc.isOpenExternal()) throw new IllegalStateException();
            result = this.openExternalEditor(desc, input);
        }
        Workbench wb = (Workbench)this.window.getWorkbench();
        wb.getEditorHistory().add(input, desc);
        return result;
    }

    private IEditorReference openExternalEditor(final EditorDescriptor desc, IEditorInput input) throws PartInitException {
        final CoreException[] ex = new CoreException[1];
        final IPathEditorInput pathInput = this.getPathEditorInput(input);
        if (pathInput == null) {
            throw new PartInitException(WorkbenchMessages.format("EditorManager.errorOpeningExternalEditor", new Object[]{desc.getFileName(), desc.getId()}));
        }
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    if (desc.getLauncher() != null) {
                        Object launcher = WorkbenchPlugin.createExtension(desc.getConfigurationElement(), "launcher");
                        ((IEditorLauncher)launcher).open(pathInput.getPath());
                    } else {
                        ExternalEditor oEditor = new ExternalEditor(pathInput.getPath(), desc);
                        oEditor.open();
                    }
                }
                catch (CoreException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw new PartInitException(WorkbenchMessages.format("EditorManager.errorOpeningExternalEditor", new Object[]{desc.getFileName(), desc.getId()}), ex[0]);
        }
        return null;
    }

    private IEditorReference[] openMultiEditor(IEditorReference ref, MultiEditor part, EditorDescriptor desc, MultiEditorInput input, boolean setVisible) throws PartInitException {
        String[] editorArray = input.getEditors();
        IEditorInput[] inputArray = input.getInput();
        EditorDescriptor[] descArray = new EditorDescriptor[editorArray.length];
        IEditorReference[] refArray = new IEditorReference[editorArray.length];
        IEditorPart[] partArray = new IEditorPart[editorArray.length];
        IEditorRegistry reg = this.getEditorRegistry();
        int i = 0;
        while (i < editorArray.length) {
            EditorDescriptor innerDesc = (EditorDescriptor)reg.findEditor(editorArray[i]);
            if (innerDesc == null) {
                throw new PartInitException(WorkbenchMessages.format("EditorManager.unknownEditorIDMessage", new Object[]{editorArray[i]}));
            }
            descArray[i] = innerDesc;
            partArray[i] = this.createPart(descArray[i]);
            refArray[i] = new Editor();
            this.createSite(partArray[i], descArray[i], inputArray[i]);
            ((Editor)refArray[i]).setPart(partArray[i]);
            ++i;
        }
        part.setChildren(partArray);
        return refArray;
    }

    private void createEditorTab(final IEditorReference ref, final EditorDescriptor desc, final IEditorInput input, final boolean setVisible) throws PartInitException {
        IEditorReference[] refs = this.editorPresentation.getEditors();
        int i = 0;
        while (i < refs.length) {
            if (ref == refs[i]) {
                return;
            }
            ++i;
        }
        final PartInitException[] ex = new PartInitException[1];
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    IEditorPart part;
                    if (input != null && (part = ref.getEditor(false)) != null && part instanceof MultiEditor) {
                        IEditorReference[] refArray = EditorManager.this.openMultiEditor(ref, (MultiEditor)part, desc, (MultiEditorInput)input, setVisible);
                        EditorManager.this.editorPresentation.openEditor(ref, refArray, setVisible);
                        return;
                    }
                    EditorManager.this.editorPresentation.openEditor(ref, setVisible);
                }
                catch (PartInitException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSite(IEditorPart part, EditorDescriptor desc, IEditorInput input) throws PartInitException {
        EditorSite site = new EditorSite(part, this.page, desc);
        String label = part.getTitle();
        try {
            UIStats.start(UIStats.INIT_PART, label);
            part.init(site, input);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            UIStats.end(UIStats.INIT_PART, label);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        UIStats.end(UIStats.INIT_PART, label);
        if (part.getSite() != site) {
            throw new PartInitException(WorkbenchMessages.format("EditorManager.siteIncorrect", new Object[]{desc.getId()}));
        }
        if (desc != null) {
            site.setActionBars(this.createEditorActionBars(desc));
            return;
        }
        site.setActionBars(this.createEmptyEditorActionBars());
    }

    private IEditorReference reuseInternalEditor(EditorDescriptor desc, IEditorInput input) throws PartInitException {
        IEditorReference reusableEditorRef = this.findReusableEditor(desc);
        if (reusableEditorRef != null) {
            IEditorPart reusableEditor = reusableEditorRef.getEditor(false);
            if (reusableEditor == null) {
                Editor result = new Editor();
                this.openInternalEditor(result, desc, input, true);
                this.page.closeEditor(reusableEditorRef, false);
                return result;
            }
            EditorSite site = (EditorSite)reusableEditor.getEditorSite();
            EditorDescriptor oldDesc = site.getEditorDescriptor();
            if (desc.getId().equals(oldDesc.getId()) && reusableEditor instanceof IReusableEditor) {
                Workbench wb = (Workbench)this.window.getWorkbench();
                this.editorPresentation.moveEditor(reusableEditor, -1);
                wb.getEditorHistory().add(reusableEditor.getEditorInput(), site.getEditorDescriptor());
                this.page.reuseEditor((IReusableEditor)reusableEditor, input);
                return reusableEditorRef;
            }
            Editor ref = new Editor();
            this.openInternalEditor(ref, desc, input, true);
            reusableEditor.getEditorSite().getPage().closeEditor(reusableEditor, false);
            return ref;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openInternalEditor(IEditorReference ref, EditorDescriptor desc, IEditorInput input, boolean setVisible) throws PartInitException {
        IEditorPart editor;
        String label = ref.getName();
        if (label == null) {
            label = desc.getLabel();
        }
        try {
            UIStats.start(UIStats.CREATE_PART, label);
            editor = this.createPart(desc);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            UIStats.end(UIStats.CREATE_PART, label);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        UIStats.end(UIStats.CREATE_PART, label);
        this.createSite(editor, desc, input);
        ((Editor)ref).setPart(editor);
        this.createEditorTab(ref, desc, input, setVisible);
    }

    private IEditorPart createPart(final EditorDescriptor desc) throws PartInitException {
        final IEditorPart[] editor = new IEditorPart[1];
        final Throwable[] ex = new Throwable[1];
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws CoreException {
                editor[0] = (IEditorPart)WorkbenchPlugin.createExtension(desc.getConfigurationElement(), "class");
            }

            public void handleException(Throwable e) {
                ex[0] = e;
            }
        });
        if (ex[0] != null) {
            throw new PartInitException(WorkbenchMessages.format("EditorManager.unableToInstantiate", new Object[]{desc.getId(), ex[0]}));
        }
        return editor[0];
    }

    private IEditorReference openSystemExternalEditor(final IPath location) throws PartInitException {
        if (location == null) {
            throw new IllegalArgumentException();
        }
        final boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (location != null) {
                    result[0] = Program.launch((String)location.toOSString());
                }
            }
        });
        if (!result[0]) {
            throw new PartInitException(WorkbenchMessages.format("EditorManager.unableToOpenExternalEditor", new Object[]{location}));
        }
        return null;
    }

    private IEditorReference openSystemInPlaceEditor(IEditorReference ref, EditorDescriptor desc, IEditorInput input) throws PartInitException {
        IEditorPart cEditor = ComponentSupport.getSystemInPlaceEditor();
        if (cEditor == null) {
            return null;
        }
        this.createSite(cEditor, desc, input);
        ((Editor)ref).setPart(cEditor);
        this.createEditorTab(ref, desc, input, true);
        return ref;
    }

    private ImageDescriptor findImage(EditorDescriptor desc, IPath path) {
        if (desc == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        if (desc.isOpenExternal() && path != null) {
            return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(path.toOSString());
        }
        return desc.getImageDescriptor();
    }

    public IStatus restoreState(IMemento memento) {
        final MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("EditorManager.problemsRestoringEditors"), null);
        final String[] activeWorkbookID = new String[1];
        final ArrayList<Editor> visibleEditors = new ArrayList<Editor>(5);
        final IEditorPart[] activeEditor = new IEditorPart[1];
        final ArrayList<String> errorWorkbooks = new ArrayList<String>(1);
        IMemento areaMem = memento.getChild("editorArea");
        if (areaMem != null) {
            result.add(this.editorPresentation.restoreState(areaMem));
            activeWorkbookID[0] = areaMem.getString("activeWorkbook");
        }
        IMemento[] editorMems = memento.getChildren("editor");
        int x = 0;
        while (x < editorMems.length) {
            IMemento editorMem = editorMems[x];
            String strFocus = editorMem.getString("focus");
            boolean visibleEditor = "true".equals(strFocus);
            if (visibleEditor) {
                Editor e = new Editor();
                e.setPinned("true".equals(editorMem.getString("pinned")));
                visibleEditors.add(e);
                this.page.addPart(e);
                result.add(this.restoreEditor(e, editorMem));
                IEditorPart editor = (IEditorPart)e.getPart(true);
                if (editor != null) {
                    String strActivePart = editorMem.getString("activePart");
                    if ("true".equals(strActivePart)) {
                        activeEditor[0] = editor;
                    }
                } else {
                    this.page.closeEditor(e, false);
                    visibleEditors.remove(e);
                    errorWorkbooks.add(editorMem.getString("workbook"));
                }
            } else {
                String editorTitle = editorMem.getString("title");
                String editorName = editorMem.getString("name");
                String editorID = editorMem.getString("id");
                boolean pinned = "true".equals(editorMem.getString("pinned"));
                IMemento inputMem = editorMem.getChild("input");
                String factoryID = null;
                if (inputMem != null) {
                    factoryID = inputMem.getString("factoryID");
                }
                if (factoryID == null) {
                    WorkbenchPlugin.log("Unable to restore editor - no input factory ID.");
                }
                if (editorTitle == null) {
                    Editor e = new Editor();
                    e.setPinned("true".equals(editorMem.getString("pinned")));
                    result.add(this.restoreEditor(e, editorMem));
                    IEditorPart editor = (IEditorPart)e.getPart(true);
                    if (editor == null) {
                        this.page.closeEditor(e, false);
                        visibleEditors.remove(e);
                        errorWorkbooks.add(editorMem.getString("workbook"));
                    }
                    this.page.addPart(e);
                } else {
                    String workbookID = editorMem.getString("workbook");
                    this.editorPresentation.setActiveEditorWorkbookFromID(workbookID);
                    EditorDescriptor desc = null;
                    if (editorID != null) {
                        IEditorRegistry reg = WorkbenchPlugin.getDefault().getEditorRegistry();
                        desc = (EditorDescriptor)reg.findEditor(editorID);
                    }
                    String location = editorMem.getString("path");
                    Path path = null;
                    if (location != null) {
                        path = new Path(location);
                    }
                    ImageDescriptor iDesc = this.findImage(desc, (IPath)path);
                    String tooltip = editorMem.getString("tooltip");
                    if (tooltip == null) {
                        tooltip = "";
                    }
                    Editor e = new Editor(editorID, editorMem, editorName, editorTitle, tooltip, iDesc, factoryID, pinned);
                    this.page.addPart(e);
                    try {
                        this.createEditorTab(e, null, null, false);
                    }
                    catch (PartInitException ex) {
                        result.add(ex.getStatus());
                    }
                }
            }
            ++x;
        }
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                int i = 0;
                while (i < visibleEditors.size()) {
                    EditorManager.this.setVisibleEditor((IEditorReference)visibleEditors.get(i), false);
                    ++i;
                }
                Iterator iter = errorWorkbooks.iterator();
                while (iter.hasNext()) {
                    iter.next();
                    EditorManager.this.editorPresentation.setActiveEditorWorkbookFromID(activeWorkbookID[0]);
                    EditorManager.this.editorPresentation.fixVisibleEditor();
                }
                if (activeWorkbookID[0] != null) {
                    EditorManager.this.editorPresentation.setActiveEditorWorkbookFromID(activeWorkbookID[0]);
                }
                if (activeEditor[0] != null) {
                    EditorManager.this.page.activate(activeEditor[0]);
                }
            }

            public void handleException(Throwable e) {
                result.add((IStatus)new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.getString("EditorManager.exceptionRestoringEditor"), e));
            }
        });
        return result;
    }

    public IStatus restoreEditor(final Editor ref, final IMemento editorMem) {
        final IStatus[] result = new IStatus[1];
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                result[0] = EditorManager.this.busyRestoreEditor(ref, editorMem);
            }
        });
        return result[0];
    }

    public IStatus busyRestoreEditor(final Editor ref, final IMemento editorMem) {
        final IStatus[] result = new IStatus[1];
        Platform.run((ISafeRunnable)new SafeRunnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                IAdaptable input;
                String label;
                String factoryID;
                block12: {
                    block13: {
                        block11: {
                            IMemento inputMem = editorMem.getChild("input");
                            factoryID = null;
                            if (inputMem != null) {
                                factoryID = inputMem.getString("factoryID");
                            }
                            if (factoryID == null) {
                                WorkbenchPlugin.log("Unable to restore editor - no input factory ID.");
                                result[0] = EditorManager.this.unableToCreateEditor(editorMem, null);
                                return;
                            }
                            label = ref.getName() != null ? ref.getName() : factoryID;
                            try {
                                UIStats.start(UIStats.CREATE_PART_INPUT, label);
                                IElementFactory factory = PlatformUI.getWorkbench().getElementFactory(factoryID);
                                if (factory == null) {
                                    WorkbenchPlugin.log("Unable to restore editor - cannot instantiate input element factory: " + factoryID);
                                    result[0] = EditorManager.this.unableToCreateEditor(editorMem, null);
                                    Object var6_5 = null;
                                    break block11;
                                }
                                input = factory.createElement(inputMem);
                                if (input != null) break block12;
                                WorkbenchPlugin.log("Unable to restore editor - createElement returned null for input element factory: " + factoryID);
                                result[0] = EditorManager.this.unableToCreateEditor(editorMem, null);
                                break block13;
                            }
                            catch (Throwable throwable) {
                                Object var6_7 = null;
                                UIStats.end(UIStats.CREATE_PART_INPUT, label);
                                throw throwable;
                            }
                        }
                        UIStats.end(UIStats.CREATE_PART_INPUT, label);
                        return;
                    }
                    Object var6_6 = null;
                    UIStats.end(UIStats.CREATE_PART_INPUT, label);
                    return;
                }
                Object var6_8 = null;
                UIStats.end(UIStats.CREATE_PART_INPUT, label);
                if (!(input instanceof IEditorInput)) {
                    WorkbenchPlugin.log("Unable to restore editor - createElement result is not an IEditorInput for input element factory: " + factoryID);
                    result[0] = EditorManager.this.unableToCreateEditor(editorMem, null);
                    return;
                }
                IEditorInput editorInput = (IEditorInput)input;
                String editorID = editorMem.getString("id");
                EditorDescriptor desc = null;
                if (editorID != null) {
                    IEditorRegistry reg = WorkbenchPlugin.getDefault().getEditorRegistry();
                    desc = (EditorDescriptor)reg.findEditor(editorID);
                }
                if (desc == null) {
                    WorkbenchPlugin.log("Unable to restore editor - no editor descriptor for id: " + editorID);
                    result[0] = EditorManager.this.unableToCreateEditor(editorMem, null);
                    return;
                }
                try {
                    String workbookID = editorMem.getString("workbook");
                    EditorManager.this.editorPresentation.setActiveEditorWorkbookFromID(workbookID);
                    EditorManager.this.openInternalEditor(ref, desc, editorInput, false);
                    ref.getPane().createChildControl();
                    ((EditorPane)ref.getPane()).getWorkbook().updateEditorTab(ref);
                    return;
                }
                catch (PartInitException e) {
                    WorkbenchPlugin.log("Exception creating editor: " + e.getMessage());
                    result[0] = EditorManager.this.unableToCreateEditor(editorMem, (Throwable)((Object)e));
                }
            }

            public void handleException(Throwable e) {
                result[0] = EditorManager.this.unableToCreateEditor(editorMem, e);
            }
        });
        if (result[0] != null) {
            return result[0];
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    private IStatus unableToCreateEditor(IMemento editorMem, Throwable t) {
        String name = editorMem.getString("name");
        return new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("EditorManager.unableToCreateEditor", new String[]{name}), t);
    }

    private static boolean runProgressMonitorOperation(String opName, final IRunnableWithProgress progressOp, IWorkbenchWindow window) {
        IWorkbenchWindow ctx = window instanceof ApplicationWindow ? window : new ProgressMonitorDialog(window.getShell());
        final boolean[] wasCanceled = new boolean[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                progressOp.run(monitor);
                wasCanceled[0] = monitor.isCanceled();
            }
        };
        try {
            ctx.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            String title = WorkbenchMessages.format("EditorManager.operationFailed", new Object[]{opName});
            Throwable targetExc = e.getTargetException();
            WorkbenchPlugin.log(title, (IStatus)new Status(2, "org.eclipse.ui", 0, title, targetExc));
            MessageDialog.openError((Shell)window.getShell(), (String)WorkbenchMessages.getString("Error"), (String)(String.valueOf(title) + ':' + targetExc.getMessage()));
        }
        catch (InterruptedException e) {
            wasCanceled[0] = true;
        }
        return !wasCanceled[0];
    }

    public boolean saveAll(boolean confirm, boolean closing) {
        List dirtyEditors = this.collectDirtyEditors();
        if (dirtyEditors.size() == 0) {
            return true;
        }
        return EditorManager.saveAll(dirtyEditors, confirm, this.window);
    }

    public static boolean saveAll(List dirtyEditors, boolean confirm, IWorkbenchWindow window) {
        if (confirm) {
            AdaptableList input = new AdaptableList(dirtyEditors);
            ListSelectionDialog dlg = new ListSelectionDialog(window.getShell(), input, (IStructuredContentProvider)new BaseWorkbenchContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), RESOURCES_TO_SAVE_MESSAGE);
            dlg.setInitialSelections(dirtyEditors.toArray(new Object[dirtyEditors.size()]));
            dlg.setTitle(SAVE_RESOURCES_TITLE);
            int result = dlg.open();
            if (result == 1) {
                return false;
            }
            dirtyEditors = Arrays.asList(dlg.getResult());
            if (dirtyEditors == null) {
                return false;
            }
            if (dirtyEditors.size() == 0) {
                return true;
            }
        }
        final List<Object> finalEditors = dirtyEditors;
        IRunnableWithProgress progressOp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
                monitorWrap.beginTask("", finalEditors.size());
                Iterator iterator = finalEditors.iterator();
                while (iterator.hasNext()) {
                    IEditorPart part = (IEditorPart)iterator.next();
                    part.doSave((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitorWrap, 1));
                    if (monitorWrap.isCanceled()) break;
                }
                monitorWrap.done();
            }
        };
        return EditorManager.runProgressMonitorOperation(WorkbenchMessages.getString("Save_All"), progressOp, window);
    }

    public boolean savePart(final ISaveablePart saveable, IWorkbenchPart part, boolean confirm) {
        if (!saveable.isDirty()) {
            return true;
        }
        if (confirm) {
            String message = WorkbenchMessages.format("EditorManager.saveChangesQuestion", new Object[]{part.getTitle()});
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            MessageDialog d = new MessageDialog(this.window.getShell(), WorkbenchMessages.getString("Save_Resource"), null, message, 3, buttons, 0);
            int choice = d.open();
            switch (choice) {
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        IRunnableWithProgress progressOp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
                saveable.doSave((IProgressMonitor)monitorWrap);
            }
        };
        return EditorManager.runProgressMonitorOperation(WorkbenchMessages.getString("Save"), progressOp, this.window);
    }

    public boolean saveEditor(IEditorPart part, boolean confirm) {
        return this.savePart(part, part, confirm);
    }

    public IStatus saveState(final IMemento memento) {
        final MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("EditorManager.problemsSavingEditors"), null);
        IMemento editorAreaMem = memento.createChild("editorArea");
        result.add(this.editorPresentation.saveState(editorAreaMem));
        editorAreaMem.putString("activeWorkbook", this.editorPresentation.getActiveEditorWorkbookID());
        ArrayList workbooks = this.editorPresentation.getWorkbooks();
        Iterator iter = workbooks.iterator();
        while (iter.hasNext()) {
            EditorWorkbook workbook = (EditorWorkbook)iter.next();
            EditorPane[] editorPanes = workbook.getEditors();
            int i = 0;
            while (i < editorPanes.length) {
                IEditorReference editorReference = editorPanes[i].getEditorReference();
                final IEditorPart editor = editorReference.getEditor(false);
                if (editor == null) {
                    Editor e = (Editor)editorReference;
                    if (e.getMemento() != null) {
                        IMemento editorMem = memento.createChild("editor");
                        editorMem.putMemento(e.getMemento());
                    }
                } else {
                    final EditorSite site = (EditorSite)editor.getEditorSite();
                    if (!(site.getPane() instanceof MultiEditorInnerPane)) {
                        Platform.run((ISafeRunnable)new SafeRunnable(){

                            public void run() {
                                IPathEditorInput pathInput;
                                IEditorInput input = editor.getEditorInput();
                                IPersistableElement persistable = input.getPersistable();
                                if (persistable == null) {
                                    return;
                                }
                                IMemento editorMem = memento.createChild("editor");
                                editorMem.putString("title", editor.getTitle());
                                editorMem.putString("name", input.getName());
                                editorMem.putString("id", editor.getSite().getId());
                                editorMem.putString("tooltip", editor.getTitleToolTip());
                                if (!site.getReuseEditor()) {
                                    editorMem.putString("pinned", "true");
                                }
                                EditorPane editorPane = (EditorPane)((EditorSite)editor.getEditorSite()).getPane();
                                editorMem.putString("workbook", editorPane.getWorkbook().getID());
                                if (editor == EditorManager.this.page.getActivePart()) {
                                    editorMem.putString("activePart", "true");
                                }
                                if (editorPane == editorPane.getWorkbook().getVisibleEditor()) {
                                    editorMem.putString("focus", "true");
                                }
                                if ((pathInput = EditorManager.this.getPathEditorInput(input)) != null) {
                                    IPath path = pathInput.getPath();
                                    editorMem.putString("path", path.toString());
                                }
                                IMemento inputMem = editorMem.createChild("input");
                                inputMem.putString("factoryID", persistable.getFactoryId());
                                persistable.saveState(inputMem);
                            }

                            public void handleException(Throwable e) {
                                result.add((IStatus)new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("EditorManager.unableToSaveEditor", new String[]{editor.getTitle()}), e));
                            }
                        });
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public boolean setVisibleEditor(IEditorReference newEd, boolean setFocus) {
        return this.editorPresentation.setVisibleEditor(newEd, setFocus);
    }

    private IPathEditorInput getPathEditorInput(IEditorInput input) {
        if (input instanceof IPathEditorInput) {
            return (IPathEditorInput)input;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.IPathEditorInput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IPathEditorInput)input.getAdapter(clazz);
    }

    private class Editor
    extends WorkbenchPartReference
    implements IEditorReference {
        private IMemento editorMemento;
        private String name;
        private String factoryId;
        private boolean pinned = false;

        Editor(String id, IMemento memento, String name, String title, String tooltip, ImageDescriptor desc, String factoryId, boolean pinned) {
            this.init(id, title, tooltip, desc);
            this.editorMemento = memento;
            this.name = name;
            this.factoryId = factoryId;
            this.pinned = pinned;
            if (this.name == null) {
                this.name = title;
            }
        }

        Editor() {
        }

        public String getFactoryId() {
            IEditorPart editor = this.getEditor(false);
            if (editor != null) {
                IPersistableElement persistable = editor.getEditorInput().getPersistable();
                if (persistable != null) {
                    return persistable.getFactoryId();
                }
                return null;
            }
            return this.factoryId;
        }

        public String getName() {
            if (this.part != null) {
                return this.getEditor(false).getEditorInput().getName();
            }
            return this.name;
        }

        public String getRegisteredName() {
            if (this.part != null) {
                return this.part.getSite().getRegisteredName();
            }
            return this.getName();
        }

        public IWorkbenchPart getPart(boolean restore) {
            return this.getEditor(restore);
        }

        public IEditorPart getEditor(boolean restore) {
            if (this.part != null) {
                return (IEditorPart)this.part;
            }
            if (!restore || this.editorMemento == null) {
                return null;
            }
            IStatus status = EditorManager.this.restoreEditor(this, this.editorMemento);
            Workbench workbench = (Workbench)EditorManager.this.window.getWorkbench();
            if (status.getSeverity() == 4) {
                this.editorMemento = null;
                EditorManager.this.page.closeEditor(this, false);
                if (EditorManager.this.closingEditorStatus != null) {
                    EditorManager.this.closingEditorStatus.add(status);
                } else if (!workbench.isStarting()) {
                    ErrorDialog.openError((Shell)EditorManager.this.window.getShell(), (String)WorkbenchMessages.getString("EditorManager.unableToRestoreEditorTitle"), (String)WorkbenchMessages.format("EditorManager.unableToRestoreEditorMessage", new String[]{this.getName()}), (IStatus)status, (int)6);
                }
            }
            this.setPane(this.getPane());
            this.releaseReferences();
            return (IEditorPart)this.part;
        }

        public void releaseReferences() {
            super.releaseReferences();
            this.editorMemento = null;
            this.name = null;
            this.factoryId = null;
        }

        public void setPart(IWorkbenchPart part) {
            super.setPart(part);
            if (part == null) {
                return;
            }
            EditorSite site = (EditorSite)part.getSite();
            if (site != null) {
                site.setReuseEditor(!this.pinned);
            }
        }

        public IMemento getMemento() {
            return this.editorMemento;
        }

        public boolean isDirty() {
            if (this.part == null) {
                return false;
            }
            return ((IEditorPart)this.part).isDirty();
        }

        public boolean isPinned() {
            if (this.part != null) {
                return !((EditorSite)((IEditorPart)this.part).getEditorSite()).getReuseEditor();
            }
            return this.pinned;
        }

        public void setPinned(boolean pinned) {
            this.pinned = pinned;
        }

        public IWorkbenchPage getPage() {
            return EditorManager.this.page;
        }

        public void dispose() {
            super.dispose();
            this.editorMemento = null;
        }
    }
}

