/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.TabbedEditorWorkbook;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;

public class EditorList {
    private WorkbenchWindow window;
    private TabbedEditorWorkbook workbook;
    private Table editorsTable;
    private static List editorListViews = new ArrayList();
    private List elements = new ArrayList();
    private SaveAction saveAction;
    private CloseAction closeAction;
    private SelectionAction selectCleanAction;
    private SelectionAction InvertSelectionAction;
    private SelectionAction selectAllAction;
    private FullNameAction fullNameAction;
    private SortAction nameSortAction;
    private SortAction MRUSortAction;
    private SetScopeAction windowScopeAction;
    private SetScopeAction pageScopeAction;
    private SetScopeAction tabGroupScopeAction;
    private boolean dropDown;
    private static int sortOrder;
    private static int listScope;
    private static boolean displayFullPath;
    private static Collator collator;
    private static final int SELECT_ALL = 0;
    private static final int INVERT_SELECTION = 1;
    private static final int SELECT_CLEAN = 2;
    private static final int NAME_SORT = 0;
    private static final int MRU_SORT = 1;
    private static final int SET_WINDOW_SCOPE = 0;
    private static final int SET_PAGE_SCOPE = 1;
    private static final int SET_TAB_GROUP_SCOPE = 2;
    private static final String editorListData = "editorListData";
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int property) {
            if ((property == 257 || property == 1) && source instanceof IEditorPart) {
                EditorSite site = (EditorSite)((IEditorPart)source).getEditorSite();
                IEditorReference ref = (IEditorReference)site.getPane().getPartReference();
                TableItem[] items = EditorList.this.editorsTable.getItems();
                int i = 0;
                while (i < items.length) {
                    Adapter editor = (Adapter)items[i].getData(EditorList.editorListData);
                    if (editor.editorRef == ref) {
                        EditorList.this.updateItem(items[i], editor);
                    }
                    ++i;
                }
            }
        }
    };
    private IPartListener2 partListener = new IPartListener2(){
        int counter = 0;

        private void updateEditorList(IWorkbenchPartReference ref) {
            if (ref instanceof IEditorReference) {
                Display display = EditorList.this.window.getShell().getDisplay();
                int TIMER_INTERVAL = 100;
                ++this.counter;
                display.timerExec(100, new Runnable(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        --this.this$1.counter;
                        if (this.this$1.counter == 0 && EditorList.access$0(2.access$0(this.this$1)) != null) {
                            EditorList.access$3(2.access$0(this.this$1));
                            EditorList.access$4(2.access$0(this.this$1));
                        }
                    }
                });
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
            this.updateEditorList(ref);
        }

        public void partActivated(IWorkbenchPartReference ref) {
            this.updateEditorList(ref);
        }

        public void partClosed(IWorkbenchPartReference ref) {
            this.updateEditorList(ref);
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
            this.updateEditorList(ref);
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        static /* synthetic */ EditorList access$0(2 var0) {
            return var0.EditorList.this;
        }
    };

    static {
        collator = Collator.getInstance();
    }

    public EditorList(IWorkbenchWindow window, TabbedEditorWorkbook workbook) {
        this.window = (WorkbenchWindow)window;
        this.workbook = workbook;
        listScope = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("EDITORLIST_SELECTION_SCOPE");
        sortOrder = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("EDITORLIST_SORT_CRITERIA");
        displayFullPath = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("EDITORLIST_DISPLAY_FULL_NAME");
        boolean bl = this.dropDown = workbook != null;
        if (!this.dropDown) {
            window.getPartService().addPartListener(this.partListener);
            editorListViews.add(this);
        }
        this.saveAction = new SaveAction();
        this.closeAction = new CloseAction();
        this.selectCleanAction = new SelectionAction(2);
        this.InvertSelectionAction = new SelectionAction(1);
        this.selectAllAction = new SelectionAction(0);
        this.fullNameAction = new FullNameAction();
        this.nameSortAction = new SortAction(0);
        this.MRUSortAction = new SortAction(1);
        this.windowScopeAction = new SetScopeAction(0);
        this.pageScopeAction = new SetScopeAction(1);
        this.tabGroupScopeAction = new SetScopeAction(2);
    }

    public Control createControl(Composite parent) {
        this.editorsTable = new Table(parent, 770);
        this.updateItems();
        this.editorsTable.pack();
        this.editorsTable.setFocus();
        MenuManager menuMgr = new MenuManager("#PopUp");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EditorList.this.setCheckedMenuItems();
                EditorList.this.fillContextMenu(manager);
            }
        });
        this.editorsTable.setMenu(menuMgr.createContextMenu((Control)this.editorsTable));
        this.editorsTable.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    EditorList.this.destroyControl();
                }
                if (e.character == ' ' || e.character == '\r') {
                    EditorList.this.handleSelectionEvent(true);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.editorsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if ((e.stateMask & 0x40000) != 0 || (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (e.button != 3) {
                    EditorList.this.handleSelectionEvent(true);
                }
            }
        });
        return this.editorsTable;
    }

    public void dispose() {
        this.editorsTable = null;
        editorListViews.remove(this);
        this.elements = new ArrayList();
        this.getAllEditors(this.elements);
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Adapter e = (Adapter)iterator.next();
            e.editorRef.removePropertyListener(this.propertyListener);
        }
        this.window.getPartService().removePartListener(this.partListener);
    }

    public void destroyControl() {
        if (this.dropDown && this.editorsTable != null) {
            Composite parent = this.editorsTable.getParent();
            parent.dispose();
            this.dispose();
        }
    }

    public Control getControl() {
        return this.editorsTable;
    }

    public int getItemCount() {
        return this.editorsTable.getItemCount();
    }

    private void notifyEditorListViews() {
        Iterator iterator = editorListViews.iterator();
        while (iterator.hasNext()) {
            EditorList editorList = (EditorList)iterator.next();
            if (editorList == this) continue;
            editorList.updateItems();
        }
    }

    private void handleSelectionEvent(boolean mouseEvent) {
        TableItem[] selection = this.editorsTable.getSelection();
        if (selection.length > 0) {
            boolean enableSaveAction = false;
            int i = 0;
            while (i < selection.length) {
                Adapter editor = (Adapter)selection[i].getData(editorListData);
                if (editor.isDirty()) {
                    enableSaveAction = true;
                    break;
                }
                ++i;
            }
            this.saveAction.setEnabled(enableSaveAction);
            this.closeAction.setEnabled(true);
        } else {
            this.saveAction.setEnabled(false);
            this.closeAction.setEnabled(false);
        }
        if (selection.length == 1 && mouseEvent) {
            Adapter a = (Adapter)selection[0].getData(editorListData);
            this.destroyControl();
            a.activate(this.dropDown);
        }
        this.notifyEditorListViews();
    }

    private void setCheckedMenuItems() {
        this.fullNameAction.setChecked(displayFullPath);
        this.nameSortAction.setChecked(sortOrder == 0);
        this.MRUSortAction.setChecked(sortOrder == 1);
        this.windowScopeAction.setChecked(listScope == 0);
        this.pageScopeAction.setChecked(listScope == 1);
        if (this.dropDown) {
            this.tabGroupScopeAction.setChecked(listScope == 2);
        } else {
            this.tabGroupScopeAction.setEnabled(false);
            if (listScope == 2) {
                this.pageScopeAction.setChecked(true);
            }
        }
    }

    private void updateItem(TableItem item, Adapter editor) {
        int index = this.fullNameAction.isChecked() ? 1 : 0;
        item.setData(editorListData, (Object)editor);
        item.setText(editor.getDisplayText()[index]);
        Image image = editor.getImage();
        if (image != null) {
            item.setImage(image);
        }
        if (!this.dropDown) {
            editor.editorRef.addPropertyListener(this.propertyListener);
        }
    }

    private void sort() {
        switch (sortOrder) {
            case 0: {
                Object[] a = new Adapter[this.elements.size()];
                this.elements.toArray(a);
                Arrays.sort(a);
                this.elements = Arrays.asList(a);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private void updateEditors(IWorkbenchPage[] pages) {
        int j = 0;
        while (j < pages.length) {
            IEditorReference[] editors = ((WorkbenchPage)pages[j]).getSortedEditors();
            int k = editors.length - 1;
            while (k >= 0) {
                this.elements.add(new Adapter(editors[k]));
                --k;
            }
            ++j;
        }
    }

    private void getAllEditors(List elements) {
        if (this.windowScopeAction.isChecked()) {
            IWorkbenchPage page;
            IWorkbenchWindow[] windows = this.window.getWorkbench().getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                this.updateEditors(windows[i].getPages());
                ++i;
            }
            if (!this.dropDown && elements.size() == 0 && (page = this.window.getActivePage()) != null) {
                this.updateEditors(new IWorkbenchPage[]{page});
            }
        } else {
            IWorkbenchPage page = this.window.getActivePage();
            if (page != null) {
                if (this.pageScopeAction.isChecked()) {
                    this.updateEditors(new IWorkbenchPage[]{page});
                } else {
                    EditorPane[] editors = this.workbook.getEditors();
                    int j = 0;
                    while (j < editors.length) {
                        elements.add(new Adapter(editors[j].getEditorReference()));
                        ++j;
                    }
                }
            }
        }
    }

    private void updateItems() {
        this.setCheckedMenuItems();
        this.editorsTable.removeAll();
        this.elements = new ArrayList();
        this.getAllEditors(this.elements);
        this.sort();
        IEditorPart selection = null;
        if (this.window.getActivePage() != null) {
            selection = this.window.getActivePage().getActiveEditor();
        }
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Adapter e = (Adapter)iterator.next();
            TableItem item = new TableItem(this.editorsTable, 0);
            this.updateItem(item, e);
            if (selection == null || selection != e.editorRef.getPart(false)) continue;
            this.editorsTable.setSelection(new TableItem[]{item});
            this.saveAction.setEnabled(e.isDirty());
        }
    }

    private void fillContextMenu(IMenuManager menuMgr) {
        MenuManager sortMenuMgr = new MenuManager(WorkbenchMessages.getString("EditorList.SortBy.text"));
        sortMenuMgr.add((IAction)this.nameSortAction);
        sortMenuMgr.add((IAction)this.MRUSortAction);
        MenuManager applyToMenuMgr = new MenuManager(WorkbenchMessages.getString("EditorList.ApplyTo.text"));
        applyToMenuMgr.add((IAction)this.windowScopeAction);
        applyToMenuMgr.add((IAction)this.pageScopeAction);
        if (this.dropDown) {
            applyToMenuMgr.add((IAction)this.tabGroupScopeAction);
        }
        menuMgr.add((IAction)this.saveAction);
        menuMgr.add((IAction)this.closeAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.selectCleanAction);
        menuMgr.add((IAction)this.InvertSelectionAction);
        menuMgr.add((IAction)this.selectAllAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.fullNameAction);
        menuMgr.add((IContributionItem)sortMenuMgr);
        menuMgr.add((IContributionItem)applyToMenuMgr);
    }

    static /* synthetic */ int access$10() {
        return sortOrder;
    }

    static /* synthetic */ int access$12() {
        return listScope;
    }

    private class SaveAction
    extends Action {
        SaveAction() {
            this.setText(WorkbenchMessages.getString("EditorList.saveSelected.text"));
            this.setToolTipText(WorkbenchMessages.getString("EditorList.saveSelected.toolTip"));
            WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.save_action_context");
        }

        public void run() {
            TableItem[] items = EditorList.this.editorsTable.getSelection();
            ArrayList<IWorkbenchPart> dirtyEditorList = new ArrayList<IWorkbenchPart>();
            int i = 0;
            while (i < items.length) {
                Adapter editor = (Adapter)items[i].getData(EditorList.editorListData);
                IWorkbenchPart element = editor.editorRef.getPart(false);
                if (editor.isDirty()) {
                    dirtyEditorList.add(element);
                }
                ++i;
            }
            if (dirtyEditorList.size() != 0) {
                EditorManager.saveAll(dirtyEditorList, false, EditorList.this.window);
            }
            EditorList.this.destroyControl();
        }
    }

    private class CloseAction
    extends Action {
        CloseAction() {
            this.setText(WorkbenchMessages.getString("EditorList.closeSelected.text"));
            this.setToolTipText(WorkbenchMessages.getString("EditorList.closeSelected.toolTip"));
            WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.close_part_action_context");
        }

        public void run() {
            TableItem[] items = EditorList.this.editorsTable.getSelection();
            Adapter[] editorRef = new Adapter[items.length];
            ArrayList<IWorkbenchPart> dirtyEditorList = new ArrayList<IWorkbenchPart>();
            int i = 0;
            while (i < items.length) {
                editorRef[i] = (Adapter)items[i].getData(EditorList.editorListData);
                IWorkbenchPart element = editorRef[i].editorRef.getPart(false);
                if (editorRef[i].isDirty()) {
                    dirtyEditorList.add(element);
                }
                ++i;
            }
            boolean result = true;
            if (dirtyEditorList.size() != 0) {
                result = EditorManager.saveAll(dirtyEditorList, true, EditorList.this.window);
            }
            if (result) {
                int i2 = 0;
                while (i2 < editorRef.length) {
                    editorRef[i2].close();
                    ++i2;
                }
            }
            EditorList.this.notifyEditorListViews();
            EditorList.this.destroyControl();
        }
    }

    private class SelectionAction
    extends Action {
        private int selectionType;

        SelectionAction(int selectionType) {
            this.selectionType = selectionType;
            switch (selectionType) {
                case 0: {
                    this.setText(WorkbenchMessages.getString("EditorList.selectAll.text"));
                    this.setToolTipText(WorkbenchMessages.getString("EditorList.selectAll.toolTip"));
                    break;
                }
                case 1: {
                    this.setText(WorkbenchMessages.getString("EditorList.invertSelection.text"));
                    this.setToolTipText(WorkbenchMessages.getString("EditorList.invertSelection.toolTip"));
                    break;
                }
                case 2: {
                    this.setText(WorkbenchMessages.getString("EditorList.selectClean.text"));
                    this.setToolTipText(WorkbenchMessages.getString("EditorList.selectClean.toolTip"));
                    break;
                }
            }
        }

        private TableItem[] invertSelection(TableItem[] allItems, TableItem[] selectedItems) {
            if (allItems.length == 0) {
                return allItems;
            }
            ArrayList<TableItem> invertedSelection = new ArrayList<TableItem>(allItems.length - selectedItems.length);
            int i = 0;
            while (i < allItems.length) {
                block4: {
                    int j = 0;
                    while (j < selectedItems.length) {
                        if (allItems[i] != selectedItems[j]) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    invertedSelection.add(allItems[i]);
                }
                ++i;
            }
            TableItem[] result = new TableItem[invertedSelection.size()];
            invertedSelection.toArray(result);
            return result;
        }

        private TableItem[] selectClean(TableItem[] allItems) {
            if (allItems.length == 0) {
                return new TableItem[0];
            }
            ArrayList<TableItem> cleanItems = new ArrayList<TableItem>(allItems.length);
            int i = 0;
            while (i < allItems.length) {
                Adapter editor = (Adapter)allItems[i].getData(EditorList.editorListData);
                if (!editor.isDirty()) {
                    cleanItems.add(allItems[i]);
                }
                ++i;
            }
            TableItem[] result = new TableItem[cleanItems.size()];
            cleanItems.toArray(result);
            return result;
        }

        public void run() {
            switch (this.selectionType) {
                case 0: {
                    EditorList.this.editorsTable.setSelection(EditorList.this.editorsTable.getItems());
                    break;
                }
                case 1: {
                    EditorList.this.editorsTable.setSelection(this.invertSelection(EditorList.this.editorsTable.getItems(), EditorList.this.editorsTable.getSelection()));
                    break;
                }
                case 2: {
                    EditorList.this.editorsTable.setSelection(this.selectClean(EditorList.this.editorsTable.getItems()));
                }
            }
            EditorList.this.handleSelectionEvent(false);
        }
    }

    private class FullNameAction
    extends Action {
        FullNameAction() {
            this.setText(WorkbenchMessages.getString("EditorList.FullName.text"));
            this.setToolTipText(WorkbenchMessages.getString("EditorList.FullName.toolTip"));
        }

        public void run() {
            displayFullPath = !displayFullPath;
            WorkbenchPlugin.getDefault().getPreferenceStore().setValue("EDITORLIST_DISPLAY_FULL_NAME", displayFullPath);
            this.setChecked(displayFullPath);
            int[] indices = EditorList.this.editorsTable.getSelectionIndices();
            EditorList.this.updateItems();
            if (EditorList.this.dropDown) {
                EditorList.this.workbook.resizeEditorList();
            }
            EditorList.this.editorsTable.setSelection(indices);
            EditorList.this.notifyEditorListViews();
        }
    }

    private class SortAction
    extends Action {
        private int sortOrder;

        SortAction(int sortOrder) {
            this.sortOrder = sortOrder;
            switch (sortOrder) {
                case 0: {
                    this.setText(WorkbenchMessages.getString("EditorList.SortByName.text"));
                    this.setToolTipText(WorkbenchMessages.getString("EditorList.SortByName.toolTip"));
                    break;
                }
                case 1: {
                    this.setText(WorkbenchMessages.getString("EditorList.SortByMostRecentlyUsed.text"));
                    this.setToolTipText(WorkbenchMessages.getString("EditorList.SortByMostRecentlyUsed.toolTip"));
                    break;
                }
            }
        }

        public void run() {
            sortOrder = this.sortOrder;
            WorkbenchPlugin.getDefault().getPreferenceStore().setValue("EDITORLIST_SORT_CRITERIA", this.sortOrder);
            TableItem[] items = EditorList.this.editorsTable.getItems();
            if (items.length == 0) {
                return;
            }
            EditorList.this.updateItems();
            EditorList.this.notifyEditorListViews();
        }
    }

    private class SetScopeAction
    extends Action {
        private int whichScope;

        SetScopeAction(int whichScope) {
            this.whichScope = whichScope;
            switch (whichScope) {
                case 0: {
                    this.setText(WorkbenchMessages.getString("EditorList.DisplayAllWindows.text"));
                    this.setToolTipText(WorkbenchMessages.getString("EditorList.DisplayAllWindows.toolTip"));
                    break;
                }
                case 1: {
                    this.setText(WorkbenchMessages.getString("EditorList.DisplayAllPage.text"));
                    this.setToolTipText(WorkbenchMessages.getString("EditorList.DisplayAllPage.toolTip"));
                    break;
                }
                case 2: {
                    this.setText(WorkbenchMessages.getString("EditorList.DisplayTabGroup.text"));
                    this.setToolTipText(WorkbenchMessages.getString("EditorList.DisplayTabGroup.toolTip"));
                    break;
                }
            }
        }

        public void run() {
            listScope = this.whichScope;
            WorkbenchPlugin.getDefault().getPreferenceStore().setValue("EDITORLIST_SELECTION_SCOPE", this.whichScope);
            EditorList.this.updateItems();
            if (EditorList.this.dropDown) {
                EditorList.this.workbook.resizeEditorList();
            }
            EditorList.this.notifyEditorListViews();
        }
    }

    private class Adapter
    implements Comparable {
        IEditorReference editorRef;
        String[] text;
        String[] displayText;
        Image[] images;

        Adapter(IEditorReference ref) {
            this.editorRef = ref;
        }

        boolean isDirty() {
            return this.editorRef.isDirty();
        }

        void close() {
            WorkbenchPage p = ((WorkbenchPartReference)((Object)this.editorRef)).getPane().getPage();
            p.closeEditor(this.editorRef, false);
        }

        String[] getText() {
            this.text = new String[2];
            this.text[0] = this.editorRef.getTitle();
            this.text[1] = this.editorRef.getTitleToolTip();
            return this.text;
        }

        String[] getDisplayText() {
            this.displayText = new String[2];
            if (this.editorRef.isDirty()) {
                this.displayText[0] = "*" + this.editorRef.getTitle();
                this.displayText[1] = "*" + this.editorRef.getTitleToolTip();
            } else {
                this.displayText[0] = this.editorRef.getTitle();
                this.displayText[1] = this.editorRef.getTitleToolTip();
            }
            return this.displayText;
        }

        Image getImage() {
            return this.editorRef.getTitleImage();
        }

        private void activate(boolean activate) {
            IEditorPart editor = this.editorRef.getEditor(true);
            if (editor != null) {
                WorkbenchPage p = (WorkbenchPage)editor.getEditorSite().getPage();
                Shell s = p.getWorkbenchWindow().getShell();
                if (s.getMinimized()) {
                    s.setMinimized(false);
                }
                s.moveAbove(null);
                p.getWorkbenchWindow().setActivePage(p);
                if (activate) {
                    if (editor == p.getActivePart()) {
                        editor.setFocus();
                    } else {
                        p.activate(editor);
                    }
                } else {
                    p.bringToTop(editor);
                }
            }
        }

        public int compareTo(Object another) {
            int index = EditorList.this.fullNameAction.isChecked() ? 1 : 0;
            Adapter adapter = (Adapter)another;
            int result = collator.compare(this.getText()[index], adapter.getText()[index]);
            return result;
        }
    }
}

