/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.SubActionBars2;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.internal.EditorMenuManager;

public class EditorActionBars
extends SubActionBars2 {
    private String type;
    private int refCount;
    private IEditorActionBarContributor editorContributor;
    private IEditorActionBarContributor extensionContributor;
    private ToolBarContributionItem toolBarContributionItem = null;
    private IToolBarManager coolItemToolBarMgr = null;
    private boolean enabledAllowed = true;

    public EditorActionBars(IActionBars2 parent, String type) {
        super(parent);
        this.type = type;
    }

    public void activate(boolean forceVisibility) {
        this.setActive(true, forceVisibility);
    }

    public void addRef() {
        ++this.refCount;
    }

    protected SubMenuManager createSubMenuManager(IMenuManager parent) {
        return new EditorMenuManager(parent);
    }

    protected SubToolBarManager createSubToolBarManager(IToolBarManager parent) {
        return null;
    }

    public void deactivate(boolean forceVisibility) {
        this.setActive(false, forceVisibility);
    }

    public void dispose() {
        super.dispose();
        if (this.editorContributor != null) {
            this.editorContributor.dispose();
        }
        if (this.extensionContributor != null) {
            this.extensionContributor.dispose();
        }
        if (this.toolBarContributionItem != null) {
            this.toolBarContributionItem.dispose();
        }
        this.toolBarContributionItem = null;
    }

    public IEditorActionBarContributor getEditorContributor() {
        return this.editorContributor;
    }

    public IEditorActionBarContributor getExtensionContributor() {
        return this.extensionContributor;
    }

    public String getEditorType() {
        return this.type;
    }

    public IToolBarManager getToolBarManager() {
        ICoolBarManager coolBarManager = this.getCastedParent().getCoolBarManager();
        if (coolBarManager == null) {
            return null;
        }
        if (this.coolItemToolBarMgr == null) {
            this.coolItemToolBarMgr = new ToolBarManager(coolBarManager.getStyle());
            ((ToolBarManager)this.coolItemToolBarMgr).setOverrides((IContributionManagerOverrides)new Overrides());
        }
        if (this.toolBarContributionItem == null) {
            this.toolBarContributionItem = new ToolBarContributionItem(this.coolItemToolBarMgr, this.type);
            this.toolBarContributionItem.setVisible(this.getActive());
            this.coolItemToolBarMgr.markDirty();
            coolBarManager.prependToGroup("group.editor", (IContributionItem)this.toolBarContributionItem);
        }
        return this.coolItemToolBarMgr;
    }

    public int getRef() {
        return this.refCount;
    }

    private boolean isVisible() {
        if (this.toolBarContributionItem != null) {
            return this.toolBarContributionItem.isVisible();
        }
        return false;
    }

    public void partChanged(IWorkbenchPart part) {
        super.partChanged(part);
        if (part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            if (this.editorContributor != null) {
                this.editorContributor.setActiveEditor(editor);
            }
            if (this.extensionContributor != null) {
                this.extensionContributor.setActiveEditor(editor);
            }
        }
    }

    public void removeRef() {
        --this.refCount;
    }

    private void setActive(boolean set, boolean forceVisibility) {
        this.basicSetActive(set);
        if (this.isSubMenuManagerCreated()) {
            ((EditorMenuManager)this.getMenuManager()).setVisible(set, forceVisibility);
        }
        if (this.isSubStatusLineManagerCreated()) {
            ((SubStatusLineManager)this.getStatusLineManager()).setVisible(set);
        }
        this.setVisible(set, forceVisibility);
    }

    public void setEditorContributor(IEditorActionBarContributor c) {
        this.editorContributor = c;
    }

    public void setExtensionContributor(IEditorActionBarContributor c) {
        this.extensionContributor = c;
    }

    private void setVisible(boolean visible) {
        if (this.toolBarContributionItem != null) {
            this.toolBarContributionItem.setVisible(visible);
            if (this.toolBarContributionItem.getParent() != null) {
                this.toolBarContributionItem.getParent().markDirty();
            }
        }
    }

    private void setVisible(boolean visible, boolean forceVisibility) {
        if (visible) {
            if (forceVisibility) {
                if (!this.enabledAllowed) {
                    this.setEnabledAllowed(true);
                }
            } else if (this.enabledAllowed) {
                this.setEnabledAllowed(false);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (forceVisibility) {
            this.setVisible(false);
        } else {
            this.setEnabledAllowed(false);
        }
        if (this.toolBarContributionItem != null) {
            this.toolBarContributionItem.setVisible(visible);
            if (this.toolBarContributionItem.getParent() != null) {
                this.toolBarContributionItem.getParent().markDirty();
            }
        }
    }

    private void setEnabledAllowed(boolean enabledAllowed) {
        if (this.enabledAllowed == enabledAllowed) {
            return;
        }
        this.enabledAllowed = enabledAllowed;
        if (this.coolItemToolBarMgr != null) {
            IContributionItem[] items = this.coolItemToolBarMgr.getItems();
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                item.update("enabled");
                ++i;
            }
        }
    }

    private class Overrides
    implements IContributionManagerOverrides {
        Overrides() {
        }

        public Boolean getEnabled(IContributionItem item) {
            if (item instanceof ActionContributionItem && ((ActionContributionItem)item).getAction() instanceof RetargetAction || EditorActionBars.this.enabledAllowed) {
                return null;
            }
            return Boolean.FALSE;
        }

        public Integer getAccelerator(IContributionItem item) {
            return null;
        }

        public String getAcceleratorText(IContributionItem item) {
            return null;
        }

        public String getText(IContributionItem item) {
            return null;
        }
    }
}

