/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ImportWizard;

public class ImportResourcesAction
extends BaseSelectionListenerAction
implements ActionFactory.IWorkbenchAction {
    private static final int SIZING_WIZARD_WIDTH = 470;
    private static final int SIZING_WIZARD_HEIGHT = 550;
    private IWorkbenchWindow workbenchWindow;
    private final ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structured = (IStructuredSelection)selection;
                ImportResourcesAction.this.selectionChanged(structured);
            }
        }
    };

    public ImportResourcesAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("ImportResourcesAction.text"));
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setActionDefinitionId("org.eclipse.ui.file.import");
        this.setToolTipText(WorkbenchMessages.getString("ImportResourcesAction.toolTip"));
        this.setId("import");
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.import_action_context");
        this.workbenchWindow.getSelectionService().addSelectionListener(this.selectionListener);
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_IMPORT_WIZ"));
        this.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_IMPORT_WIZ_HOVER"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_IMPORT_WIZ_DISABLED"));
    }

    public ImportResourcesAction(IWorkbench workbench) {
        this(workbench.getActiveWorkbenchWindow());
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        ImportWizard wizard = new ImportWizard();
        ISelection workbenchSelection = this.workbenchWindow.getSelectionService().getSelection();
        Object selectionToPass = workbenchSelection instanceof IStructuredSelection ? (IStructuredSelection)workbenchSelection : StructuredSelection.EMPTY;
        wizard.init(this.workbenchWindow.getWorkbench(), (IStructuredSelection)selectionToPass);
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection("ImportResourcesAction");
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection("ImportResourcesAction");
        }
        wizard.setDialogSettings(wizardSettings);
        wizard.setForcePreviousAndNextButtons(true);
        Shell parent = this.workbenchWindow.getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(470, dialog.getShell().getSize().x), 550);
        WorkbenchHelp.setHelp((Control)dialog.getShell(), "org.eclipse.ui.import_wizard_context");
        dialog.open();
    }

    public void setSelection(IStructuredSelection selection) {
        this.selectionChanged(selection);
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow.getSelectionService().removeSelectionListener(this.selectionListener);
        this.workbenchWindow = null;
    }
}

