/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLMemento
implements IMemento {
    private Document factory;
    private Element element;

    public static XMLMemento createReadRoot(Reader reader) throws WorkbenchException {
        return XMLMemento.createReadRoot(reader, null);
    }

    public static XMLMemento createReadRoot(Reader reader, String baseDir) throws WorkbenchException {
        String messageKey = "XMLMemento.noElement";
        Exception exception = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource source = new InputSource(reader);
            if (baseDir != null) {
                source.setSystemId(baseDir);
            }
            Document document = parser.parse(source);
            NodeList list = document.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node instanceof Element) {
                    return new XMLMemento(document, (Element)node);
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            exception = e;
            messageKey = "XMLMemento.parserConfigError";
        }
        catch (IOException e) {
            exception = e;
            messageKey = "XMLMemento.ioError";
        }
        catch (SAXException e) {
            exception = e;
            messageKey = "XMLMemento.formatError";
        }
        String problemText = null;
        if (exception != null) {
            problemText = exception.getMessage();
        }
        if (problemText == null || problemText.length() == 0) {
            problemText = WorkbenchMessages.getString(messageKey);
        }
        throw new WorkbenchException(problemText, exception);
    }

    public static XMLMemento createWriteRoot(String type) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(type);
            document.appendChild(element);
            return new XMLMemento(document, element);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
    }

    public XMLMemento(Document document, Element element) {
        this.factory = document;
        this.element = element;
    }

    public IMemento createChild(String type) {
        Element child = this.factory.createElement(type);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    public IMemento createChild(String type, String id) {
        Element child = this.factory.createElement(type);
        child.setAttribute("IMemento.internal.id", id == null ? "" : id);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    public IMemento copyChild(IMemento child) {
        Element childElement = ((XMLMemento)child).element;
        Element newElement = (Element)this.factory.importNode(childElement, true);
        this.element.appendChild(newElement);
        return new XMLMemento(this.factory, newElement);
    }

    public IMemento getChild(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        int nX = 0;
        while (nX < size) {
            Element element;
            Node node = nodes.item(nX);
            if (node instanceof Element && (element = (Element)node).getNodeName().equals(type)) {
                return new XMLMemento(this.factory, element);
            }
            ++nX;
        }
        return null;
    }

    public IMemento[] getChildren(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return new IMemento[0];
        }
        ArrayList<Element> list = new ArrayList<Element>(size);
        int nX = 0;
        while (nX < size) {
            Element element;
            Node node = nodes.item(nX);
            if (node instanceof Element && (element = (Element)node).getNodeName().equals(type)) {
                list.add(element);
            }
            ++nX;
        }
        size = list.size();
        IMemento[] results = new IMemento[size];
        int x = 0;
        while (x < size) {
            results[x] = new XMLMemento(this.factory, (Element)list.get(x));
            ++x;
        }
        return results;
    }

    public Float getFloat(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Float(strValue);
        }
        catch (NumberFormatException e) {
            WorkbenchPlugin.log("Memento problem - Invalid float for key: " + key + " value: " + strValue);
            return null;
        }
    }

    public String getID() {
        return this.element.getAttribute("IMemento.internal.id");
    }

    public Integer getInteger(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Integer(strValue);
        }
        catch (NumberFormatException e) {
            WorkbenchPlugin.log("Memento problem - invalid integer for key: " + key + " value: " + strValue);
            return null;
        }
    }

    public String getString(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public String getTextData() {
        Text textNode = this.getTextNode();
        if (textNode != null) {
            return textNode.getData();
        }
        return null;
    }

    private Text getTextNode() {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        int nX = 0;
        while (nX < size) {
            Node node = nodes.item(nX);
            if (node instanceof Text) {
                return (Text)node;
            }
            ++nX;
        }
        return null;
    }

    private void putElement(Element element) {
        NamedNodeMap nodeMap = element.getAttributes();
        int size = nodeMap.getLength();
        int i = 0;
        while (i < size) {
            Attr attr = (Attr)nodeMap.item(i);
            this.putString(attr.getName(), attr.getValue());
            ++i;
        }
        NodeList nodes = element.getChildNodes();
        size = nodes.getLength();
        int i2 = 0;
        while (i2 < size) {
            Node node = nodes.item(i2);
            if (node instanceof Element) {
                XMLMemento child = (XMLMemento)this.createChild(node.getNodeName());
                child.putElement((Element)node);
            }
            ++i2;
        }
    }

    public void putFloat(String key, float f) {
        this.element.setAttribute(key, String.valueOf(f));
    }

    public void putInteger(String key, int n) {
        this.element.setAttribute(key, String.valueOf(n));
    }

    public void putMemento(IMemento memento) {
        this.putElement(((XMLMemento)memento).element);
    }

    public void putString(String key, String value) {
        if (value == null) {
            return;
        }
        this.element.setAttribute(key, value);
    }

    public void putTextData(String data) {
        Text textNode = this.getTextNode();
        if (textNode == null) {
            textNode = this.factory.createTextNode(data);
            this.element.appendChild(textNode);
        } else {
            textNode.setData(data);
        }
    }

    public void save(Writer writer) throws IOException {
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(this.factory);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }
}

