/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.actions.SimpleWildcardTester;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.model.IWorkbenchAdapter;

public final class SelectionEnabler {
    private static final String ATT_NAME = "name";
    private static final String ATT_CLASS = "class";
    public static final int UNKNOWN = 0;
    public static final int ONE_OR_MORE = -1;
    public static final int ANY_NUMBER = -2;
    public static final int NONE_OR_ONE = -3;
    public static final int NONE = -4;
    public static final int MULTIPLE = -5;
    private List classes = new ArrayList();
    private ActionExpression enablementExpression;
    private int mode = 0;
    private static final String JFACE_TEXT_PLUG_IN = "org.eclipse.jface.text";
    private static final String TEXT_SELECTION_CLASS = "org.eclipse.jface.text.ITextSelection";
    private static Class iTextSelectionClass = null;
    private static boolean textSelectionPossible = true;
    static /* synthetic */ Class class$0;

    private static Class getTextSelectionClass() {
        if (iTextSelectionClass != null) {
            return iTextSelectionClass;
        }
        if (!textSelectionPossible) {
            return null;
        }
        IPluginDescriptor desc = Platform.getPluginRegistry().getPluginDescriptor(JFACE_TEXT_PLUG_IN);
        if (desc == null) {
            textSelectionPossible = false;
            return null;
        }
        if (!desc.isPluginActivated()) {
            textSelectionPossible = true;
            return null;
        }
        ClassLoader rcl = desc.getPluginClassLoader();
        try {
            Class<?> c;
            iTextSelectionClass = c = rcl.loadClass(TEXT_SELECTION_CLASS);
            return iTextSelectionClass;
        }
        catch (ClassNotFoundException e) {
            textSelectionPossible = false;
            return null;
        }
    }

    public SelectionEnabler(IConfigurationElement configElement) {
        if (configElement == null) {
            throw new IllegalArgumentException();
        }
        this.parseClasses(configElement);
    }

    public boolean isEnabledForSelection(ISelection selection) {
        if (this.mode == 0) {
            return false;
        }
        if (selection == null) {
            selection = StructuredSelection.EMPTY;
        }
        if (selection instanceof IStructuredSelection) {
            return this.isEnabledFor((IStructuredSelection)selection);
        }
        Class tselClass = SelectionEnabler.getTextSelectionClass();
        if (tselClass != null && tselClass.isInstance(selection)) {
            try {
                Method m = tselClass.getDeclaredMethod("getLength", new Class[0]);
                Object r = m.invoke((Object)selection, new Object[0]);
                if (r instanceof Integer) {
                    return this.isEnabledFor(selection, (Integer)r);
                }
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return this.isEnabledFor(selection);
    }

    private boolean verifySelectionCount(int count) {
        if (count > 0 && this.mode == -4) {
            return false;
        }
        if (count == 0 && this.mode == -1) {
            return false;
        }
        if (count > 1 && this.mode == -3) {
            return false;
        }
        if (count < 2 && this.mode == -5) {
            return false;
        }
        return this.mode <= 0 || count == this.mode;
    }

    private boolean isEnabledFor(ISelection sel) {
        int count;
        ISelection obj = sel;
        int n = count = sel.isEmpty() ? 0 : 1;
        if (!this.verifySelectionCount(count)) {
            return false;
        }
        if (this.enablementExpression != null) {
            return this.enablementExpression.isEnabledFor(obj);
        }
        if (this.classes.isEmpty()) {
            return true;
        }
        if (obj instanceof IAdaptable) {
            IAdaptable element = (IAdaptable)obj;
            return this.verifyElement(element);
        }
        return false;
    }

    private boolean isEnabledFor(ISelection sel, int count) {
        if (!this.verifySelectionCount(count)) {
            return false;
        }
        if (this.enablementExpression != null) {
            return this.enablementExpression.isEnabledFor(sel);
        }
        if (this.classes.isEmpty()) {
            return true;
        }
        int i = 0;
        while (i < this.classes.size()) {
            SelectionClass sc = (SelectionClass)this.classes.get(i);
            if (this.verifyClass(sel, sc.className)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isEnabledFor(IStructuredSelection ssel) {
        int count = ssel.size();
        if (!this.verifySelectionCount(count)) {
            return false;
        }
        if (this.enablementExpression != null) {
            return this.enablementExpression.isEnabledFor(ssel);
        }
        if (this.classes.isEmpty()) {
            return true;
        }
        Iterator elements = ssel.iterator();
        while (elements.hasNext()) {
            Object obj = elements.next();
            if (obj instanceof IAdaptable) {
                IAdaptable element = (IAdaptable)obj;
                if (this.verifyElement(element)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void parseClasses(IConfigurationElement config) {
        String enablesFor = config.getAttribute("enablesFor");
        if (enablesFor == null) {
            enablesFor = "*";
        }
        if (enablesFor.equals("*")) {
            this.mode = -2;
        } else if (enablesFor.equals("?")) {
            this.mode = -3;
        } else if (enablesFor.equals("!")) {
            this.mode = -4;
        } else if (enablesFor.equals("+")) {
            this.mode = -1;
        } else if (enablesFor.equals("multiple") || enablesFor.equals("2+")) {
            this.mode = -5;
        } else {
            try {
                this.mode = Integer.parseInt(enablesFor);
            }
            catch (NumberFormatException e) {
                this.mode = 0;
            }
        }
        IConfigurationElement[] children = config.getChildren("enablement");
        if (children.length > 0) {
            this.enablementExpression = new ActionExpression(children[0]);
            return;
        }
        children = config.getChildren("selection");
        if (children.length > 0) {
            this.classes = new ArrayList();
            int i = 0;
            while (i < children.length) {
                IConfigurationElement sel = children[i];
                String cname = sel.getAttribute(ATT_CLASS);
                String name = sel.getAttribute(ATT_NAME);
                SelectionClass sclass = new SelectionClass();
                sclass.className = cname;
                sclass.nameFilter = name;
                this.classes.add(sclass);
                ++i;
            }
        }
    }

    private boolean verifyClass(Object element, String className) {
        Class<?> eclass;
        Class<?> clazz = eclass = element.getClass();
        boolean match = false;
        while (clazz != null) {
            if (clazz.getName().equals(className)) {
                match = true;
                break;
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (interfaces[i].getName().equals(className)) {
                    match = true;
                    break;
                }
                ++i;
            }
            if (match) break;
            clazz = clazz.getSuperclass();
        }
        return match;
    }

    private boolean verifyElement(IAdaptable element) {
        if (this.classes.isEmpty()) {
            return true;
        }
        int i = 0;
        while (i < this.classes.size()) {
            SelectionClass sc = (SelectionClass)this.classes.get(i);
            if (this.verifyClass(element, sc.className)) {
                IWorkbenchAdapter de;
                if (sc.nameFilter == null) {
                    return true;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((de = (IWorkbenchAdapter)element.getAdapter((Class)clazz)) != null && SelectionEnabler.verifyNameMatch(de.getLabel(element), sc.nameFilter)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean verifyNameMatch(String name, String filter) {
        return SimpleWildcardTester.testWildcardIgnoreCase(filter, name);
    }

    public static class SelectionClass {
        public String className;
        public boolean recursive;
        public String nameFilter;
    }
}

