/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.text;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.internal.ui.text.FastJavaPartitionScanner;
import org.eclipse.jdt.internal.ui.text.JavaColorManager;
import org.eclipse.jdt.internal.ui.text.JavaCommentScanner;
import org.eclipse.jdt.internal.ui.text.SingleTokenJavaScanner;
import org.eclipse.jdt.internal.ui.text.java.JavaCodeScanner;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDocScanner;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class JavaTextTools {
    private JavaColorManager fColorManager;
    private JavaCodeScanner fCodeScanner;
    private JavaCommentScanner fMultilineCommentScanner;
    private JavaCommentScanner fSinglelineCommentScanner;
    private SingleTokenJavaScanner fStringScanner;
    private JavaDocScanner fJavaDocScanner;
    private FastJavaPartitionScanner fPartitionScanner;
    private IPreferenceStore fPreferenceStore;
    private Preferences fCorePreferenceStore;
    private PreferenceListener fPreferenceListener = new PreferenceListener();

    public JavaTextTools(IPreferenceStore store) {
        this(store, null, true);
    }

    public JavaTextTools(IPreferenceStore store, boolean autoDisposeOnDisplayDispose) {
        this(store, null, autoDisposeOnDisplayDispose);
    }

    public JavaTextTools(IPreferenceStore store, Preferences coreStore) {
        this(store, coreStore, true);
    }

    public JavaTextTools(IPreferenceStore store, Preferences coreStore, boolean autoDisposeOnDisplayDispose) {
        this.fPreferenceStore = store;
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fCorePreferenceStore = coreStore;
        if (this.fCorePreferenceStore != null) {
            this.fCorePreferenceStore.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
        }
        this.fColorManager = new JavaColorManager(autoDisposeOnDisplayDispose);
        this.fCodeScanner = new JavaCodeScanner(this.fColorManager, store);
        this.fMultilineCommentScanner = new JavaCommentScanner(this.fColorManager, store, coreStore, "java_multi_line_comment");
        this.fSinglelineCommentScanner = new JavaCommentScanner(this.fColorManager, store, coreStore, "java_single_line_comment");
        this.fStringScanner = new SingleTokenJavaScanner(this.fColorManager, store, "java_string");
        this.fJavaDocScanner = new JavaDocScanner(this.fColorManager, store, coreStore);
        this.fPartitionScanner = new FastJavaPartitionScanner();
    }

    public void dispose() {
        this.fCodeScanner = null;
        this.fMultilineCommentScanner = null;
        this.fSinglelineCommentScanner = null;
        this.fStringScanner = null;
        this.fJavaDocScanner = null;
        this.fPartitionScanner = null;
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
            this.fPreferenceStore = null;
            if (this.fCorePreferenceStore != null) {
                this.fCorePreferenceStore.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
                this.fCorePreferenceStore = null;
            }
            this.fPreferenceListener = null;
        }
    }

    public IColorManager getColorManager() {
        return this.fColorManager;
    }

    public RuleBasedScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    public RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    public RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    public RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    public RuleBasedScanner getJavaDocScanner() {
        return this.fJavaDocScanner;
    }

    public IPartitionTokenScanner getPartitionScanner() {
        return this.fPartitionScanner;
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        String[] types = new String[]{"__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character"};
        return new DefaultPartitioner(this.getPartitionScanner(), types);
    }

    public String[] getPartitionManagingPositionCategories() {
        return new String[]{"__content_types_category"};
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fMultilineCommentScanner.affectsBehavior(event) || this.fSinglelineCommentScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event) || this.fJavaDocScanner.affectsBehavior(event);
    }

    protected void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fJavaDocScanner.affectsBehavior(event)) {
            this.fJavaDocScanner.adaptToPreferenceChange(event);
        }
    }

    public void setupJavaDocumentPartitioner(IDocument document) {
        this.setupJavaDocumentPartitioner(document, "__dftl_partitioning");
    }

    public void setupJavaDocumentPartitioner(IDocument document, String partitioning) {
        IDocumentPartitioner partitioner = this.createDocumentPartitioner();
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner(partitioning, partitioner);
        } else {
            document.setDocumentPartitioner(partitioner);
        }
        partitioner.connect(document);
    }

    public void setupDocument(IDocument document) {
        this.setupJavaDocumentPartitioner(document, "__dftl_partitioning");
    }

    public void setupDocument(IDocument document, String partitioning) {
        this.setupJavaDocumentPartitioner(document, partitioning);
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    private class PreferenceListener
    implements IPropertyChangeListener,
    Preferences.IPropertyChangeListener {
        PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            JavaTextTools.this.adaptToPreferenceChange(event);
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            JavaTextTools.this.adaptToPreferenceChange(new PropertyChangeEvent(event.getSource(), event.getProperty(), event.getOldValue(), event.getNewValue()));
        }
    }
}

