/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.text;

import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.ContentAssistPreference;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.internal.ui.text.JavaAnnotationHover;
import org.eclipse.jdt.internal.ui.text.JavaElementProvider;
import org.eclipse.jdt.internal.ui.text.JavaOutlineInformationControl;
import org.eclipse.jdt.internal.ui.text.JavaReconciler;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.eclipse.jdt.internal.ui.text.java.JavaAutoIndentStrategy;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProcessor;
import org.eclipse.jdt.internal.ui.text.java.JavaDoubleClickSelector;
import org.eclipse.jdt.internal.ui.text.java.JavaFormattingStrategy;
import org.eclipse.jdt.internal.ui.text.java.JavaReconcilingStrategy;
import org.eclipse.jdt.internal.ui.text.java.JavaStringAutoIndentStrategy;
import org.eclipse.jdt.internal.ui.text.java.JavaStringDoubleClickSelector;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverProxy;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaInformationProvider;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDocAutoIndentStrategy;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDocCompletionProcessor;
import org.eclipse.jdt.internal.ui.typehierarchy.HierarchyInformationControl;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter2;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaSourceViewerConfiguration
extends SourceViewerConfiguration {
    public static final String PREFERENCE_TAB_WIDTH = "org.eclipse.jdt.ui.editor.tab.width";
    public static final String SPACES_FOR_TABS = "spacesForTabs";
    private JavaTextTools fJavaTextTools;
    private ITextEditor fTextEditor;
    private String fDocumentPartitioning;

    public JavaSourceViewerConfiguration(JavaTextTools tools, ITextEditor editor, String partitioning) {
        this.fJavaTextTools = tools;
        this.fTextEditor = editor;
        this.fDocumentPartitioning = partitioning;
    }

    public JavaSourceViewerConfiguration(JavaTextTools tools, ITextEditor editor) {
        this(tools, editor, null);
    }

    protected RuleBasedScanner getCodeScanner() {
        return this.fJavaTextTools.getCodeScanner();
    }

    protected RuleBasedScanner getMultilineCommentScanner() {
        return this.fJavaTextTools.getMultilineCommentScanner();
    }

    protected RuleBasedScanner getSinglelineCommentScanner() {
        return this.fJavaTextTools.getSinglelineCommentScanner();
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fJavaTextTools.getStringScanner();
    }

    protected RuleBasedScanner getJavaDocScanner() {
        return this.fJavaTextTools.getJavaDocScanner();
    }

    protected IColorManager getColorManager() {
        return this.fJavaTextTools.getColorManager();
    }

    protected ITextEditor getEditor() {
        return this.fTextEditor;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fJavaTextTools.getPreferenceStore();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getJavaDocScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_javadoc");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_javadoc");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_multiline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_singleline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_singleline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_character");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_character");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.getEditor() != null) {
            ContentAssistant assistant = new ContentAssistant();
            assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            JavaCompletionProcessor processor = new JavaCompletionProcessor((IEditorPart)this.getEditor());
            assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
            assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__java_string");
            assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__java_singleline_comment");
            assistant.setContentAssistProcessor((IContentAssistProcessor)new JavaDocCompletionProcessor((IEditorPart)this.getEditor()), "__java_javadoc");
            ContentAssistPreference.configure(assistant, this.getPreferenceStore());
            assistant.setContextInformationPopupOrientation(20);
            assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            return assistant;
        }
        return null;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.getEditor() != null && this.getEditor().isEditable()) {
            JavaReconciler reconciler = new JavaReconciler(this.getEditor(), new JavaReconcilingStrategy(this.getEditor()), false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    public IAutoIndentStrategy getAutoIndentStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__java_javadoc".equals(contentType) || "__java_multiline_comment".equals(contentType)) {
            return new JavaDocAutoIndentStrategy(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        if ("__java_string".equals(contentType)) {
            return new JavaStringAutoIndentStrategy(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        return new JavaAutoIndentStrategy(this.getConfiguredDocumentPartitioning(sourceViewer));
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__java_javadoc".equals(contentType) || "__java_multiline_comment".equals(contentType) || "__java_singleline_comment".equals(contentType)) {
            return new DefaultTextDoubleClickStrategy();
        }
        if ("__java_string".equals(contentType) || "__java_character".equals(contentType)) {
            return new JavaStringDoubleClickSelector(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        return new JavaDoubleClickSelector();
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"//", ""};
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        int tabWidth = CodeFormatterUtil.getTabWidth();
        boolean useSpaces = this.getPreferenceStore().getBoolean(SPACES_FOR_TABS);
        int i = 0;
        while (i <= tabWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            if (useSpaces) {
                j = 0;
                while (j + i < tabWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != tabWidth) {
                    prefix.append('\t');
                }
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return this.getPreferenceStore().getInt(PREFERENCE_TAB_WIDTH);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new JavaAnnotationHover(JavaAnnotationHover.VERTICAL_RULER_HOVER);
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new JavaAnnotationHover(JavaAnnotationHover.OVERVIEW_RULER_HOVER);
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        JavaEditorTextHoverDescriptor[] hoverDescs = JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = hoverDescs[i].getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        JavaEditorTextHoverDescriptor[] hoverDescs = JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                return new JavaEditorTextHoverProxy(hoverDescs[i], (IEditorPart)this.getEditor());
            }
            ++i;
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character"};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter2 formatter = new ContentFormatter2();
        formatter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        JavaFormattingStrategy strategy = new JavaFormattingStrategy(sourceViewer);
        formatter.setFormattingStrategy((IFormattingStrategy)strategy);
        formatter.setFormattingStrategy((IFormattingStrategy)strategy, "__dftl_partition_content_type");
        formatter.setFormattingStrategy((IFormattingStrategy)new CommentFormattingStrategy(formatter, sourceViewer), "__java_javadoc");
        formatter.setFormattingStrategy((IFormattingStrategy)new CommentFormattingStrategy(formatter, sourceViewer), "__java_singleline_comment");
        formatter.setFormattingStrategy((IFormattingStrategy)new CommentFormattingStrategy(formatter, sourceViewer), "__java_multiline_comment");
        return formatter;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int style = 768;
                return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new JavaOutlineInformationControl(parent, shellStyle, treeStyle);
            }
        };
    }

    private IInformationControlCreator getHierarchyPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new HierarchyInformationControl(parent, shellStyle, treeStyle);
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        JavaInformationProvider provider = new JavaInformationProvider((IEditorPart)this.getEditor());
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_javadoc");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_character");
        presenter.setSizeConstraints(60, 10, true, true);
        return presenter;
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
        InformationPresenter presenter = new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(InformationPresenter.ANCHOR_GLOBAL);
        JavaElementProvider provider = new JavaElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_javadoc");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_multiline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_singleline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_string");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_character");
        presenter.setSizeConstraints(40, 20, true, false);
        return presenter;
    }

    public IInformationPresenter getHierarchyPresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
        InformationPresenter presenter = new InformationPresenter(this.getHierarchyPresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(InformationPresenter.ANCHOR_GLOBAL);
        JavaElementProvider provider = new JavaElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_javadoc");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_multiline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_singleline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_string");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_character");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }
}

