/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringPreferences;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameRefactoringAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;

public class RenameSupport {
    private RenameRefactoring fRefactoring;
    private RefactoringStatus fPreCheckStatus;
    public static final int NONE = 0;
    public static final int UPDATE_REFERENCES = 1;
    public static final int UPDATE_JAVADOC_COMMENTS = 2;
    public static final int UPDATE_REGULAR_COMMENTS = 4;
    public static final int UPDATE_STRING_LITERALS = 8;
    public static final int UPDATE_GETTER_METHOD = 16;
    public static final int UPDATE_SETTER_METHOD = 32;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IStatus preCheck() throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            return this.fPreCheckStatus.getFirstEntry(4).asStatus();
        }
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    public void openDialog(Shell parent) throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            this.showInformation(parent, this.fPreCheckStatus);
            return;
        }
        RenameRefactoringAction.run(this.fRefactoring, parent);
    }

    public void perform(Shell parent, IRunnableContext context) throws InterruptedException, InvocationTargetException {
        try {
            this.ensureChecked();
            if (this.fPreCheckStatus.hasFatalError()) {
                this.showInformation(parent, this.fPreCheckStatus);
                return;
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        RefactoringExecutionHelper helper = new RefactoringExecutionHelper(this.fRefactoring, RefactoringPreferences.getStopSeverity(), true, parent, context);
        helper.perform();
    }

    private RenameSupport(IJavaElement element, String newName, int flags) throws CoreException {
        this.fRefactoring = new RenameRefactoring(element);
        RenameSupport.initialize(this.fRefactoring, newName, flags);
    }

    public static RenameSupport create(IJavaProject project, String newName, int flags) throws CoreException {
        return new RenameSupport((IJavaElement)project, newName, flags);
    }

    public static RenameSupport create(IPackageFragmentRoot root, String newName) throws CoreException {
        return new RenameSupport((IJavaElement)root, newName, 0);
    }

    public static RenameSupport create(IPackageFragment fragment, String newName, int flags) throws CoreException {
        return new RenameSupport((IJavaElement)fragment, newName, flags);
    }

    public static RenameSupport create(ICompilationUnit unit, String newName, int flags) throws CoreException {
        return new RenameSupport((IJavaElement)unit, newName, flags);
    }

    public static RenameSupport create(IType type, String newName, int flags) throws CoreException {
        return new RenameSupport((IJavaElement)type, newName, flags);
    }

    public static RenameSupport create(IMethod method, String newName, int flags) throws CoreException {
        return new RenameSupport((IJavaElement)method, newName, flags);
    }

    public static RenameSupport create(IField field, String newName, int flags) throws CoreException {
        RenameSupport result = new RenameSupport((IJavaElement)field, newName, flags);
        RenameFieldProcessor processor = (RenameFieldProcessor)result.fRefactoring.getProcessor();
        if (processor != null) {
            processor.setRenameGetter(RenameSupport.updateGetterMethod(flags));
            processor.setRenameSetter(RenameSupport.updateSetterMethod(flags));
        }
        return result;
    }

    private static void initialize(RenameRefactoring refactoring, String newName, int flags) {
        ITextUpdating text;
        Class<?> clazz;
        IReferenceUpdating reference;
        if (refactoring.getProcessor() == null) {
            return;
        }
        RenameSupport.setNewName(refactoring, newName);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("[Lorg.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reference = (IReferenceUpdating)refactoring.getAdapter(clazz2)) != null) {
            reference.setUpdateReferences(RenameSupport.updateReferences(flags));
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((text = (ITextUpdating)refactoring.getAdapter(clazz)) != null) {
            text.setUpdateJavaDoc(RenameSupport.updateJavadocComments(flags));
            text.setUpdateComments(RenameSupport.updateRegularComments(flags));
            text.setUpdateStrings(RenameSupport.updateStringLiterals(flags));
        }
    }

    private static void setNewName(IRenameRefactoring refactoring, String newName) {
        if (newName != null) {
            refactoring.setNewName(newName);
        }
    }

    private static boolean updateReferences(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean updateJavadocComments(int flags) {
        return (flags & 2) != 0;
    }

    private static boolean updateRegularComments(int flags) {
        return (flags & 4) != 0;
    }

    private static boolean updateStringLiterals(int flags) {
        return (flags & 8) != 0;
    }

    private static boolean updateGetterMethod(int flags) {
        return (flags & 0x10) != 0;
    }

    private static boolean updateSetterMethod(int flags) {
        return (flags & 0x20) != 0;
    }

    private void ensureChecked() throws CoreException {
        if (this.fPreCheckStatus == null) {
            this.fPreCheckStatus = this.fRefactoring.getProcessor() == null ? RefactoringStatus.createFatalErrorStatus("This refactoring is not enabled.") : new RefactoringStatus();
        }
    }

    private void showInformation(Shell parent, RefactoringStatus status) {
        String message = status.getFirstMessage(4);
        MessageDialog.openInformation((Shell)parent, (String)"Rename", (String)message);
    }
}

