/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatusEntry;
import org.eclipse.jdt.internal.corext.refactoring.surround.ISurroundWithTryCatchQuery;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryCatchRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringErrorDialogUtil;
import org.eclipse.jdt.internal.ui.refactoring.changes.AbortChangeExceptionHandler;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class SurroundWithTryCatchAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public SurroundWithTryCatchAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.getString("SurroundWithTryCatchAction.label"));
        this.fEditor = editor;
        this.setEnabled(this.checkEditor());
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.surround_with_try_catch_action");
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null || !ElementValidator.checkValidateEdit((IJavaElement)cu, this.getShell(), SurroundWithTryCatchAction.getDialogTitle())) {
            return;
        }
        SurroundWithTryCatchRefactoring refactoring = SurroundWithTryCatchRefactoring.create(this.getCompilationUnit(), selection, JavaPreferencesSettings.getCodeGenerationSettings(), new Query(this.getShell()));
        if (refactoring == null) {
            return;
        }
        try {
            RefactoringStatus status = refactoring.checkActivation((IProgressMonitor)new NullProgressMonitor());
            if (status.hasFatalError()) {
                RefactoringErrorDialogUtil.open(SurroundWithTryCatchAction.getDialogTitle(), status, this.getShell());
                RefactoringStatusEntry entry = status.getFirstEntry(4);
                if (entry.getContext() instanceof JavaStatusContext && this.fEditor != null) {
                    JavaStatusContext context = (JavaStatusContext)entry.getContext();
                    ISourceRange range = context.getSourceRange();
                    this.fEditor.setHighlightRange(range.getOffset(), range.getLength(), true);
                }
                return;
            }
            if (refactoring.stopExecution()) {
                return;
            }
            PerformChangeOperation op = new PerformChangeOperation(refactoring.createChange((IProgressMonitor)new NullProgressMonitor()));
            op.setChangeContext(new ChangeContext(new AbortChangeExceptionHandler()));
            new BusyIndicatorRunnableContext().run(false, false, op);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, SurroundWithTryCatchAction.getDialogTitle(), RefactoringMessages.getString("SurroundWithTryCatchAction.exception"));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, SurroundWithTryCatchAction.getDialogTitle(), RefactoringMessages.getString("SurroundWithTryCatchAction.exception"));
        }
        catch (InterruptedException interruptedException) {}
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(selection.getLength() > 0 && this.checkEditor());
    }

    private final ICompilationUnit getCompilationUnit() {
        return SelectionConverter.getInputAsCompilationUnit(this.fEditor);
    }

    private boolean checkEditor() {
        return this.fEditor != null && this.getCompilationUnit() != null;
    }

    private static String getDialogTitle() {
        return RefactoringMessages.getString("SurroundWithTryCatchAction.dialog.title");
    }

    private static class Query
    implements ISurroundWithTryCatchQuery {
        private Shell fParent;

        public Query(Shell shell) {
            this.fParent = shell;
        }

        public boolean catchRuntimeException() {
            MessageDialog dialog = new MessageDialog(this, this.fParent, SurroundWithTryCatchAction.getDialogTitle(), null, RefactoringMessages.getString("SurroundWithTryCatchAction.no_exceptions"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1){
                final /* synthetic */ Query this$1;
                {
                    this.this$1 = query;
                }

                protected void createButtonsForButtonBar(Composite parent) {
                    super.createButtonsForButtonBar(parent);
                    Button button = this.getButton(1);
                    if (button != null) {
                        button.setFocus();
                    }
                }
            };
            return dialog.open() == 0;
        }
    }
}

