/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.codemanipulation.SortMembersOperation;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class SortMembersAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String ID = "org.eclipse.jdt.ui.actions.SortMembersAction";

    public SortMembersAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("SortMembersAction.label"));
        this.setDescription(ActionMessages.getString("SortMembersAction.description"));
        this.setToolTipText(ActionMessages.getString("SortMembersAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.sort_members_action");
    }

    public SortMembersAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    public void selectionChanged(IStructuredSelection selection) {
        boolean enabled = false;
        enabled = this.getSelectedCompilationUnit(selection) != null;
        this.setEnabled(enabled);
    }

    public void run(IStructuredSelection selection) {
        Shell shell = this.getShell();
        try {
            ICompilationUnit cu = this.getSelectedCompilationUnit(selection);
            int cuMembers = cu.getTypes().length;
            IType type = cu.findPrimaryType();
            int memberCount = type.getChildren().length;
            if (cuMembers <= 1 && memberCount <= 1) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.getString("SortMembersAction.no_members"));
                return;
            }
            if (cu == null || !ElementValidator.check((IJavaElement)cu, this.getShell(), this.getDialogTitle(), false)) {
                return;
            }
            IEditorPart editor = EditorUtility.openInEditor(cu);
            if (editor != null) {
                this.run(shell, JavaModelUtil.toWorkingCopy(cu), editor);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, this.getDialogTitle(), null);
        }
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void run(ITextSelection selection) {
        Shell shell = this.getShell();
        IJavaElement input = SelectionConverter.getInput(this.fEditor);
        if (input instanceof ICompilationUnit) {
            if (ElementValidator.check(input, this.getShell(), this.getDialogTitle(), true)) {
                this.run(shell, (ICompilationUnit)input, (IEditorPart)this.fEditor);
            }
        } else {
            MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.getString("SortMembersAction.not_applicable"));
        }
    }

    private boolean containsRelevantMarkers(IEditorPart editor) {
        IAnnotationModel model = JavaUI.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            IJavaAnnotation annot;
            Object element = iterator.next();
            if (!(element instanceof IJavaAnnotation) || (annot = (IJavaAnnotation)element).isMarkedDeleted() || !annot.isPersistent() || annot.isProblem()) continue;
            return true;
        }
        return false;
    }

    private void run(Shell shell, ICompilationUnit cu, IEditorPart editor) {
        int returnCode;
        if (!ActionUtil.isProcessable(this.getShell(), cu)) {
            return;
        }
        if (this.containsRelevantMarkers(editor) && (returnCode = OptionalMessageDialog.open(ID, this.getShell(), this.getDialogTitle(), null, ActionMessages.getString("SortMembersAction.containsmarkers"), 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0)) != 1025 && returnCode != 0) {
            return;
        }
        SortMembersOperation op = new SortMembersOperation(cu, null);
        try {
            BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
            context.run(false, true, new WorkbenchRunnableAdapter(op));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, shell, this.getDialogTitle(), null);
        }
        catch (InterruptedException interruptedException) {}
    }

    private ICompilationUnit getSelectedCompilationUnit(IStructuredSelection selection) {
        if (selection.size() == 1) {
            IType type;
            Object element = selection.getFirstElement();
            if (element instanceof ICompilationUnit) {
                return (ICompilationUnit)element;
            }
            if (element instanceof IType && (type = (IType)element).getParent() instanceof ICompilationUnit) {
                return type.getCompilationUnit();
            }
        }
        return null;
    }

    private String getDialogTitle() {
        return ActionMessages.getString("SortMembersAction.error.title");
    }
}

