/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInstanceMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.MoveInstanceMethodAction;
import org.eclipse.jdt.internal.ui.refactoring.actions.MoveStaticMembersAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveAction;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class MoveAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private MoveInstanceMethodAction fMoveInstanceMethodAction;
    private MoveStaticMembersAction fMoveStaticMembersAction;
    private ReorgMoveAction fReorgMoveAction;

    public MoveAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("MoveAction.text"));
        this.fMoveStaticMembersAction = new MoveStaticMembersAction(site);
        this.fMoveInstanceMethodAction = new MoveInstanceMethodAction(site);
        this.fReorgMoveAction = new ReorgMoveAction(site);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.move_action");
    }

    public MoveAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(RefactoringMessages.getString("MoveAction.text"));
        this.fMoveStaticMembersAction = new MoveStaticMembersAction(editor);
        this.fMoveInstanceMethodAction = new MoveInstanceMethodAction(editor);
        this.fReorgMoveAction = new ReorgMoveAction((IWorkbenchSite)editor.getEditorSite());
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.move_action");
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fMoveStaticMembersAction.selectionChanged(event);
        this.fMoveInstanceMethodAction.selectionChanged(event);
        this.fReorgMoveAction.selectionChanged(event);
        this.setEnabled(this.computeEnableState());
    }

    public void run(IStructuredSelection selection) {
        try {
            if (this.fMoveInstanceMethodAction.isEnabled() && this.tryMoveInstanceMethod(selection)) {
                return;
            }
            if (this.fMoveStaticMembersAction.isEnabled() && this.tryMoveStaticMembers(selection)) {
                return;
            }
            if (this.fReorgMoveAction.isEnabled()) {
                this.fReorgMoveAction.run();
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    public void run(ITextSelection selection) {
        try {
            if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
                return;
            }
            if (this.fMoveStaticMembersAction.isEnabled() && this.tryMoveStaticMembers(selection)) {
                return;
            }
            if (this.fMoveInstanceMethodAction.isEnabled() && this.tryMoveInstanceMethod(selection)) {
                return;
            }
            if (this.tryReorgMove(selection)) {
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.getString("MoveAction.Move"), (String)RefactoringMessages.getString("MoveAction.select"));
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    private boolean tryMoveStaticMembers(ITextSelection selection) throws JavaModelException {
        IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
        if (element == null || !(element instanceof IMember)) {
            return false;
        }
        IMember[] array = new IMember[]{(IMember)element};
        if (!MoveStaticMembersRefactoring.isAvailable(array)) {
            return false;
        }
        MoveStaticMembersRefactoring refactoring = MoveStaticMembersRefactoring.create(array, JavaPreferencesSettings.getCodeGenerationSettings());
        if (refactoring == null) {
            return false;
        }
        this.fMoveStaticMembersAction.run(selection);
        return true;
    }

    private static IMember[] getSelectedMembers(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof IMember) continue;
            return null;
        }
        return MoveAction.convertToMemberArray(selection.toArray());
    }

    private static IMember[] convertToMemberArray(Object[] obj) {
        if (obj == null) {
            return null;
        }
        HashSet<Object> memberSet = new HashSet<Object>();
        memberSet.addAll(Arrays.asList(obj));
        return memberSet.toArray(new IMember[memberSet.size()]);
    }

    private boolean tryMoveStaticMembers(IStructuredSelection selection) throws JavaModelException {
        IMember[] array = MoveAction.getSelectedMembers(selection);
        if (!MoveStaticMembersRefactoring.isAvailable(array)) {
            return false;
        }
        MoveStaticMembersRefactoring refactoring = MoveStaticMembersRefactoring.create(array, JavaPreferencesSettings.getCodeGenerationSettings());
        if (refactoring == null) {
            return false;
        }
        this.fMoveStaticMembersAction.run(selection);
        return true;
    }

    private boolean tryMoveInstanceMethod(ITextSelection selection) throws JavaModelException {
        IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
        if (element == null || !(element instanceof IMethod)) {
            return false;
        }
        IMethod method = (IMethod)element;
        if (!MoveInstanceMethodRefactoring.isAvailable(method)) {
            return false;
        }
        MoveInstanceMethodRefactoring refactoring = MoveInstanceMethodRefactoring.create(method, JavaPreferencesSettings.getCodeGenerationSettings());
        if (refactoring == null) {
            return false;
        }
        this.fMoveInstanceMethodAction.run(selection);
        return true;
    }

    private boolean tryMoveInstanceMethod(IStructuredSelection selection) throws JavaModelException {
        IMethod method = MoveAction.getSingleSelectedMethod(selection);
        if (method == null) {
            return false;
        }
        if (!MoveInstanceMethodRefactoring.isAvailable(method)) {
            return false;
        }
        MoveInstanceMethodRefactoring refactoring = MoveInstanceMethodRefactoring.create(method, JavaPreferencesSettings.getCodeGenerationSettings());
        if (refactoring == null) {
            return false;
        }
        this.fMoveInstanceMethodAction.run(selection);
        return true;
    }

    private static IMethod getSingleSelectedMethod(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IMethod)) {
            return null;
        }
        return (IMethod)first;
    }

    private boolean tryReorgMove(ITextSelection selection) throws JavaModelException {
        IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
        if (element == null) {
            return false;
        }
        StructuredSelection mockStructuredSelection = new StructuredSelection((Object)element);
        this.fReorgMoveAction.selectionChanged((IStructuredSelection)mockStructuredSelection);
        if (!this.fReorgMoveAction.isEnabled()) {
            return false;
        }
        this.fReorgMoveAction.run((IStructuredSelection)mockStructuredSelection);
        return true;
    }

    public void update(ISelection selection) {
        this.fMoveStaticMembersAction.update(selection);
        this.fMoveInstanceMethodAction.update(selection);
        this.fReorgMoveAction.update(selection);
        this.setEnabled(this.computeEnableState());
    }

    private boolean computeEnableState() {
        return this.fMoveStaticMembersAction.isEnabled() || this.fMoveInstanceMethodAction.isEnabled() || this.fReorgMoveAction.isEnabled();
    }
}

