/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.DeclarationsSearchGroup;
import org.eclipse.jdt.ui.actions.FindOccurrencesInFileAction;
import org.eclipse.jdt.ui.actions.ImplementorsSearchGroup;
import org.eclipse.jdt.ui.actions.ReadReferencesSearchGroup;
import org.eclipse.jdt.ui.actions.ReferencesSearchGroup;
import org.eclipse.jdt.ui.actions.WriteReferencesSearchGroup;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class JavaSearchActionGroup
extends ActionGroup {
    private JavaEditor fEditor;
    private IWorkbenchSite fSite;
    private ReferencesSearchGroup fReferencesGroup;
    private ReadReferencesSearchGroup fReadAccessGroup;
    private WriteReferencesSearchGroup fWriteAccessGroup;
    private DeclarationsSearchGroup fDeclarationsGroup;
    private ImplementorsSearchGroup fImplementorsGroup;
    private FindOccurrencesInFileAction fOccurrencesInFileAction;

    public JavaSearchActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getViewSite());
        this.fOccurrencesInFileAction = new FindOccurrencesInFileAction(part);
        part.getViewSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.fOccurrencesInFileAction);
    }

    public JavaSearchActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
        this.fOccurrencesInFileAction = new FindOccurrencesInFileAction(page);
        page.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.fOccurrencesInFileAction);
    }

    public JavaSearchActionGroup(JavaEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fReferencesGroup = new ReferencesSearchGroup(this.fEditor);
        this.fReadAccessGroup = new ReadReferencesSearchGroup(this.fEditor);
        this.fWriteAccessGroup = new WriteReferencesSearchGroup(this.fEditor);
        this.fDeclarationsGroup = new DeclarationsSearchGroup(this.fEditor);
        this.fImplementorsGroup = new ImplementorsSearchGroup(this.fEditor);
        this.fOccurrencesInFileAction = new FindOccurrencesInFileAction(this.fEditor);
    }

    private JavaSearchActionGroup(IWorkbenchSite site) {
        this.fReferencesGroup = new ReferencesSearchGroup(site);
        this.fReadAccessGroup = new ReadReferencesSearchGroup(site);
        this.fWriteAccessGroup = new WriteReferencesSearchGroup(site);
        this.fDeclarationsGroup = new DeclarationsSearchGroup(site);
        this.fImplementorsGroup = new ImplementorsSearchGroup(site);
        this.fSite = site;
    }

    public void setContext(ActionContext context) {
        this.fReferencesGroup.setContext(context);
        this.fDeclarationsGroup.setContext(context);
        this.fImplementorsGroup.setContext(context);
        this.fReadAccessGroup.setContext(context);
        this.fWriteAccessGroup.setContext(context);
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.fReferencesGroup.fillActionBars(actionBar);
        this.fDeclarationsGroup.fillActionBars(actionBar);
        this.fImplementorsGroup.fillActionBars(actionBar);
        this.fReadAccessGroup.fillActionBars(actionBar);
        this.fWriteAccessGroup.fillActionBars(actionBar);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.OccurrencesInFile", (IAction)this.fOccurrencesInFileAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (PreferenceConstants.getPreferenceStore().getBoolean("small_search_menu")) {
            this.fReferencesGroup.fillContextMenu(menu);
        } else {
            IMenuManager target = menu;
            MenuManager searchSubMenu = null;
            if (this.fEditor != null) {
                String groupName = SearchMessages.getString("group.search");
                searchSubMenu = new MenuManager(groupName, "group.find");
                searchSubMenu.add((IContributionItem)new GroupMarker("group.find"));
                target = searchSubMenu;
            }
            this.fReferencesGroup.fillContextMenu(target);
            this.fDeclarationsGroup.fillContextMenu(target);
            this.fImplementorsGroup.fillContextMenu(target);
            this.fReadAccessGroup.fillContextMenu(target);
            this.fWriteAccessGroup.fillContextMenu(target);
            if (searchSubMenu != null) {
                searchSubMenu.add((IContributionItem)new Separator());
                this.addAction(target, (IAction)this.fOccurrencesInFileAction);
            } else {
                this.addAction(target, "group.search", (IAction)this.fOccurrencesInFileAction);
            }
            if (searchSubMenu != null && searchSubMenu.getItems().length > 2) {
                menu.appendToGroup("group.find", (IContributionItem)searchSubMenu);
            }
        }
    }

    public void dispose() {
        this.fReferencesGroup.dispose();
        this.fDeclarationsGroup.dispose();
        this.fImplementorsGroup.dispose();
        this.fReadAccessGroup.dispose();
        this.fWriteAccessGroup.dispose();
        if (this.fOccurrencesInFileAction != null) {
            this.fSite.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.fOccurrencesInFileAction);
        }
        super.dispose();
    }

    private void addAction(IMenuManager manager, IAction action) {
        if (action != null && action.isEnabled()) {
            manager.add(action);
        }
    }

    private void addAction(IMenuManager manager, String group, IAction action) {
        if (action != null && action.isEnabled()) {
            manager.appendToGroup(group, action);
        }
    }
}

