/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.ui.actions.FindAction;
import org.eclipse.jdt.ui.actions.FindImplementorsAction;
import org.eclipse.jdt.ui.actions.FindImplementorsInProjectAction;
import org.eclipse.jdt.ui.actions.FindImplementorsInWorkingSetAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jdt.ui.actions.WorkingSetFindAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;

public class ImplementorsSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.getString("group.implementors");
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindImplementorsAction fFindImplementorsAction;
    private FindImplementorsInProjectAction fFindImplementorsInProjectAction;
    private FindImplementorsInWorkingSetAction fFindImplementorsInWorkingSetAction;

    public ImplementorsSearchGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.fFindImplementorsAction = new FindImplementorsAction(site);
        this.fFindImplementorsInProjectAction = new FindImplementorsInProjectAction(site);
        this.fFindImplementorsInWorkingSetAction = new FindImplementorsInWorkingSetAction(site);
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.registerAction(this.fFindImplementorsAction, provider, selection);
        this.registerAction(this.fFindImplementorsInProjectAction, provider, selection);
        this.registerAction(this.fFindImplementorsInWorkingSetAction, provider, selection);
    }

    public ImplementorsSearchGroup(JavaEditor editor) {
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindImplementorsAction = new FindImplementorsAction(this.fEditor);
        this.fFindImplementorsAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.implementors.in.workspace");
        this.fEditor.setAction("SearchImplementorsInWorkspace", (IAction)this.fFindImplementorsAction);
        this.fFindImplementorsInProjectAction = new FindImplementorsInProjectAction(this.fEditor);
        this.fFindImplementorsInProjectAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.implementors.in.project");
        this.fEditor.setAction("SearchImplementorsInProject", (IAction)this.fFindImplementorsInProjectAction);
        this.fFindImplementorsInWorkingSetAction = new FindImplementorsInWorkingSetAction(this.fEditor);
        this.fFindImplementorsInWorkingSetAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.implementors.in.working.set");
        this.fEditor.setAction("SearchImplementorsInWorkingSet", (IAction)this.fFindImplementorsInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    private FindAction[] getActions(ISelection sel) {
        ArrayList<FindAction> actions = new ArrayList<FindAction>(SearchUtil.LRU_WORKINGSET_LIST_SIZE + 2);
        actions.add(this.fFindImplementorsAction);
        actions.add(this.fFindImplementorsInProjectAction);
        actions.add(this.fFindImplementorsInWorkingSetAction);
        Iterator iter = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iter.hasNext()) {
            IWorkingSet[] workingSets = (IWorkingSet[])iter.next();
            WorkingSetFindAction action = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindImplementorsInWorkingSetAction(this.fEditor, workingSets), SearchUtil.toString(workingSets)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindImplementorsInWorkingSetAction(this.fSite, workingSets), SearchUtil.toString(workingSets));
            action.update(sel);
            actions.add(action);
        }
        return actions.toArray(new FindAction[actions.size()]);
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager javaSearchMM = new MenuManager(MENU_TEXT, "group.search");
        ISelection sel = this.getContext().getSelection();
        FindAction[] actions = this.getActions(sel);
        int i = 0;
        while (i < actions.length) {
            FindAction action = actions[i];
            if (action.isEnabled()) {
                javaSearchMM.add((IAction)action);
            }
            ++i;
        }
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fFindImplementorsAction, provider);
            this.disposeAction(this.fFindImplementorsInProjectAction, provider);
            this.disposeAction(this.fFindImplementorsInWorkingSetAction, provider);
        }
        super.dispose();
        this.fFindImplementorsAction = null;
        this.fFindImplementorsInProjectAction = null;
        this.fFindImplementorsInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ImplementorsInWorkspace", (IAction)this.fFindImplementorsAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ImplementorsInProject", (IAction)this.fFindImplementorsInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ImplementorsInWorkingSet", (IAction)this.fFindImplementorsInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

