/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.AddTaskAction;
import org.eclipse.jdt.internal.ui.javaeditor.AddImportOnSelectionAction;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.actions.AddDelegateMethodsAction;
import org.eclipse.jdt.ui.actions.AddGetterSetterAction;
import org.eclipse.jdt.ui.actions.AddJavaDocStubAction;
import org.eclipse.jdt.ui.actions.AddToClasspathAction;
import org.eclipse.jdt.ui.actions.AddUnimplementedConstructorsAction;
import org.eclipse.jdt.ui.actions.ExternalizeStringsAction;
import org.eclipse.jdt.ui.actions.FindStringsToExternalizeAction;
import org.eclipse.jdt.ui.actions.GenerateNewConstructorUsingFieldsAction;
import org.eclipse.jdt.ui.actions.JdtActionConstants;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jdt.ui.actions.OverrideMethodsAction;
import org.eclipse.jdt.ui.actions.RemoveFromClasspathAction;
import org.eclipse.jdt.ui.actions.SortMembersAction;
import org.eclipse.jdt.ui.actions.SurroundWithTryCatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ConvertLineDelimitersAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class GenerateActionGroup
extends ActionGroup {
    private CompilationUnitEditor fEditor;
    private IWorkbenchSite fSite;
    private String fGroupName = "group.reorganize";
    private List fRegisteredSelectionListeners;
    private AddImportOnSelectionAction fAddImport;
    private OverrideMethodsAction fOverrideMethods;
    private AddGetterSetterAction fAddGetterSetter;
    private AddDelegateMethodsAction fAddDelegateMethods;
    private AddUnimplementedConstructorsAction fAddUnimplementedConstructors;
    private GenerateNewConstructorUsingFieldsAction fGenerateConstructorUsingFields;
    private AddJavaDocStubAction fAddJavaDocStub;
    private AddBookmarkAction fAddBookmark;
    private AddTaskAction fAddTaskAction;
    private ExternalizeStringsAction fExternalizeStrings;
    private FindStringsToExternalizeAction fFindStringsToExternalize;
    private SurroundWithTryCatchAction fSurroundWithTryCatch;
    private AddToClasspathAction fAddToClasspathAction;
    private RemoveFromClasspathAction fRemoveFromClasspathAction;
    private OrganizeImportsAction fOrganizeImports;
    private SortMembersAction fSortMembers;
    private ConvertLineDelimitersAction fConvertToWindows;
    private ConvertLineDelimitersAction fConvertToUNIX;
    private ConvertLineDelimitersAction fConvertToMac;

    public GenerateActionGroup(CompilationUnitEditor editor, String groupName) {
        this.fSite = editor.getSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fAddImport = new AddImportOnSelectionAction(editor);
        this.fAddImport.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.add.import");
        this.fAddImport.update();
        editor.setAction("AddImport", (IAction)this.fAddImport);
        this.fOrganizeImports = new OrganizeImportsAction(editor);
        this.fOrganizeImports.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.organize.imports");
        editor.setAction("OrganizeImports", (IAction)this.fOrganizeImports);
        this.fSortMembers = new SortMembersAction(editor);
        this.fSortMembers.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.sort.members");
        editor.setAction("SortMembers", (IAction)this.fSortMembers);
        this.fOverrideMethods = new OverrideMethodsAction(editor);
        this.fOverrideMethods.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.override.methods");
        editor.setAction("OverrideMethods", (IAction)this.fOverrideMethods);
        this.fAddGetterSetter = new AddGetterSetterAction(editor);
        this.fAddGetterSetter.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.create.getter.setter");
        editor.setAction("AddGetterSetter", (IAction)this.fAddGetterSetter);
        this.fAddDelegateMethods = new AddDelegateMethodsAction(editor);
        this.fAddDelegateMethods.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.create.delegate.methods");
        editor.setAction("AddDelegateMethods", (IAction)this.fAddDelegateMethods);
        this.fAddUnimplementedConstructors = new AddUnimplementedConstructorsAction(editor);
        this.fAddUnimplementedConstructors.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.add.unimplemented.constructors");
        editor.setAction("AddUnimplementedConstructors", (IAction)this.fAddUnimplementedConstructors);
        this.fGenerateConstructorUsingFields = new GenerateNewConstructorUsingFieldsAction(editor);
        this.fGenerateConstructorUsingFields.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.generate.constructor.using.fields");
        editor.setAction("GenerateConstructorUsingFields", (IAction)this.fGenerateConstructorUsingFields);
        this.fAddJavaDocStub = new AddJavaDocStubAction(editor);
        this.fAddJavaDocStub.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.add.javadoc.comment");
        editor.setAction("AddJavadocComment", (IAction)this.fAddJavaDocStub);
        this.fSurroundWithTryCatch = new SurroundWithTryCatchAction(editor);
        this.fSurroundWithTryCatch.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.surround.with.try.catch");
        this.fSurroundWithTryCatch.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.fSurroundWithTryCatch);
        editor.setAction("SurroundWithTryCatch", (IAction)this.fSurroundWithTryCatch);
        this.fExternalizeStrings = new ExternalizeStringsAction(editor);
        this.fExternalizeStrings.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.externalize.strings");
        editor.setAction("ExternalizeStrings", (IAction)this.fExternalizeStrings);
        this.fConvertToWindows = new ConvertLineDelimitersAction((ITextEditor)editor, "\r\n");
        this.fConvertToWindows.setActionDefinitionId("org.eclipse.ui.edit.text.convert.lineDelimiters.toWindows");
        this.fConvertToWindows.setHelpContextId("org.eclipse.ui.ConvertLineDelimitersToWindows_action_context");
        editor.setAction("ConvertLineDelimitersToWindows", (IAction)this.fConvertToWindows);
        this.fConvertToUNIX = new ConvertLineDelimitersAction((ITextEditor)editor, "\n");
        this.fConvertToUNIX.setActionDefinitionId("org.eclipse.ui.edit.text.convert.lineDelimiters.toUNIX");
        this.fConvertToUNIX.setHelpContextId("org.eclipse.ui.ConvertLineDelimitersToUNIX_action_context");
        editor.setAction("ConvertLineDelimitersToUNIX", (IAction)this.fConvertToUNIX);
        this.fConvertToMac = new ConvertLineDelimitersAction((ITextEditor)editor, "\r");
        this.fConvertToMac.setActionDefinitionId("org.eclipse.ui.edit.text.convert.lineDelimiters.toMac");
        this.fConvertToMac.setHelpContextId("org.eclipse.ui.ConvertLineDelimitersToMAC_action_context");
        editor.setAction("ConvertLineDelimitersToMac", (IAction)this.fConvertToMac);
    }

    public GenerateActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public GenerateActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    private GenerateActionGroup(IWorkbenchSite site) {
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fOverrideMethods = new OverrideMethodsAction(site);
        this.fAddGetterSetter = new AddGetterSetterAction(site);
        this.fAddDelegateMethods = new AddDelegateMethodsAction(site);
        this.fAddUnimplementedConstructors = new AddUnimplementedConstructorsAction(site);
        this.fGenerateConstructorUsingFields = new GenerateNewConstructorUsingFieldsAction(site);
        this.fAddJavaDocStub = new AddJavaDocStubAction(site);
        this.fAddBookmark = new AddBookmarkAction(site.getShell());
        this.fAddToClasspathAction = new AddToClasspathAction(site);
        this.fRemoveFromClasspathAction = new RemoveFromClasspathAction(site);
        this.fAddTaskAction = new AddTaskAction(site);
        this.fExternalizeStrings = new ExternalizeStringsAction(site);
        this.fFindStringsToExternalize = new FindStringsToExternalizeAction(site);
        this.fOrganizeImports = new OrganizeImportsAction(site);
        this.fSortMembers = new SortMembersAction(site);
        this.fOverrideMethods.update(selection);
        this.fAddGetterSetter.update(selection);
        this.fAddDelegateMethods.update(selection);
        this.fAddUnimplementedConstructors.update(selection);
        this.fGenerateConstructorUsingFields.update(selection);
        this.fAddJavaDocStub.update(selection);
        this.fAddToClasspathAction.update(selection);
        this.fRemoveFromClasspathAction.update(selection);
        this.fExternalizeStrings.update(selection);
        this.fFindStringsToExternalize.update(selection);
        this.fAddTaskAction.update(selection);
        this.fOrganizeImports.update(selection);
        this.fSortMembers.update(selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            this.fAddBookmark.selectionChanged(ss);
        } else {
            this.fAddBookmark.setEnabled(false);
        }
        this.registerSelectionListener(provider, this.fOverrideMethods);
        this.registerSelectionListener(provider, this.fAddGetterSetter);
        this.registerSelectionListener(provider, this.fAddDelegateMethods);
        this.registerSelectionListener(provider, this.fAddUnimplementedConstructors);
        this.registerSelectionListener(provider, this.fGenerateConstructorUsingFields);
        this.registerSelectionListener(provider, this.fAddJavaDocStub);
        this.registerSelectionListener(provider, (ISelectionChangedListener)this.fAddBookmark);
        this.registerSelectionListener(provider, this.fAddToClasspathAction);
        this.registerSelectionListener(provider, this.fRemoveFromClasspathAction);
        this.registerSelectionListener(provider, this.fExternalizeStrings);
        this.registerSelectionListener(provider, this.fFindStringsToExternalize);
        this.registerSelectionListener(provider, this.fOrganizeImports);
        this.registerSelectionListener(provider, this.fSortMembers);
        this.registerSelectionListener(provider, this.fAddTaskAction);
    }

    private void registerSelectionListener(ISelectionProvider provider, ISelectionChangedListener listener) {
        if (this.fRegisteredSelectionListeners == null) {
            this.fRegisteredSelectionListeners = new ArrayList(20);
        }
        provider.addSelectionChangedListener(listener);
        this.fRegisteredSelectionListeners.add(listener);
    }

    public void editorStateChanged() {
        Assert.isTrue((boolean)this.isEditorOwner());
        this.fConvertToMac.update();
        this.fConvertToUNIX.update();
        this.fConvertToWindows.update();
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        IMenuManager subMenu = null;
        subMenu = this.isEditorOwner() ? this.createEditorSubMenu(menu) : this.createViewSubMenu(menu);
        if (subMenu != null) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
        }
    }

    private IMenuManager createEditorSubMenu(IMenuManager mainMenu) {
        MenuManager result = new MenuManager(ActionMessages.getString("SourceMenu.label"));
        int added = 0;
        added += this.addEditorAction((IMenuManager)result, "Comment");
        added += this.addEditorAction((IMenuManager)result, "Uncomment");
        added += this.addEditorAction((IMenuManager)result, "AddBlockComment");
        added += this.addEditorAction((IMenuManager)result, "RemoveBlockComment");
        added += this.addEditorAction((IMenuManager)result, "Format");
        added += this.addEditorAction((IMenuManager)result, "Indent");
        result.add((IContributionItem)new Separator());
        added += this.addAction((IMenuManager)result, (IAction)this.fOrganizeImports);
        added += this.addAction((IMenuManager)result, (IAction)this.fAddImport);
        result.add((IContributionItem)new Separator());
        added += this.addAction((IMenuManager)result, (IAction)this.fOverrideMethods);
        added += this.addAction((IMenuManager)result, (IAction)this.fAddGetterSetter);
        added += this.addAction((IMenuManager)result, (IAction)this.fAddDelegateMethods);
        added += this.addAction((IMenuManager)result, (IAction)this.fAddUnimplementedConstructors);
        added += this.addAction((IMenuManager)result, (IAction)this.fGenerateConstructorUsingFields);
        added += this.addAction((IMenuManager)result, (IAction)this.fAddJavaDocStub);
        result.add((IContributionItem)new Separator());
        if ((added += this.addAction((IMenuManager)result, (IAction)this.fSurroundWithTryCatch)) == 0) {
            result = null;
        }
        return result;
    }

    private IMenuManager createViewSubMenu(IMenuManager mainMenu) {
        MenuManager result = new MenuManager(ActionMessages.getString("SourceMenu.label"));
        int added = 0;
        added += this.addAction((IMenuManager)result, (IAction)this.fSortMembers);
        result.add((IContributionItem)new Separator());
        added += this.addAction((IMenuManager)result, (IAction)this.fOrganizeImports);
        added += this.addAction((IMenuManager)result, (IAction)this.fAddImport);
        result.add((IContributionItem)new Separator());
        added += this.addAction((IMenuManager)result, (IAction)this.fOverrideMethods);
        added += this.addAction((IMenuManager)result, (IAction)this.fAddGetterSetter);
        added += this.addAction((IMenuManager)result, (IAction)this.fAddDelegateMethods);
        added += this.addAction((IMenuManager)result, (IAction)this.fAddUnimplementedConstructors);
        added += this.addAction((IMenuManager)result, (IAction)this.fGenerateConstructorUsingFields);
        added += this.addAction((IMenuManager)result, (IAction)this.fAddJavaDocStub);
        added += this.addAction((IMenuManager)result, (IAction)this.fAddToClasspathAction);
        added += this.addAction((IMenuManager)result, (IAction)this.fRemoveFromClasspathAction);
        result.add((IContributionItem)new Separator());
        added += this.addAction((IMenuManager)result, (IAction)this.fSurroundWithTryCatch);
        added += this.addAction((IMenuManager)result, (IAction)this.fExternalizeStrings);
        if ((added += this.addAction((IMenuManager)result, (IAction)this.fFindStringsToExternalize)) == 0) {
            result = null;
        }
        return result;
    }

    public void dispose() {
        if (this.fRegisteredSelectionListeners != null) {
            ISelectionProvider provider = this.fSite.getSelectionProvider();
            Iterator iter = this.fRegisteredSelectionListeners.iterator();
            while (iter.hasNext()) {
                ISelectionChangedListener listener = (ISelectionChangedListener)iter.next();
                provider.removeSelectionChangedListener(listener);
            }
        }
        this.fEditor = null;
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.AddImport", (IAction)this.fAddImport);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.SurroundWithTryCatch", (IAction)this.fSurroundWithTryCatch);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.OverrideMethods", (IAction)this.fOverrideMethods);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.GenerateGetterSetter", (IAction)this.fAddGetterSetter);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.GenerateDelegateMethods", (IAction)this.fAddDelegateMethods);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.AddConstructorFromSuperclass", (IAction)this.fAddUnimplementedConstructors);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.GenerateConstructorUsingFields", (IAction)this.fGenerateConstructorUsingFields);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.AddJavaDocComment", (IAction)this.fAddJavaDocStub);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ExternalizeStrings", (IAction)this.fExternalizeStrings);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.FindStringsToExternalize", (IAction)this.fFindStringsToExternalize);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.OrganizeImports", (IAction)this.fOrganizeImports);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.SortMembers", (IAction)this.fSortMembers);
        actionBar.setGlobalActionHandler(JdtActionConstants.CONVERT_LINE_DELIMITERS_TO_WINDOWS, (IAction)this.fConvertToWindows);
        actionBar.setGlobalActionHandler(JdtActionConstants.CONVERT_LINE_DELIMITERS_TO_UNIX, (IAction)this.fConvertToUNIX);
        actionBar.setGlobalActionHandler(JdtActionConstants.CONVERT_LINE_DELIMITERS_TO_MAC, (IAction)this.fConvertToMac);
        if (!this.isEditorOwner()) {
            actionBar.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.fAddBookmark);
            actionBar.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.fAddTaskAction);
        }
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private int addEditorAction(IMenuManager menu, String actionID) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction action = this.fEditor.getAction(actionID);
        if (action == null) {
            return 0;
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean isEditorOwner() {
        return this.fEditor != null;
    }
}

