/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.JavaSearchOperation;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.ui.actions.FindImplementorsAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.help.WorkbenchHelp;

public class FindImplementorsInWorkingSetAction
extends FindImplementorsAction {
    private IWorkingSet[] fWorkingSets;

    public FindImplementorsInWorkingSetAction(IWorkbenchSite site) {
        super(site);
        this.init();
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.find_implementors_in_working_set_action");
    }

    public FindImplementorsInWorkingSetAction(IWorkbenchSite site, IWorkingSet[] workingSets) {
        this(site);
        this.fWorkingSets = workingSets;
    }

    public FindImplementorsInWorkingSetAction(JavaEditor editor) {
        super(editor);
        this.init();
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.find_implementors_in_working_set_action");
    }

    public FindImplementorsInWorkingSetAction(JavaEditor editor, IWorkingSet[] workingSets) {
        this(editor);
        this.fWorkingSets = workingSets;
    }

    private void init() {
        this.setText(SearchMessages.getString("Search.FindImplementorsInWorkingSetAction.label"));
        this.setToolTipText(SearchMessages.getString("Search.FindImplementorsInWorkingSetAction.tooltip"));
    }

    JavaSearchOperation makeOperation(IJavaElement element) throws JavaModelException {
        IWorkingSet[] workingSets = this.fWorkingSets;
        if (this.fWorkingSets == null && (workingSets = JavaSearchScopeFactory.getInstance().queryWorkingSets()) == null) {
            return null;
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        return new JavaSearchOperation(JavaPlugin.getWorkspace(), element, this.getLimitTo(), this.getScope(workingSets), this.getScopeDescription(workingSets), this.getCollector());
    }

    private IJavaSearchScope getScope(IWorkingSet[] workingSets) throws JavaModelException {
        return JavaSearchScopeFactory.getInstance().createJavaSearchScope(workingSets);
    }

    private String getScopeDescription(IWorkingSet[] workingSets) {
        return SearchMessages.getFormattedString("WorkingSetScope", new String[]{SearchUtil.toString(workingSets)});
    }
}

