/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.internal.ui.refactoring.reorg.CopyToClipboardAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CutAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.DeleteAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.PasteAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class CCPActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private Clipboard fClipboard;
    private SelectionDispatchAction[] fActions;
    private SelectionDispatchAction fDeleteAction;
    private SelectionDispatchAction fCopyAction;
    private SelectionDispatchAction fPasteAction;
    private SelectionDispatchAction fCutAction;

    public CCPActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    public CCPActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    private CCPActionGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fClipboard = new Clipboard(site.getShell().getDisplay());
        this.fPasteAction = new PasteAction(this.fSite, this.fClipboard);
        this.fCopyAction = new CopyToClipboardAction(this.fSite, this.fClipboard, this.fPasteAction);
        this.fCutAction = new CutAction(this.fSite, this.fClipboard, this.fPasteAction);
        this.fDeleteAction = new DeleteAction(this.fSite);
        this.fActions = new SelectionDispatchAction[]{this.fCutAction, this.fCopyAction, this.fPasteAction, this.fDeleteAction};
        this.registerActionsAsSelectionChangeListeners();
    }

    private void registerActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        int i = 0;
        while (i < this.fActions.length) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fActions[i]);
            ++i;
        }
    }

    private void deregisterActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        int i = 0;
        while (i < this.fActions.length) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fActions[i]);
            ++i;
        }
    }

    public IAction getDeleteAction() {
        return this.fDeleteAction;
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("delete", (IAction)this.fDeleteAction);
        actionBars.setGlobalActionHandler("copy", (IAction)this.fCopyAction);
        actionBars.setGlobalActionHandler("cut", (IAction)this.fCutAction);
        actionBars.setGlobalActionHandler("paste", (IAction)this.fPasteAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        int i = 0;
        while (i < this.fActions.length) {
            menu.appendToGroup("group.reorganize", (IAction)this.fActions[i]);
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
        this.deregisterActionsAsSelectionChangeListeners();
    }
}

