/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddUnimplementedConstructorsAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_TITLE = ActionMessages.getString("AddUnimplementedConstructorsAction.error.title");
    static /* synthetic */ Class class$0;

    public AddUnimplementedConstructorsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("AddUnimplementedConstructorsAction.label"));
        this.setDescription(ActionMessages.getString("AddUnimplementedConstructorsAction.description"));
        this.setToolTipText(ActionMessages.getString("AddUnimplementedConstructorsAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.add_unimplemented_constructors_action_context");
    }

    public AddUnimplementedConstructorsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getCompilationUnit() != null && type.isClass() && !type.isLocal();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit;
    }

    public void run(IStructuredSelection selection) {
        Shell shell = this.getShell();
        try {
            IType type = this.getSelectedType(selection);
            if (type == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.getString("AddUnimplementedConstructorsAction.not_applicable"));
                return;
            }
            if (type == null) {
                MessageDialog.openError((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.getString("AddUnimplementedConstructorsAction.error.type_removed_in_editor"));
                return;
            }
            this.run(shell, type, false);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, this.getDialogTitle(), null);
        }
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void run(ITextSelection selection) {
        Shell shell = this.getShell();
        try {
            IType type = SelectionConverter.getTypeAtOffset(this.fEditor);
            if (type != null) {
                this.run(shell, type, true);
            } else {
                MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.getString("AddUnimplementedConstructorsAction.not_applicable"));
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), this.getDialogTitle(), null);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), null);
        }
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    /*
     * Exception decompiling
     */
    private void run(Shell shell, IType type, boolean activatedFromEditor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 630->634)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ISelectionStatusValidator createValidator(int entries) {
        AddUnimplementedConstructorsValidator validator = new AddUnimplementedConstructorsValidator(entries);
        return validator;
    }

    private IType getSelectedType(IStructuredSelection selection) throws JavaModelException {
        ICompilationUnit cu;
        IType type;
        Object[] elements = selection.toArray();
        if (elements.length == 1 && elements[0] instanceof IType) {
            IType type2 = (IType)elements[0];
            if (type2.getCompilationUnit() != null && type2.isClass()) {
                return type2;
            }
        } else if (elements[0] instanceof ICompilationUnit && (type = (cu = (ICompilationUnit)elements[0]).findPrimaryType()) != null && !type.isInterface()) {
            return type;
        }
        return null;
    }

    private String getDialogTitle() {
        return DIALOG_TITLE;
    }

    private static class AddUnimplementedConstructorsContentProvider
    implements ITreeContentProvider {
        private IMethod[] fMethodsList;
        private static final Object[] EMPTY = new Object[0];

        public AddUnimplementedConstructorsContentProvider(IMethod[] methodList) {
            this.fMethodsList = methodList;
        }

        public Object[] getChildren(Object parentElement) {
            return EMPTY;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.fMethodsList;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class AddUnimplementedConstructorsValidator
    implements ISelectionStatusValidator {
        private static int fEntries;

        AddUnimplementedConstructorsValidator(int entries) {
            fEntries = entries;
        }

        public IStatus validate(Object[] selection) {
            int count = this.countSelectedMethods(selection);
            if (count == 0) {
                return new StatusInfo(4, "");
            }
            String message = ActionMessages.getFormattedString("AddUnimplementedConstructorsAction.methods_selected", new Object[]{String.valueOf(count), String.valueOf(fEntries)});
            return new StatusInfo(1, message);
        }

        private int countSelectedMethods(Object[] selection) {
            int count = 0;
            int i = 0;
            while (i < selection.length) {
                if (selection[i] instanceof IMethod) {
                    ++count;
                }
                ++i;
            }
            return count;
        }
    }

    private static class AddUnimplementedConstructorsDialog
    extends SourceActionDialog {
        private boolean fOmitSuper;
        private int fWidth = 60;
        private int fHeight = 18;
        private IDialogSettings fAddConstructorsSettings;
        private final String SETTINGS_SECTION = "AddUnimplementedConstructorsDialog";
        private final String OMIT_SUPER = "OmitCallToSuper";

        public AddUnimplementedConstructorsDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, CompilationUnitEditor editor, IType type) {
            super(parent, labelProvider, contentProvider, editor, type);
            IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
            this.fAddConstructorsSettings = dialogSettings.getSection("AddUnimplementedConstructorsDialog");
            if (this.fAddConstructorsSettings == null) {
                this.fAddConstructorsSettings = dialogSettings.addNewSection("AddUnimplementedConstructorsDialog");
                this.fAddConstructorsSettings.put("OmitCallToSuper", false);
            }
            this.fOmitSuper = this.fAddConstructorsSettings.getBoolean("OmitCallToSuper");
        }

        protected Composite createEntryPtCombo(Composite composite) {
            Composite entryComposite = super.createEntryPtCombo(composite);
            this.addVisibilityAndModifiersChoices(entryComposite);
            return entryComposite;
        }

        protected Composite createVisibilityControlAndModifiers(Composite parent, IVisibilityChangeListener visibilityChangeListener, int[] availableVisibilities, int correctVisibility) {
            Composite visibilityComposite = this.createVisibilityControl(parent, visibilityChangeListener, availableVisibilities, correctVisibility);
            return visibilityComposite;
        }

        public boolean isOmitSuper() {
            return this.fOmitSuper;
        }

        public void setOmitSuper(boolean omitSuper) {
            if (this.fOmitSuper != omitSuper) {
                this.fOmitSuper = omitSuper;
                this.fAddConstructorsSettings.put("OmitCallToSuper", omitSuper);
            }
        }

        private Composite createOmitSuper(Composite composite) {
            Composite omitSuperComposite = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            omitSuperComposite.setLayout((Layout)layout);
            omitSuperComposite.setFont(composite.getFont());
            Button omitSuperButton = new Button(omitSuperComposite, 32);
            omitSuperButton.setText(ActionMessages.getString("AddUnimplementedConstructorsDialog.omit.super"));
            omitSuperButton.setLayoutData((Object)new GridData(256));
            omitSuperButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ AddUnimplementedConstructorsDialog this$1;
                {
                    this.this$1 = addUnimplementedConstructorsDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = ((Button)e.widget).getSelection();
                    this.this$1.setOmitSuper(isSelected);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            omitSuperButton.setSelection(this.isOmitSuper());
            GridData gd = new GridData(256);
            gd.horizontalSpan = 2;
            omitSuperButton.setLayoutData((Object)gd);
            return omitSuperComposite;
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            GridData gd = null;
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            Label messageLabel = this.createMessageArea(composite);
            if (messageLabel != null) {
                gd = new GridData(256);
                gd.horizontalSpan = 2;
                messageLabel.setLayoutData((Object)gd);
            }
            Composite inner = new Composite(composite, 0);
            GridLayout innerLayout = new GridLayout();
            innerLayout.numColumns = 2;
            innerLayout.marginHeight = 0;
            innerLayout.marginWidth = 0;
            inner.setLayout((Layout)innerLayout);
            inner.setFont(parent.getFont());
            CheckboxTreeViewer treeViewer = this.createTreeViewer(inner);
            gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
            gd.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
            treeViewer.getControl().setLayoutData((Object)gd);
            Composite buttonComposite = this.createSelectionButtons(inner);
            gd = new GridData(272);
            buttonComposite.setLayoutData((Object)gd);
            gd = new GridData(1808);
            inner.setLayoutData((Object)gd);
            Composite entryComposite = this.createEntryPtCombo(composite);
            entryComposite.setLayoutData((Object)new GridData(768));
            Composite commentComposite = this.createCommentSelection(composite);
            commentComposite.setLayoutData((Object)new GridData(768));
            Composite overrideSuperComposite = this.createOmitSuper(composite);
            overrideSuperComposite.setLayoutData((Object)new GridData(768));
            gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }
    }
}

