/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class OverrideIndicatorLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;

    public OverrideIndicatorLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public OverrideIndicatorLabelDecorator(ImageDescriptorRegistry registry) {
        this.fRegistry = registry;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object element) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
        }
        return image;
    }

    public int computeAdornmentFlags(Object element) {
        block6: {
            if (element instanceof IMethod) {
                if (!PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.overrideindicator")) {
                    return 0;
                }
                try {
                    IMethod method = (IMethod)element;
                    if (!method.getJavaProject().isOnClasspath((IJavaElement)method)) {
                        return 0;
                    }
                    int flags = method.getFlags();
                    if (method.getDeclaringType().isClass() && !method.isConstructor() && !Flags.isPrivate((int)flags) && !Flags.isStatic((int)flags)) {
                        return this.getOverrideIndicators(method);
                    }
                }
                catch (JavaModelException e) {
                    if (e.isDoesNotExist()) break block6;
                    JavaPlugin.log(e);
                }
            }
        }
        return 0;
    }

    protected int getOverrideIndicators(IMethod method) throws JavaModelException {
        IType type = method.getDeclaringType();
        if (type.isAnonymous() && !SuperTypeHierarchyCache.hasInCache(type)) {
            int flags = method.getFlags();
            if (!Flags.isPublic((int)flags) || type.getSuperclassName().endsWith("Adapter")) {
                return 128;
            }
            return 256;
        }
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(type);
        if (hierarchy != null) {
            return this.findInHierarchy(type, hierarchy, method.getElementName(), method.getParameterTypes());
        }
        return 0;
    }

    protected int findInHierarchy(IType type, ITypeHierarchy hierarchy, String name, String[] paramTypes) throws JavaModelException {
        IMethod impl = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, type, name, paramTypes, false);
        if (impl != null && JavaModelUtil.isVisibleInHierarchy((IMember)impl, type.getPackageFragment())) {
            IMethod overridden = JavaModelUtil.findMethodImplementationInHierarchy(hierarchy, type, name, paramTypes, false);
            if (overridden != null) {
                return 128;
            }
            return 256;
        }
        return 0;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags != 0) {
            decoration.addOverlay(JavaPluginImages.DESC_OVR_OVERRIDES);
        }
    }
}

