/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;

class JavaWorkingSetPageContentProvider
extends StandardJavaElementContentProvider {
    JavaWorkingSetPageContentProvider() {
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject && !((IProject)element).isAccessible()) {
            return false;
        }
        if (element instanceof IPackageFragment) {
            IPackageFragment pkg = (IPackageFragment)element;
            try {
                if (pkg.getKind() == 2) {
                    return pkg.getChildren().length > 0;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IJavaModel) {
                return StandardJavaElementContentProvider.concatenate(super.getChildren(parentElement), this.getClosedProjects((IJavaModel)parentElement));
            }
            return super.getChildren(parentElement);
        }
        catch (CoreException coreException) {
            return StandardJavaElementContentProvider.NO_CHILDREN;
        }
    }

    private IProject[] getClosedProjects(IJavaModel model) throws JavaModelException {
        Object[] resources = model.getNonJavaResources();
        ArrayList<Object> closedProjects = new ArrayList<Object>(resources.length);
        int i = 0;
        while (i < resources.length) {
            Object resource = resources[i];
            if (resource instanceof IProject && !((IProject)resource).isOpen()) {
                closedProjects.add(resource);
            }
            ++i;
        }
        return closedProjects.toArray(new IProject[closedProjects.size()]);
    }
}

