/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ExclusionPatternDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.NewSourceFolderDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.OutputLocationDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class SourceContainerWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fClassPathList;
    private IJavaProject fCurrJProject;
    private IPath fProjPath;
    private Control fSWTControl;
    private IWorkspaceRoot fWorkspaceRoot;
    private TreeListDialogField fFoldersList;
    private StringDialogField fOutputLocationField;
    private SelectionButtonDialogField fUseFolderOutputs;
    private final int IDX_ADD = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SourceContainerWorkbookPage(IWorkspaceRoot root, ListDialogField classPathList, StringDialogField outputLocationField) {
        this.fWorkspaceRoot = root;
        this.fClassPathList = classPathList;
        this.fOutputLocationField = outputLocationField;
        this.fSWTControl = null;
        SourceContainerAdapter adapter = new SourceContainerAdapter();
        String[] stringArray = new String[4];
        stringArray[0] = NewWizardMessages.getString("SourceContainerWorkbookPage.folders.add.button");
        stringArray[2] = NewWizardMessages.getString("SourceContainerWorkbookPage.folders.edit.button");
        stringArray[3] = NewWizardMessages.getString("SourceContainerWorkbookPage.folders.remove.button");
        String[] buttonLabels = stringArray;
        this.fFoldersList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fFoldersList.setDialogFieldListener(adapter);
        this.fFoldersList.setLabelText(NewWizardMessages.getString("SourceContainerWorkbookPage.folders.label"));
        this.fFoldersList.setViewerSorter(new CPListElementSorter());
        this.fFoldersList.enableButton(2, false);
        this.fUseFolderOutputs = new SelectionButtonDialogField(32);
        this.fUseFolderOutputs.setSelection(false);
        this.fUseFolderOutputs.setLabelText(NewWizardMessages.getString("SourceContainerWorkbookPage.folders.check"));
        this.fUseFolderOutputs.setDialogFieldListener(adapter);
    }

    public void init(IJavaProject jproject) {
        this.fCurrJProject = jproject;
        this.fProjPath = this.fCurrJProject.getProject().getFullPath();
        this.updateFoldersList();
    }

    private void updateFoldersList() {
        CPListElement cpe;
        ArrayList<CPListElement> folders = new ArrayList<CPListElement>();
        boolean useFolderOutputs = false;
        List cpelements = this.fClassPathList.getElements();
        int i = 0;
        while (i < cpelements.size()) {
            cpe = (CPListElement)cpelements.get(i);
            if (cpe.getEntryKind() == 3) {
                boolean hasOutputFolder;
                folders.add(cpe);
                boolean bl = hasOutputFolder = cpe.getAttribute("output") != null;
                if (hasOutputFolder) {
                    useFolderOutputs = true;
                }
            }
            ++i;
        }
        this.fFoldersList.setElements(folders);
        this.fUseFolderOutputs.setSelection(useFolderOutputs);
        i = 0;
        while (i < folders.size()) {
            boolean hasOutputFolder;
            cpe = (CPListElement)folders.get(i);
            IPath[] patterns = (IPath[])cpe.getAttribute("exclusion");
            boolean bl = hasOutputFolder = cpe.getAttribute("output") != null;
            if (patterns.length > 0 || hasOutputFolder) {
                this.fFoldersList.expandElement(cpe, 3);
            }
            ++i;
        }
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fFoldersList, this.fUseFolderOutputs}, true);
        LayoutUtil.setHorizontalGrabbing(this.fFoldersList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fFoldersList.setButtonsMinWidth(buttonBarWidth);
        this.fSWTControl = composite;
        List elements = this.fFoldersList.getElements();
        int i = 0;
        while (i < elements.size()) {
            CPListElement elem = (CPListElement)elements.get(i);
            IPath[] patterns = (IPath[])elem.getAttribute("exclusion");
            IPath output = (IPath)elem.getAttribute("output");
            if (patterns.length > 0 || output != null) {
                this.fFoldersList.expandElement(elem, 3);
            }
            ++i;
        }
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    protected void sourcePageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fFoldersList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected void sourcePageDoubleClicked(TreeListDialogField field) {
        List selection;
        if (field == this.fFoldersList && this.canEdit(selection = field.getSelectedElements())) {
            this.editEntry();
        }
    }

    protected void sourcePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fFoldersList) {
            if (index == 0) {
                ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(10);
                if (this.fCurrJProject.getProject().exists()) {
                    CPListElement[] srcentries = this.openSourceContainerDialog(null);
                    if (srcentries != null) {
                        int i = 0;
                        while (i < srcentries.length) {
                            elementsToAdd.add(srcentries[i]);
                            ++i;
                        }
                    }
                } else {
                    CPListElement entry = this.openNewSourceContainerDialog(null);
                    if (entry != null) {
                        elementsToAdd.add(entry);
                    }
                }
                if (!elementsToAdd.isEmpty()) {
                    CPListElement existing;
                    if (this.fFoldersList.getSize() == 1 && (existing = (CPListElement)this.fFoldersList.getElement(0)).getResource() instanceof IProject) {
                        this.askForChangingBuildPathDialog(existing);
                    }
                    HashSet modifiedElements = new HashSet();
                    this.askForAddingExclusionPatternsDialog(elementsToAdd, modifiedElements);
                    this.fFoldersList.addElements(elementsToAdd);
                    this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(elementsToAdd));
                    if (!modifiedElements.isEmpty()) {
                        Iterator iter = modifiedElements.iterator();
                        while (iter.hasNext()) {
                            Object elem = iter.next();
                            this.fFoldersList.refresh(elem);
                            this.fFoldersList.expandElement(elem, 3);
                        }
                    }
                }
            } else if (index == 2) {
                this.editEntry();
            } else if (index == 3) {
                this.removeEntry();
            }
        }
    }

    private void editEntry() {
        List selElements = this.fFoldersList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fFoldersList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPListElement)elem);
        } else if (elem instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)elem);
        }
    }

    private void editElementEntry(CPListElement elem) {
        CPListElement res = null;
        IResource resource = elem.getResource();
        if (resource.exists()) {
            CPListElement[] arr = this.openSourceContainerDialog(elem);
            if (arr != null) {
                res = arr[0];
            }
        } else {
            res = this.openNewSourceContainerDialog(elem);
        }
        if (res != null) {
            this.fFoldersList.replaceElement(elem, res);
        }
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("output")) {
            CPListElement selElement = elem.getParent();
            OutputLocationDialog dialog = new OutputLocationDialog(this.getShell(), selElement);
            if (dialog.open() == 0) {
                selElement.setAttribute("output", dialog.getOutputLocation());
                this.fFoldersList.refresh();
                this.fClassPathList.dialogFieldChanged();
            }
        } else if (key.equals("exclusion")) {
            CPListElement selElement = elem.getParent();
            ExclusionPatternDialog dialog = new ExclusionPatternDialog(this.getShell(), selElement);
            if (dialog.open() == 0) {
                selElement.setAttribute("exclusion", dialog.getExclusionPattern());
                this.fFoldersList.refresh();
                this.fClassPathList.dialogFieldChanged();
            }
        }
    }

    protected void sourcePageSelectionChanged(DialogField field) {
        List selected = this.fFoldersList.getSelectedElements();
        this.fFoldersList.enableButton(2, this.canEdit(selected));
        this.fFoldersList.enableButton(3, this.canRemove(selected));
    }

    private void removeEntry() {
        List selElements = this.fFoldersList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                String key = attrib.getKey();
                Path[] value = key.equals("exclusion") ? new Path[]{} : null;
                attrib.getParent().setAttribute(key, value);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fFoldersList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            this.fFoldersList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPListElement curr;
            CPListElementAttribute attrib;
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute ? ((attrib = (CPListElementAttribute)elem).getKey().equals("exclusion") ? ((IPath[])attrib.getValue()).length == 0 : attrib.getValue() == null) : elem instanceof CPListElement && (curr = (CPListElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (this.fFoldersList.getIndexOfElement(elem) != -1) {
            return true;
        }
        return elem instanceof CPListElementAttribute;
    }

    private void sourcePageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject == null) {
            return;
        }
        if (field == this.fUseFolderOutputs) {
            if (!this.fUseFolderOutputs.isSelected()) {
                int nFolders = this.fFoldersList.getSize();
                int i = 0;
                while (i < nFolders) {
                    CPListElement cpe = (CPListElement)this.fFoldersList.getElement(i);
                    cpe.setAttribute("output", null);
                    ++i;
                }
            }
            this.fFoldersList.refresh();
        } else if (field == this.fFoldersList) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        List cpelements = this.fClassPathList.getElements();
        List srcelements = this.fFoldersList.getElements();
        boolean changeDone = false;
        CPListElement lastSourceFolder = null;
        int i = cpelements.size() - 1;
        while (i >= 0) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind())) {
                if (!srcelements.remove(cpe)) {
                    cpelements.remove(i);
                    changeDone = true;
                } else if (lastSourceFolder == null) {
                    lastSourceFolder = cpe;
                }
            }
            --i;
        }
        if (!srcelements.isEmpty()) {
            int insertIndex = lastSourceFolder == null ? 0 : cpelements.indexOf(lastSourceFolder) + 1;
            cpelements.addAll(insertIndex, srcelements);
            changeDone = true;
        }
        if (changeDone) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    private CPListElement openNewSourceContainerDialog(CPListElement existing) {
        String title = existing == null ? NewWizardMessages.getString("SourceContainerWorkbookPage.NewSourceFolderDialog.new.title") : NewWizardMessages.getString("SourceContainerWorkbookPage.NewSourceFolderDialog.edit.title");
        IProject proj = this.fCurrJProject.getProject();
        NewSourceFolderDialog dialog = new NewSourceFolderDialog(this.getShell(), title, proj, this.getExistingContainers(existing), existing);
        dialog.setMessage(NewWizardMessages.getFormattedString("SourceContainerWorkbookPage.NewSourceFolderDialog.description", this.fProjPath.toString()));
        if (dialog.open() == 0) {
            IContainer folder = dialog.getSourceFolder();
            return this.newCPSourceElement((IResource)folder);
        }
        return null;
    }

    private void askForChangingBuildPathDialog(CPListElement existing) {
        String message;
        Path outputFolder = new Path(this.fOutputLocationField.getText());
        IPath newOutputFolder = null;
        if (outputFolder.segmentCount() == 1) {
            String outputFolderName = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            newOutputFolder = outputFolder.append(outputFolderName);
            message = NewWizardMessages.getFormattedString("SourceContainerWorkbookPage.ChangeOutputLocationDialog.project_and_output.message", newOutputFolder);
        } else {
            message = NewWizardMessages.getString("SourceContainerWorkbookPage.ChangeOutputLocationDialog.project.message");
        }
        String title = NewWizardMessages.getString("SourceContainerWorkbookPage.ChangeOutputLocationDialog.title");
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message)) {
            this.fFoldersList.removeElement(existing);
            if (newOutputFolder != null) {
                this.fOutputLocationField.setText(newOutputFolder.toString());
            }
        }
    }

    private void askForAddingExclusionPatternsDialog(List newEntries, Set modifiedEntries) {
        int i = 0;
        while (i < newEntries.size()) {
            CPListElement curr = (CPListElement)newEntries.get(i);
            this.addExclusionPatterns(curr, modifiedEntries);
            ++i;
        }
        if (!modifiedEntries.isEmpty()) {
            String title = NewWizardMessages.getString("SourceContainerWorkbookPage.exclusion_added.title");
            String message = NewWizardMessages.getString("SourceContainerWorkbookPage.exclusion_added.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private void addExclusionPatterns(CPListElement newEntry, Set modifiedEntries) {
        IPath entryPath = newEntry.getPath();
        List existing = this.fFoldersList.getElements();
        int i = 0;
        while (i < existing.size()) {
            IPath[] exclusionFilters;
            CPListElement curr = (CPListElement)existing.get(i);
            IPath currPath = curr.getPath();
            if (currPath.isPrefixOf(entryPath) && !JavaModelUtil.isExcludedPath(entryPath, exclusionFilters = (IPath[])curr.getAttribute("exclusion"))) {
                IPath pathToExclude = entryPath.removeFirstSegments(currPath.segmentCount()).addTrailingSeparator();
                IPath[] newExclusionFilters = new IPath[exclusionFilters.length + 1];
                System.arraycopy(exclusionFilters, 0, newExclusionFilters, 0, exclusionFilters.length);
                newExclusionFilters[exclusionFilters.length] = pathToExclude;
                curr.setAttribute("exclusion", newExclusionFilters);
                modifiedEntries.add(curr);
            }
            ++i;
        }
    }

    private CPListElement[] openSourceContainerDialog(CPListElement existing) {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IProject;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.core.resources.IFolder;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, existing == null, this.getExistingContainers(null));
        IProject[] allProjects = this.fWorkspaceRoot.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.fCurrJProject.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        String title = existing == null ? NewWizardMessages.getString("SourceContainerWorkbookPage.ExistingSourceFolderDialog.new.title") : NewWizardMessages.getString("SourceContainerWorkbookPage.ExistingSourceFolderDialog.edit.title");
        String message = existing == null ? NewWizardMessages.getString("SourceContainerWorkbookPage.ExistingSourceFolderDialog.new.description") : NewWizardMessages.getString("SourceContainerWorkbookPage.ExistingSourceFolderDialog.edit.description");
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(filter);
        dialog.setInput(this.fCurrJProject.getProject().getParent());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (existing == null) {
            dialog.setInitialSelection(this.fCurrJProject.getProject());
        } else {
            dialog.setInitialSelection(existing.getResource());
        }
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            CPListElement[] res = new CPListElement[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = this.newCPSourceElement(elem);
                ++i2;
            }
            return res;
        }
        return null;
    }

    private List getExistingContainers(CPListElement existing) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        List cplist = this.fFoldersList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem != existing && (resource = elem.getResource()) instanceof IContainer) {
                res.add(resource);
            }
            ++i;
        }
        return res;
    }

    private CPListElement newCPSourceElement(IResource res) {
        Assert.isNotNull((Object)res);
        return new CPListElement(this.fCurrJProject, 3, res.getFullPath(), res);
    }

    public List getSelection() {
        return this.fFoldersList.getSelectedElements();
    }

    public void setSelection(List selElements) {
        this.fFoldersList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    public boolean isEntryKind(int kind) {
        return kind == 3;
    }

    private class SourceContainerAdapter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] EMPTY_ARR = new Object[0];

        SourceContainerAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            SourceContainerWorkbookPage.this.sourcePageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            SourceContainerWorkbookPage.this.sourcePageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            SourceContainerWorkbookPage.this.sourcePageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            SourceContainerWorkbookPage.this.sourcePageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(!SourceContainerWorkbookPage.this.fUseFolderOutputs.isSelected());
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element instanceof CPListElement;
        }

        public void dialogFieldChanged(DialogField field) {
            SourceContainerWorkbookPage.this.sourcePageDialogFieldChanged(field);
        }
    }
}

