/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.ClasspathVariablesPreferencePage;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPVariableElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPVariableElementLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.JARFileSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewVariableEntryDialog
extends StatusDialog {
    private final int IDX_EXTEND = 0;
    private ListDialogField fVariablesList;
    private boolean fCanExtend;
    private boolean fIsValidSelection;
    private IPath[] fResultPaths;
    private SelectionButtonDialogField fConfigButton;

    public NewVariableEntryDialog(Shell parent) {
        super(parent);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.updateStatus(new StatusInfo(4, ""));
        String[] buttonLabels = new String[]{NewWizardMessages.getString("NewVariableEntryDialog.vars.extend")};
        VariablesAdapter adapter = new VariablesAdapter();
        CPVariableElementLabelProvider labelProvider = new CPVariableElementLabelProvider(false);
        this.fVariablesList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)labelProvider);
        this.fVariablesList.setDialogFieldListener(adapter);
        this.fVariablesList.setLabelText(NewWizardMessages.getString("NewVariableEntryDialog.vars.label"));
        this.fVariablesList.enableButton(0, false);
        this.fVariablesList.setViewerSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof CPVariableElement && e2 instanceof CPVariableElement) {
                    return ((CPVariableElement)e1).getName().compareTo(((CPVariableElement)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fConfigButton = new SelectionButtonDialogField(8);
        this.fConfigButton.setLabelText(NewWizardMessages.getString("NewVariableEntryDialog.configbutton.label"));
        this.fConfigButton.setDialogFieldListener(adapter);
        this.initializeElements();
        this.fCanExtend = false;
        this.fIsValidSelection = false;
        this.fResultPaths = null;
    }

    private void initializeElements() {
        String[] entries = JavaCore.getClasspathVariableNames();
        ArrayList<CPVariableElement> elements = new ArrayList<CPVariableElement>(entries.length);
        int i = 0;
        while (i < entries.length) {
            String name = entries[i];
            IPath entryPath = JavaCore.getClasspathVariable((String)name);
            if (entryPath != null) {
                elements.add(new CPVariableElement(name, entryPath, false));
            }
            ++i;
        }
        this.fVariablesList.setElements(elements);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.jdt.ui.new_variable_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        this.fVariablesList.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fVariablesList.getLabelControl(null), 2);
        GridData listData = (GridData)this.fVariablesList.getListControl(null).getLayoutData();
        listData.grabExcessHorizontalSpace = true;
        listData.heightHint = this.convertHeightInCharsToPixels(10);
        Composite lowerComposite = new Composite(composite, 0);
        lowerComposite.setLayoutData((Object)new GridData(256));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        lowerComposite.setLayout((Layout)layout);
        this.fConfigButton.doFillIntoGrid(lowerComposite, 1);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public IPath[] getResult() {
        return this.fResultPaths;
    }

    private void doDoubleClick() {
        if (this.fIsValidSelection) {
            this.okPressed();
        } else if (this.fCanExtend) {
            this.extendButtonPressed();
        }
    }

    private void doSelectionChanged() {
        boolean isValidSelection = true;
        boolean canExtend = false;
        StatusInfo status = new StatusInfo();
        List selected = this.fVariablesList.getSelectedElements();
        int nSelected = selected.size();
        if (nSelected > 0) {
            this.fResultPaths = new Path[nSelected];
            int i = 0;
            while (i < nSelected) {
                CPVariableElement curr = (CPVariableElement)selected.get(i);
                this.fResultPaths[i] = new Path(curr.getName());
                if (!curr.getPath().toFile().isFile()) {
                    status.setInfo(NewWizardMessages.getString("NewVariableEntryDialog.info.isfolder"));
                    canExtend = true;
                }
                ++i;
            }
        } else {
            isValidSelection = false;
            status.setInfo(NewWizardMessages.getString("NewVariableEntryDialog.info.noselection"));
        }
        if (isValidSelection && nSelected > 1) {
            String str = NewWizardMessages.getFormattedString("NewVariableEntryDialog.info.selected", String.valueOf(nSelected));
            status.setInfo(str);
        }
        this.fCanExtend = nSelected == 1 && canExtend;
        this.fVariablesList.enableButton(0, this.fCanExtend);
        this.updateStatus(status);
        this.fIsValidSelection = isValidSelection;
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(isValidSelection);
        }
    }

    private IPath[] chooseExtensions(CPVariableElement elem) {
        File file = elem.getPath().toFile();
        JARFileSelectionDialog dialog = new JARFileSelectionDialog(this.getShell(), true, false);
        dialog.setTitle(NewWizardMessages.getString("NewVariableEntryDialog.ExtensionDialog.title"));
        dialog.setMessage(NewWizardMessages.getFormattedString("NewVariableEntryDialog.ExtensionDialog.description", elem.getName()));
        dialog.setInput(file);
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            IPath[] paths = new IPath[selected.length];
            int i = 0;
            while (i < selected.length) {
                Path filePath = new Path(((File)selected[i]).getPath());
                Path resPath = new Path(elem.getName());
                int k = elem.getPath().segmentCount();
                while (k < filePath.segmentCount()) {
                    resPath = resPath.append(filePath.segment(k));
                    ++k;
                }
                paths[i] = resPath;
                ++i;
            }
            return paths;
        }
        return null;
    }

    protected void extendButtonPressed() {
        IPath[] extendedPaths;
        List selected = this.fVariablesList.getSelectedElements();
        if (selected.size() == 1 && (extendedPaths = this.chooseExtensions((CPVariableElement)selected.get(0))) != null) {
            this.fResultPaths = extendedPaths;
            super.buttonPressed(0);
        }
    }

    protected void configButtonPressed() {
        ClasspathVariablesPreferencePage page = new ClasspathVariablesPreferencePage();
        this.showPreferencePage("org.eclipse.jdt.ui.preferences.ClasspathVariablesPreferencePage", (IPreferencePage)page);
        this.initializeElements();
    }

    private boolean showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager);
        boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode, result){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            private final /* synthetic */ boolean[] val$result;
            {
                this.val$targetNode = iPreferenceNode;
                this.val$result = blArray;
            }

            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                this.val$result[0] = dialog.open() == 0;
            }
        });
        return result[0];
    }

    private class VariablesAdapter
    implements IDialogFieldListener,
    IListAdapter {
        VariablesAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    NewVariableEntryDialog.this.extendButtonPressed();
                }
            }
        }

        public void selectionChanged(ListDialogField field) {
            NewVariableEntryDialog.this.doSelectionChanged();
        }

        public void doubleClicked(ListDialogField field) {
            NewVariableEntryDialog.this.doDoubleClick();
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == NewVariableEntryDialog.this.fConfigButton) {
                NewVariableEntryDialog.this.configButtonPressed();
            }
        }
    }
}

